///////////////////////////////////////////////////////////////////////////////
//
// File: dia_IOCtrlManagerFSM.h
//
// Generated by SMC 4.6.1 (C++ State Pattern Code Generator)
//
// Command Line Arguments:
//
//   -c dia_IOCtrlManagerFSM.fsm
//   --protected_interface
//   --use_factory_method
//
///////////////////////////////////////////////////////////////////////////////

#ifndef __INCLUDED_DIA_IOCTRLMANAGERFSM__
#define __INCLUDED_DIA_IOCTRLMANAGERFSM__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

namespace dia_IOCtrlManagerFSM
{

///////////////////////////////////////////////////////////////////////////////
//
// Forward Declarations
//
///////////////////////////////////////////////////////////////////////////////

class FsmBody;

///////////////////////////////////////////////////////////////////////////////
//
// Enums and typedefs
//
///////////////////////////////////////////////////////////////////////////////

//! enumeration of FSM events. First and last item added by SMC
enum FsmEvent
{
   evUnknown = 0,
   evCheckSignals,
   evIdle,
   evNoSignalActive,
   evSignalActivated,
   evSignalDeactivated,
   evTerminateAllSignals,
   evTimeout,
   evCount
};

///////////////////////////////////////////////////////////////////////////////
//
// Functions
//
///////////////////////////////////////////////////////////////////////////////

const char* getEventName ( FsmEvent event );

///////////////////////////////////////////////////////////////////////////////
//
// Class: FsmBehaviour
//
// This is the base class for the FSM server (provides implementation for all
// actions and guards)
//
///////////////////////////////////////////////////////////////////////////////

class FsmBehaviour
{ 
   friend class ActiveIdleState;
   friend class IdleState;
   friend class SignalsActiveState;
   friend class TerminateSignalsState;
   friend class ToplevelState;
   friend class FsmBody;

public:
   virtual ~FsmBehaviour ( void ) {}

protected:
   // FSM actions
   virtual void vFsmAddSignal ( void* pArg ) = 0;
   virtual void vFsmCollectSignals ( void* pArg ) = 0;
   virtual void vFsmHandleTimeout ( void* pArg ) = 0;
   virtual void vFsmRemoveSignal ( void* pArg ) = 0;
   virtual void vFsmReset ( void* pArg ) = 0;
   virtual void vFsmStopNextSignal ( void* pArg ) = 0;

   // FSM guards
   virtual bool bFsmIsNoSignalActive ( void* pArg ) = 0;
};

///////////////////////////////////////////////////////////////////////////////
//
// Class: Fsm
//
// This is the finite state machine class 'dia_IOCtrlManagerFSM'.
//
///////////////////////////////////////////////////////////////////////////////

class Fsm
{
    //! we grant the body class access to our protected section
    friend class FsmBody;

public:
    //! factory method used to create an FAM object in two stages
    static bool createFSM ( Fsm** ppFSM, FsmBehaviour* behaviour, void* pInitArg=0 );
    //! class destructor
    virtual ~Fsm ( void );

    //! this method is used to stimulate the FSM with events
    virtual void acceptEvent ( FsmEvent event, void* pArg );

    //! return the name of the current state
    virtual const char* getStateName ( void ) const;

protected:
    //! protected default constructor to avoid usage
    Fsm ( void );
    //! class constructor
    Fsm ( FsmBehaviour* behaviour );
    //! copy constructor without implementation
    Fsm ( const Fsm& obj );
    //! assignment operator without implementation
    Fsm& operator = ( const Fsm& obj );

    //! setup and initialize the state machine
    virtual bool init ( void* pInitArg=0 );

protected:
    //! pointer to the server that provides the implementation for the actions and guards
    FsmBehaviour* mpBehaviour;
    //! body of the FSM implementation
    FsmBody* mpBody;
};


} // namespace

#endif
