///////////////////////////////////////////////////////////////////////////////
//
// File: dia_FileTransferFSM.h
//
// Generated by SMC 4.5.1 (C++ State Pattern Code Generator)
//
///////////////////////////////////////////////////////////////////////////////

#ifndef __INCLUDED_DIA_FILETRANSFERFSM__
#define __INCLUDED_DIA_FILETRANSFERFSM__

namespace dia_FileTransferFSM
{

///////////////////////////////////////////////////////////////////////////////
//
// Forward Declarations
//
///////////////////////////////////////////////////////////////////////////////

class FsmBody;

///////////////////////////////////////////////////////////////////////////////
//
// Enums and typedefs
//
///////////////////////////////////////////////////////////////////////////////

//! enumeration of FSM events. First and last item added by SMC
enum FsmEvent
{
   evUnknown = 0,
   evDataTransferComplete,
   evDataTransferDone,
   evDataTransferExit,
   evDataTransferRx,
   evDataTransferValidated,
   evFileDeleted,
   evIdle,
   evInvalidFormat,
   evInvalidLength,
   evInvalidRequest,
   evNoPermission,
   evRequestDirRead,
   evRequestFileAdd,
   evRequestFileDelete,
   evRequestFileRead,
   evRequestFileReplace,
   evRequestFileTransfer,
   evSessionChange,
   evTimeout,
   evCount
};

///////////////////////////////////////////////////////////////////////////////
//
// Functions
//
///////////////////////////////////////////////////////////////////////////////

const char* getEventName ( FsmEvent event );

///////////////////////////////////////////////////////////////////////////////
//
// Class: FsmBehaviour
//
// This is the base class for the FSM server (provides implementation for all
// actions and guards)
//
///////////////////////////////////////////////////////////////////////////////

class FsmBehaviour
{ 
   friend class DeleteFileState;
   friend class DownloadDataState;
   friend class DownloadDataTransferState;
   friend class DownloadDoneState;
   friend class DownloadingDataState;
   friend class NotActiveState;
   friend class ToplevelState;
   friend class UploadDataState;
   friend class UploadDataTransferState;
   friend class UploadDoneState;
   friend class FsmBody;

public:
   virtual ~FsmBehaviour ( void ) {}

protected:
   // FSM actions
   virtual void vFsmCalcCrcRam ( void* pArg ) = 0;
   virtual void vFsmCheckForCompletion ( void* pArg ) = 0;
   virtual void vFsmDeleteFile ( void* pArg ) = 0;
   virtual void vFsmDownloadData ( void* pArg ) = 0;
   virtual void vFsmPostprocessDownload ( void* pArg ) = 0;
   virtual void vFsmPostprocessUpload ( void* pArg ) = 0;
   virtual void vFsmPrepareDirRead ( void* pArg ) = 0;
   virtual void vFsmPrepareFileAdd ( void* pArg ) = 0;
   virtual void vFsmPrepareFileDelete ( void* pArg ) = 0;
   virtual void vFsmPrepareFileRead ( void* pArg ) = 0;
   virtual void vFsmPrepareFileReplace ( void* pArg ) = 0;
   virtual void vFsmReset ( void* pArg ) = 0;
   virtual void vFsmSaveFile ( void* pArg ) = 0;
   virtual void vFsmSendDownloadTransferDataResponse ( void* pArg ) = 0;
   virtual void vFsmSendErrorAlreadyRequested ( void* pArg ) = 0;
   virtual void vFsmSendErrorInvalidData ( void* pArg ) = 0;
   virtual void vFsmSendErrorInvalidDataTransExit ( void* pArg ) = 0;
   virtual void vFsmSendErrorInvalidFormat ( void* pArg ) = 0;
   virtual void vFsmSendErrorInvalidLength ( void* pArg ) = 0;
   virtual void vFsmSendErrorInvalidRequest ( void* pArg ) = 0;
   virtual void vFsmSendErrorInvalidSequence ( void* pArg ) = 0;
   virtual void vFsmSendErrorNoPermission ( void* pArg ) = 0;
   virtual void vFsmSendErrorRequestRejectedDirRead ( void* pArg ) = 0;
   virtual void vFsmSendErrorRequestRejectedFileAdd ( void* pArg ) = 0;
   virtual void vFsmSendErrorRequestRejectedFileDelete ( void* pArg ) = 0;
   virtual void vFsmSendErrorRequestRejectedFileRead ( void* pArg ) = 0;
   virtual void vFsmSendErrorRequestRejectedFileReplace ( void* pArg ) = 0;
   virtual void vFsmSendRequestDirReadResponse ( void* pArg ) = 0;
   virtual void vFsmSendRequestFileAddResponse ( void* pArg ) = 0;
   virtual void vFsmSendRequestFileDeleteResponse ( void* pArg ) = 0;
   virtual void vFsmSendRequestFileReadResponse ( void* pArg ) = 0;
   virtual void vFsmSendRequestFileReplaceResponse ( void* pArg ) = 0;
   virtual void vFsmSendTransExitResponse ( void* pArg ) = 0;
   virtual void vFsmSendUploadTransferDataResponse ( void* pArg ) = 0;
   virtual void vFsmSetDownloadActive ( void* pArg ) = 0;
   virtual void vFsmSetUploadActive ( void* pArg ) = 0;
   virtual void vFsmUploadData ( void* pArg ) = 0;
   virtual void vFsmValidateFileTransferRequest ( void* pArg ) = 0;
   virtual void vFsmValidateTransferredData ( void* pArg ) = 0;

   // FSM guards
   virtual bool areDirReadConditionsOK ( void* pArg ) = 0;
   virtual bool areFileAddConditionsOK ( void* pArg ) = 0;
   virtual bool areFileDeleteConditionsOK ( void* pArg ) = 0;
   virtual bool areFileReadConditionsOK ( void* pArg ) = 0;
   virtual bool areFileReplaceConditionsOK ( void* pArg ) = 0;
   virtual bool bFsmIsCrcOk ( void* pArg ) = 0;
   virtual bool bFsmIsDataValid ( void* pArg ) = 0;
};

///////////////////////////////////////////////////////////////////////////////
//
// Class: Fsm
//
// This is the finite state machine class 'dia_FileTransferFSM'.
//
///////////////////////////////////////////////////////////////////////////////

class Fsm
{
    //! we grant the body class access to our protected section
    friend class FsmBody;

public:
    //! factory method used to create an FAM object in two stages
    static bool createFSM ( Fsm** ppFSM, FsmBehaviour* behaviour );
    //! class destructor
    virtual ~Fsm ( void );

    //! this method is used to stimulate the FSM with events
    virtual void acceptEvent ( FsmEvent event, void* pArg );

    //! return the name of the current state
    virtual const char* getStateName ( void ) const;

protected:
    //! protected default constructor to avoid usage
    Fsm ( void );
    //! class constructor
    Fsm ( FsmBehaviour* behaviour );
    //! copy constructor without implementation
    Fsm ( const Fsm& obj );
    //! assignment operator without implementation
    Fsm& operator = ( const Fsm& obj );

    //! setup and initialize the state machine
    virtual bool init ( void );

protected:
    //! pointer to the server that provides the implementation for the actions and guards
    FsmBehaviour* mpBehaviour;
    //! body of the FSM implementation
    FsmBody* mpBody;
};


} // namespace

#endif
