///////////////////////////////////////////////////////////////////////////////
//
// File: dia_FileTransferFSM.cpp
//
// Generated by SMC 4.5.1 (C++ State Pattern Code Generator)
//
///////////////////////////////////////////////////////////////////////////////

#include <string.h>

#ifndef __INCLUDED_DIA_FILETRANSFERFSM__
#include "dia_FileTransferFSM.h"
#endif

namespace dia_FileTransferFSM
{

const unsigned int MAX_TRIGGER_EVENTS = 20;

///////////////////////////////////////////////////////////////////////////////
//
// Forward Declarations
//
///////////////////////////////////////////////////////////////////////////////

class Fsm;
class FsmSuperState;

///////////////////////////////////////////////////////////////////////////////
//
// Abstract base class for all FSM states.
//
///////////////////////////////////////////////////////////////////////////////

class FsmState
{
public:
   //! name of the FSM's state
   virtual const char* getStateName ( void ) const = 0;

   //! resetting state internals
   virtual void reset ( void ) {}

   // event functions 
   virtual void evDataTransferComplete ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evDataTransferDone ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evDataTransferExit ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evDataTransferRx ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evDataTransferValidated ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evFileDeleted ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evInvalidFormat ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evInvalidLength ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evInvalidRequest ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evNoPermission ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestDirRead ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestFileAdd ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestFileDelete ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestFileRead ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestFileReplace ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestFileTransfer ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSessionChange ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! default implementation for the Entry action
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! default implementation for the Exit action
   virtual void exit  ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! method used to propagate the event to the superstate
   virtual const FsmState* propagate ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! return the parent state
   virtual FsmSuperState* getParent ( void );

   //! assign the body object
   void initState ( FsmSuperState* pParent );

protected:
   //! default constructor is protected to prevent usage of this constructor
   FsmState ( void );
   //! class destructor
   virtual ~FsmState ( void );

   //! pointer to the superstate
   FsmSuperState* mpParent;
};

///////////////////////////////////////////////////////////////////////////////
//
// Abstract base class for all FSM superstates.
//
///////////////////////////////////////////////////////////////////////////////

class FsmSuperState
   : public FsmState
{
public:
   //! set a savepoint for the history
   virtual void savepoint ( FsmBody& b );
   //! default action
   virtual void defaultAction ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! resetting state internals
   virtual void reset ( void ) { _history = 0; }

   //! method used to propagate the event to the superstate
   virtual const FsmState* propagate ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! assign the body object
   void initSuperState ( FsmSuperState* pParent, FsmState* defState, bool histEnable=false );

protected:
   //! default constructor is protected to prevent usage of this constructor
   FsmSuperState ( void );

   //! pointer to the default substate
   FsmState* _default;
   //! pointer to the history substate
   const FsmState* _history;
   //! flag that indicates if history is enabled or not
   bool _historyEnable;
};

///////////////////////////////////////////////////////////////////////////////
// 
// Class: DeleteFileState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class DeleteFileState
   : public FsmState
{
public:
   //! default constructor
   DeleteFileState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evDataTransferRx ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evFileDeleted ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evInvalidFormat ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evInvalidLength ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evInvalidRequest ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evNoPermission ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestFileTransfer ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* DeleteFileState::mStateName = "DeleteFile";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: DownloadDataState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class DownloadDataState
   : public FsmSuperState
{
public:
   //! default constructor
   DownloadDataState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evInvalidFormat ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evInvalidLength ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evInvalidRequest ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evNoPermission ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestFileTransfer ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSessionChange ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* DownloadDataState::mStateName = "DownloadData";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: DownloadDataTransferState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class DownloadDataTransferState
   : public FsmState
{
public:
   //! default constructor
   DownloadDataTransferState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evDataTransferComplete ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evDataTransferExit ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evDataTransferRx ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evDataTransferValidated ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evInvalidFormat ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evInvalidLength ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evInvalidRequest ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evNoPermission ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestFileTransfer ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSessionChange ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* DownloadDataTransferState::mStateName = "DownloadDataTransfer";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: DownloadDoneState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class DownloadDoneState
   : public FsmState
{
public:
   //! default constructor
   DownloadDoneState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evDataTransferExit ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evDataTransferRx ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evInvalidFormat ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evInvalidLength ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evInvalidRequest ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evNoPermission ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestFileTransfer ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSessionChange ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* DownloadDoneState::mStateName = "DownloadDone";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: DownloadingDataState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class DownloadingDataState
   : public FsmState
{
public:
   //! default constructor
   DownloadingDataState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evDataTransferDone ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evDataTransferExit ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evInvalidFormat ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evInvalidLength ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evInvalidRequest ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evNoPermission ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestFileTransfer ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSessionChange ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* DownloadingDataState::mStateName = "DownloadingData";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: NotActiveState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class NotActiveState
   : public FsmState
{
public:
   //! default constructor
   NotActiveState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evDataTransferExit ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evDataTransferRx ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evInvalidFormat ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evInvalidLength ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evInvalidRequest ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evNoPermission ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestDirRead ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestFileAdd ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestFileDelete ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestFileRead ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestFileReplace ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestFileTransfer ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* NotActiveState::mStateName = "NotActive";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: ToplevelState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class ToplevelState
   : public FsmSuperState
{
public:
   //! default constructor
   ToplevelState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evInvalidFormat ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evInvalidLength ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evInvalidRequest ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evNoPermission ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* ToplevelState::mStateName = "Toplevel";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: UploadDataState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class UploadDataState
   : public FsmSuperState
{
public:
   //! default constructor
   UploadDataState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evInvalidFormat ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evInvalidLength ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evInvalidRequest ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evNoPermission ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestFileTransfer ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSessionChange ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* UploadDataState::mStateName = "UploadData";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: UploadDataTransferState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class UploadDataTransferState
   : public FsmState
{
public:
   //! default constructor
   UploadDataTransferState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evDataTransferComplete ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evDataTransferExit ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evDataTransferRx ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evInvalidFormat ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evInvalidLength ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evInvalidRequest ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evNoPermission ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestFileTransfer ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSessionChange ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* UploadDataTransferState::mStateName = "UploadDataTransfer";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: UploadDoneState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class UploadDoneState
   : public FsmState
{
public:
   //! default constructor
   UploadDoneState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evDataTransferExit ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evDataTransferRx ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evInvalidFormat ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evInvalidLength ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evInvalidRequest ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evNoPermission ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestFileTransfer ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSessionChange ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* UploadDoneState::mStateName = "UploadDone";

///////////////////////////////////////////////////////////////////////////////
//
// Class: FsmBody
//
// This is the finite state machine's body class 'FsmBody'.
//
///////////////////////////////////////////////////////////////////////////////

class FsmBody
{
    struct FsmDeferredEvent
    {
          FsmDeferredEvent() : mEvent(evUnknown), mArg(0) {}
          FsmEvent mEvent;
          void*    mArg;
    };

public:
    //! class constructor
    FsmBody ( void );

    //! connect the FSM body with its frontend
    void connect ( Fsm* frontend );

    //! initialize the FSM: set initial state and execute initial actions
    bool init ( void );

    //! this method is used to stimulate the FSM with events
    void acceptEvent ( FsmEvent event, void* pArg );

    //! return the name of the active state
    const char* getStateName ( void ) const;

    //! push trigger events to the event queue
    bool addEvent ( const FsmEvent& event, void* arg  );
    //! get event from the event queue
    bool getEvent ( FsmEvent& event, void** arg  );
    //! get event from the event queue
    bool isQueueEmpty ( void ) const;

    // set the FSM's internal state and propagate to default or history substate
    void setState ( FsmState& state, void* pArg );
    // set the FSM's internal state (no propagation
    void setState ( FsmState* pState );
    // return the active state object
    const FsmState* getState ( void ) const;

    //! static state objects
    DeleteFileState oDeleteFileState;
    DownloadDataState oDownloadDataState;
    DownloadDataTransferState oDownloadDataTransferState;
    DownloadDoneState oDownloadDoneState;
    DownloadingDataState oDownloadingDataState;
    NotActiveState oNotActiveState;
    ToplevelState oToplevelState;
    UploadDataState oUploadDataState;
    UploadDataTransferState oUploadDataTransferState;
    UploadDoneState oUploadDoneState;

    //! frontend for this body
    Fsm* mpFrontend;
    //! link to the active state object
    FsmState* mpState;

    //! busy indicator flag
    bool mBusyFlag;

    //! queue of trigger events
    FsmEvent mEventQueue[MAX_TRIGGER_EVENTS];
    //! queue of arguments for trigger events
    void*    mParamQueue[MAX_TRIGGER_EVENTS];
    //! index of the queue's front element
    unsigned int mQueueHead;
    //! index of the queue's back element
    unsigned int mQueueTail;
    //! number of queued events
    unsigned int mQueueSize;
};

///////////////////////////////////////////////////////////////////////////////
//
// Default implementation for all events.
//
///////////////////////////////////////////////////////////////////////////////

void
FsmState::evDataTransferComplete ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evDataTransferComplete *** 
}

void
FsmState::evDataTransferDone ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evDataTransferDone *** 
}

void
FsmState::evDataTransferExit ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evDataTransferExit *** 
}

void
FsmState::evDataTransferRx ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evDataTransferRx *** 
}

void
FsmState::evDataTransferValidated ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evDataTransferValidated *** 
}

void
FsmState::evFileDeleted ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evFileDeleted *** 
}

void
FsmState::evIdle ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evIdle *** 
}

void
FsmState::evInvalidFormat ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evInvalidFormat *** 
}

void
FsmState::evInvalidLength ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evInvalidLength *** 
}

void
FsmState::evInvalidRequest ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evInvalidRequest *** 
}

void
FsmState::evNoPermission ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evNoPermission *** 
}

void
FsmState::evRequestDirRead ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evRequestDirRead *** 
}

void
FsmState::evRequestFileAdd ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evRequestFileAdd *** 
}

void
FsmState::evRequestFileDelete ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evRequestFileDelete *** 
}

void
FsmState::evRequestFileRead ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evRequestFileRead *** 
}

void
FsmState::evRequestFileReplace ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evRequestFileReplace *** 
}

void
FsmState::evRequestFileTransfer ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evRequestFileTransfer *** 
}

void
FsmState::evSessionChange ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evSessionChange *** 
}

void
FsmState::evTimeout ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evTimeout *** 
}

///////////////////////////////////////////////////////////////////////////////
//
// Abstract base class for all FSM states components.
//
///////////////////////////////////////////////////////////////////////////////

FsmState::FsmState ( void )
   : mpParent(0)
{}

FsmState::~FsmState ( void )
{
   // make lint happy
   mpParent = 0;
}

void
FsmState::initState ( FsmSuperState* pParent )
{
   mpParent = pParent;
}

void
FsmState::entry ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   //... empty as default ...
}

void
FsmState::exit ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   //... empty as default ...
}

const FsmState*
FsmState::propagate ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   b.setState(this);
   entry(b,s,pArg);
   return this;
}

FsmSuperState*
FsmState::getParent ( void )
{
   return (mpParent) ? mpParent : 0;
}

///////////////////////////////////////////////////////////////////////////////
//
// Abstract base class for all FSM superstates.
//
///////////////////////////////////////////////////////////////////////////////

FsmSuperState::FsmSuperState ( void )
   : _default(0),
     _history(0),
     _historyEnable(false)
{}

void
FsmSuperState::initSuperState ( FsmSuperState* pParent, FsmState* defState, bool histEnable )
{
   mpParent = pParent;
   _default = defState;
   _history = 0;
   _historyEnable = histEnable;
}

const FsmState*
FsmSuperState::propagate ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   const FsmState* pState = 0;

   // we have crossed a state boundary
   b.setState(this);
   // execute the entry actions for this superstate
   entry(b,s,pArg);
   
   if ( _history && _historyEnable )
   {
      pState = const_cast<FsmState*>(_history)->propagate(b,s,pArg);
   }
   else
   {
      defaultAction(b,s,pArg);
      if ( _default ) {
         pState = _default->propagate(b,s,pArg);
      }
   }
   
   return pState;
}

void
FsmSuperState::savepoint ( FsmBody& b )
{
   if ( _historyEnable )
   {
      _history = b.getState();
   }
}

void
FsmSuperState::defaultAction ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /*pArg*/ )
{
   //... empty as default ...
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: DeleteFileState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

DeleteFileState::DeleteFileState ( void )
{}

void
DeleteFileState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmDeleteFile(pArg);
}

void
DeleteFileState::evDataTransferRx ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSendErrorInvalidSequence(pArg);
   // this is an internal transition
}

void
DeleteFileState::evFileDeleted ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSendRequestFileDeleteResponse(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
DeleteFileState::evIdle ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oNotActiveState,pArg);
}

void
DeleteFileState::evInvalidFormat ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSendErrorInvalidFormat(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
DeleteFileState::evInvalidLength ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSendErrorInvalidLength(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
DeleteFileState::evInvalidRequest ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSendErrorInvalidRequest(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
DeleteFileState::evNoPermission ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSendErrorNoPermission(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
DeleteFileState::evRequestFileTransfer ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSendErrorAlreadyRequested(pArg);
   // this is an internal transition
}

void
DeleteFileState::evTimeout ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oNotActiveState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: DownloadDataState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

DownloadDataState::DownloadDataState ( void )
{}

void
DownloadDataState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmSetDownloadActive(pArg);
}

void
DownloadDataState::evIdle ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oNotActiveState,pArg);
}

void
DownloadDataState::evInvalidFormat ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSendErrorInvalidFormat(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
DownloadDataState::evInvalidLength ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSendErrorInvalidLength(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
DownloadDataState::evInvalidRequest ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSendErrorInvalidRequest(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
DownloadDataState::evNoPermission ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSendErrorNoPermission(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
DownloadDataState::evRequestFileTransfer ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSendErrorAlreadyRequested(pArg);
   // this is an internal transition
}

void
DownloadDataState::evSessionChange ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmPostprocessDownload(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
DownloadDataState::evTimeout ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oNotActiveState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: DownloadDataTransferState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

DownloadDataTransferState::DownloadDataTransferState ( void )
{}

void
DownloadDataTransferState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmCheckForCompletion(pArg);
}

void
DownloadDataTransferState::evDataTransferComplete ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmCalcCrcRam(pArg);
   b.setState(b.oDownloadDoneState,pArg);
}

void
DownloadDataTransferState::evDataTransferExit ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.bFsmIsCrcOk(pArg) )
   {
        // transition Actions
        s.vFsmSaveFile(pArg);
        s.vFsmPostprocessDownload(pArg);
        s.vFsmSendTransExitResponse(pArg);
        b.setState(b.oNotActiveState,pArg);
    }
    else
    {
   // transition Actions
   s.vFsmSendErrorInvalidDataTransExit(pArg);
   b.setState(b.oNotActiveState,pArg);
    }
}

void
DownloadDataTransferState::evDataTransferRx ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmValidateTransferredData(pArg);
   // this is an internal transition
}

void
DownloadDataTransferState::evDataTransferValidated ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.bFsmIsDataValid(pArg) )
   {
        b.setState(b.oDownloadingDataState,pArg);
    }
    else
    {
   // transition Actions
   s.vFsmSendErrorInvalidData(pArg);
   // this is an internal transition
    }
}

void
DownloadDataTransferState::evIdle ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oNotActiveState,pArg);
}

void
DownloadDataTransferState::evInvalidFormat ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSendErrorInvalidFormat(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
DownloadDataTransferState::evInvalidLength ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSendErrorInvalidLength(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
DownloadDataTransferState::evInvalidRequest ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSendErrorInvalidRequest(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
DownloadDataTransferState::evNoPermission ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSendErrorNoPermission(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
DownloadDataTransferState::evRequestFileTransfer ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSendErrorAlreadyRequested(pArg);
   // this is an internal transition
}

void
DownloadDataTransferState::evSessionChange ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmPostprocessDownload(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
DownloadDataTransferState::evTimeout ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oNotActiveState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: DownloadDoneState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

DownloadDoneState::DownloadDoneState ( void )
{}

void
DownloadDoneState::evDataTransferExit ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.bFsmIsCrcOk(pArg) )
   {
        // transition Actions
        s.vFsmSaveFile(pArg);
        s.vFsmPostprocessDownload(pArg);
        s.vFsmSendTransExitResponse(pArg);
        b.setState(b.oNotActiveState,pArg);
    }
    else
    {
   // transition Actions
   s.vFsmSendErrorInvalidDataTransExit(pArg);
   b.setState(b.oNotActiveState,pArg);
    }
}

void
DownloadDoneState::evDataTransferRx ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSendErrorInvalidSequence(pArg);
   // this is an internal transition
}

void
DownloadDoneState::evIdle ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oNotActiveState,pArg);
}

void
DownloadDoneState::evInvalidFormat ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSendErrorInvalidFormat(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
DownloadDoneState::evInvalidLength ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSendErrorInvalidLength(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
DownloadDoneState::evInvalidRequest ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSendErrorInvalidRequest(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
DownloadDoneState::evNoPermission ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSendErrorNoPermission(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
DownloadDoneState::evRequestFileTransfer ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSendErrorAlreadyRequested(pArg);
   // this is an internal transition
}

void
DownloadDoneState::evSessionChange ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmPostprocessDownload(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
DownloadDoneState::evTimeout ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oNotActiveState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: DownloadingDataState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

DownloadingDataState::DownloadingDataState ( void )
{}

void
DownloadingDataState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmDownloadData(pArg);
}

void
DownloadingDataState::evDataTransferDone ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSendDownloadTransferDataResponse(pArg);
   b.setState(b.oDownloadDataTransferState,pArg);
}

void
DownloadingDataState::evDataTransferExit ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.bFsmIsCrcOk(pArg) )
   {
        // transition Actions
        s.vFsmSaveFile(pArg);
        s.vFsmPostprocessDownload(pArg);
        s.vFsmSendTransExitResponse(pArg);
        b.setState(b.oNotActiveState,pArg);
    }
    else
    {
   // transition Actions
   s.vFsmSendErrorInvalidDataTransExit(pArg);
   b.setState(b.oNotActiveState,pArg);
    }
}

void
DownloadingDataState::evIdle ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oNotActiveState,pArg);
}

void
DownloadingDataState::evInvalidFormat ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSendErrorInvalidFormat(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
DownloadingDataState::evInvalidLength ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSendErrorInvalidLength(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
DownloadingDataState::evInvalidRequest ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSendErrorInvalidRequest(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
DownloadingDataState::evNoPermission ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSendErrorNoPermission(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
DownloadingDataState::evRequestFileTransfer ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSendErrorAlreadyRequested(pArg);
   // this is an internal transition
}

void
DownloadingDataState::evSessionChange ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmPostprocessDownload(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
DownloadingDataState::evTimeout ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oNotActiveState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: NotActiveState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

NotActiveState::NotActiveState ( void )
{}

void
NotActiveState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmReset(pArg);
}

void
NotActiveState::evDataTransferExit ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSendErrorInvalidSequence(pArg);
   // this is an internal transition
}

void
NotActiveState::evDataTransferRx ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSendErrorInvalidSequence(pArg);
   // this is an internal transition
}

void
NotActiveState::evIdle ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oNotActiveState,pArg);
}

void
NotActiveState::evInvalidFormat ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSendErrorInvalidFormat(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
NotActiveState::evInvalidLength ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSendErrorInvalidLength(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
NotActiveState::evInvalidRequest ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSendErrorInvalidRequest(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
NotActiveState::evNoPermission ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSendErrorNoPermission(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
NotActiveState::evRequestDirRead ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.areDirReadConditionsOK(pArg) )
   {
        // transition Actions
        s.vFsmPrepareDirRead(pArg);
        s.vFsmSendRequestDirReadResponse(pArg);
        b.setState(b.oUploadDataState,pArg);
    }
    else
    {
   // transition Actions
   s.vFsmSendErrorRequestRejectedDirRead(pArg);
   // this is an internal transition
    }
}

void
NotActiveState::evRequestFileAdd ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.areFileAddConditionsOK(pArg) )
   {
        // transition Actions
        s.vFsmPrepareFileAdd(pArg);
        s.vFsmSendRequestFileAddResponse(pArg);
        b.setState(b.oDownloadDataState,pArg);
    }
    else
    {
   // transition Actions
   s.vFsmSendErrorRequestRejectedFileAdd(pArg);
   // this is an internal transition
    }
}

void
NotActiveState::evRequestFileDelete ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.areFileDeleteConditionsOK(pArg) )
   {
        // transition Actions
        s.vFsmPrepareFileDelete(pArg);
        b.setState(b.oDeleteFileState,pArg);
    }
    else
    {
   // transition Actions
   s.vFsmSendErrorRequestRejectedFileDelete(pArg);
   // this is an internal transition
    }
}

void
NotActiveState::evRequestFileRead ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.areFileReadConditionsOK(pArg) )
   {
        // transition Actions
        s.vFsmPrepareFileRead(pArg);
        s.vFsmSendRequestFileReadResponse(pArg);
        b.setState(b.oUploadDataState,pArg);
    }
    else
    {
   // transition Actions
   s.vFsmSendErrorRequestRejectedFileRead(pArg);
   // this is an internal transition
    }
}

void
NotActiveState::evRequestFileReplace ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.areFileReplaceConditionsOK(pArg) )
   {
        // transition Actions
        s.vFsmPrepareFileReplace(pArg);
        s.vFsmSendRequestFileReplaceResponse(pArg);
        b.setState(b.oDownloadDataState,pArg);
    }
    else
    {
   // transition Actions
   s.vFsmSendErrorRequestRejectedFileReplace(pArg);
   // this is an internal transition
    }
}

void
NotActiveState::evRequestFileTransfer ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmValidateFileTransferRequest(pArg);
   // this is an internal transition
}

void
NotActiveState::evTimeout ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oNotActiveState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: ToplevelState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

ToplevelState::ToplevelState ( void )
{}

void
ToplevelState::evIdle ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oNotActiveState,pArg);
}

void
ToplevelState::evInvalidFormat ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSendErrorInvalidFormat(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
ToplevelState::evInvalidLength ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSendErrorInvalidLength(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
ToplevelState::evInvalidRequest ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSendErrorInvalidRequest(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
ToplevelState::evNoPermission ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSendErrorNoPermission(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
ToplevelState::evTimeout ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oNotActiveState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: UploadDataState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

UploadDataState::UploadDataState ( void )
{}

void
UploadDataState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmSetUploadActive(pArg);
}

void
UploadDataState::evIdle ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oNotActiveState,pArg);
}

void
UploadDataState::evInvalidFormat ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSendErrorInvalidFormat(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
UploadDataState::evInvalidLength ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSendErrorInvalidLength(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
UploadDataState::evInvalidRequest ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSendErrorInvalidRequest(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
UploadDataState::evNoPermission ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSendErrorNoPermission(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
UploadDataState::evRequestFileTransfer ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSendErrorAlreadyRequested(pArg);
   // this is an internal transition
}

void
UploadDataState::evSessionChange ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmPostprocessUpload(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
UploadDataState::evTimeout ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oNotActiveState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: UploadDataTransferState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

UploadDataTransferState::UploadDataTransferState ( void )
{}

void
UploadDataTransferState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmCheckForCompletion(pArg);
}

void
UploadDataTransferState::evDataTransferComplete ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oUploadDoneState,pArg);
}

void
UploadDataTransferState::evDataTransferExit ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmPostprocessUpload(pArg);
   s.vFsmSendTransExitResponse(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
UploadDataTransferState::evDataTransferRx ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmUploadData(pArg);
   s.vFsmSendUploadTransferDataResponse(pArg);
   b.setState(b.oUploadDataTransferState,pArg);
}

void
UploadDataTransferState::evIdle ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oNotActiveState,pArg);
}

void
UploadDataTransferState::evInvalidFormat ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSendErrorInvalidFormat(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
UploadDataTransferState::evInvalidLength ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSendErrorInvalidLength(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
UploadDataTransferState::evInvalidRequest ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSendErrorInvalidRequest(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
UploadDataTransferState::evNoPermission ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSendErrorNoPermission(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
UploadDataTransferState::evRequestFileTransfer ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSendErrorAlreadyRequested(pArg);
   // this is an internal transition
}

void
UploadDataTransferState::evSessionChange ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmPostprocessUpload(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
UploadDataTransferState::evTimeout ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oNotActiveState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: UploadDoneState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

UploadDoneState::UploadDoneState ( void )
{}

void
UploadDoneState::evDataTransferExit ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmPostprocessUpload(pArg);
   s.vFsmSendTransExitResponse(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
UploadDoneState::evDataTransferRx ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSendErrorInvalidSequence(pArg);
   // this is an internal transition
}

void
UploadDoneState::evIdle ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oNotActiveState,pArg);
}

void
UploadDoneState::evInvalidFormat ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSendErrorInvalidFormat(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
UploadDoneState::evInvalidLength ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSendErrorInvalidLength(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
UploadDoneState::evInvalidRequest ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSendErrorInvalidRequest(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
UploadDoneState::evNoPermission ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSendErrorNoPermission(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
UploadDoneState::evRequestFileTransfer ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSendErrorAlreadyRequested(pArg);
   // this is an internal transition
}

void
UploadDoneState::evSessionChange ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmPostprocessUpload(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
UploadDoneState::evTimeout ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oNotActiveState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
//
// This is the finite state machine class implementation
//
///////////////////////////////////////////////////////////////////////////////

Fsm::Fsm ( void )
    : mpBehaviour(0),
      mpBody(0)
{
}

Fsm::Fsm ( FsmBehaviour* server )
    : mpBehaviour(server),
      mpBody(0)
{}

Fsm::~Fsm ( void )
{
    if ( mpBody )
    {
        delete mpBody;
        mpBody = 0;
    }
    mpBehaviour = 0;
}

bool
Fsm::createFSM ( Fsm** ppFSM, FsmBehaviour* behaviour )
{
   bool retCode = false;

   if ( ppFSM && behaviour )
   {
      (*ppFSM) = new Fsm(behaviour);
      if ( (*ppFSM) )
      {
         if ( !((*ppFSM)->init()) )
         {
            delete (*ppFSM);
            (*ppFSM) = 0;
         }
         else
         {
            retCode = true;
         }
      }
   }

   return retCode;
}

bool
Fsm::init ( void )
{
   bool retCode = false;
   
   mpBody = new FsmBody();
   
   if ( mpBody )
   {
      // connect the body with its frontend
      mpBody->connect(this);
      if ( mpBody->init() )
      {
          retCode = true;
      }
   }
   
   return retCode;
}

const char*
Fsm::getStateName (void) const
{
    return ( mpBody ) ? mpBody->getStateName() : 0;
}

void 
Fsm::acceptEvent ( FsmEvent event, void* pArg )
{
    if ( mpBody )
    {
        // forward the event to the FSM body (handle-body pattern)
        mpBody->acceptEvent(event,pArg);
    }
}
///////////////////////////////////////////////////////////////////////////////
//
// This is the finite state machine class implementation
//
///////////////////////////////////////////////////////////////////////////////

FsmBody::FsmBody ( void ) :
      mpFrontend(0),
      mpState(0),
      mBusyFlag(false),
      mQueueHead(0),
      mQueueTail(0),
      mQueueSize(0)
{
    (void) ::memset(mEventQueue,0,sizeof(FsmEvent)*MAX_TRIGGER_EVENTS);
    (void) ::memset(mParamQueue,0,sizeof(void*)*MAX_TRIGGER_EVENTS);
}

bool
FsmBody::init ( void )
{
    oDeleteFileState.initState(&oToplevelState);
    oDownloadDataState.initSuperState(&oToplevelState, &oDownloadDataTransferState, false);
    oDownloadDataTransferState.initState(&oDownloadDataState);
    oDownloadDoneState.initState(&oDownloadDataState);
    oDownloadingDataState.initState(&oDownloadDataState);
    oNotActiveState.initState(&oToplevelState);
    oToplevelState.initSuperState(0, &oNotActiveState, false);
    oUploadDataState.initSuperState(&oToplevelState, &oUploadDataTransferState, false);
    oUploadDataTransferState.initState(&oUploadDataState);
    oUploadDoneState.initState(&oUploadDataState);

    setState(oToplevelState,0);
    
    return true;
}

void
FsmBody::connect ( Fsm* frontend )
{
    mpFrontend = frontend;
}

const char*
FsmBody::getStateName ( void ) const
{
    return ( mpState ) ? mpState->getStateName() : 0;
}

bool
FsmBody::addEvent ( const FsmEvent& event, void* param )
{
    if ( mQueueSize < MAX_TRIGGER_EVENTS )
    {
        mQueueSize++;
        mEventQueue[mQueueTail] = event;
        mParamQueue[mQueueTail] = param;
        mQueueTail++;
        if ( mQueueTail == MAX_TRIGGER_EVENTS )
        {
            mQueueTail = 0;
        }
        return true;
    }
    return false;
}

bool
FsmBody::getEvent ( FsmEvent& event, void** param )
{
    if ( !mQueueSize || !param )
    {
        return false;
    }
    mQueueSize--;
    event  = mEventQueue[mQueueHead];
    *param = mParamQueue[mQueueHead];
    mQueueHead++;
    if ( mQueueHead == MAX_TRIGGER_EVENTS )
    {
        mQueueHead = 0;
    }
    return true;
}

bool
FsmBody::isQueueEmpty ( void ) const
{
    return ( mQueueSize ) ? false : true;
}

void 
FsmBody::acceptEvent ( FsmEvent event, void* pArg )
{
    (void) addEvent(event,pArg);

    if ( mBusyFlag )
    {
        return;
    }

    mBusyFlag = true;
    while ( !isQueueEmpty() )
    {
        FsmEvent nextEvent = evUnknown;
        void*    nextArg   = 0;
        if ( !getEvent(nextEvent,&nextArg) )
        {
            break;
        }

        switch (nextEvent)
        {
        case evDataTransferComplete:
            if ( mpState ) mpState->evDataTransferComplete(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evDataTransferDone:
            if ( mpState ) mpState->evDataTransferDone(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evDataTransferExit:
            if ( mpState ) mpState->evDataTransferExit(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evDataTransferRx:
            if ( mpState ) mpState->evDataTransferRx(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evDataTransferValidated:
            if ( mpState ) mpState->evDataTransferValidated(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evFileDeleted:
            if ( mpState ) mpState->evFileDeleted(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evIdle:
            if ( mpState ) mpState->evIdle(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evInvalidFormat:
            if ( mpState ) mpState->evInvalidFormat(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evInvalidLength:
            if ( mpState ) mpState->evInvalidLength(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evInvalidRequest:
            if ( mpState ) mpState->evInvalidRequest(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evNoPermission:
            if ( mpState ) mpState->evNoPermission(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evRequestDirRead:
            if ( mpState ) mpState->evRequestDirRead(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evRequestFileAdd:
            if ( mpState ) mpState->evRequestFileAdd(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evRequestFileDelete:
            if ( mpState ) mpState->evRequestFileDelete(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evRequestFileRead:
            if ( mpState ) mpState->evRequestFileRead(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evRequestFileReplace:
            if ( mpState ) mpState->evRequestFileReplace(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evRequestFileTransfer:
            if ( mpState ) mpState->evRequestFileTransfer(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evSessionChange:
            if ( mpState ) mpState->evSessionChange(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evTimeout:
            if ( mpState ) mpState->evTimeout(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        default:
            //... unknown event ...
            break;
        } //lint !e788: not all items used within defaulted switch
    }
    mBusyFlag = false;
}

void 
FsmBody::setState ( FsmState& state, void* pArg )
{
    if ( mpFrontend )
    {
        mpState = const_cast<FsmState*>(state.propagate(*this,*(mpFrontend->mpBehaviour),pArg));
    }
}

void 
FsmBody::setState ( FsmState* pState )
{
    mpState = pState;
}

const FsmState*
FsmBody::getState ( void ) const
{
    return mpState;
}

///////////////////////////////////////////////////////////////////////////////
//
// Functions
//
///////////////////////////////////////////////////////////////////////////////

const char* getEventName ( FsmEvent event )
{
   static const char* eventNames[evCount] = {
      "evUnknown",
      "evDataTransferComplete",
      "evDataTransferDone",
      "evDataTransferExit",
      "evDataTransferRx",
      "evDataTransferValidated",
      "evFileDeleted",
      "evIdle",
      "evInvalidFormat",
      "evInvalidLength",
      "evInvalidRequest",
      "evNoPermission",
      "evRequestDirRead",
      "evRequestFileAdd",
      "evRequestFileDelete",
      "evRequestFileRead",
      "evRequestFileReplace",
      "evRequestFileTransfer",
      "evSessionChange",
      "evTimeout",
   };

   return eventNames[event];
}


} // namespace
