///////////////////////////////////////////////////////////////////////////////
//
// File: dia_EngineUdsFSM.h
//
// Generated by SMC 4.4.0 (C++ State Pattern Code Generator)
//
///////////////////////////////////////////////////////////////////////////////

#ifndef __INCLUDED_DIA_ENGINEUDSFSM__
#define __INCLUDED_DIA_ENGINEUDSFSM__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

namespace dia_EngineUdsFSM
{

///////////////////////////////////////////////////////////////////////////////
//
// Forward Declarations
//
///////////////////////////////////////////////////////////////////////////////

class FsmBody;

///////////////////////////////////////////////////////////////////////////////
//
// Enums and typedefs
//
///////////////////////////////////////////////////////////////////////////////

//! enumeration of FSM events. First and last item added by SMC
enum FsmEvent
{
   evUnknown = 0,
   evConfTxOk,
   evIdle,
   evIntMsgRx,
   evReqChecked,
   evReqRx,
   evReqRxOk,
   evResReady,
   evResReadyAndQuit,
   evTimeout,
   evCount
};

///////////////////////////////////////////////////////////////////////////////
//
const char* getEventName ( FsmEvent event );
// Class: FsmBehaviour
//
// This is the base class for the FSM server (provides implementation for all
// actions and guards)
//
///////////////////////////////////////////////////////////////////////////////

class FsmBehaviour
{ 
   friend class ActiveState;
   friend class ActiveReadyForReqRxState;
   friend class ActiveValidateState;
   friend class BusyState;
   friend class IdleState;
   friend class IdleReadyForReqRxState;
   friend class IdleValidateState;
   friend class PostProcessingState;
   friend class ProcessingState;
   friend class ReadyForReqRxState;
   friend class TopLevelState;
   friend class WaitConfTxAndQuitState;
   friend class FsmBody;

public:
   virtual ~FsmBehaviour ( void ) {}

protected:
   // FSM actions
   virtual void vFsmAdoptRequest ( void* pArg ) = 0;
   virtual void vFsmCleanupProcessing ( void* pArg ) = 0;
   virtual void vFsmConfirmationTimeout ( void* pArg ) = 0;
   virtual void vFsmDispatchInternalMsg ( void* pArg ) = 0;
   virtual void vFsmIgnoreRequest ( void* pArg ) = 0;
   virtual void vFsmInitRx ( void* pArg ) = 0;
   virtual void vFsmPostProcessingTimeout ( void* pArg ) = 0;
   virtual void vFsmPrepareProcessing ( void* pArg ) = 0;
   virtual void vFsmProcessingTimeout ( void* pArg ) = 0;
   virtual void vFsmResetRx ( void* pArg ) = 0;
   virtual void vFsmSendConfirmation ( void* pArg ) = 0;
   virtual void vFsmSetDiagActive ( void* pArg ) = 0;
   virtual void vFsmSetDiagInactive ( void* pArg ) = 0;
   virtual void vFsmStartConfirmationTimer ( void* pArg ) = 0;
   virtual void vFsmStartPostProcessing ( void* pArg ) = 0;
   virtual void vFsmStartPostProcessingTimer ( void* pArg ) = 0;
   virtual void vFsmStartProcessing ( void* pArg ) = 0;
   virtual void vFsmStartProcessingTimer ( void* pArg ) = 0;
   virtual void vFsmStartTests ( void* pArg ) = 0;
   virtual void vFsmStopConfirmationTimer ( void* pArg ) = 0;
   virtual void vFsmStopPostProcessingTimer ( void* pArg ) = 0;
   virtual void vFsmStopProcessingTimer ( void* pArg ) = 0;
   virtual void vFsmValidateRequest ( void* pArg ) = 0;

   // FSM guards
   virtual bool bFsmIsServiceAccepted ( void* pArg ) = 0;
   virtual bool bFsmIsServiceInternal ( void* pArg ) = 0;
};

///////////////////////////////////////////////////////////////////////////////
//
// Class: Fsm
//
// This is the finite state machine class 'dia_EngineUdsFSM'.
//
///////////////////////////////////////////////////////////////////////////////

class Fsm
{
    //! we grant the body class access to our protected section
    friend class FsmBody;

public:
    //! class constructor
    Fsm ( FsmBehaviour* behaviour );
    //! class destructor
    virtual ~Fsm ( void );

    //! setup and initialize the state machine
    virtual void init ( void );

    //! this method is used to stimulate the FSM with events
    virtual void acceptEvent ( FsmEvent event, void* pArg );

    //! return the name of the current state
    virtual const char* getStateName ( void ) const;

protected:
    //! protected default constructor to avoid usage
    Fsm ( void );
    //! copy constructor without implementation
    Fsm ( const Fsm& obj );
    //! assignment operator without implementation
    Fsm& operator = ( const Fsm& obj );

protected:
    //! pointer to the server that provides the implementation for the actions and guards
    FsmBehaviour* mpBehaviour;
    //! body of the FSM implementation
    FsmBody* mpBody;
};


} // namespace

#endif
