///////////////////////////////////////////////////////////////////////////////
//
// File: dia_EngineUdsFSM.cpp
//
// Generated by SMC 4.4.0 (C++ State Pattern Code Generator)
//
///////////////////////////////////////////////////////////////////////////////

#include <string.h>

#ifndef __INCLUDED_DIA_ENGINEUDSFSM__
#include "dia_EngineUdsFSM.h"
#endif

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

namespace dia_EngineUdsFSM
{

const unsigned int MAX_TRIGGER_EVENTS = 50;

const unsigned int MAX_DEFERRED_EVENTS = 50;

///////////////////////////////////////////////////////////////////////////////
//
// Forward Declarations
//
///////////////////////////////////////////////////////////////////////////////

class Fsm;
class FsmSuperState;

///////////////////////////////////////////////////////////////////////////////
//
// Abstract base class for all FSM states.
//
///////////////////////////////////////////////////////////////////////////////

class FsmState
{
public:
   //! name of the FSM's state
   virtual const char* getStateName ( void ) const = 0;

   //! resetting state internals
   virtual void reset ( void ) {}

   // event functions 
   virtual void evConfTxOk ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIntMsgRx ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReqChecked ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReqRx ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReqRxOk ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evResReady ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evResReadyAndQuit ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! default implementation for the Entry action
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! default implementation for the Exit action
   virtual void exit  ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! method used to propagate the event to the superstate
   virtual const FsmState* propagate ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! return the parent state
   virtual FsmSuperState* getParent ( void );


protected:
   //! default constructor is protected to prevent usage of this constructor
   FsmState ( void );
   //! constructor for a substate of the given superstate
   FsmState ( FsmSuperState& parent );
   //! class destructor
   virtual ~FsmState ( void );

   //! pointer to the superstate
   FsmSuperState* mpParent;
};

///////////////////////////////////////////////////////////////////////////////
//
// Abstract base class for all FSM superstates.
//
///////////////////////////////////////////////////////////////////////////////

class FsmSuperState
   : public FsmState
{
public:
   //! class constructor for a superstate without parent
   FsmSuperState ( FsmState& defState, bool histEnable=false );
   //! class constructor for a superstate with parent
   FsmSuperState ( FsmSuperState& parent, FsmState& defState, bool histEnable=false );

   //! set a savepoint for the history
   virtual void savepoint ( FsmBody& b );
   //! default action
   virtual void defaultAction ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! resetting state internals
   virtual void reset ( void ) { _history = 0; }

   //! method used to propagate the event to the superstate
   virtual const FsmState* propagate ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   //! default constructor is protected to prevent usage of this constructor
   FsmSuperState ( void );

   //! pointer to the default substate
   FsmState* _default;
   //! pointer to the history substate
   const FsmState* _history;
   //! flag that indicates if history is enabled or not
   bool _historyEnable;
};

///////////////////////////////////////////////////////////////////////////////
// 
// Class: ActiveState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class ActiveState
   : public FsmState
{
public:
   //! default constructor
   ActiveState ( void );

   ActiveState ( FsmBody& b );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIntMsgRx ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReqRx ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReqRxOk ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* ActiveState::mStateName = "Active";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: ActiveReadyForReqRxState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class ActiveReadyForReqRxState
   : public FsmSuperState
{
public:
   //! default constructor
   ActiveReadyForReqRxState ( void );

   ActiveReadyForReqRxState ( FsmBody& b );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIntMsgRx ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReqRx ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReqRxOk ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* ActiveReadyForReqRxState::mStateName = "ActiveReadyForReqRx";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: ActiveValidateState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class ActiveValidateState
   : public FsmState
{
public:
   //! default constructor
   ActiveValidateState ( void );

   ActiveValidateState ( FsmBody& b );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIntMsgRx ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReqChecked ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReqRxOk ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! deferred events
   virtual void evReqRx ( FsmBody& b, FsmBehaviour& s, void* pArg );


protected:
   //! array for recording received events to be deferred
   FsmEvent _deferredEvents[MAX_DEFERRED_EVENTS];
   //! array for recording params of events to be deferred
   void*    _deferredParams[MAX_DEFERRED_EVENTS];
   //! number of events currently deferred
   int _numDeferredEvents;


protected:
   static const char* mStateName;
};

const char* ActiveValidateState::mStateName = "ActiveValidate";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: BusyState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class BusyState
   : public FsmSuperState
{
public:
   //! default constructor
   BusyState ( void );

   BusyState ( FsmBody& b );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evIntMsgRx ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evResReadyAndQuit ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! deferred events
   virtual void evReqRx ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! exit actions
   virtual void exit ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   //! array for recording received events to be deferred
   FsmEvent _deferredEvents[MAX_DEFERRED_EVENTS];
   //! array for recording params of events to be deferred
   void*    _deferredParams[MAX_DEFERRED_EVENTS];
   //! number of events currently deferred
   int _numDeferredEvents;


protected:
   static const char* mStateName;
};

const char* BusyState::mStateName = "Busy";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: IdleState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class IdleState
   : public FsmState
{
public:
   //! default constructor
   IdleState ( void );

   IdleState ( FsmBody& b );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evIntMsgRx ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReqRx ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* IdleState::mStateName = "Idle";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: IdleReadyForReqRxState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class IdleReadyForReqRxState
   : public FsmSuperState
{
public:
   //! default constructor
   IdleReadyForReqRxState ( void );

   IdleReadyForReqRxState ( FsmBody& b );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evIntMsgRx ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReqRx ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* IdleReadyForReqRxState::mStateName = "IdleReadyForReqRx";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: IdleValidateState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class IdleValidateState
   : public FsmState
{
public:
   //! default constructor
   IdleValidateState ( void );

   IdleValidateState ( FsmBody& b );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evIntMsgRx ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReqChecked ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! deferred events
   virtual void evReqRx ( FsmBody& b, FsmBehaviour& s, void* pArg );


protected:
   //! array for recording received events to be deferred
   FsmEvent _deferredEvents[MAX_DEFERRED_EVENTS];
   //! array for recording params of events to be deferred
   void*    _deferredParams[MAX_DEFERRED_EVENTS];
   //! number of events currently deferred
   int _numDeferredEvents;


protected:
   static const char* mStateName;
};

const char* IdleValidateState::mStateName = "IdleValidate";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: PostProcessingState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class PostProcessingState
   : public FsmState
{
public:
   //! default constructor
   PostProcessingState ( void );

   PostProcessingState ( FsmBody& b );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evIntMsgRx ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evResReadyAndQuit ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! deferred events
   virtual void evReqRx ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! exit actions
   virtual void exit ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   //! array for recording received events to be deferred
   FsmEvent _deferredEvents[MAX_DEFERRED_EVENTS];
   //! array for recording params of events to be deferred
   void*    _deferredParams[MAX_DEFERRED_EVENTS];
   //! number of events currently deferred
   int _numDeferredEvents;


protected:
   static const char* mStateName;
};

const char* PostProcessingState::mStateName = "PostProcessing";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: ProcessingState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class ProcessingState
   : public FsmState
{
public:
   //! default constructor
   ProcessingState ( void );

   ProcessingState ( FsmBody& b );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evIntMsgRx ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evResReady ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evResReadyAndQuit ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! deferred events
   virtual void evReqRx ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! exit actions
   virtual void exit ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   //! array for recording received events to be deferred
   FsmEvent _deferredEvents[MAX_DEFERRED_EVENTS];
   //! array for recording params of events to be deferred
   void*    _deferredParams[MAX_DEFERRED_EVENTS];
   //! number of events currently deferred
   int _numDeferredEvents;


protected:
   static const char* mStateName;
};

const char* ProcessingState::mStateName = "Processing";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: ReadyForReqRxState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class ReadyForReqRxState
   : public FsmSuperState
{
public:
   //! default constructor
   ReadyForReqRxState ( void );

   ReadyForReqRxState ( FsmBody& b );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evIntMsgRx ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReqRx ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! exit actions
   virtual void exit ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! set a savepoint for the history
   virtual void savepoint ( FsmBody& b );

protected:
   static const char* mStateName;
};

const char* ReadyForReqRxState::mStateName = "ReadyForReqRx";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: TopLevelState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class TopLevelState
   : public FsmSuperState
{
public:
   //! default constructor
   TopLevelState ( void );

   TopLevelState ( FsmBody& b );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evIntMsgRx ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReqRx ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* TopLevelState::mStateName = "TopLevel";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: WaitConfTxAndQuitState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class WaitConfTxAndQuitState
   : public FsmState
{
public:
   //! default constructor
   WaitConfTxAndQuitState ( void );

   WaitConfTxAndQuitState ( FsmBody& b );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evConfTxOk ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! deferred events
   virtual void evReqRx ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIntMsgRx ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! exit actions
   virtual void exit ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   //! array for recording received events to be deferred
   FsmEvent _deferredEvents[MAX_DEFERRED_EVENTS];
   //! array for recording params of events to be deferred
   void*    _deferredParams[MAX_DEFERRED_EVENTS];
   //! number of events currently deferred
   int _numDeferredEvents;


protected:
   static const char* mStateName;
};

const char* WaitConfTxAndQuitState::mStateName = "WaitConfTxAndQuit";

///////////////////////////////////////////////////////////////////////////////
//
// Class: FsmBody
//
// This is the finite state machine's body class 'FsmBody'.
//
///////////////////////////////////////////////////////////////////////////////

class FsmBody
{
    struct FsmDeferredEvent
    {
          FsmDeferredEvent() : mEvent(evUnknown), mArg(0) {}
          FsmEvent mEvent;
          void*    mArg;
    };

public:
    //! class constructor
    FsmBody ( void );

    //! connect the FSM body with its frontend
    void connect ( Fsm* frontend );

    //! initialize the FSM: set initial state and execute initial actions
    void init ( void );

    //! this method is used to stimulate the FSM with events
    void acceptEvent ( FsmEvent event, void* pArg );

    //! return the name of the active state
    const char* getStateName ( void ) const;

    //! push trigger events to the event queue
    bool addEvent ( const FsmEvent& event, void* arg  );
    //! get event from the event queue
    bool getEvent ( FsmEvent& event, void** arg  );
    //! get event from the event queue
    bool isQueueEmpty ( void ) const;

    //! push deferred events to the pool of deferred events
    bool addDeferredEvent ( const FsmEvent& event, void* arg );
    //! get deferred event from the pool of deferred events
    bool getDeferredEvent ( FsmEvent& event, void** arg );
    //! check if the event pool is empty
    bool isPoolOfDeferredEventsEmpty ( void ) const;

    // set the FSM's internal state and propagate to default or history substate
    void setState ( FsmState& state, void* pArg );
    // set the FSM's internal state (no propagation
    void setState ( FsmState* pState );
    // return the active state object
    const FsmState* getState ( void ) const;

    //! static state objects
    ActiveState oActiveState;
    ActiveReadyForReqRxState oActiveReadyForReqRxState;
    ActiveValidateState oActiveValidateState;
    BusyState oBusyState;
    IdleState oIdleState;
    IdleReadyForReqRxState oIdleReadyForReqRxState;
    IdleValidateState oIdleValidateState;
    PostProcessingState oPostProcessingState;
    ProcessingState oProcessingState;
    ReadyForReqRxState oReadyForReqRxState;
    TopLevelState oTopLevelState;
    WaitConfTxAndQuitState oWaitConfTxAndQuitState;

    //! frontend for this body
    Fsm* mpFrontend;
    //! link to the active state object
    FsmState* mpState;

    //! busy indicator flag
    bool mBusyFlag;

    //! queue of trigger events
    FsmEvent mEventQueue[MAX_TRIGGER_EVENTS];
    //! queue of arguments for trigger events
    void*    mParamQueue[MAX_TRIGGER_EVENTS];
    //! index of the queue's front element
    unsigned int mQueueHead;
    //! index of the queue's back element
    unsigned int mQueueTail;
    //! number of queued events
    unsigned int mQueueSize;
    //! pool of deferred events
    FsmDeferredEvent mDeferredEventPool[MAX_DEFERRED_EVENTS];
    //! index of the pool's front element
    unsigned int mPoolHead;
    //! index of the pool's back element
    unsigned int mPoolTail;
    //! number of deferred events stored in the pool
    unsigned int mPoolSize;
};

///////////////////////////////////////////////////////////////////////////////
//
// Default implementation for all events.
//
///////////////////////////////////////////////////////////////////////////////

void
FsmState::evConfTxOk ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evConfTxOk *** 
}

void
FsmState::evIdle ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evIdle *** 
}

void
FsmState::evIntMsgRx ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evIntMsgRx *** 
}

void
FsmState::evReqChecked ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evReqChecked *** 
}

void
FsmState::evReqRx ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evReqRx *** 
}

void
FsmState::evReqRxOk ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evReqRxOk *** 
}

void
FsmState::evResReady ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evResReady *** 
}

void
FsmState::evResReadyAndQuit ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evResReadyAndQuit *** 
}

void
FsmState::evTimeout ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evTimeout *** 
}

///////////////////////////////////////////////////////////////////////////////
//
// Abstract base class for all FSM states components.
//
///////////////////////////////////////////////////////////////////////////////

FsmState::FsmState ( void )
   : mpParent(0)
{}

FsmState::FsmState ( FsmSuperState& parent )
   : mpParent(&parent)
{}

FsmState::~FsmState ( void )
{
   // make lint happy
   mpParent = 0;
}

void
FsmState::entry ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   //... empty as default ...
}

void
FsmState::exit ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   //... empty as default ...
}

const FsmState*
FsmState::propagate ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   b.setState(this);
   entry(b,s,pArg);
   return this;
}

FsmSuperState*
FsmState::getParent ( void )
{
   return (mpParent) ? mpParent : 0;
}

///////////////////////////////////////////////////////////////////////////////
//
// Abstract base class for all FSM superstates.
//
///////////////////////////////////////////////////////////////////////////////

FsmSuperState::FsmSuperState ( FsmState& defState, bool histEnable )
   : _default(&defState),
     _history(0),
     _historyEnable(histEnable)
{}

FsmSuperState::FsmSuperState ( FsmSuperState& parent, FsmState& defState, bool histEnable )
   : FsmState(parent),
     _default(&defState),
     _history(0),
     _historyEnable(histEnable)
{}

FsmSuperState::FsmSuperState ( void )
   : _default(0),
     _history(0),
     _historyEnable(false)
{}

const FsmState*
FsmSuperState::propagate ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   const FsmState* pState = 0;

   // we have crossed a state boundary
   b.setState(this);
   // execute the entry actions for this superstate
   entry(b,s,pArg);
   
   if ( _history && _historyEnable )
   {
      pState = const_cast<FsmState*>(_history)->propagate(b,s,pArg);
   }
   else
   {
      defaultAction(b,s,pArg);
      if ( _default ) {
         pState = _default->propagate(b,s,pArg);
      }
   }
   
   return pState;
}

void
FsmSuperState::savepoint ( FsmBody& b )
{
   if ( _historyEnable )
   {
      _history = b.getState();
   }
}

void
FsmSuperState::defaultAction ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /*pArg*/ )
{
   //... empty as default ...
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: ActiveState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

ActiveState::ActiveState ( void )
{}

ActiveState::ActiveState ( FsmBody& b )
   : FsmState(b.oActiveReadyForReqRxState) 
{}

void
ActiveState::evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSetDiagInactive(pArg);
//   b.oReadyForReqRxState.entry(b,s,pArg);
   b.setState(b.oIdleReadyForReqRxState,pArg);
}

void
ActiveState::evIntMsgRx ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmDispatchInternalMsg(pArg);
   // this is an internal transition
}

void
ActiveState::evReqRx ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmAdoptRequest(pArg);
   s.vFsmValidateRequest(pArg);
   // trigger events
   FsmEvent event = dia_EngineUdsFSM::evUnknown;

   event = dia_EngineUdsFSM::evReqChecked; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   b.setState(b.oActiveValidateState,pArg);
}

void
ActiveState::evReqRxOk ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // set savepoint in superstate with enabled history
   b.oReadyForReqRxState.savepoint(b);

   b.oReadyForReqRxState.exit(b,s,pArg);
   b.setState(b.oBusyState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: ActiveReadyForReqRxState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

ActiveReadyForReqRxState::ActiveReadyForReqRxState ( void )
{}

ActiveReadyForReqRxState::ActiveReadyForReqRxState ( FsmBody& b )
   : FsmSuperState(b.oReadyForReqRxState, b.oActiveState, false)
{}

void
ActiveReadyForReqRxState::evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSetDiagInactive(pArg);
   b.setState(b.oIdleReadyForReqRxState,pArg);
}

void
ActiveReadyForReqRxState::evIntMsgRx ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmDispatchInternalMsg(pArg);
   // this is an internal transition
}

void
ActiveReadyForReqRxState::evReqRx ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmIgnoreRequest(pArg);
   // this is an internal transition
}

void
ActiveReadyForReqRxState::evReqRxOk ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // set savepoint in superstate with enabled history
   b.oReadyForReqRxState.savepoint(b);

   b.oReadyForReqRxState.exit(b,s,pArg);
   b.setState(b.oBusyState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: ActiveValidateState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

ActiveValidateState::ActiveValidateState ( void )
   : _numDeferredEvents(0)
{
   (void) ::memset(_deferredEvents, 0, sizeof(FsmEvent)*MAX_DEFERRED_EVENTS);
   (void) ::memset(_deferredParams, 0, sizeof(FsmEvent)*MAX_DEFERRED_EVENTS);
}

ActiveValidateState::ActiveValidateState ( FsmBody& b )
   : FsmState(b.oActiveReadyForReqRxState) 
   , _numDeferredEvents(0)
{
   (void) ::memset(_deferredEvents, 0, sizeof(FsmEvent)*MAX_DEFERRED_EVENTS);
   (void) ::memset(_deferredParams, 0, sizeof(FsmEvent)*MAX_DEFERRED_EVENTS);
}

void
ActiveValidateState::evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSetDiagInactive(pArg);
   // trigger deferred events
   while ( !b.isPoolOfDeferredEventsEmpty() )
   {
       FsmEvent defevent = evUnknown;
       void*    defarg   = 0;
       if ( b.getDeferredEvent(defevent,&defarg) )
       {
           b.addEvent(defevent,defarg);
       }
   }
   b.oReadyForReqRxState.entry(b,s,pArg);
   b.setState(b.oIdleReadyForReqRxState,pArg);
}

void
ActiveValidateState::evIntMsgRx ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmDispatchInternalMsg(pArg);
   // this is an internal transition
}

void
ActiveValidateState::evReqChecked ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.bFsmIsServiceAccepted(pArg) )
   {
        // set savepoint in superstate with enabled history
        b.oReadyForReqRxState.savepoint(b);

        b.oReadyForReqRxState.exit(b,s,pArg);
        // trigger deferred events
        while ( !b.isPoolOfDeferredEventsEmpty() )
        {
            FsmEvent defevent = evUnknown;
            void*    defarg   = 0;
            if ( b.getDeferredEvent(defevent,&defarg) )
            {
                b.addEvent(defevent,defarg);
            }
        }
        b.setState(b.oBusyState,pArg);
    }
    else
    {
   // set savepoint in superstate with enabled history
   b.oReadyForReqRxState.savepoint(b);

   b.oReadyForReqRxState.exit(b,s,pArg);
   // transition Actions
   s.vFsmStartProcessing(pArg);
   s.vFsmCleanupProcessing(pArg);
   // trigger deferred events
   while ( !b.isPoolOfDeferredEventsEmpty() )
   {
       FsmEvent defevent = evUnknown;
       void*    defarg   = 0;
       if ( b.getDeferredEvent(defevent,&defarg) )
       {
           b.addEvent(defevent,defarg);
       }
   }
   b.setState(b.oWaitConfTxAndQuitState,pArg);
    }
}

void
ActiveValidateState::evReqRxOk ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // set savepoint in superstate with enabled history
   b.oReadyForReqRxState.savepoint(b);

   b.oReadyForReqRxState.exit(b,s,pArg);
   // trigger deferred events
   while ( !b.isPoolOfDeferredEventsEmpty() )
   {
       FsmEvent defevent = evUnknown;
       void*    defarg   = 0;
       if ( b.getDeferredEvent(defevent,&defarg) )
       {
           b.addEvent(defevent,defarg);
       }
   }
   b.setState(b.oBusyState,pArg);
}

void
ActiveValidateState::evReqRx( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // defer event
   FsmEvent event = dia_EngineUdsFSM::evReqRx;

   b.addDeferredEvent(event,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: BusyState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

BusyState::BusyState ( void )
   : _numDeferredEvents(0)
{
   (void) ::memset(_deferredEvents, 0, sizeof(FsmEvent)*MAX_DEFERRED_EVENTS);
   (void) ::memset(_deferredParams, 0, sizeof(FsmEvent)*MAX_DEFERRED_EVENTS);
}

BusyState::BusyState ( FsmBody& b )
   : FsmSuperState(b.oTopLevelState, b.oProcessingState, false)
   , _numDeferredEvents(0)
{
   (void) ::memset(_deferredEvents, 0, sizeof(FsmEvent)*MAX_DEFERRED_EVENTS);
   (void) ::memset(_deferredParams, 0, sizeof(FsmEvent)*MAX_DEFERRED_EVENTS);
}

void
BusyState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   _numDeferredEvents = 0;

   s.vFsmPrepareProcessing(pArg);
}

void
BusyState::exit ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmCleanupProcessing(pArg);
}

void
BusyState::evIntMsgRx ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmDispatchInternalMsg(pArg);
   // this is an internal transition
}

void
BusyState::evResReadyAndQuit ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   //... performing exit actions ...
   exit(b,s,pArg);
   // trigger deferred events
   while ( !b.isPoolOfDeferredEventsEmpty() )
   {
       FsmEvent defevent = evUnknown;
       void*    defarg   = 0;
       if ( b.getDeferredEvent(defevent,&defarg) )
       {
           b.addEvent(defevent,defarg);
       }
   }
   b.setState(b.oWaitConfTxAndQuitState,pArg);
}

void
BusyState::evReqRx( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // defer event
   FsmEvent event = dia_EngineUdsFSM::evReqRx;

   b.addDeferredEvent(event,pArg);
}

void
BusyState::evIdle( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // defer event
   FsmEvent event = dia_EngineUdsFSM::evIdle;

   b.addDeferredEvent(event,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: IdleState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

IdleState::IdleState ( void )
{}

IdleState::IdleState ( FsmBody& b )
   : FsmState(b.oIdleReadyForReqRxState) 
{}

void
IdleState::evIntMsgRx ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmDispatchInternalMsg(pArg);
   // this is an internal transition
}

void
IdleState::evReqRx ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmAdoptRequest(pArg);
   s.vFsmValidateRequest(pArg);
   // trigger events
   FsmEvent event = dia_EngineUdsFSM::evUnknown;

   event = dia_EngineUdsFSM::evReqChecked; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   b.setState(b.oIdleValidateState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: IdleReadyForReqRxState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

IdleReadyForReqRxState::IdleReadyForReqRxState ( void )
{}

IdleReadyForReqRxState::IdleReadyForReqRxState ( FsmBody& b )
   : FsmSuperState(b.oReadyForReqRxState, b.oIdleState, false)
{}

void
IdleReadyForReqRxState::evIntMsgRx ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmDispatchInternalMsg(pArg);
   // this is an internal transition
}

void
IdleReadyForReqRxState::evReqRx ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmIgnoreRequest(pArg);
   // this is an internal transition
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: IdleValidateState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

IdleValidateState::IdleValidateState ( void )
   : _numDeferredEvents(0)
{
   (void) ::memset(_deferredEvents, 0, sizeof(FsmEvent)*MAX_DEFERRED_EVENTS);
   (void) ::memset(_deferredParams, 0, sizeof(FsmEvent)*MAX_DEFERRED_EVENTS);
}

IdleValidateState::IdleValidateState ( FsmBody& b )
   : FsmState(b.oIdleReadyForReqRxState) 
   , _numDeferredEvents(0)
{
   (void) ::memset(_deferredEvents, 0, sizeof(FsmEvent)*MAX_DEFERRED_EVENTS);
   (void) ::memset(_deferredParams, 0, sizeof(FsmEvent)*MAX_DEFERRED_EVENTS);
}

void
IdleValidateState::evIntMsgRx ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmDispatchInternalMsg(pArg);
   // this is an internal transition
}

void
IdleValidateState::evReqChecked ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.bFsmIsServiceAccepted(pArg) && s.bFsmIsServiceInternal(pArg) )
   {
        // set savepoint in superstate with enabled history
        b.oReadyForReqRxState.savepoint(b);

        b.oReadyForReqRxState.exit(b,s,pArg);
        // trigger deferred events
        while ( !b.isPoolOfDeferredEventsEmpty() )
        {
            FsmEvent defevent = evUnknown;
            void*    defarg   = 0;
            if ( b.getDeferredEvent(defevent,&defarg) )
            {
                b.addEvent(defevent,defarg);
            }
        }
        b.setState(b.oBusyState,pArg);
    } 
    else if ( s.bFsmIsServiceAccepted(pArg) )
   {
        // transition Actions
        s.vFsmSetDiagActive(pArg);
        s.vFsmStartTests(pArg);
        // trigger deferred events
        while ( !b.isPoolOfDeferredEventsEmpty() )
        {
            FsmEvent defevent = evUnknown;
            void*    defarg   = 0;
            if ( b.getDeferredEvent(defevent,&defarg) )
            {
                b.addEvent(defevent,defarg);
            }
        }
        // trigger events
        FsmEvent event = dia_EngineUdsFSM::evUnknown;

        event = dia_EngineUdsFSM::evReqRxOk; //lint !e838 Info: Previously assigned value to variable has not been used
        (void) b.addEvent(event,pArg);
//        b.oReadyForReqRxState.entry(b,s,pArg);
        b.setState(b.oActiveValidateState,pArg);
    }
    else
    {
   // set savepoint in superstate with enabled history
   b.oReadyForReqRxState.savepoint(b);

   b.oReadyForReqRxState.exit(b,s,pArg);
   // transition Actions
   s.vFsmStartProcessing(pArg);
   s.vFsmCleanupProcessing(pArg);
   // trigger deferred events
   while ( !b.isPoolOfDeferredEventsEmpty() )
   {
       FsmEvent defevent = evUnknown;
       void*    defarg   = 0;
       if ( b.getDeferredEvent(defevent,&defarg) )
       {
           b.addEvent(defevent,defarg);
       }
   }
   b.setState(b.oWaitConfTxAndQuitState,pArg);
    }
}

void
IdleValidateState::evReqRx( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // defer event
   FsmEvent event = dia_EngineUdsFSM::evReqRx;

   b.addDeferredEvent(event,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: PostProcessingState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

PostProcessingState::PostProcessingState ( void )
   : _numDeferredEvents(0)
{
   (void) ::memset(_deferredEvents, 0, sizeof(FsmEvent)*MAX_DEFERRED_EVENTS);
   (void) ::memset(_deferredParams, 0, sizeof(FsmEvent)*MAX_DEFERRED_EVENTS);
}

PostProcessingState::PostProcessingState ( FsmBody& b )
   : FsmState(b.oBusyState) 
   , _numDeferredEvents(0)
{
   (void) ::memset(_deferredEvents, 0, sizeof(FsmEvent)*MAX_DEFERRED_EVENTS);
   (void) ::memset(_deferredParams, 0, sizeof(FsmEvent)*MAX_DEFERRED_EVENTS);
}

void
PostProcessingState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   _numDeferredEvents = 0;

   s.vFsmStartPostProcessingTimer(pArg);
   s.vFsmStartPostProcessing(pArg);
}

void
PostProcessingState::exit ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmStopPostProcessingTimer(pArg);
}

void
PostProcessingState::evIntMsgRx ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmDispatchInternalMsg(pArg);
   // this is an internal transition
}

void
PostProcessingState::evResReadyAndQuit ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   //... performing exit actions ...
   exit(b,s,pArg);
   b.oBusyState.exit(b,s,pArg);
   // trigger deferred events
   while ( !b.isPoolOfDeferredEventsEmpty() )
   {
       FsmEvent defevent = evUnknown;
       void*    defarg   = 0;
       if ( b.getDeferredEvent(defevent,&defarg) )
       {
           b.addEvent(defevent,defarg);
       }
   }
   b.setState(b.oWaitConfTxAndQuitState,pArg);
}

void
PostProcessingState::evTimeout ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmPostProcessingTimeout(pArg);
   // this is an internal transition
}

void
PostProcessingState::evReqRx( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // defer event
   FsmEvent event = dia_EngineUdsFSM::evReqRx;

   b.addDeferredEvent(event,pArg);
}

void
PostProcessingState::evIdle( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // defer event
   FsmEvent event = dia_EngineUdsFSM::evIdle;

   b.addDeferredEvent(event,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: ProcessingState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

ProcessingState::ProcessingState ( void )
   : _numDeferredEvents(0)
{
   (void) ::memset(_deferredEvents, 0, sizeof(FsmEvent)*MAX_DEFERRED_EVENTS);
   (void) ::memset(_deferredParams, 0, sizeof(FsmEvent)*MAX_DEFERRED_EVENTS);
}

ProcessingState::ProcessingState ( FsmBody& b )
   : FsmState(b.oBusyState) 
   , _numDeferredEvents(0)
{
   (void) ::memset(_deferredEvents, 0, sizeof(FsmEvent)*MAX_DEFERRED_EVENTS);
   (void) ::memset(_deferredParams, 0, sizeof(FsmEvent)*MAX_DEFERRED_EVENTS);
}

void
ProcessingState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   _numDeferredEvents = 0;

   s.vFsmStartProcessingTimer(pArg);
   s.vFsmStartProcessing(pArg);
}

void
ProcessingState::exit ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmStopProcessingTimer(pArg);
}

void
ProcessingState::evIntMsgRx ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmDispatchInternalMsg(pArg);
   // this is an internal transition
}

void
ProcessingState::evResReady ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   //... performing exit actions ...
   exit(b,s,pArg);
   // trigger deferred events
   while ( !b.isPoolOfDeferredEventsEmpty() )
   {
       FsmEvent defevent = evUnknown;
       void*    defarg   = 0;
       if ( b.getDeferredEvent(defevent,&defarg) )
       {
           b.addEvent(defevent,defarg);
       }
   }
   b.setState(b.oPostProcessingState,pArg);
}

void
ProcessingState::evResReadyAndQuit ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   //... performing exit actions ...
   exit(b,s,pArg);
   b.oBusyState.exit(b,s,pArg);
   // trigger deferred events
   while ( !b.isPoolOfDeferredEventsEmpty() )
   {
       FsmEvent defevent = evUnknown;
       void*    defarg   = 0;
       if ( b.getDeferredEvent(defevent,&defarg) )
       {
           b.addEvent(defevent,defarg);
       }
   }
   b.setState(b.oWaitConfTxAndQuitState,pArg);
}

void
ProcessingState::evTimeout ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmProcessingTimeout(pArg);
   // this is an internal transition
}

void
ProcessingState::evReqRx( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // defer event
   FsmEvent event = dia_EngineUdsFSM::evReqRx;

   b.addDeferredEvent(event,pArg);
}

void
ProcessingState::evIdle( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // defer event
   FsmEvent event = dia_EngineUdsFSM::evIdle;

   b.addDeferredEvent(event,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: ReadyForReqRxState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

ReadyForReqRxState::ReadyForReqRxState ( void )
{}

ReadyForReqRxState::ReadyForReqRxState ( FsmBody& b )
   : FsmSuperState(b.oTopLevelState, b.oIdleReadyForReqRxState, true)
{}

void
ReadyForReqRxState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmInitRx(pArg);
}

void
ReadyForReqRxState::exit ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmResetRx(pArg);
}

void
ReadyForReqRxState::savepoint ( FsmBody& b )
{
   if ( _historyEnable )
   {
      _history = b.getState();
      while (  _history && (_history->getStateName() != b.oIdleReadyForReqRxState.getStateName()) && (_history->getStateName() != b.oActiveReadyForReqRxState.getStateName()) )
      {
         _history = const_cast<FsmState*>(_history)->getParent();
      }
   }
}

void
ReadyForReqRxState::evIntMsgRx ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmDispatchInternalMsg(pArg);
   // this is an internal transition
}

void
ReadyForReqRxState::evReqRx ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmIgnoreRequest(pArg);
   // this is an internal transition
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: TopLevelState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

TopLevelState::TopLevelState ( void )
{}

TopLevelState::TopLevelState ( FsmBody& b )
   : FsmSuperState(b.oReadyForReqRxState, false)
{}

void
TopLevelState::evIntMsgRx ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmDispatchInternalMsg(pArg);
   // this is an internal transition
}

void
TopLevelState::evReqRx ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmIgnoreRequest(pArg);
   // this is an internal transition
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: WaitConfTxAndQuitState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

WaitConfTxAndQuitState::WaitConfTxAndQuitState ( void )
   : _numDeferredEvents(0)
{
   (void) ::memset(_deferredEvents, 0, sizeof(FsmEvent)*MAX_DEFERRED_EVENTS);
   (void) ::memset(_deferredParams, 0, sizeof(FsmEvent)*MAX_DEFERRED_EVENTS);
}

WaitConfTxAndQuitState::WaitConfTxAndQuitState ( FsmBody& b )
   : FsmState(b.oTopLevelState) 
   , _numDeferredEvents(0)
{
   (void) ::memset(_deferredEvents, 0, sizeof(FsmEvent)*MAX_DEFERRED_EVENTS);
   (void) ::memset(_deferredParams, 0, sizeof(FsmEvent)*MAX_DEFERRED_EVENTS);
}

void
WaitConfTxAndQuitState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   _numDeferredEvents = 0;

   s.vFsmStartConfirmationTimer(pArg);
   s.vFsmSendConfirmation(pArg);
}

void
WaitConfTxAndQuitState::exit ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmStopConfirmationTimer(pArg);
}

void
WaitConfTxAndQuitState::evConfTxOk ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   //... performing exit actions ...
   exit(b,s,pArg);
   // trigger deferred events
   while ( !b.isPoolOfDeferredEventsEmpty() )
   {
       FsmEvent defevent = evUnknown;
       void*    defarg   = 0;
       if ( b.getDeferredEvent(defevent,&defarg) )
       {
           b.addEvent(defevent,defarg);
       }
   }
   b.setState(b.oReadyForReqRxState,pArg);
}

void
   // transition Actions
   // s.vFsmDispatchInternalMsg(pArg);
   // this is an internal transition
   
   // defer event

WaitConfTxAndQuitState::evTimeout ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmConfirmationTimeout(pArg);
   // this is an internal transition
}

void
WaitConfTxAndQuitState::evReqRx( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // defer event
   FsmEvent event = dia_EngineUdsFSM::evReqRx;

   b.addDeferredEvent(event,pArg);
}

void
WaitConfTxAndQuitState::evIdle( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // defer event
   FsmEvent event = dia_EngineUdsFSM::evIdle;
   b.addDeferredEvent(event,pArg);
}
void
WaitConfTxAndQuitState::evIntMsgRx( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   FsmEvent event = dia_EngineUdsFSM::evIntMsgRx;

   b.addDeferredEvent(event,pArg);
}

///////////////////////////////////////////////////////////////////////////////
//
// This is the finite state machine class implementation
//
///////////////////////////////////////////////////////////////////////////////

Fsm::Fsm ( void )
    : mpBehaviour(0),
      mpBody(0)
{
}

Fsm::Fsm ( FsmBehaviour* server )
    : mpBehaviour(server),
      mpBody(0)
{
    mpBody = new FsmBody();
}

Fsm::~Fsm ( void )
{
    if ( mpBody )
    {
        delete mpBody;
        mpBody = 0;
    }
    mpBehaviour = 0;
}

void
Fsm::init ( void )
{
    
    if ( mpBody )
    {
        // connect the body with its frontend
        mpBody->connect(this);
        {
            mpBody->init();
        }
    }
}

const char*
Fsm::getStateName (void) const
{
    return ( mpBody ) ? mpBody->getStateName() : 0;
}

void 
Fsm::acceptEvent ( FsmEvent event, void* pArg )
{
    if ( mpBody )
    {
        // forward the event to the FSM body (handle-body pattern)
        mpBody->acceptEvent(event,pArg);
    }
}
///////////////////////////////////////////////////////////////////////////////
//
// This is the finite state machine class implementation
//
///////////////////////////////////////////////////////////////////////////////

FsmBody::FsmBody ( void ) :
      oActiveState(*this),
      oActiveReadyForReqRxState(*this),
      oActiveValidateState(*this),
      oBusyState(*this),
      oIdleState(*this),
      oIdleReadyForReqRxState(*this),
      oIdleValidateState(*this),
      oPostProcessingState(*this),
      oProcessingState(*this),
      oReadyForReqRxState(*this),
      oTopLevelState(*this),
      oWaitConfTxAndQuitState(*this),
      mpFrontend(0),
      mpState(0),
      mBusyFlag(false),
      mQueueHead(0),
      mQueueTail(0),
      mQueueSize(0),
      mPoolHead(0),
      mPoolTail(0),
      mPoolSize(0)
{
    (void) ::memset(mEventQueue,0,sizeof(FsmEvent)*MAX_TRIGGER_EVENTS);
    (void) ::memset(mParamQueue,0,sizeof(void*)*MAX_TRIGGER_EVENTS);
}

void
FsmBody::init ( void )
{
    oActiveState.reset();
    oActiveReadyForReqRxState.reset();
    oActiveValidateState.reset();
    oBusyState.reset();
    oIdleState.reset();
    oIdleReadyForReqRxState.reset();
    oIdleValidateState.reset();
    oPostProcessingState.reset();
    oProcessingState.reset();
    oReadyForReqRxState.reset();
    oTopLevelState.reset();
    oWaitConfTxAndQuitState.reset();

    setState(oTopLevelState,0);
}

void
FsmBody::connect ( Fsm* frontend )
{
    mpFrontend = frontend;
}

const char*
FsmBody::getStateName ( void ) const
{
    return ( mpState ) ? mpState->getStateName() : 0;
}

bool
FsmBody::addEvent ( const FsmEvent& event, void* param )
{
    if ( mQueueSize < MAX_TRIGGER_EVENTS )
    {
        mQueueSize++;
        mEventQueue[mQueueTail] = event;
        mParamQueue[mQueueTail] = param;
        mQueueTail++;
        if ( mQueueTail == MAX_TRIGGER_EVENTS )
        {
            mQueueTail = 0;
        }
        return true;
    }
    return false;
}

bool
FsmBody::getEvent ( FsmEvent& event, void** param )
{
    if ( !mQueueSize || !param )
    {
        return false;
    }
    mQueueSize--;
    event  = mEventQueue[mQueueHead];
    *param = mParamQueue[mQueueHead];
    mQueueHead++;
    if ( mQueueHead == MAX_TRIGGER_EVENTS )
    {
        mQueueHead = 0;
    }
    return true;
}

bool
FsmBody::isQueueEmpty ( void ) const
{
    return ( mQueueSize ) ? false : true;
}

bool
FsmBody::addDeferredEvent ( const FsmEvent& event, void* arg )
{
    if ( mPoolSize < MAX_DEFERRED_EVENTS )
    {
        mPoolSize++;
        mDeferredEventPool[mPoolTail].mEvent = event;
        mDeferredEventPool[mPoolTail].mArg   = arg;
        mPoolTail++;
        if ( mPoolTail == MAX_DEFERRED_EVENTS )
        {
            mPoolTail = 0;
        }
        return true;
    }
    return false;
}

bool
FsmBody::getDeferredEvent ( FsmEvent& event, void** pArg )
{
    if ( !mPoolSize || !pArg )
    {
        return false;
    }
    mPoolSize--;
    event = mDeferredEventPool[mPoolHead].mEvent;
    *pArg = mDeferredEventPool[mPoolHead].mArg;
    mPoolHead++;
    if ( mPoolHead == MAX_DEFERRED_EVENTS )
    {
        mPoolHead = 0;
    }
    return true;
}

bool
FsmBody::isPoolOfDeferredEventsEmpty ( void ) const
{
    return ( mPoolSize ) ? false : true;
}

void 
FsmBody::acceptEvent ( FsmEvent event, void* pArg )
{
    (void) addEvent(event,pArg);

    if ( mBusyFlag )
    {
        return;
    }

    mBusyFlag = true;
    while ( !isQueueEmpty() )
    {
        FsmEvent nextEvent = evUnknown;
        void*    nextArg   = 0;
        if ( !getEvent(nextEvent,&nextArg) )
        {
            break;
        }

        switch (nextEvent)
        {
        case evConfTxOk:
            if ( mpState ) mpState->evConfTxOk(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evIdle:
            if ( mpState ) mpState->evIdle(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evIntMsgRx:
            if ( mpState ) mpState->evIntMsgRx(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evReqChecked:
            if ( mpState ) mpState->evReqChecked(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evReqRx:
            if ( mpState ) mpState->evReqRx(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evReqRxOk:
            if ( mpState ) mpState->evReqRxOk(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evResReady:
            if ( mpState ) mpState->evResReady(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evResReadyAndQuit:
            if ( mpState ) mpState->evResReadyAndQuit(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evTimeout:
            if ( mpState ) mpState->evTimeout(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        default:
            //... unknown event ...
            break;
        } //lint !e788: not all items used within defaulted switch
    }
    mBusyFlag = false;
}

void 
FsmBody::setState ( FsmState& state, void* pArg )
{
    if ( mpFrontend )
    {
        mpState = const_cast<FsmState*>(state.propagate(*this,*(mpFrontend->mpBehaviour),pArg));
    }
}

void 
FsmBody::setState ( FsmState* pState )
{
    mpState = pState;
}

const FsmState*
FsmBody::getState ( void ) const
{
    return mpState;
}


const char* getEventName ( FsmEvent event )
{
   static const char* eventNames[evCount] = {
      "evUnknown",
      "evConfTxOk",
      "evIdle",
      "evIntMsgRx",
      "evReqChecked",
      "evReqRx",
      "evReqRxOk",
      "evResReady",
      "evResReadyAndQuit",
      "evTimeout",
   };
   return eventNames[event];
}
} // namespace
