///////////////////////////////////////////////////////////////////////////////
//
// File: dia_EngineRunInFSM.h
//
// Generated by SMC 4.3.1 (C++ State Pattern Code Generator)
//
///////////////////////////////////////////////////////////////////////////////

#ifndef __INCLUDED_DIA_ENGINERUNINFSM__
#define __INCLUDED_DIA_ENGINERUNINFSM__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

namespace dia_EngineRunInFSM
{

///////////////////////////////////////////////////////////////////////////////
//
// Forward Declarations
//
///////////////////////////////////////////////////////////////////////////////

class FsmBody;

///////////////////////////////////////////////////////////////////////////////
//
// Enums and typedefs
//
///////////////////////////////////////////////////////////////////////////////

//! enumeration of FSM events. First and last item added by SMC
enum FsmEvent
{
    evUnknown = 0,
    evStart,
    evStop,
    evDone,
    evTerminate,
    evProcessRequest,
    evErrorHandled,
    evProcessingFailed,
    evTimeout,
    evProcessed,
    evResponseReceived,
    evRequestSent,
    evPollingTimeout,
    evCount
};

///////////////////////////////////////////////////////////////////////////////
//
// Class: FsmBehaviour
//
// This is the base class for the FSM server (provides implementation for all
// actions and guards)
//
///////////////////////////////////////////////////////////////////////////////

class FsmBehaviour
{ 
    friend class ActiveState;
    friend class ActiveIdleState;
    friend class ErrorHandlingState;
    friend class FinalState;
    friend class GetRequestState;
    friend class IdleState;
    friend class PollForResponseState;
    friend class ProcessRequestState;
    friend class SendRequestState;
    friend class TopLevelState;
    friend class WaitForResponseState;
    friend class FsmBody;

public:
    virtual ~FsmBehaviour ( void ) {}

protected:
    // FSM actions
    virtual void vFsmInitialize ( void* pArg ) = 0;
    virtual void vFsmFinalize ( void* pArg ) = 0;
    virtual void vFsmInitializeRunIn ( void* pArg ) = 0;
    virtual void vFsmLoadRequests ( void* pArg ) = 0;
    virtual void vFsmDiagnosisActive ( void* pArg ) = 0;
    virtual void vFsmStartMonitoring ( void* pArg ) = 0;
    virtual void vFsmFinalizeRunIn ( void* pArg ) = 0;
    virtual void vFsmDiagnosisInactive ( void* pArg ) = 0;
    virtual void vFsmStopMonitoring ( void* pArg ) = 0;
    virtual void vFsmSequenceComplete ( void* pArg ) = 0;
    virtual void vFsmInitializePostProcessing ( void* pArg ) = 0;
    virtual void vFsmLoadPostProcessingCommands ( void* pArg ) = 0;
    virtual void vFsmGetRequest ( void* pArg ) = 0;
    virtual void vFsmLogError ( void* pArg ) = 0;
    virtual void vFsmHandleError ( void* pArg ) = 0;
    virtual void vFsmStartTimer ( void* pArg ) = 0;
    virtual void vFsmInitializeProcessing ( void* pArg ) = 0;
    virtual void vFsmStopTimer ( void* pArg ) = 0;
    virtual void vFsmFinalizeProcessing ( void* pArg ) = 0;
    virtual void vFsmLogResult ( void* pArg ) = 0;
    virtual void vFsmEvaluateResult ( void* pArg ) = 0;
    virtual void vFsmSendRequest ( void* pArg ) = 0;
    virtual void vFsmStartPollingTimer ( void* pArg ) = 0;
    virtual void vFsmInitializePolling ( void* pArg ) = 0;
    virtual void vFsmStopPollingTimer ( void* pArg ) = 0;
    virtual void vFsmFinalizePolling ( void* pArg ) = 0;
    virtual void vFsmSendRequestResult ( void* pArg ) = 0;

    // FSM guards
    virtual bool bFsmIsRunInActivated ( void* pArg ) = 0;
    virtual bool bFsmIsPostProcessingComplete ( void* pArg ) = 0;
    virtual bool bFsmIsValidRequest ( void* pArg ) = 0;
    virtual bool bFsmCanProceed ( void* pArg ) = 0;
    virtual bool bWasCompleted ( void* pArg ) = 0;
    virtual bool bFsmWasSentSuccessfully ( void* pArg ) = 0;
    virtual bool bFsmNeedToPollForResponse ( void* pArg ) = 0;
};

///////////////////////////////////////////////////////////////////////////////
//
// Class: Fsm
//
// This is the finite state machine class 'dia_EngineRunInFSM'.
//
///////////////////////////////////////////////////////////////////////////////

class Fsm
{
    //! we grant the body class access to our protected section
    friend class FsmBody;

public:
    //! class constructor
    Fsm ( FsmBehaviour* behaviour );
    //! class destructor
    virtual ~Fsm ( void );

    //! setup and initialize the state machine
    virtual void init ( void );

    //! this method is used to stimulate the FSM with events
    virtual void acceptEvent ( FsmEvent event, void* pArg );

    //! return the name of the current state
    virtual const char* getStateName ( void ) const;

protected:
    //! protected default constructor to avoid usage
    Fsm ( void );
    //! copy constructor without implementation
    Fsm ( const Fsm& obj );
    //! assignment operator without implementation
    Fsm& operator = ( const Fsm& obj );

protected:
    //! pointer to the server that provides the implementation for the actions and guards
    FsmBehaviour* mpBehaviour;
    //! body of the FSM implementation
    FsmBody* mpBody;
};


} // namespace

#endif
