///////////////////////////////////////////////////////////////////////////////
//
// File: dia_EngineRunInFSM.cpp
//
// Generated by SMC 4.3.1 (C++ State Pattern Code Generator)
//
///////////////////////////////////////////////////////////////////////////////

#include <string.h>

#ifndef __INCLUDED_DIA_ENGINERUNINFSM__
#include "dia_EngineRunInFSM.h"
#endif

#define MAX_TRIGGER_EVENTS  20

#define MAX_DEFERRED_EVENTS 25

namespace dia_EngineRunInFSM
{

///////////////////////////////////////////////////////////////////////////////
//
// Forward Declarations
//
///////////////////////////////////////////////////////////////////////////////

class Fsm;
class FsmSuperState;

///////////////////////////////////////////////////////////////////////////////
//
// Abstract base class for all FSM states.
//
///////////////////////////////////////////////////////////////////////////////

class FsmState
{
public:
    //! name of the FSM's state
    virtual const char* getStateName ( void ) const = 0;

    //! resetting state internals
    virtual void reset ( void ) {}

    // event functions
    virtual void evStart ( FsmBody& b, FsmBehaviour& s, void* pArg );
    virtual void evStop ( FsmBody& b, FsmBehaviour& s, void* pArg );
    virtual void evDone ( FsmBody& b, FsmBehaviour& s, void* pArg );
    virtual void evTerminate ( FsmBody& b, FsmBehaviour& s, void* pArg );
    virtual void evProcessRequest ( FsmBody& b, FsmBehaviour& s, void* pArg );
    virtual void evErrorHandled ( FsmBody& b, FsmBehaviour& s, void* pArg );
    virtual void evProcessingFailed ( FsmBody& b, FsmBehaviour& s, void* pArg );
    virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );
    virtual void evProcessed ( FsmBody& b, FsmBehaviour& s, void* pArg );
    virtual void evResponseReceived ( FsmBody& b, FsmBehaviour& s, void* pArg );
    virtual void evRequestSent ( FsmBody& b, FsmBehaviour& s, void* pArg );
    virtual void evPollingTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );

    //! default implementation for the Entry action
    virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );
    //! default implementation for the Exit action
    virtual void exit  ( FsmBody& b, FsmBehaviour& s, void* pArg );
    //! method used to propagate the event to the superstate
    virtual const FsmState* propagate ( FsmBody& b, FsmBehaviour& s, void* pArg );
    //! return the parent state
    virtual FsmSuperState* getParent ( void );


protected:
    //! default constructor is protected to prevent usage of this constructor
    FsmState ( void );
    //! constructor for a substate of the given superstate
    FsmState ( FsmSuperState& parent );
    //! class destructor
    virtual ~FsmState ( void );

    //! pointer to the superstate
    FsmSuperState* mpParent;
};

///////////////////////////////////////////////////////////////////////////////
//
// Abstract base class for all FSM superstates.
//
///////////////////////////////////////////////////////////////////////////////

class FsmSuperState
    : public FsmState
{
public:
    //! class constructor for a superstate without parent
    FsmSuperState ( FsmState& defState, bool histEnable=false );
    //! class constructor for a superstate with parent
    FsmSuperState ( FsmSuperState& parent, FsmState& defState, bool histEnable=false );

    //! set a savepoint for the history
    virtual void savepoint ( FsmBody& b );
    //! default action
    virtual void defaultAction ( FsmBody& b, FsmBehaviour& s, void* pArg );

    //! resetting state internals
    virtual void reset ( void ) { _history = 0; }

    //! method used to propagate the event to the superstate
    virtual const FsmState* propagate ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
    //! default constructor is protected to prevent usage of this constructor
    FsmSuperState ( void );

    //! pointer to the default substate
    FsmState* _default;
    //! pointer to the history substate
    const FsmState* _history;
    //! flag that indicates if history is enabled or not
    bool _historyEnable;
};

///////////////////////////////////////////////////////////////////////////////
//
// Class: ActiveState
//
// Concrete state of FSM
//
///////////////////////////////////////////////////////////////////////////////

class ActiveState
    : public FsmSuperState
{
public:
    //! default constructor
    ActiveState ( void ) {}

    ActiveState ( FsmBody& b );

    //! return state name
    virtual const char* getStateName ( void ) const { return mStateName; }

    //! event functions
    virtual void evStop ( FsmBody& b, FsmBehaviour& s, void* pArg );
    virtual void evDone ( FsmBody& b, FsmBehaviour& s, void* pArg );
    virtual void evTerminate ( FsmBody& b, FsmBehaviour& s, void* pArg );
    //! entry actions
    virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );
    //! exit actions
    virtual void exit ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
    static const char* mStateName;
};

const char* ActiveState::mStateName = "Active";

///////////////////////////////////////////////////////////////////////////////
//
// Class: ActiveIdleState
//
// Concrete state of FSM
//
///////////////////////////////////////////////////////////////////////////////

class ActiveIdleState
    : public FsmState
{
public:
    //! default constructor
    ActiveIdleState ( void ) {}

    ActiveIdleState ( FsmBody& b );

    //! return state name
    virtual const char* getStateName ( void ) const { return mStateName; }

    //! event functions
    virtual void evStop ( FsmBody& b, FsmBehaviour& s, void* pArg );
    virtual void evDone ( FsmBody& b, FsmBehaviour& s, void* pArg );
    virtual void evTerminate ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
    static const char* mStateName;
};

const char* ActiveIdleState::mStateName = "ActiveIdle";

///////////////////////////////////////////////////////////////////////////////
//
// Class: ErrorHandlingState
//
// Concrete state of FSM
//
///////////////////////////////////////////////////////////////////////////////

class ErrorHandlingState
    : public FsmState
{
public:
    //! default constructor
    ErrorHandlingState ( void ) {}

    ErrorHandlingState ( FsmBody& b );

    //! return state name
    virtual const char* getStateName ( void ) const { return mStateName; }

    //! event functions
    virtual void evStop ( FsmBody& b, FsmBehaviour& s, void* pArg );
    virtual void evDone ( FsmBody& b, FsmBehaviour& s, void* pArg );
    virtual void evTerminate ( FsmBody& b, FsmBehaviour& s, void* pArg );
    virtual void evErrorHandled ( FsmBody& b, FsmBehaviour& s, void* pArg );
    //! entry actions
    virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
    static const char* mStateName;
};

const char* ErrorHandlingState::mStateName = "ErrorHandling";

///////////////////////////////////////////////////////////////////////////////
//
// Class: FinalState
//
// Concrete state of FSM
//
///////////////////////////////////////////////////////////////////////////////

class FinalState
    : public FsmState
{
public:
    //! default constructor
    FinalState ( void ) {}

    FinalState ( FsmBody& b );

    //! return state name
    virtual const char* getStateName ( void ) const { return mStateName; }

    //! event functions
    //! entry actions
    virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
    static const char* mStateName;
};

const char* FinalState::mStateName = "Final";

///////////////////////////////////////////////////////////////////////////////
//
// Class: GetRequestState
//
// Concrete state of FSM
//
///////////////////////////////////////////////////////////////////////////////

class GetRequestState
    : public FsmState
{
public:
    //! default constructor
    GetRequestState ( void ) {}

    GetRequestState ( FsmBody& b );

    //! return state name
    virtual const char* getStateName ( void ) const { return mStateName; }

    //! event functions
    virtual void evStop ( FsmBody& b, FsmBehaviour& s, void* pArg );
    virtual void evDone ( FsmBody& b, FsmBehaviour& s, void* pArg );
    virtual void evTerminate ( FsmBody& b, FsmBehaviour& s, void* pArg );
    virtual void evProcessRequest ( FsmBody& b, FsmBehaviour& s, void* pArg );
    //! entry actions
    virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
    static const char* mStateName;
};

const char* GetRequestState::mStateName = "GetRequest";

///////////////////////////////////////////////////////////////////////////////
//
// Class: IdleState
//
// Concrete state of FSM
//
///////////////////////////////////////////////////////////////////////////////

class IdleState
    : public FsmState
{
public:
    //! default constructor
    IdleState ( void ) {}

    IdleState ( FsmBody& b );

    //! return state name
    virtual const char* getStateName ( void ) const { return mStateName; }

    //! event functions
    virtual void evStart ( FsmBody& b, FsmBehaviour& s, void* pArg );
    //! entry actions
    virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
    static const char* mStateName;
};

const char* IdleState::mStateName = "Idle";

///////////////////////////////////////////////////////////////////////////////
//
// Class: PollForResponseState
//
// Concrete state of FSM
//
///////////////////////////////////////////////////////////////////////////////

class PollForResponseState
    : public FsmState
{
public:
    //! default constructor
    PollForResponseState ( void ) {}

    PollForResponseState ( FsmBody& b );

    //! return state name
    virtual const char* getStateName ( void ) const { return mStateName; }

    //! event functions
    virtual void evStop ( FsmBody& b, FsmBehaviour& s, void* pArg );
    virtual void evDone ( FsmBody& b, FsmBehaviour& s, void* pArg );
    virtual void evTerminate ( FsmBody& b, FsmBehaviour& s, void* pArg );
    virtual void evProcessingFailed ( FsmBody& b, FsmBehaviour& s, void* pArg );
    virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );
    virtual void evProcessed ( FsmBody& b, FsmBehaviour& s, void* pArg );
    virtual void evResponseReceived ( FsmBody& b, FsmBehaviour& s, void* pArg );
    virtual void evPollingTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );
    //! entry actions
    virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );
    //! exit actions
    virtual void exit ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
    static const char* mStateName;
};

const char* PollForResponseState::mStateName = "PollForResponse";

///////////////////////////////////////////////////////////////////////////////
//
// Class: ProcessRequestState
//
// Concrete state of FSM
//
///////////////////////////////////////////////////////////////////////////////

class ProcessRequestState
    : public FsmSuperState
{
public:
    //! default constructor
    ProcessRequestState ( void ) {}

    ProcessRequestState ( FsmBody& b );

    //! return state name
    virtual const char* getStateName ( void ) const { return mStateName; }

    //! event functions
    virtual void evStop ( FsmBody& b, FsmBehaviour& s, void* pArg );
    virtual void evDone ( FsmBody& b, FsmBehaviour& s, void* pArg );
    virtual void evTerminate ( FsmBody& b, FsmBehaviour& s, void* pArg );
    virtual void evProcessingFailed ( FsmBody& b, FsmBehaviour& s, void* pArg );
    virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );
    virtual void evProcessed ( FsmBody& b, FsmBehaviour& s, void* pArg );
    virtual void evResponseReceived ( FsmBody& b, FsmBehaviour& s, void* pArg );
    //! entry actions
    virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );
    //! exit actions
    virtual void exit ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
    static const char* mStateName;
};

const char* ProcessRequestState::mStateName = "ProcessRequest";

///////////////////////////////////////////////////////////////////////////////
//
// Class: SendRequestState
//
// Concrete state of FSM
//
///////////////////////////////////////////////////////////////////////////////

class SendRequestState
    : public FsmState
{
public:
    //! default constructor
    SendRequestState ( void );

    SendRequestState ( FsmBody& b );

    //! return state name
    virtual const char* getStateName ( void ) const { return mStateName; }

    //! event functions
    virtual void evStop ( FsmBody& b, FsmBehaviour& s, void* pArg );
    virtual void evDone ( FsmBody& b, FsmBehaviour& s, void* pArg );
    virtual void evTerminate ( FsmBody& b, FsmBehaviour& s, void* pArg );
    virtual void evProcessingFailed ( FsmBody& b, FsmBehaviour& s, void* pArg );
    virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );
    virtual void evProcessed ( FsmBody& b, FsmBehaviour& s, void* pArg );
    virtual void evRequestSent ( FsmBody& b, FsmBehaviour& s, void* pArg );

    //! deferred events
    virtual void evResponseReceived ( FsmBody& b, FsmBehaviour& s, void* pArg );

    //! entry actions
    virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
    //! array for recording received events to be deferred
    FsmEvent _deferredEvents[MAX_DEFERRED_EVENTS];
    //! array for recording params of events to be deferred
    void*    _deferredParams[MAX_DEFERRED_EVENTS];
    //! number of events currently deferred
    int _numDeferredEvents;


protected:
    static const char* mStateName;
};

const char* SendRequestState::mStateName = "SendRequest";

///////////////////////////////////////////////////////////////////////////////
//
// Class: TopLevelState
//
// Concrete state of FSM
//
///////////////////////////////////////////////////////////////////////////////

class TopLevelState
    : public FsmSuperState
{
public:
    //! default constructor
    TopLevelState ( void ) {}

    TopLevelState ( FsmBody& b );

    //! return state name
    virtual const char* getStateName ( void ) const { return mStateName; }

    //! event functions

protected:
    static const char* mStateName;
};

const char* TopLevelState::mStateName = "TopLevel";

///////////////////////////////////////////////////////////////////////////////
//
// Class: WaitForResponseState
//
// Concrete state of FSM
//
///////////////////////////////////////////////////////////////////////////////

class WaitForResponseState
    : public FsmState
{
public:
    //! default constructor
    WaitForResponseState ( void ) {}

    WaitForResponseState ( FsmBody& b );

    //! return state name
    virtual const char* getStateName ( void ) const { return mStateName; }

    //! event functions
    virtual void evStop ( FsmBody& b, FsmBehaviour& s, void* pArg );
    virtual void evDone ( FsmBody& b, FsmBehaviour& s, void* pArg );
    virtual void evTerminate ( FsmBody& b, FsmBehaviour& s, void* pArg );
    virtual void evProcessingFailed ( FsmBody& b, FsmBehaviour& s, void* pArg );
    virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );
    virtual void evProcessed ( FsmBody& b, FsmBehaviour& s, void* pArg );
    virtual void evResponseReceived ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
    static const char* mStateName;
};

const char* WaitForResponseState::mStateName = "WaitForResponse";

///////////////////////////////////////////////////////////////////////////////
//
// Class: FsmBody
//
// This is the finite state machine's body class 'FsmBody'.
//
///////////////////////////////////////////////////////////////////////////////

class FsmBody
{
    struct FsmDeferredEvent
    {
          FsmDeferredEvent() : mEvent(evUnknown), mArg(0) {}
          FsmEvent mEvent;
          void*    mArg;
    };

public:
    //! class constructor
    FsmBody ( void );

    //! connect the FSM body with its frontend
    void connect ( Fsm* frontend );

    //! initialize the FSM: set initial state and execute initial actions
    void init ( void );

    //! this method is used to stimulate the FSM with events
    void acceptEvent ( FsmEvent event, void* pArg );

    //! return the name of the active state
    const char* getStateName ( void ) const;

    //! push trigger events to the event queue
    bool addEvent ( const FsmEvent& event, void* arg  );
    //! get event from the event queue
    bool getEvent ( FsmEvent& event, void** arg  );
    //! get event from the event queue
    bool isQueueEmpty ( void ) const;

    //! push deferred events to the pool of deferred events
    bool addDeferredEvent ( const FsmEvent& event, void* arg );
    //! get deferred event from the pool of deferred events
    bool getDeferredEvent ( FsmEvent& event, void** arg );
    //! check if the event pool is empty
    bool isPoolOfDeferredEventsEmpty ( void ) const;

    // set the FSM's internal state
    void setState ( FsmState& state, void* pArg );
    // return the active state object
    const FsmState* getState ( void ) const;

    //! static state objects
    ActiveState oActiveState;
    ActiveIdleState oActiveIdleState;
    ErrorHandlingState oErrorHandlingState;
    FinalState oFinalState;
    GetRequestState oGetRequestState;
    IdleState oIdleState;
    PollForResponseState oPollForResponseState;
    ProcessRequestState oProcessRequestState;
    SendRequestState oSendRequestState;
    TopLevelState oTopLevelState;
    WaitForResponseState oWaitForResponseState;

    //! frontend for this body
    Fsm* mpFrontend;
    //! link to the active state object
    FsmState* mpState;

    //! busy indicator flag
    bool mBusyFlag;

    //! queue of trigger events
    FsmEvent mEventQueue[MAX_TRIGGER_EVENTS];
    //! queue of arguments for trigger events
    void*    mParamQueue[MAX_TRIGGER_EVENTS];
    //! index of the queue's front element
    unsigned int mQueueHead;
    //! index of the queue's back element
    unsigned int mQueueTail;
    //! number of queued events
    unsigned int mQueueSize;
    //! pool of deferred events
    FsmDeferredEvent mDeferredEventPool[MAX_DEFERRED_EVENTS];
    //! index of the pool's front element
    unsigned int mPoolHead;
    //! index of the pool's back element
    unsigned int mPoolTail;
    //! number of deferred events stored in the pool
    unsigned int mPoolSize;
};

///////////////////////////////////////////////////////////////////////////////
//
// Default implementation for all events.
//
///////////////////////////////////////////////////////////////////////////////

void
FsmState::evStart ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evStart ***
}

void
FsmState::evStop ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evStop ***
}

void
FsmState::evDone ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evDone ***
}

void
FsmState::evTerminate ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evTerminate ***
}

void
FsmState::evProcessRequest ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evProcessRequest ***
}

void
FsmState::evErrorHandled ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evErrorHandled ***
}

void
FsmState::evProcessingFailed ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evProcessingFailed ***
}

void
FsmState::evTimeout ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evTimeout ***
}

void
FsmState::evProcessed ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evProcessed ***
}

void
FsmState::evResponseReceived ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evResponseReceived ***
}

void
FsmState::evRequestSent ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evRequestSent ***
}

void
FsmState::evPollingTimeout ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evPollingTimeout ***
}

///////////////////////////////////////////////////////////////////////////////
//
// Abstract base class for all FSM states components.
//
///////////////////////////////////////////////////////////////////////////////

FsmState::FsmState ( void )
    : mpParent(0)
{}

FsmState::FsmState ( FsmSuperState& parent )
    : mpParent(&parent)
{}

FsmState::~FsmState ( void )
{
    // make lint happy
    mpParent = 0;
}

void
FsmState::entry ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    //... empty as default ...
}

void
FsmState::exit ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    //... empty as default ...
}

const FsmState*
FsmState::propagate ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
    entry(b,s,pArg);
    return this;
}

FsmSuperState*
FsmState::getParent ( void )
{
    return (mpParent) ? mpParent : 0;
}

///////////////////////////////////////////////////////////////////////////////
//
// Abstract base class for all FSM superstates.
//
///////////////////////////////////////////////////////////////////////////////

FsmSuperState::FsmSuperState ( FsmState& defState, bool histEnable )
    : _default(&defState),
      _history(0),
      _historyEnable(histEnable)
{}

FsmSuperState::FsmSuperState ( FsmSuperState& parent, FsmState& defState, bool histEnable )
    : FsmState(parent),
      _default(&defState),
      _history(0),
      _historyEnable(histEnable)
{}

FsmSuperState::FsmSuperState ( void )
    : _default(0),
      _history(0),
      _historyEnable(false)
{}

const FsmState*
FsmSuperState::propagate ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
    const FsmState* pState = 0;

    // execute the entry actions for this superstate
    entry(b,s,pArg);

    if ( _history && _historyEnable )
    {
        pState = const_cast<FsmState*>(_history)->propagate(b,s,pArg);
    }
    else
    {
       defaultAction(b,s,pArg);
       if ( _default ) {
          pState = _default->propagate(b,s,pArg);
       }
    }

    return pState;
}

void
FsmSuperState::savepoint ( FsmBody& b )
{
    if ( _historyEnable )
    {
        _history = b.getState();
    }
}

void
FsmSuperState::defaultAction ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /*pArg*/ )
{
    //... empty as default ...
}

///////////////////////////////////////////////////////////////////////////////
//
// Class: ActiveState
//
// Implementation of concrete FSM state
//
///////////////////////////////////////////////////////////////////////////////

ActiveState::ActiveState ( FsmBody& b )
    : FsmSuperState(b.oTopLevelState, b.oGetRequestState, false)
{}

void
ActiveState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
    s.vFsmInitializeRunIn(pArg);
    s.vFsmLoadRequests(pArg);
    s.vFsmDiagnosisActive(pArg);
    s.vFsmStartMonitoring(pArg);
}

void
ActiveState::exit ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
    s.vFsmFinalizeRunIn(pArg);
    s.vFsmDiagnosisInactive(pArg);
    s.vFsmStopMonitoring(pArg);
}

void
ActiveState::evStop ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
    //... performing exit actions ...
    exit(b,s,pArg);
    b.setState(b.oIdleState,pArg);
}

void
ActiveState::evDone ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
    if ( s.bFsmIsPostProcessingComplete(pArg) )
    {
        //... performing exit actions ...
        exit(b,s,pArg);
        // transition Actions
        s.vFsmSequenceComplete(pArg);
        b.setState(b.oFinalState,pArg);
    }
    else
    {
    //... performing exit actions ...
//    exit(b,s,pArg);
//    b.oActiveState.entry(b,s,pArg);
    b.setState(b.oActiveIdleState,pArg);
    }
}

void
ActiveState::evTerminate ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
    //... performing exit actions ...
//    exit(b,s,pArg);
    // transition Actions
    s.vFsmInitializePostProcessing(pArg);
    s.vFsmLoadPostProcessingCommands(pArg);
//    b.oActiveState.entry(b,s,pArg);
    b.setState(b.oGetRequestState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
//
// Class: ActiveIdleState
//
// Implementation of concrete FSM state
//
///////////////////////////////////////////////////////////////////////////////

ActiveIdleState::ActiveIdleState ( FsmBody& b )
    : FsmState(b.oActiveState)
{}

void
ActiveIdleState::evStop ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
    b.oActiveState.exit(b,s,pArg);
    b.setState(b.oIdleState,pArg);
}

void
ActiveIdleState::evDone ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // this is an internal transition
}

void
ActiveIdleState::evTerminate ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
    // transition Actions
    s.vFsmInitializePostProcessing(pArg);
    s.vFsmLoadPostProcessingCommands(pArg);
    b.setState(b.oGetRequestState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
//
// Class: ErrorHandlingState
//
// Implementation of concrete FSM state
//
///////////////////////////////////////////////////////////////////////////////

ErrorHandlingState::ErrorHandlingState ( FsmBody& b )
    : FsmState(b.oActiveState)
{}

void
ErrorHandlingState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
    s.vFsmLogError(pArg);
    s.vFsmHandleError(pArg);
}

void
ErrorHandlingState::evStop ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
    b.oActiveState.exit(b,s,pArg);
    b.setState(b.oIdleState,pArg);
}

void
ErrorHandlingState::evDone ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
    if ( s.bFsmIsPostProcessingComplete(pArg) )
    {
        //... performing exit actions ...
//        exit(b,s,pArg);
       b.oActiveState.exit(b,s,pArg);
       // transition Actions
        s.vFsmSequenceComplete(pArg);
        b.setState(b.oFinalState,pArg);
    }
    else
    {
    //... performing exit actions ...
//    exit(b,s,pArg);
//    b.oActiveState.entry(b,s,pArg);
    b.setState(b.oActiveIdleState,pArg);
    }
}

void
ErrorHandlingState::evTerminate ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
    // transition Actions
    s.vFsmInitializePostProcessing(pArg);
    s.vFsmLoadPostProcessingCommands(pArg);
    b.setState(b.oGetRequestState,pArg);
}

void
ErrorHandlingState::evErrorHandled ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
    if ( s.bFsmCanProceed(pArg) )
    {
        b.setState(b.oGetRequestState,pArg);
    }
    else
    {
    b.setState(b.oActiveIdleState,pArg);
    }
}

///////////////////////////////////////////////////////////////////////////////
//
// Class: FinalState
//
// Implementation of concrete FSM state
//
///////////////////////////////////////////////////////////////////////////////

FinalState::FinalState ( FsmBody& b )
    : FsmState(b.oTopLevelState)
{}

void
FinalState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
    s.vFsmFinalize(pArg);
}

///////////////////////////////////////////////////////////////////////////////
//
// Class: GetRequestState
//
// Implementation of concrete FSM state
//
///////////////////////////////////////////////////////////////////////////////

GetRequestState::GetRequestState ( FsmBody& b )
    : FsmState(b.oActiveState)
{}

void
GetRequestState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
    s.vFsmGetRequest(pArg);
}

void
GetRequestState::evStop ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
    b.oActiveState.exit(b,s,pArg);
    b.setState(b.oIdleState,pArg);
}

void
GetRequestState::evDone ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
    if ( s.bFsmIsPostProcessingComplete(pArg) )
    {
        //... performing exit actions ...
//        exit(b,s,pArg);
       b.oActiveState.exit(b,s,pArg);
       // transition Actions
        s.vFsmSequenceComplete(pArg);
        b.setState(b.oFinalState,pArg);
    }
    else
    {
    //... performing exit actions ...
//    exit(b,s,pArg);
//    b.oActiveState.entry(b,s,pArg);
    b.setState(b.oActiveIdleState,pArg);
    }
}

void
GetRequestState::evTerminate ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
    // transition Actions
    s.vFsmInitializePostProcessing(pArg);
    s.vFsmLoadPostProcessingCommands(pArg);
    b.setState(b.oGetRequestState,pArg);
}

void
GetRequestState::evProcessRequest ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
    if ( s.bFsmIsValidRequest(pArg) )
    {
        b.setState(b.oProcessRequestState,pArg);
    }
    else
    {
    b.setState(b.oErrorHandlingState,pArg);
    }
}

///////////////////////////////////////////////////////////////////////////////
//
// Class: IdleState
//
// Implementation of concrete FSM state
//
///////////////////////////////////////////////////////////////////////////////

IdleState::IdleState ( FsmBody& b )
    : FsmState(b.oTopLevelState)
{}

void
IdleState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
    s.vFsmInitialize(pArg);
}

void
IdleState::evStart ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
    if ( s.bFsmIsRunInActivated(pArg) )
    {
        b.setState(b.oActiveState,pArg);
    }
}

///////////////////////////////////////////////////////////////////////////////
//
// Class: PollForResponseState
//
// Implementation of concrete FSM state
//
///////////////////////////////////////////////////////////////////////////////

PollForResponseState::PollForResponseState ( FsmBody& b )
    : FsmState(b.oProcessRequestState)
{}

void
PollForResponseState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
    s.vFsmStartPollingTimer(pArg);
    s.vFsmInitializePolling(pArg);
}

void
PollForResponseState::exit ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
    s.vFsmStopPollingTimer(pArg);
    s.vFsmFinalizePolling(pArg);
}

void
PollForResponseState::evStop ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
    //... performing exit actions ...
    exit(b,s,pArg);
    b.oProcessRequestState.exit(b,s,pArg);
    b.oActiveState.exit(b,s,pArg);
    b.setState(b.oIdleState,pArg);
}

void
PollForResponseState::evDone ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
    if ( s.bFsmIsPostProcessingComplete(pArg) )
    {
        //... performing exit actions ...
        exit(b,s,pArg);
        b.oProcessRequestState.exit(b,s,pArg);
        b.oActiveState.exit(b,s,pArg);
        // transition Actions
        s.vFsmSequenceComplete(pArg);
        b.setState(b.oFinalState,pArg);
    }
    else
    {
    //... performing exit actions ...
    exit(b,s,pArg);
    b.oProcessRequestState.exit(b,s,pArg);
//    b.oActiveState.entry(b,s,pArg);
    b.setState(b.oActiveIdleState,pArg);
    }
}

void
PollForResponseState::evTerminate ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
    //... performing exit actions ...
    exit(b,s,pArg);
    b.oProcessRequestState.exit(b,s,pArg);
    // transition Actions
    s.vFsmInitializePostProcessing(pArg);
    s.vFsmLoadPostProcessingCommands(pArg);
//    b.oActiveState.entry(b,s,pArg);
    b.setState(b.oGetRequestState,pArg);
}

void
PollForResponseState::evProcessingFailed ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
    //... performing exit actions ...
    exit(b,s,pArg);
    b.oProcessRequestState.exit(b,s,pArg);
//    b.oActiveState.entry(b,s,pArg);
    b.setState(b.oErrorHandlingState,pArg);
}

void
PollForResponseState::evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
    //... performing exit actions ...
    exit(b,s,pArg);
    b.oProcessRequestState.exit(b,s,pArg);
//    b.oActiveState.entry(b,s,pArg);
    b.setState(b.oErrorHandlingState,pArg);
}

void
PollForResponseState::evProcessed ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
    if ( s.bWasCompleted(pArg) )
    {
        //... performing exit actions ...
        exit(b,s,pArg);
        b.oProcessRequestState.exit(b,s,pArg);
        // transition Actions
        s.vFsmLogResult(pArg);
//        b.oActiveState.entry(b,s,pArg);
        b.setState(b.oGetRequestState,pArg);
    }
}

void
PollForResponseState::evResponseReceived ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
    // transition Actions
    s.vFsmEvaluateResult(pArg);
    // this is an internal transition
}

void
PollForResponseState::evPollingTimeout ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
    // transition Actions
    s.vFsmSendRequestResult(pArg);
    // this is an internal transition
}

///////////////////////////////////////////////////////////////////////////////
//
// Class: ProcessRequestState
//
// Implementation of concrete FSM state
//
///////////////////////////////////////////////////////////////////////////////

ProcessRequestState::ProcessRequestState ( FsmBody& b )
    : FsmSuperState(b.oActiveState, b.oSendRequestState, false)
{}

void
ProcessRequestState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
    s.vFsmStartTimer(pArg);
    s.vFsmInitializeProcessing(pArg);
}

void
ProcessRequestState::exit ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
    s.vFsmStopTimer(pArg);
    s.vFsmFinalizeProcessing(pArg);
}

void
ProcessRequestState::evStop ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
    //... performing exit actions ...
    exit(b,s,pArg);
    b.oActiveState.exit(b,s,pArg);
    b.setState(b.oIdleState,pArg);
}

void
ProcessRequestState::evDone ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
    if ( s.bFsmIsPostProcessingComplete(pArg) )
    {
        //... performing exit actions ...
        exit(b,s,pArg);
        b.oActiveState.exit(b,s,pArg);
        // transition Actions
        s.vFsmSequenceComplete(pArg);
        b.setState(b.oFinalState,pArg);
    }
    else
    {
    //... performing exit actions ...
    exit(b,s,pArg);
//    b.oActiveState.entry(b,s,pArg);
    b.setState(b.oActiveIdleState,pArg);
    }
}

void
ProcessRequestState::evTerminate ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
    //... performing exit actions ...
    exit(b,s,pArg);
    // transition Actions
    s.vFsmInitializePostProcessing(pArg);
    s.vFsmLoadPostProcessingCommands(pArg);
    b.setState(b.oGetRequestState,pArg);
}

void
ProcessRequestState::evProcessingFailed ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
    //... performing exit actions ...
    exit(b,s,pArg);
    b.setState(b.oErrorHandlingState,pArg);
}

void
ProcessRequestState::evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
    //... performing exit actions ...
    exit(b,s,pArg);
    b.setState(b.oErrorHandlingState,pArg);
}

void
ProcessRequestState::evProcessed ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
    if ( s.bWasCompleted(pArg) )
    {
        //... performing exit actions ...
        exit(b,s,pArg);
        // transition Actions
        s.vFsmLogResult(pArg);
        b.setState(b.oGetRequestState,pArg);
    }
}

void
ProcessRequestState::evResponseReceived ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
    // transition Actions
    s.vFsmEvaluateResult(pArg);
    // this is an internal transition
}

///////////////////////////////////////////////////////////////////////////////
//
// Class: SendRequestState
//
// Implementation of concrete FSM state
//
///////////////////////////////////////////////////////////////////////////////


SendRequestState::SendRequestState ( void )
    : _numDeferredEvents(0)
{
   (void) ::memset(_deferredEvents, 0, sizeof(FsmEvent)*MAX_DEFERRED_EVENTS);
   (void) ::memset(_deferredParams, 0, sizeof(FsmEvent)*MAX_DEFERRED_EVENTS);
}

SendRequestState::SendRequestState ( FsmBody& b )
    : FsmState(b.oProcessRequestState)
    , _numDeferredEvents(0)
{
   (void) ::memset(_deferredEvents, 0, sizeof(FsmEvent)*MAX_DEFERRED_EVENTS);
   (void) ::memset(_deferredParams, 0, sizeof(FsmEvent)*MAX_DEFERRED_EVENTS);
}

void
SendRequestState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
    _numDeferredEvents = 0;

    s.vFsmSendRequest(pArg);
}

void
SendRequestState::evStop ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
    b.oProcessRequestState.exit(b,s,pArg);
    b.oActiveState.exit(b,s,pArg);
    // trigger deferred events
    while ( !b.isPoolOfDeferredEventsEmpty() )
    {
        FsmEvent defevent = evUnknown;
        void*    defarg   = 0;
        if ( b.getDeferredEvent(defevent,&defarg) )
        {
            b.addEvent(defevent,defarg);
        }
    }
    b.setState(b.oIdleState,pArg);
}

void
SendRequestState::evDone ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
    if ( s.bFsmIsPostProcessingComplete(pArg) )
    {
        //... performing exit actions ...
//        exit(b,s,pArg);
        b.oProcessRequestState.exit(b,s,pArg);
       b.oActiveState.exit(b,s,pArg);
        // transition Actions
        s.vFsmSequenceComplete(pArg);
        // trigger deferred events
        while ( !b.isPoolOfDeferredEventsEmpty() )
        {
            FsmEvent defevent = evUnknown;
            void*    defarg   = 0;
            if ( b.getDeferredEvent(defevent,&defarg) )
            {
                b.addEvent(defevent,defarg);
            }
        }
        b.setState(b.oFinalState,pArg);
    }
    else
    {
    //... performing exit actions ...
//    exit(b,s,pArg);
    b.oProcessRequestState.exit(b,s,pArg);
//    b.oActiveState.entry(b,s,pArg);
    // trigger deferred events
    while ( !b.isPoolOfDeferredEventsEmpty() )
    {
        FsmEvent defevent = evUnknown;
        void*    defarg   = 0;
        if ( b.getDeferredEvent(defevent,&defarg) )
        {
            b.addEvent(defevent,defarg);
        }
    }

    b.setState(b.oActiveIdleState,pArg);
    }
}

void
SendRequestState::evTerminate ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
    b.oProcessRequestState.exit(b,s,pArg);
    // transition Actions
    s.vFsmInitializePostProcessing(pArg);
    s.vFsmLoadPostProcessingCommands(pArg);
    // trigger deferred events
    while ( !b.isPoolOfDeferredEventsEmpty() )
    {
        FsmEvent defevent = evUnknown;
        void*    defarg   = 0;
        if ( b.getDeferredEvent(defevent,&defarg) )
        {
            b.addEvent(defevent,defarg);
        }
    }
//    b.oActiveState.entry(b,s,pArg);
    b.setState(b.oGetRequestState,pArg);
}

void
SendRequestState::evProcessingFailed ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
    b.oProcessRequestState.exit(b,s,pArg);
    // trigger deferred events
    while ( !b.isPoolOfDeferredEventsEmpty() )
    {
        FsmEvent defevent = evUnknown;
        void*    defarg   = 0;
        if ( b.getDeferredEvent(defevent,&defarg) )
        {
            b.addEvent(defevent,defarg);
        }
    }
//    b.oActiveState.entry(b,s,pArg);
    b.setState(b.oErrorHandlingState,pArg);
}

void
SendRequestState::evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
    b.oProcessRequestState.exit(b,s,pArg);
    // trigger deferred events
    while ( !b.isPoolOfDeferredEventsEmpty() )
    {
        FsmEvent defevent = evUnknown;
        void*    defarg   = 0;
        if ( b.getDeferredEvent(defevent,&defarg) )
        {
            b.addEvent(defevent,defarg);
        }
    }
//    b.oActiveState.entry(b,s,pArg);
    b.setState(b.oErrorHandlingState,pArg);
}

void
SendRequestState::evProcessed ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // this is an internal transition
}

void
SendRequestState::evRequestSent ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
    if ( s.bFsmWasSentSuccessfully(pArg) && s.bFsmNeedToPollForResponse(pArg) )
    {
        // trigger deferred events
        while ( !b.isPoolOfDeferredEventsEmpty() )
        {
            FsmEvent defevent = evUnknown;
            void*    defarg   = 0;
            if ( b.getDeferredEvent(defevent,&defarg) )
            {
                b.addEvent(defevent,defarg);
            }
        }
        b.setState(b.oPollForResponseState,pArg);
    }
    else if ( s.bFsmWasSentSuccessfully(pArg) )
    {
        // trigger deferred events
        while ( !b.isPoolOfDeferredEventsEmpty() )
        {
            FsmEvent defevent = evUnknown;
            void*    defarg   = 0;
            if ( b.getDeferredEvent(defevent,&defarg) )
            {
                b.addEvent(defevent,defarg);
            }
        }
        b.setState(b.oWaitForResponseState,pArg);
    }
}

void
SendRequestState::evResponseReceived( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
    // defer event
    FsmEvent event = dia_EngineRunInFSM::evResponseReceived;

    b.addDeferredEvent(event,pArg);
}

///////////////////////////////////////////////////////////////////////////////
//
// Class: TopLevelState
//
// Implementation of concrete FSM state
//
///////////////////////////////////////////////////////////////////////////////

TopLevelState::TopLevelState ( FsmBody& b )
    : FsmSuperState(b.oIdleState, false)
{}

///////////////////////////////////////////////////////////////////////////////
//
// Class: WaitForResponseState
//
// Implementation of concrete FSM state
//
///////////////////////////////////////////////////////////////////////////////

WaitForResponseState::WaitForResponseState ( FsmBody& b )
    : FsmState(b.oProcessRequestState)
{}

void
WaitForResponseState::evStop ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
    b.oProcessRequestState.exit(b,s,pArg);
    b.oActiveState.exit(b,s,pArg);
    b.setState(b.oIdleState,pArg);
}

void
WaitForResponseState::evDone ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
    if ( s.bFsmIsPostProcessingComplete(pArg) )
    {
        //... performing exit actions ...
//        exit(b,s,pArg);
        b.oProcessRequestState.exit(b,s,pArg);
       b.oActiveState.exit(b,s,pArg);
       // transition Actions
        s.vFsmSequenceComplete(pArg);
        b.setState(b.oFinalState,pArg);
    }
    else
    {
    //... performing exit actions ...
//    exit(b,s,pArg);
    b.oProcessRequestState.exit(b,s,pArg);
//    b.oActiveState.entry(b,s,pArg);
    b.setState(b.oActiveIdleState,pArg);
    }
}

void
WaitForResponseState::evTerminate ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
    b.oProcessRequestState.exit(b,s,pArg);
    // transition Actions
    s.vFsmInitializePostProcessing(pArg);
    s.vFsmLoadPostProcessingCommands(pArg);
//    b.oActiveState.entry(b,s,pArg);
    b.setState(b.oGetRequestState,pArg);
}

void
WaitForResponseState::evProcessingFailed ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
    b.oProcessRequestState.exit(b,s,pArg);
//    b.oActiveState.entry(b,s,pArg);
    b.setState(b.oErrorHandlingState,pArg);
}

void
WaitForResponseState::evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
    b.oProcessRequestState.exit(b,s,pArg);
//    b.oActiveState.entry(b,s,pArg);
    b.setState(b.oErrorHandlingState,pArg);
}

void
WaitForResponseState::evProcessed ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
    if ( s.bWasCompleted(pArg) )
    {
        b.oProcessRequestState.exit(b,s,pArg);
        // transition Actions
        s.vFsmLogResult(pArg);
//        b.oActiveState.entry(b,s,pArg);
        b.setState(b.oGetRequestState,pArg);
    }
}

void
WaitForResponseState::evResponseReceived ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
    // transition Actions
    s.vFsmEvaluateResult(pArg);
    // this is an internal transition
}

///////////////////////////////////////////////////////////////////////////////
//
// This is the finite state machine class implementation
//
///////////////////////////////////////////////////////////////////////////////

Fsm::Fsm ( void )
    : mpBehaviour(0),
      mpBody(0)
{
}

Fsm::Fsm ( FsmBehaviour* server )
    : mpBehaviour(server),
      mpBody(0)
{
    mpBody = new FsmBody();
}

Fsm::~Fsm ( void )
{
//   _BP_TRY_BEGIN
//   {
       if ( mpBody )
       {
           delete mpBody;
           mpBody = 0;
       }
       mpBehaviour = 0;
//   }
//   _BP_CATCH_ALL
//   {}
//   _BP_CATCH_END
}

void
Fsm::init ( void )
{

    if ( mpBody )
    {
        // connect the body with its frontend
        mpBody->connect(this);
        {
            mpBody->init();
        }
    }
}

const char*
Fsm::getStateName (void) const
{
    return ( mpBody ) ? mpBody->getStateName() : 0;
}

void
Fsm::acceptEvent ( FsmEvent event, void* pArg )
{
    if ( mpBody )
    {
        // forward the event to the FSM body (handle-body pattern)
        mpBody->acceptEvent(event,pArg);
    }
}
///////////////////////////////////////////////////////////////////////////////
//
// This is the finite state machine class implementation
//
///////////////////////////////////////////////////////////////////////////////

FsmBody::FsmBody ( void ) :
      oActiveState(*this),
      oActiveIdleState(*this),
      oErrorHandlingState(*this),
      oFinalState(*this),
      oGetRequestState(*this),
      oIdleState(*this),
      oPollForResponseState(*this),
      oProcessRequestState(*this),
      oSendRequestState(*this),
      oTopLevelState(*this),
      oWaitForResponseState(*this),
      mpFrontend(0),
      mpState(0),
      mBusyFlag(false),
      mQueueHead(0),
      mQueueTail(0),
      mQueueSize(0),
      mPoolHead(0),
      mPoolTail(0),
      mPoolSize(0)
{
    (void) ::memset(mEventQueue,0,sizeof(FsmEvent)*MAX_TRIGGER_EVENTS);
    (void) ::memset(mParamQueue,0,sizeof(void*)*MAX_TRIGGER_EVENTS);
}

void
FsmBody::init ( void )
{
    oActiveState.reset();
    oActiveIdleState.reset();
    oErrorHandlingState.reset();
    oFinalState.reset();
    oGetRequestState.reset();
    oIdleState.reset();
    oPollForResponseState.reset();
    oProcessRequestState.reset();
    oSendRequestState.reset();
    oTopLevelState.reset();
    oWaitForResponseState.reset();

    setState(oTopLevelState,0);
}

void
FsmBody::connect ( Fsm* frontend )
{
    mpFrontend = frontend;
}

const char*
FsmBody::getStateName ( void ) const
{
    return ( mpState ) ? mpState->getStateName() : 0;
}

bool
FsmBody::addEvent ( const FsmEvent& event, void* param )
{
    if ( mQueueSize < MAX_TRIGGER_EVENTS )
    {
        mQueueSize++;
        mEventQueue[mQueueTail] = event;
        mParamQueue[mQueueTail] = param;
        mQueueTail++;
        if ( mQueueTail == MAX_TRIGGER_EVENTS )
        {
            mQueueTail = 0;
        }
        return true;
    }
    return false;
}

bool
FsmBody::getEvent ( FsmEvent& event, void** param )
{
    if ( !mQueueSize || !param )
    {
        return false;
    }
    mQueueSize--;
    event  = mEventQueue[mQueueHead];
    *param = mParamQueue[mQueueHead];
    mQueueHead++;
    if ( mQueueHead == MAX_TRIGGER_EVENTS )
    {
        mQueueHead = 0;
    }
    return true;
}

bool
FsmBody::isQueueEmpty ( void ) const
{
    return ( mQueueSize ) ? false : true;
}

bool
FsmBody::addDeferredEvent ( const FsmEvent& event, void* arg )
{
    if ( mPoolSize < MAX_DEFERRED_EVENTS )
    {
        mPoolSize++;
        mDeferredEventPool[mPoolTail].mEvent = event;
        mDeferredEventPool[mPoolTail].mArg   = arg;
        mPoolTail++;
        if ( mPoolTail == MAX_DEFERRED_EVENTS )
        {
            mPoolTail = 0;
        }
        return true;
    }
    return false;
}

bool
FsmBody::getDeferredEvent ( FsmEvent& event, void** pArg )
{
    if ( !mPoolSize || !pArg )
    {
        return false;
    }
    mPoolSize--;
    event = mDeferredEventPool[mPoolHead].mEvent;
    *pArg = mDeferredEventPool[mPoolHead].mArg;
    mPoolHead++;
    if ( mPoolHead == MAX_DEFERRED_EVENTS )
    {
        mPoolHead = 0;
    }
    return true;
}

bool
FsmBody::isPoolOfDeferredEventsEmpty ( void ) const
{
    return ( mPoolSize ) ? false : true;
}

void
FsmBody::acceptEvent ( FsmEvent event, void* pArg )
{
    (void) addEvent(event,pArg);

    if ( mBusyFlag )
    {
        return;
    }

    mBusyFlag = true;
    while ( !isQueueEmpty() )
    {
        FsmEvent nextEvent = evUnknown;
        void*    nextArg   = 0;
        if ( !getEvent(nextEvent,&nextArg) )
        {
            break;
        }

        switch (nextEvent)
        {
        case evStart:
            if ( mpState ) mpState->evStart(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evStop:
            if ( mpState ) mpState->evStop(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evDone:
            if ( mpState ) mpState->evDone(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evTerminate:
            if ( mpState ) mpState->evTerminate(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evProcessRequest:
            if ( mpState ) mpState->evProcessRequest(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evErrorHandled:
            if ( mpState ) mpState->evErrorHandled(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evProcessingFailed:
            if ( mpState ) mpState->evProcessingFailed(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evTimeout:
            if ( mpState ) mpState->evTimeout(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evProcessed:
            if ( mpState ) mpState->evProcessed(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evResponseReceived:
            if ( mpState ) mpState->evResponseReceived(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evRequestSent:
            if ( mpState ) mpState->evRequestSent(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evPollingTimeout:
            if ( mpState ) mpState->evPollingTimeout(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        default:
            //... unknown event ...
            break;
        } //lint !e788: not all items used within defaulted switch
    }
    mBusyFlag = false;
}

void
FsmBody::setState ( FsmState& state, void* pArg )
{
    if ( mpFrontend )
    {
        mpState = const_cast<FsmState*>(state.propagate(*this,*(mpFrontend->mpBehaviour),pArg));
    }
}

const FsmState*
FsmBody::getState ( void ) const
{
    return mpState;
}


} // namespace
