///////////////////////////////////////////////////////////////////////////////
//
// File: dia_EngineInternalTesterFSM.h
//
// Generated by SMC 4.4.0 (C++ State Pattern Code Generator)
//
///////////////////////////////////////////////////////////////////////////////

#ifndef __INCLUDED_DIA_ENGINEINTERNALTESTERFSM__
#define __INCLUDED_DIA_ENGINEINTERNALTESTERFSM__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

namespace dia_EngineInternalTesterFSM
{

///////////////////////////////////////////////////////////////////////////////
//
// Forward Declarations
//
///////////////////////////////////////////////////////////////////////////////

class FsmBody;

///////////////////////////////////////////////////////////////////////////////
//
// Enums and typedefs
//
///////////////////////////////////////////////////////////////////////////////

//! enumeration of FSM events. First and last item added by SMC
enum FsmEvent
{
   evUnknown = 0,
   evDone,
   evErrorHandled,
   evFinalise,
   evIdle,
   evProcessed,
   evProcessingFailed,
   evProcessRequest,
   evRequestSent,
   evResponseReceived,
   evTimeout,
   evCount
};

///////////////////////////////////////////////////////////////////////////////
//
// Class: FsmBehaviour
//
// This is the base class for the FSM server (provides implementation for all
// actions and guards)
//
///////////////////////////////////////////////////////////////////////////////

class FsmBehaviour
{ 
   friend class ChangeSessionState;
   friend class ErrorHandlingState;
   friend class IdleState;
   friend class ProcessRequestState;
   friend class RestoreSessionState;
   friend class SendRequestState;
   friend class SwitchSessionState;
   friend class TopLevelState;
   friend class WaitForResponseState;
   friend class processState;
   friend class waitingForRequestState;
   friend class FsmBody;

public:
   virtual ~FsmBehaviour ( void ) {}

protected:
   // FSM actions
   virtual void vFsmClearResponsePending ( void* pArg ) = 0;
   virtual void vFsmCreateResponse ( void* pArg ) = 0;
   virtual void vFsmCreateSessionRequest ( void* pArg ) = 0;
   virtual void vFsmEvaluateResult ( void* pArg ) = 0;
   virtual void vFsmFinalizeProcessing ( void* pArg ) = 0;
   virtual void vFsmHandleError ( void* pArg ) = 0;
   virtual void vFsmInitializeProcessing ( void* pArg ) = 0;
   virtual void vFsmLogError ( void* pArg ) = 0;
   virtual void vFsmLogResult ( void* pArg ) = 0;
   virtual void vFsmRejectRequest ( void* pArg ) = 0;
   virtual void vFsmReset ( void* pArg ) = 0;
   virtual void vFsmRestoreRequest ( void* pArg ) = 0;
   virtual void vFsmRestoreSession ( void* pArg ) = 0;
   virtual void vFsmSendError ( void* pArg ) = 0;
   virtual void vFsmSendRequest ( void* pArg ) = 0;
   virtual void vFsmSendResponse ( void* pArg ) = 0;
   virtual void vFsmSetErrorInvalidRequest ( void* pArg ) = 0;
   virtual void vFsmSetErrorProcessingFailed ( void* pArg ) = 0;
   virtual void vFsmSetErrorTimeout ( void* pArg ) = 0;
   virtual void vFsmStartTimer ( void* pArg ) = 0;
   virtual void vFsmStopTimer ( void* pArg ) = 0;
   virtual void vFsmStoreRequest ( void* pArg ) = 0;
   virtual void vFsmStoreSession ( void* pArg ) = 0;

   // FSM guards
   virtual bool bFsmIsAccepted ( void* pArg ) = 0;
   virtual bool bFsmIsResponsePending ( void* pArg ) = 0;
   virtual bool bFsmIsValidRequest ( void* pArg ) = 0;
   virtual bool bFsmNeedSessionChange ( void* pArg ) = 0;
   virtual bool bFsmNoSessionChangeRequired ( void* pArg ) = 0;
   virtual bool bFsmWasSentSuccessfully ( void* pArg ) = 0;
};

///////////////////////////////////////////////////////////////////////////////
//
// Class: Fsm
//
// This is the finite state machine class 'dia_EngineInternalTesterFSM'.
//
///////////////////////////////////////////////////////////////////////////////

class Fsm
{
    //! we grant the body class access to our protected section
    friend class FsmBody;

public:
    //! factory method used to create an FAM object in two stages
    static bool createFSM ( Fsm** ppFSM, FsmBehaviour* behaviour );
    //! class destructor
    virtual ~Fsm ( void );

    //! this method is used to stimulate the FSM with events
    virtual void acceptEvent ( FsmEvent event, void* pArg );

    //! return the name of the current state
    virtual const char* getStateName ( void ) const;

protected:
    //! protected default constructor to avoid usage
    Fsm ( void );
    //! class constructor
    Fsm ( FsmBehaviour* behaviour );
    //! copy constructor without implementation
    Fsm ( const Fsm& obj );
    //! assignment operator without implementation
    Fsm& operator = ( const Fsm& obj );

    //! setup and initialize the state machine
    virtual bool init ( void );

protected:
    //! pointer to the server that provides the implementation for the actions and guards
    FsmBehaviour* mpBehaviour;
    //! body of the FSM implementation
    FsmBody* mpBody;
};


} // namespace

#endif
