///////////////////////////////////////////////////////////////////////////////
//
// File: dia_EngineFlashFSM.cpp
//
// Generated by SMC 4.4.2 (C++ State Pattern Code Generator)
//
///////////////////////////////////////////////////////////////////////////////

#include <string.h>

#ifndef __INCLUDED_DIA_ENGINEFLASHFSM__
#include "dia_EngineFlashFSM.h"
#endif

namespace dia_EngineFlashFSM
{

const unsigned int MAX_TRIGGER_EVENTS = 20;

///////////////////////////////////////////////////////////////////////////////
//
// Forward Declarations
//
///////////////////////////////////////////////////////////////////////////////

class Fsm;
class FsmSuperState;

///////////////////////////////////////////////////////////////////////////////
//
// Abstract base class for all FSM states.
//
///////////////////////////////////////////////////////////////////////////////

class FsmState
{
public:
   //! name of the FSM's state
   virtual const char* getStateName ( void ) const = 0;

   //! resetting state internals
   virtual void reset ( void ) {}

   // event functions 
   virtual void evCatalogAvailable ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evCatalogError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evDataDownload ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evDataError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evDataTransfer ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evDataTransferFailed ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evDataTransferred ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evDone ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evErrorHandled ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evExpectedIdent ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evFlashContainerError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evFlashContainerOk ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evProcessed ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evProcessingFailed ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evResponseReceived ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evStart ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evStartUnpacking ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTerminate ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evUnknownJob ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evUnpacked ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evUnpackingFailed ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evWriteDataByID ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! default implementation for the Entry action
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! default implementation for the Exit action
   virtual void exit  ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! method used to propagate the event to the superstate
   virtual const FsmState* propagate ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! return the parent state
   virtual FsmSuperState* getParent ( void );

   //! assign the body object
   void initState ( FsmSuperState* pParent );

protected:
   //! default constructor is protected to prevent usage of this constructor
   FsmState ( void );
   //! class destructor
   virtual ~FsmState ( void );

   //! pointer to the superstate
   FsmSuperState* mpParent;
};

///////////////////////////////////////////////////////////////////////////////
//
// Abstract base class for all FSM superstates.
//
///////////////////////////////////////////////////////////////////////////////

class FsmSuperState
   : public FsmState
{
public:
   //! set a savepoint for the history
   virtual void savepoint ( FsmBody& b );
   //! default action
   virtual void defaultAction ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! resetting state internals
   virtual void reset ( void ) { _history = 0; }

   //! method used to propagate the event to the superstate
   virtual const FsmState* propagate ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! assign the body object
   void initSuperState ( FsmSuperState* pParent, FsmState* defState, bool histEnable=false );

protected:
   //! default constructor is protected to prevent usage of this constructor
   FsmSuperState ( void );

   //! pointer to the default substate
   FsmState* _default;
   //! pointer to the history substate
   const FsmState* _history;
   //! flag that indicates if history is enabled or not
   bool _historyEnable;
};

///////////////////////////////////////////////////////////////////////////////
// 
// Class: ChangeDiagnosticSessionState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class ChangeDiagnosticSessionState
   : public FsmState
{
public:
   //! default constructor
   ChangeDiagnosticSessionState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evProcessed ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evProcessingFailed ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTerminate ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! exit actions
   virtual void exit ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* ChangeDiagnosticSessionState::mStateName = "ChangeDiagnosticSession";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: CheckingExpectedIdentState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class CheckingExpectedIdentState
   : public FsmState
{
public:
   //! default constructor
   CheckingExpectedIdentState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evProcessed ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evProcessingFailed ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evResponseReceived ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTerminate ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! exit actions
   virtual void exit ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* CheckingExpectedIdentState::mStateName = "CheckingExpectedIdent";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: DisableFlushingState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class DisableFlushingState
   : public FsmState
{
public:
   //! default constructor
   DisableFlushingState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evProcessed ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evProcessingFailed ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTerminate ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! exit actions
   virtual void exit ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* DisableFlushingState::mStateName = "DisableFlushing";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: EnableFlushingState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class EnableFlushingState
   : public FsmState
{
public:
   //! default constructor
   EnableFlushingState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evProcessed ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evProcessingFailed ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTerminate ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! exit actions
   virtual void exit ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* EnableFlushingState::mStateName = "EnableFlushing";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: ErrorHandlingState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class ErrorHandlingState
   : public FsmState
{
public:
   //! default constructor
   ErrorHandlingState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evErrorHandled ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTerminate ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* ErrorHandlingState::mStateName = "ErrorHandling";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: FinalState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class FinalState
   : public FsmState
{
public:
   //! default constructor
   FinalState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTerminate ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* FinalState::mStateName = "Final";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: FlashingState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class FlashingState
   : public FsmSuperState
{
public:
   //! default constructor
   FlashingState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evProcessed ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTerminate ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! exit actions
   virtual void exit ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* FlashingState::mStateName = "Flashing";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: GetDataBlockState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class GetDataBlockState
   : public FsmState
{
public:
   //! default constructor
   GetDataBlockState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evDataError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evDataTransfer ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evProcessed ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTerminate ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* GetDataBlockState::mStateName = "GetDataBlock";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: GetJobState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class GetJobState
   : public FsmState
{
public:
   //! default constructor
   GetJobState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evDataDownload ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evDone ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evExpectedIdent ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evProcessed ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTerminate ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evUnknownJob ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evWriteDataByID ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* GetJobState::mStateName = "GetJob";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: IdleState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class IdleState
   : public FsmState
{
public:
   //! default constructor
   IdleState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evStart ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evStartUnpacking ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTerminate ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* IdleState::mStateName = "Idle";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: ProcessDownloadState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class ProcessDownloadState
   : public FsmSuperState
{
public:
   //! default constructor
   ProcessDownloadState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evProcessed ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTerminate ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! exit actions
   virtual void exit ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* ProcessDownloadState::mStateName = "ProcessDownload";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: ProcessWDBIState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class ProcessWDBIState
   : public FsmState
{
public:
   //! default constructor
   ProcessWDBIState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evProcessed ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evProcessingFailed ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evResponseReceived ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTerminate ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! exit actions
   virtual void exit ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* ProcessWDBIState::mStateName = "ProcessWDBI";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: ReadingCatalogState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class ReadingCatalogState
   : public FsmState
{
public:
   //! default constructor
   ReadingCatalogState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evCatalogAvailable ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evCatalogError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTerminate ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* ReadingCatalogState::mStateName = "ReadingCatalog";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: ReadingFlashContainerState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class ReadingFlashContainerState
   : public FsmState
{
public:
   //! default constructor
   ReadingFlashContainerState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evFlashContainerError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evFlashContainerOk ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTerminate ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* ReadingFlashContainerState::mStateName = "ReadingFlashContainer";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: RequestDownloadState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class RequestDownloadState
   : public FsmState
{
public:
   //! default constructor
   RequestDownloadState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evProcessed ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evProcessingFailed ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evResponseReceived ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTerminate ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* RequestDownloadState::mStateName = "RequestDownload";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: RestoreDiagnosticSessionState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class RestoreDiagnosticSessionState
   : public FsmState
{
public:
   //! default constructor
   RestoreDiagnosticSessionState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evProcessed ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evProcessingFailed ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTerminate ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! exit actions
   virtual void exit ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* RestoreDiagnosticSessionState::mStateName = "RestoreDiagnosticSession";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: TopLevelState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class TopLevelState
   : public FsmSuperState
{
public:
   //! default constructor
   TopLevelState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTerminate ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* TopLevelState::mStateName = "TopLevel";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: TransferDataState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class TransferDataState
   : public FsmSuperState
{
public:
   //! default constructor
   TransferDataState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evProcessed ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTerminate ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* TransferDataState::mStateName = "TransferData";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: TransferExitState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class TransferExitState
   : public FsmState
{
public:
   //! default constructor
   TransferExitState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evProcessed ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evProcessingFailed ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evResponseReceived ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTerminate ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* TransferExitState::mStateName = "TransferExit";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: TransferringDataState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class TransferringDataState
   : public FsmState
{
public:
   //! default constructor
   TransferringDataState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evDataTransferFailed ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evDataTransferred ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evProcessed ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evResponseReceived ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTerminate ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* TransferringDataState::mStateName = "TransferringData";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: UnpackingState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class UnpackingState
   : public FsmState
{
public:
   //! default constructor
   UnpackingState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTerminate ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evUnpacked ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evUnpackingFailed ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* UnpackingState::mStateName = "Unpacking";

///////////////////////////////////////////////////////////////////////////////
//
// Class: FsmBody
//
// This is the finite state machine's body class 'FsmBody'.
//
///////////////////////////////////////////////////////////////////////////////

class FsmBody
{
    struct FsmDeferredEvent
    {
          FsmDeferredEvent() : mEvent(evUnknown), mArg(0) {}
          FsmEvent mEvent;
          void*    mArg;
    };

public:
    //! class constructor
    FsmBody ( void );

    //! connect the FSM body with its frontend
    void connect ( Fsm* frontend );

    //! initialize the FSM: set initial state and execute initial actions
    bool init ( void );

    //! this method is used to stimulate the FSM with events
    void acceptEvent ( FsmEvent event, void* pArg );

    //! return the name of the active state
    const char* getStateName ( void ) const;

    //! push trigger events to the event queue
    bool addEvent ( const FsmEvent& event, void* arg  );
    //! get event from the event queue
    bool getEvent ( FsmEvent& event, void** arg  );
    //! get event from the event queue
    bool isQueueEmpty ( void ) const;

    // set the FSM's internal state and propagate to default or history substate
    void setState ( FsmState& state, void* pArg );
    // set the FSM's internal state (no propagation
    void setState ( FsmState* pState );
    // return the active state object
    const FsmState* getState ( void ) const;

    //! static state objects
    ChangeDiagnosticSessionState oChangeDiagnosticSessionState;
    CheckingExpectedIdentState oCheckingExpectedIdentState;
    DisableFlushingState oDisableFlushingState;
    EnableFlushingState oEnableFlushingState;
    ErrorHandlingState oErrorHandlingState;
    FinalState oFinalState;
    FlashingState oFlashingState;
    GetDataBlockState oGetDataBlockState;
    GetJobState oGetJobState;
    IdleState oIdleState;
    ProcessDownloadState oProcessDownloadState;
    ProcessWDBIState oProcessWDBIState;
    ReadingCatalogState oReadingCatalogState;
    ReadingFlashContainerState oReadingFlashContainerState;
    RequestDownloadState oRequestDownloadState;
    RestoreDiagnosticSessionState oRestoreDiagnosticSessionState;
    TopLevelState oTopLevelState;
    TransferDataState oTransferDataState;
    TransferExitState oTransferExitState;
    TransferringDataState oTransferringDataState;
    UnpackingState oUnpackingState;

    //! frontend for this body
    Fsm* mpFrontend;
    //! link to the active state object
    FsmState* mpState;

    //! busy indicator flag
    bool mBusyFlag;

    //! queue of trigger events
    FsmEvent mEventQueue[MAX_TRIGGER_EVENTS];
    //! queue of arguments for trigger events
    void*    mParamQueue[MAX_TRIGGER_EVENTS];
    //! index of the queue's front element
    unsigned int mQueueHead;
    //! index of the queue's back element
    unsigned int mQueueTail;
    //! number of queued events
    unsigned int mQueueSize;
};

///////////////////////////////////////////////////////////////////////////////
//
// Default implementation for all events.
//
///////////////////////////////////////////////////////////////////////////////

void
FsmState::evCatalogAvailable ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evCatalogAvailable *** 
}

void
FsmState::evCatalogError ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evCatalogError *** 
}

void
FsmState::evDataDownload ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evDataDownload *** 
}

void
FsmState::evDataError ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evDataError *** 
}

void
FsmState::evDataTransfer ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evDataTransfer *** 
}

void
FsmState::evDataTransferFailed ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evDataTransferFailed *** 
}

void
FsmState::evDataTransferred ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evDataTransferred *** 
}

void
FsmState::evDone ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evDone *** 
}

void
FsmState::evError ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evError *** 
}

void
FsmState::evErrorHandled ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evErrorHandled *** 
}

void
FsmState::evExpectedIdent ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evExpectedIdent *** 
}

void
FsmState::evFlashContainerError ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evFlashContainerError *** 
}

void
FsmState::evFlashContainerOk ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evFlashContainerOk *** 
}

void
FsmState::evIdle ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evIdle *** 
}

void
FsmState::evProcessed ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evProcessed *** 
}

void
FsmState::evProcessingFailed ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evProcessingFailed *** 
}

void
FsmState::evResponseReceived ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evResponseReceived *** 
}

void
FsmState::evStart ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evStart *** 
}

void
FsmState::evStartUnpacking ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evStartUnpacking *** 
}

void
FsmState::evTerminate ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evTerminate *** 
}

void
FsmState::evTimeout ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evTimeout *** 
}

void
FsmState::evUnknownJob ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evUnknownJob *** 
}

void
FsmState::evUnpacked ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evUnpacked *** 
}

void
FsmState::evUnpackingFailed ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evUnpackingFailed *** 
}

void
FsmState::evWriteDataByID ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evWriteDataByID *** 
}

///////////////////////////////////////////////////////////////////////////////
//
// Abstract base class for all FSM states components.
//
///////////////////////////////////////////////////////////////////////////////

FsmState::FsmState ( void )
   : mpParent(0)
{}

FsmState::~FsmState ( void )
{
   // make lint happy
   mpParent = 0;
}

void
FsmState::initState ( FsmSuperState* pParent )
{
   mpParent = pParent;
}

void
FsmState::entry ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   //... empty as default ...
}

void
FsmState::exit ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   //... empty as default ...
}

const FsmState*
FsmState::propagate ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   b.setState(this);
   entry(b,s,pArg);
   return this;
}

FsmSuperState*
FsmState::getParent ( void )
{
   return (mpParent) ? mpParent : 0;
}

///////////////////////////////////////////////////////////////////////////////
//
// Abstract base class for all FSM superstates.
//
///////////////////////////////////////////////////////////////////////////////

FsmSuperState::FsmSuperState ( void )
   : _default(0),
     _history(0),
     _historyEnable(false)
{}

void
FsmSuperState::initSuperState ( FsmSuperState* pParent, FsmState* defState, bool histEnable )
{
   mpParent = pParent;
   _default = defState;
   _history = 0;
   _historyEnable = histEnable;
}

const FsmState*
FsmSuperState::propagate ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   const FsmState* pState = 0;

   // we have crossed a state boundary
   b.setState(this);
   // execute the entry actions for this superstate
   entry(b,s,pArg);
   
   if ( _history && _historyEnable )
   {
      pState = const_cast<FsmState*>(_history)->propagate(b,s,pArg);
   }
   else
   {
      defaultAction(b,s,pArg);
      if ( _default ) {
         pState = _default->propagate(b,s,pArg);
      }
   }
   
   return pState;
}

void
FsmSuperState::savepoint ( FsmBody& b )
{
   if ( _historyEnable )
   {
      _history = b.getState();
   }
}

void
FsmSuperState::defaultAction ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /*pArg*/ )
{
   //... empty as default ...
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: ChangeDiagnosticSessionState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

ChangeDiagnosticSessionState::ChangeDiagnosticSessionState ( void )
{}

void
ChangeDiagnosticSessionState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmStartTimerSession(pArg);
   s.vFsmStoreActiveSession(pArg);
   s.vFsmSendRequestSessionChange(pArg);
}

void
ChangeDiagnosticSessionState::exit ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmStopTimer(pArg);
}

void
ChangeDiagnosticSessionState::evError ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   //... performing exit actions ...
   exit(b,s,pArg);
   b.setState(b.oErrorHandlingState,pArg);
}

void
ChangeDiagnosticSessionState::evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   //... performing exit actions ...
   exit(b,s,pArg);
   b.setState(b.oIdleState,pArg);
}

void
ChangeDiagnosticSessionState::evProcessed ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.bFsmNeedToDisableFlushing(pArg) )
   {
        //... performing exit actions ...
        exit(b,s,pArg);
        b.setState(b.oDisableFlushingState,pArg);
    }
    else
    {
   //... performing exit actions ...
   exit(b,s,pArg);
   b.setState(b.oFlashingState,pArg);
    }
}

void
ChangeDiagnosticSessionState::evProcessingFailed ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmHandleSessionChangeError(pArg);
   // trigger events
   FsmEvent event = dia_EngineFlashFSM::evUnknown;

   event = dia_EngineFlashFSM::evError; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   // this is an internal transition
}

void
ChangeDiagnosticSessionState::evTerminate ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   //... performing exit actions ...
   exit(b,s,pArg);
   b.setState(b.oFinalState,pArg);
}

void
ChangeDiagnosticSessionState::evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.bFsmWasTimerStarted(pArg) )
   {
        // transition Actions
        s.vFsmHandleTimeout(pArg);
        // trigger events
        FsmEvent event = dia_EngineFlashFSM::evUnknown;

        event = dia_EngineFlashFSM::evError; //lint !e838 Info: Previously assigned value to variable has not been used
        (void) b.addEvent(event,pArg);
        // this is an internal transition
    }
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: CheckingExpectedIdentState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

CheckingExpectedIdentState::CheckingExpectedIdentState ( void )
{}

void
CheckingExpectedIdentState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmStartTimerExpectedIdent(pArg);
   s.vFsmSendRequestReadIdent(pArg);
}

void
CheckingExpectedIdentState::exit ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmStopTimer(pArg);
}

void
CheckingExpectedIdentState::evError ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   //... performing exit actions ...
   exit(b,s,pArg);
   b.oFlashingState.exit(b,s,pArg);
   b.setState(b.oErrorHandlingState,pArg);
}

void
CheckingExpectedIdentState::evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   //... performing exit actions ...
   exit(b,s,pArg);
   b.oFlashingState.exit(b,s,pArg);
   b.setState(b.oIdleState,pArg);
}

void
CheckingExpectedIdentState::evProcessed ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   //... performing exit actions ...
   exit(b,s,pArg);
   b.setState(b.oGetJobState,pArg);
}

void
CheckingExpectedIdentState::evProcessingFailed ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmHandleExpectedIdentError(pArg);
   // trigger events
   FsmEvent event = dia_EngineFlashFSM::evUnknown;

   event = dia_EngineFlashFSM::evError; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   // this is an internal transition
}

void
CheckingExpectedIdentState::evResponseReceived ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmEvalueteResponseExpectedIdent(pArg);
   // this is an internal transition
}

void
CheckingExpectedIdentState::evTerminate ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   //... performing exit actions ...
   exit(b,s,pArg);
   b.oFlashingState.exit(b,s,pArg);
   b.setState(b.oFinalState,pArg);
}

void
CheckingExpectedIdentState::evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.bFsmWasTimerStarted(pArg) )
   {
        // transition Actions
        s.vFsmHandleTimeout(pArg);
        // trigger events
        FsmEvent event = dia_EngineFlashFSM::evUnknown;

        event = dia_EngineFlashFSM::evError; //lint !e838 Info: Previously assigned value to variable has not been used
        (void) b.addEvent(event,pArg);
        // this is an internal transition
    }
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: DisableFlushingState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

DisableFlushingState::DisableFlushingState ( void )
{}

void
DisableFlushingState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmStartTimerFlushing(pArg);
   s.vFsmSendRequestDisableFlushing(pArg);
}

void
DisableFlushingState::exit ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmStopTimer(pArg);
}

void
DisableFlushingState::evError ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   //... performing exit actions ...
   exit(b,s,pArg);
   b.setState(b.oErrorHandlingState,pArg);
}

void
DisableFlushingState::evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   //... performing exit actions ...
   exit(b,s,pArg);
   b.setState(b.oIdleState,pArg);
}

void
DisableFlushingState::evProcessed ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   //... performing exit actions ...
   exit(b,s,pArg);
   b.setState(b.oFlashingState,pArg);
}

void
DisableFlushingState::evProcessingFailed ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmHandleDisableFlushingError(pArg);
   // trigger events
   FsmEvent event = dia_EngineFlashFSM::evUnknown;

   event = dia_EngineFlashFSM::evError; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   // this is an internal transition
}

void
DisableFlushingState::evTerminate ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   //... performing exit actions ...
   exit(b,s,pArg);
   b.setState(b.oFinalState,pArg);
}

void
DisableFlushingState::evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.bFsmWasTimerStarted(pArg) )
   {
        // transition Actions
        s.vFsmHandleTimeout(pArg);
        // trigger events
        FsmEvent event = dia_EngineFlashFSM::evUnknown;

        event = dia_EngineFlashFSM::evError; //lint !e838 Info: Previously assigned value to variable has not been used
        (void) b.addEvent(event,pArg);
        // this is an internal transition
    }
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: EnableFlushingState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

EnableFlushingState::EnableFlushingState ( void )
{}

void
EnableFlushingState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmStartTimerFlushing(pArg);
   s.vFsmSendRequestEnableFlushing(pArg);
}

void
EnableFlushingState::exit ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmStopTimer(pArg);
}

void
EnableFlushingState::evError ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   //... performing exit actions ...
   exit(b,s,pArg);
   b.setState(b.oErrorHandlingState,pArg);
}

void
EnableFlushingState::evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   //... performing exit actions ...
   exit(b,s,pArg);
   b.setState(b.oIdleState,pArg);
}

void
EnableFlushingState::evProcessed ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   //... performing exit actions ...
   exit(b,s,pArg);
   // transition Actions
   s.vFsmFlashingComplete(pArg);
   b.setState(b.oRestoreDiagnosticSessionState,pArg);
}

void
EnableFlushingState::evProcessingFailed ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmHandleEnableFlushingError(pArg);
   // trigger events
   FsmEvent event = dia_EngineFlashFSM::evUnknown;

   event = dia_EngineFlashFSM::evError; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   // this is an internal transition
}

void
EnableFlushingState::evTerminate ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   //... performing exit actions ...
   exit(b,s,pArg);
   b.setState(b.oFinalState,pArg);
}

void
EnableFlushingState::evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.bFsmWasTimerStarted(pArg) )
   {
        // transition Actions
        s.vFsmHandleTimeout(pArg);
        // trigger events
        FsmEvent event = dia_EngineFlashFSM::evUnknown;

        event = dia_EngineFlashFSM::evError; //lint !e838 Info: Previously assigned value to variable has not been used
        (void) b.addEvent(event,pArg);
        // this is an internal transition
    }
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: ErrorHandlingState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

ErrorHandlingState::ErrorHandlingState ( void )
{}

void
ErrorHandlingState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmLogError(pArg);
   s.vFsmHandleError(pArg);
}

void
ErrorHandlingState::evError ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   // this is an internal transition
}

void
ErrorHandlingState::evErrorHandled ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmRemovePDXContainer(pArg);
   b.setState(b.oIdleState,pArg);
}

void
ErrorHandlingState::evIdle ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oIdleState,pArg);
}

void
ErrorHandlingState::evTerminate ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oFinalState,pArg);
}

void
ErrorHandlingState::evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.bFsmWasTimerStarted(pArg) )
   {
        // transition Actions
        s.vFsmHandleTimeout(pArg);
        // trigger events
        FsmEvent event = dia_EngineFlashFSM::evUnknown;

        event = dia_EngineFlashFSM::evError; //lint !e838 Info: Previously assigned value to variable has not been used
        (void) b.addEvent(event,pArg);
        // this is an internal transition
    }
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: FinalState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

FinalState::FinalState ( void )
{}

void
FinalState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmFinalize(pArg);
}

void
FinalState::evError ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   // this is an internal transition
}

void
FinalState::evIdle ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   // this is an internal transition
}

void
FinalState::evTerminate ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   // this is an internal transition
}

void
FinalState::evTimeout ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   // this is an internal transition
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: FlashingState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

FlashingState::FlashingState ( void )
{}

void
FlashingState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmInitializeFlashing(pArg);
   s.vFsmLoadJobs(pArg);
   s.vFsmDiagnosisActive(pArg);
}

void
FlashingState::exit ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmDiagnosisInactive(pArg);
   s.vFsmFinalizeFlashing(pArg);
}

void
FlashingState::evError ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   //... performing exit actions ...
   exit(b,s,pArg);
   b.setState(b.oErrorHandlingState,pArg);
}

void
FlashingState::evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   //... performing exit actions ...
   exit(b,s,pArg);
   b.setState(b.oIdleState,pArg);
}

void
FlashingState::evProcessed ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   //... performing exit actions ...
   exit(b,s,pArg);
   b.oFlashingState.entry(b,s,pArg);
   b.setState(b.oGetJobState,pArg);
}

void
FlashingState::evTerminate ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   //... performing exit actions ...
   exit(b,s,pArg);
   b.setState(b.oFinalState,pArg);
}

void
FlashingState::evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.bFsmWasTimerStarted(pArg) )
   {
        // transition Actions
        s.vFsmHandleTimeout(pArg);
        // trigger events
        FsmEvent event = dia_EngineFlashFSM::evUnknown;

        event = dia_EngineFlashFSM::evError; //lint !e838 Info: Previously assigned value to variable has not been used
        (void) b.addEvent(event,pArg);
        // this is an internal transition
    }
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: GetDataBlockState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

GetDataBlockState::GetDataBlockState ( void )
{}

void
GetDataBlockState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmGetNextBlock(pArg);
   s.vFsmCalcCRC(pArg);
   s.vFsmAssembleData(pArg);
}

void
GetDataBlockState::evDataError ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmHandleDataError(pArg);
   // trigger events
   FsmEvent event = dia_EngineFlashFSM::evUnknown;

   event = dia_EngineFlashFSM::evError; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   // this is an internal transition
}

void
GetDataBlockState::evDataTransfer ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.bFsmIsDataTransferComplete(pArg) )
   {
//        b.oProcessDownloadState.entry(b,s,pArg);
        b.setState(b.oTransferExitState,pArg);
    }
    else
    {
   b.setState(b.oTransferringDataState,pArg);
    }
}

void
GetDataBlockState::evError ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   b.oProcessDownloadState.exit(b,s,pArg);
   b.oFlashingState.exit(b,s,pArg);
   b.setState(b.oErrorHandlingState,pArg);
}

void
GetDataBlockState::evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   b.oProcessDownloadState.exit(b,s,pArg);
   b.oFlashingState.exit(b,s,pArg);
   b.setState(b.oIdleState,pArg);
}

void
GetDataBlockState::evProcessed ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   // this is an internal transition
}

void
GetDataBlockState::evTerminate ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   b.oProcessDownloadState.exit(b,s,pArg);
   b.oFlashingState.exit(b,s,pArg);
   b.setState(b.oFinalState,pArg);
}

void
GetDataBlockState::evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.bFsmWasTimerStarted(pArg) )
   {
        // transition Actions
        s.vFsmHandleTimeout(pArg);
        // trigger events
        FsmEvent event = dia_EngineFlashFSM::evUnknown;

        event = dia_EngineFlashFSM::evError; //lint !e838 Info: Previously assigned value to variable has not been used
        (void) b.addEvent(event,pArg);
        // this is an internal transition
    }
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: GetJobState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

GetJobState::GetJobState ( void )
{}

void
GetJobState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmGetNextJob(pArg);
   s.vFsmEvaluateJob(pArg);
}

void
GetJobState::evDataDownload ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oProcessDownloadState,pArg);
}

void
GetJobState::evDone ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.bFsmNeedToDisableFlushing(pArg) )
   {
        b.oFlashingState.exit(b,s,pArg);
        b.setState(b.oEnableFlushingState,pArg);
    }
    else
    {
   b.oFlashingState.exit(b,s,pArg);
   // transition Actions
   s.vFsmFlashingComplete(pArg);
   b.setState(b.oRestoreDiagnosticSessionState,pArg);
    }
}

void
GetJobState::evError ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   b.oFlashingState.exit(b,s,pArg);
   b.setState(b.oErrorHandlingState,pArg);
}

void
GetJobState::evExpectedIdent ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oCheckingExpectedIdentState,pArg);
}

void
GetJobState::evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   b.oFlashingState.exit(b,s,pArg);
   b.setState(b.oIdleState,pArg);
}

void
GetJobState::evProcessed ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oGetJobState,pArg);
}

void
GetJobState::evTerminate ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   b.oFlashingState.exit(b,s,pArg);
   b.setState(b.oFinalState,pArg);
}

void
GetJobState::evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.bFsmWasTimerStarted(pArg) )
   {
        // transition Actions
        s.vFsmHandleTimeout(pArg);
        // trigger events
        FsmEvent event = dia_EngineFlashFSM::evUnknown;

        event = dia_EngineFlashFSM::evError; //lint !e838 Info: Previously assigned value to variable has not been used
        (void) b.addEvent(event,pArg);
        // this is an internal transition
    }
}

void
GetJobState::evUnknownJob ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmHandleUnknownJob(pArg);
   b.setState(b.oGetJobState,pArg);
}

void
GetJobState::evWriteDataByID ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oProcessWDBIState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: IdleState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

IdleState::IdleState ( void )
{}

void
IdleState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmInitialize(pArg);
}

void
IdleState::evError ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oErrorHandlingState,pArg);
}

void
IdleState::evIdle ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   // this is an internal transition
}

void
IdleState::evStart ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmCheckForPDXContainer(pArg);
   // trigger events
   FsmEvent event = dia_EngineFlashFSM::evUnknown;

   event = dia_EngineFlashFSM::evStartUnpacking; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   // this is an internal transition
}

void
IdleState::evStartUnpacking ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.bFsmIsPDXContainerAvailable(pArg) )
   {
        b.setState(b.oUnpackingState,pArg);
    }
}

void
IdleState::evTerminate ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oFinalState,pArg);
}

void
IdleState::evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.bFsmWasTimerStarted(pArg) )
   {
        // transition Actions
        s.vFsmHandleTimeout(pArg);
        // trigger events
        FsmEvent event = dia_EngineFlashFSM::evUnknown;

        event = dia_EngineFlashFSM::evError; //lint !e838 Info: Previously assigned value to variable has not been used
        (void) b.addEvent(event,pArg);
        // this is an internal transition
    }
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: ProcessDownloadState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

ProcessDownloadState::ProcessDownloadState ( void )
{}

void
ProcessDownloadState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmStartTimerDownload(pArg);
}

void
ProcessDownloadState::exit ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmStopTimer(pArg);
}

void
ProcessDownloadState::evError ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   //... performing exit actions ...
   exit(b,s,pArg);
   b.oFlashingState.exit(b,s,pArg);
   b.setState(b.oErrorHandlingState,pArg);
}

void
ProcessDownloadState::evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   //... performing exit actions ...
   exit(b,s,pArg);
   b.oFlashingState.exit(b,s,pArg);
   b.setState(b.oIdleState,pArg);
}

void
ProcessDownloadState::evProcessed ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   // this is an internal transition
}

void
ProcessDownloadState::evTerminate ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   //... performing exit actions ...
   exit(b,s,pArg);
   b.oFlashingState.exit(b,s,pArg);
   b.setState(b.oFinalState,pArg);
}

void
ProcessDownloadState::evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.bFsmWasTimerStarted(pArg) )
   {
        // transition Actions
        s.vFsmHandleTimeout(pArg);
        // trigger events
        FsmEvent event = dia_EngineFlashFSM::evUnknown;

        event = dia_EngineFlashFSM::evError; //lint !e838 Info: Previously assigned value to variable has not been used
        (void) b.addEvent(event,pArg);
        // this is an internal transition
    }
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: ProcessWDBIState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

ProcessWDBIState::ProcessWDBIState ( void )
{}

void
ProcessWDBIState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmStartTimerWDBI(pArg);
   s.vFsmSendRequestWDBI(pArg);
}

void
ProcessWDBIState::exit ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmStopTimer(pArg);
}

void
ProcessWDBIState::evError ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   //... performing exit actions ...
   exit(b,s,pArg);
   b.oFlashingState.exit(b,s,pArg);
   b.setState(b.oErrorHandlingState,pArg);
}

void
ProcessWDBIState::evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   //... performing exit actions ...
   exit(b,s,pArg);
   b.oFlashingState.exit(b,s,pArg);
   b.setState(b.oIdleState,pArg);
}

void
ProcessWDBIState::evProcessed ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   //... performing exit actions ...
   exit(b,s,pArg);
   b.setState(b.oGetJobState,pArg);
}

void
ProcessWDBIState::evProcessingFailed ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmHandleWDBIError(pArg);
   // trigger events
   FsmEvent event = dia_EngineFlashFSM::evUnknown;

   event = dia_EngineFlashFSM::evError; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   // this is an internal transition
}

void
ProcessWDBIState::evResponseReceived ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmEvaluateResponseWDBI(pArg);
   // this is an internal transition
}

void
ProcessWDBIState::evTerminate ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   //... performing exit actions ...
   exit(b,s,pArg);
   b.oFlashingState.exit(b,s,pArg);
   b.setState(b.oFinalState,pArg);
}

void
ProcessWDBIState::evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.bFsmWasTimerStarted(pArg) )
   {
        // transition Actions
        s.vFsmHandleTimeout(pArg);
        // trigger events
        FsmEvent event = dia_EngineFlashFSM::evUnknown;

        event = dia_EngineFlashFSM::evError; //lint !e838 Info: Previously assigned value to variable has not been used
        (void) b.addEvent(event,pArg);
        // this is an internal transition
    }
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: ReadingCatalogState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

ReadingCatalogState::ReadingCatalogState ( void )
{}

void
ReadingCatalogState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmReadPDXCatalog(pArg);
}

void
ReadingCatalogState::evCatalogAvailable ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.bFsmHasCatalogFlashContainer(pArg) )
   {
        b.setState(b.oReadingFlashContainerState,pArg);
    }
    else
    {
   // transition Actions
   s.vFsmRemovePDXContainer(pArg);
   b.setState(b.oIdleState,pArg);
    }
}

void
ReadingCatalogState::evCatalogError ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmHandleCatalogError(pArg);
   // trigger events
   FsmEvent event = dia_EngineFlashFSM::evUnknown;

   event = dia_EngineFlashFSM::evError; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   // this is an internal transition
}

void
ReadingCatalogState::evError ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oErrorHandlingState,pArg);
}

void
ReadingCatalogState::evIdle ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oIdleState,pArg);
}

void
ReadingCatalogState::evTerminate ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oFinalState,pArg);
}

void
ReadingCatalogState::evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.bFsmWasTimerStarted(pArg) )
   {
        // transition Actions
        s.vFsmHandleTimeout(pArg);
        // trigger events
        FsmEvent event = dia_EngineFlashFSM::evUnknown;

        event = dia_EngineFlashFSM::evError; //lint !e838 Info: Previously assigned value to variable has not been used
        (void) b.addEvent(event,pArg);
        // this is an internal transition
    }
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: ReadingFlashContainerState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

ReadingFlashContainerState::ReadingFlashContainerState ( void )
{}

void
ReadingFlashContainerState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmReadODXFlashContainer(pArg);
}

void
ReadingFlashContainerState::evError ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oErrorHandlingState,pArg);
}

void
ReadingFlashContainerState::evFlashContainerError ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmHandleFlashContainerError(pArg);
   // trigger events
   FsmEvent event = dia_EngineFlashFSM::evUnknown;

   event = dia_EngineFlashFSM::evError; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   // this is an internal transition
}

void
ReadingFlashContainerState::evFlashContainerOk ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oChangeDiagnosticSessionState,pArg);
}

void
ReadingFlashContainerState::evIdle ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oIdleState,pArg);
}

void
ReadingFlashContainerState::evTerminate ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oFinalState,pArg);
}

void
ReadingFlashContainerState::evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.bFsmWasTimerStarted(pArg) )
   {
        // transition Actions
        s.vFsmHandleTimeout(pArg);
        // trigger events
        FsmEvent event = dia_EngineFlashFSM::evUnknown;

        event = dia_EngineFlashFSM::evError; //lint !e838 Info: Previously assigned value to variable has not been used
        (void) b.addEvent(event,pArg);
        // this is an internal transition
    }
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: RequestDownloadState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

RequestDownloadState::RequestDownloadState ( void )
{}

void
RequestDownloadState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmSendRequestDownloadRequest(pArg);
}

void
RequestDownloadState::evError ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   b.oProcessDownloadState.exit(b,s,pArg);
   b.oFlashingState.exit(b,s,pArg);
   b.setState(b.oErrorHandlingState,pArg);
}

void
RequestDownloadState::evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   b.oProcessDownloadState.exit(b,s,pArg);
   b.oFlashingState.exit(b,s,pArg);
   b.setState(b.oIdleState,pArg);
}

void
RequestDownloadState::evProcessed ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oTransferDataState,pArg);
}

void
RequestDownloadState::evProcessingFailed ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmHandleRequestDownloadError(pArg);
   // trigger events
   FsmEvent event = dia_EngineFlashFSM::evUnknown;

   event = dia_EngineFlashFSM::evError; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   // this is an internal transition
}

void
RequestDownloadState::evResponseReceived ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmEvaluateResponseDownloadRequest(pArg);
   // this is an internal transition
}

void
RequestDownloadState::evTerminate ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   b.oProcessDownloadState.exit(b,s,pArg);
   b.oFlashingState.exit(b,s,pArg);
   b.setState(b.oFinalState,pArg);
}

void
RequestDownloadState::evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.bFsmWasTimerStarted(pArg) )
   {
        // transition Actions
        s.vFsmHandleTimeout(pArg);
        // trigger events
        FsmEvent event = dia_EngineFlashFSM::evUnknown;

        event = dia_EngineFlashFSM::evError; //lint !e838 Info: Previously assigned value to variable has not been used
        (void) b.addEvent(event,pArg);
        // this is an internal transition
    }
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: RestoreDiagnosticSessionState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

RestoreDiagnosticSessionState::RestoreDiagnosticSessionState ( void )
{}

void
RestoreDiagnosticSessionState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmStartTimerSession(pArg);
   s.vFsmRestoreActiveSession(pArg);
   s.vFsmSendRequestSessionChange(pArg);
}

void
RestoreDiagnosticSessionState::exit ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmStopTimer(pArg);
}

void
RestoreDiagnosticSessionState::evError ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   //... performing exit actions ...
   exit(b,s,pArg);
   b.setState(b.oErrorHandlingState,pArg);
}

void
RestoreDiagnosticSessionState::evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   //... performing exit actions ...
   exit(b,s,pArg);
   b.setState(b.oIdleState,pArg);
}

void
RestoreDiagnosticSessionState::evProcessed ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   //... performing exit actions ...
   exit(b,s,pArg);
   // transition Actions
   s.vFsmFinalizeFlashProcess(pArg);
   s.vFsmRemovePDXContainer(pArg);
   b.setState(b.oIdleState,pArg);
}

void
RestoreDiagnosticSessionState::evProcessingFailed ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmHandleSessionChangeError(pArg);
   // trigger events
   FsmEvent event = dia_EngineFlashFSM::evUnknown;

   event = dia_EngineFlashFSM::evError; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   // this is an internal transition
}

void
RestoreDiagnosticSessionState::evTerminate ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   //... performing exit actions ...
   exit(b,s,pArg);
   b.setState(b.oFinalState,pArg);
}

void
RestoreDiagnosticSessionState::evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.bFsmWasTimerStarted(pArg) )
   {
        // transition Actions
        s.vFsmHandleTimeout(pArg);
        // trigger events
        FsmEvent event = dia_EngineFlashFSM::evUnknown;

        event = dia_EngineFlashFSM::evError; //lint !e838 Info: Previously assigned value to variable has not been used
        (void) b.addEvent(event,pArg);
        // this is an internal transition
    }
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: TopLevelState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

TopLevelState::TopLevelState ( void )
{}

void
TopLevelState::evError ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oErrorHandlingState,pArg);
}

void
TopLevelState::evIdle ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oIdleState,pArg);
}

void
TopLevelState::evTerminate ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oFinalState,pArg);
}

void
TopLevelState::evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.bFsmWasTimerStarted(pArg) )
   {
        // transition Actions
        s.vFsmHandleTimeout(pArg);
        // trigger events
        FsmEvent event = dia_EngineFlashFSM::evUnknown;

        event = dia_EngineFlashFSM::evError; //lint !e838 Info: Previously assigned value to variable has not been used
        (void) b.addEvent(event,pArg);
        // this is an internal transition
    }
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: TransferDataState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

TransferDataState::TransferDataState ( void )
{}

void
TransferDataState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmReadData(pArg);
   s.vFsmSplitData(pArg);
}

void
TransferDataState::evError ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   b.oProcessDownloadState.exit(b,s,pArg);
   b.oFlashingState.exit(b,s,pArg);
   b.setState(b.oErrorHandlingState,pArg);
}

void
TransferDataState::evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   b.oProcessDownloadState.exit(b,s,pArg);
   b.oFlashingState.exit(b,s,pArg);
   b.setState(b.oIdleState,pArg);
}

void
TransferDataState::evProcessed ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   // this is an internal transition
}

void
TransferDataState::evTerminate ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   b.oProcessDownloadState.exit(b,s,pArg);
   b.oFlashingState.exit(b,s,pArg);
   b.setState(b.oFinalState,pArg);
}

void
TransferDataState::evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.bFsmWasTimerStarted(pArg) )
   {
        // transition Actions
        s.vFsmHandleTimeout(pArg);
        // trigger events
        FsmEvent event = dia_EngineFlashFSM::evUnknown;

        event = dia_EngineFlashFSM::evError; //lint !e838 Info: Previously assigned value to variable has not been used
        (void) b.addEvent(event,pArg);
        // this is an internal transition
    }
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: TransferExitState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

TransferExitState::TransferExitState ( void )
{}

void
TransferExitState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmSendRequestTransferExit(pArg);
}

void
TransferExitState::evError ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   b.oProcessDownloadState.exit(b,s,pArg);
   b.oFlashingState.exit(b,s,pArg);
   b.setState(b.oErrorHandlingState,pArg);
}

void
TransferExitState::evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   b.oProcessDownloadState.exit(b,s,pArg);
   b.oFlashingState.exit(b,s,pArg);
   b.setState(b.oIdleState,pArg);
}

void
TransferExitState::evProcessed ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   b.oProcessDownloadState.exit(b,s,pArg);
//   b.oFlashingState.entry(b,s,pArg);
   b.setState(b.oGetJobState,pArg);
}

void
TransferExitState::evProcessingFailed ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmHandlerTransferExitError(pArg);
   // trigger events
   FsmEvent event = dia_EngineFlashFSM::evUnknown;

   event = dia_EngineFlashFSM::evError; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   // this is an internal transition
}

void
TransferExitState::evResponseReceived ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmEvaluateResponseTransferExit(pArg);
   // this is an internal transition
}

void
TransferExitState::evTerminate ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   b.oProcessDownloadState.exit(b,s,pArg);
   b.oFlashingState.exit(b,s,pArg);
   b.setState(b.oFinalState,pArg);
}

void
TransferExitState::evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.bFsmWasTimerStarted(pArg) )
   {
        // transition Actions
        s.vFsmHandleTimeout(pArg);
        // trigger events
        FsmEvent event = dia_EngineFlashFSM::evUnknown;

        event = dia_EngineFlashFSM::evError; //lint !e838 Info: Previously assigned value to variable has not been used
        (void) b.addEvent(event,pArg);
        // this is an internal transition
    }
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: TransferringDataState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

TransferringDataState::TransferringDataState ( void )
{}

void
TransferringDataState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmSendRequestTransferData(pArg);
}

void
TransferringDataState::evDataTransferFailed ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmHandleDataTransferError(pArg);
   // trigger events
   FsmEvent event = dia_EngineFlashFSM::evUnknown;

   event = dia_EngineFlashFSM::evError; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   // this is an internal transition
}

void
TransferringDataState::evDataTransferred ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.bFsmIsDataTransferComplete(pArg) )
   {
//        b.oProcessDownloadState.entry(b,s,pArg);
        b.setState(b.oTransferExitState,pArg);
    }
    else
    {
   b.setState(b.oGetDataBlockState,pArg);
    }
}

void
TransferringDataState::evError ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   b.oProcessDownloadState.exit(b,s,pArg);
   b.oFlashingState.exit(b,s,pArg);
   b.setState(b.oErrorHandlingState,pArg);
}

void
TransferringDataState::evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   b.oProcessDownloadState.exit(b,s,pArg);
   b.oFlashingState.exit(b,s,pArg);
   b.setState(b.oIdleState,pArg);
}

void
TransferringDataState::evProcessed ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   // this is an internal transition
}

void
TransferringDataState::evResponseReceived ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmEvaluateResponseTransferData(pArg);
   // this is an internal transition
}

void
TransferringDataState::evTerminate ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   b.oProcessDownloadState.exit(b,s,pArg);
   b.oFlashingState.exit(b,s,pArg);
   b.setState(b.oFinalState,pArg);
}

void
TransferringDataState::evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.bFsmWasTimerStarted(pArg) )
   {
        // transition Actions
        s.vFsmHandleTimeout(pArg);
        // trigger events
        FsmEvent event = dia_EngineFlashFSM::evUnknown;

        event = dia_EngineFlashFSM::evError; //lint !e838 Info: Previously assigned value to variable has not been used
        (void) b.addEvent(event,pArg);
        // this is an internal transition
    }
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: UnpackingState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

UnpackingState::UnpackingState ( void )
{}

void
UnpackingState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmUnpackPDXContainer(pArg);
}

void
UnpackingState::evError ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oErrorHandlingState,pArg);
}

void
UnpackingState::evIdle ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oIdleState,pArg);
}

void
UnpackingState::evTerminate ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oFinalState,pArg);
}

void
UnpackingState::evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.bFsmWasTimerStarted(pArg) )
   {
        // transition Actions
        s.vFsmHandleTimeout(pArg);
        // trigger events
        FsmEvent event = dia_EngineFlashFSM::evUnknown;

        event = dia_EngineFlashFSM::evError; //lint !e838 Info: Previously assigned value to variable has not been used
        (void) b.addEvent(event,pArg);
        // this is an internal transition
    }
}

void
UnpackingState::evUnpacked ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oReadingCatalogState,pArg);
}

void
UnpackingState::evUnpackingFailed ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmHandleUnpackingError(pArg);
   // trigger events
   FsmEvent event = dia_EngineFlashFSM::evUnknown;

   event = dia_EngineFlashFSM::evError; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   // this is an internal transition
}

///////////////////////////////////////////////////////////////////////////////
//
// This is the finite state machine class implementation
//
///////////////////////////////////////////////////////////////////////////////

Fsm::Fsm ( void )
    : mpBehaviour(0),
      mpBody(0)
{
}

Fsm::Fsm ( FsmBehaviour* server )
    : mpBehaviour(server),
      mpBody(0)
{}

Fsm::~Fsm ( void )
{
    if ( mpBody )
    {
        delete mpBody;
        mpBody = 0;
    }
    mpBehaviour = 0;
}

bool
Fsm::createFSM ( Fsm** ppFSM, FsmBehaviour* behaviour )
{
   bool retCode = false;

   if ( ppFSM && behaviour )
   {
      (*ppFSM) = new Fsm(behaviour);
      if ( (*ppFSM) )
      {
         if ( !((*ppFSM)->init()) )
         {
            delete (*ppFSM);
            (*ppFSM) = 0;
         }
         else
         {
            retCode = true;
         }
      }
   }

   return retCode;
}

bool
Fsm::init ( void )
{
   bool retCode = false;
   
   mpBody = new FsmBody();
   
   if ( mpBody )
   {
      // connect the body with its frontend
      mpBody->connect(this);
      if ( mpBody->init() )
      {
          retCode = true;
      }
   }
   
   return retCode;
}

const char*
Fsm::getStateName (void) const
{
    return ( mpBody ) ? mpBody->getStateName() : 0;
}

void 
Fsm::acceptEvent ( FsmEvent event, void* pArg )
{
    if ( mpBody )
    {
        // forward the event to the FSM body (handle-body pattern)
        mpBody->acceptEvent(event,pArg);
    }
}
///////////////////////////////////////////////////////////////////////////////
//
// This is the finite state machine class implementation
//
///////////////////////////////////////////////////////////////////////////////

FsmBody::FsmBody ( void ) :
      mpFrontend(0),
      mpState(0),
      mBusyFlag(false),
      mQueueHead(0),
      mQueueTail(0),
      mQueueSize(0)
{
    (void) ::memset(mEventQueue,0,sizeof(FsmEvent)*MAX_TRIGGER_EVENTS);
    (void) ::memset(mParamQueue,0,sizeof(void*)*MAX_TRIGGER_EVENTS);
}

bool
FsmBody::init ( void )
{
    oChangeDiagnosticSessionState.initState(&oTopLevelState);
    oCheckingExpectedIdentState.initState(&oFlashingState);
    oDisableFlushingState.initState(&oTopLevelState);
    oEnableFlushingState.initState(&oTopLevelState);
    oErrorHandlingState.initState(&oTopLevelState);
    oFinalState.initState(&oTopLevelState);
    oFlashingState.initSuperState(&oTopLevelState, &oGetJobState, false);
    oGetDataBlockState.initState(&oTransferDataState);
    oGetJobState.initState(&oFlashingState);
    oIdleState.initState(&oTopLevelState);
    oProcessDownloadState.initSuperState(&oFlashingState, &oRequestDownloadState, false);
    oProcessWDBIState.initState(&oFlashingState);
    oReadingCatalogState.initState(&oTopLevelState);
    oReadingFlashContainerState.initState(&oTopLevelState);
    oRequestDownloadState.initState(&oProcessDownloadState);
    oRestoreDiagnosticSessionState.initState(&oTopLevelState);
    oTopLevelState.initSuperState(0, &oIdleState, false);
    oTransferDataState.initSuperState(&oProcessDownloadState, &oGetDataBlockState, false);
    oTransferExitState.initState(&oProcessDownloadState);
    oTransferringDataState.initState(&oTransferDataState);
    oUnpackingState.initState(&oTopLevelState);

    setState(oTopLevelState,0);
    
    return true;
}

void
FsmBody::connect ( Fsm* frontend )
{
    mpFrontend = frontend;
}

const char*
FsmBody::getStateName ( void ) const
{
    return ( mpState ) ? mpState->getStateName() : 0;
}

bool
FsmBody::addEvent ( const FsmEvent& event, void* param )
{
    if ( mQueueSize < MAX_TRIGGER_EVENTS )
    {
        mQueueSize++;
        mEventQueue[mQueueTail] = event;
        mParamQueue[mQueueTail] = param;
        mQueueTail++;
        if ( mQueueTail == MAX_TRIGGER_EVENTS )
        {
            mQueueTail = 0;
        }
        return true;
    }
    return false;
}

bool
FsmBody::getEvent ( FsmEvent& event, void** param )
{
    if ( !mQueueSize || !param )
    {
        return false;
    }
    mQueueSize--;
    event  = mEventQueue[mQueueHead];
    *param = mParamQueue[mQueueHead];
    mQueueHead++;
    if ( mQueueHead == MAX_TRIGGER_EVENTS )
    {
        mQueueHead = 0;
    }
    return true;
}

bool
FsmBody::isQueueEmpty ( void ) const
{
    return ( mQueueSize ) ? false : true;
}

void 
FsmBody::acceptEvent ( FsmEvent event, void* pArg )
{
    (void) addEvent(event,pArg);

    if ( mBusyFlag )
    {
        return;
    }

    mBusyFlag = true;
    while ( !isQueueEmpty() )
    {
        FsmEvent nextEvent = evUnknown;
        void*    nextArg   = 0;
        if ( !getEvent(nextEvent,&nextArg) )
        {
            break;
        }

        switch (nextEvent)
        {
        case evCatalogAvailable:
            if ( mpState ) mpState->evCatalogAvailable(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evCatalogError:
            if ( mpState ) mpState->evCatalogError(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evDataDownload:
            if ( mpState ) mpState->evDataDownload(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evDataError:
            if ( mpState ) mpState->evDataError(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evDataTransfer:
            if ( mpState ) mpState->evDataTransfer(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evDataTransferFailed:
            if ( mpState ) mpState->evDataTransferFailed(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evDataTransferred:
            if ( mpState ) mpState->evDataTransferred(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evDone:
            if ( mpState ) mpState->evDone(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evError:
            if ( mpState ) mpState->evError(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evErrorHandled:
            if ( mpState ) mpState->evErrorHandled(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evExpectedIdent:
            if ( mpState ) mpState->evExpectedIdent(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evFlashContainerError:
            if ( mpState ) mpState->evFlashContainerError(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evFlashContainerOk:
            if ( mpState ) mpState->evFlashContainerOk(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evIdle:
            if ( mpState ) mpState->evIdle(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evProcessed:
            if ( mpState ) mpState->evProcessed(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evProcessingFailed:
            if ( mpState ) mpState->evProcessingFailed(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evResponseReceived:
            if ( mpState ) mpState->evResponseReceived(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evStart:
            if ( mpState ) mpState->evStart(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evStartUnpacking:
            if ( mpState ) mpState->evStartUnpacking(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evTerminate:
            if ( mpState ) mpState->evTerminate(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evTimeout:
            if ( mpState ) mpState->evTimeout(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evUnknownJob:
            if ( mpState ) mpState->evUnknownJob(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evUnpacked:
            if ( mpState ) mpState->evUnpacked(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evUnpackingFailed:
            if ( mpState ) mpState->evUnpackingFailed(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evWriteDataByID:
            if ( mpState ) mpState->evWriteDataByID(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        default:
            //... unknown event ...
            break;
        } //lint !e788: not all items used within defaulted switch
    }
    mBusyFlag = false;
}

void 
FsmBody::setState ( FsmState& state, void* pArg )
{
    if ( mpFrontend )
    {
        mpState = const_cast<FsmState*>(state.propagate(*this,*(mpFrontend->mpBehaviour),pArg));
    }
}

void 
FsmBody::setState ( FsmState* pState )
{
    mpState = pState;
}

const FsmState*
FsmBody::getState ( void ) const
{
    return mpState;
}

///////////////////////////////////////////////////////////////////////////////
//
// Functions
//
///////////////////////////////////////////////////////////////////////////////

const char* getEventName ( FsmEvent event )
{
   static const char* eventNames[evCount] = {
      "evUnknown",
      "evCatalogAvailable",
      "evCatalogError",
      "evDataDownload",
      "evDataError",
      "evDataTransfer",
      "evDataTransferFailed",
      "evDataTransferred",
      "evDone",
      "evError",
      "evErrorHandled",
      "evExpectedIdent",
      "evFlashContainerError",
      "evFlashContainerOk",
      "evIdle",
      "evProcessed",
      "evProcessingFailed",
      "evResponseReceived",
      "evStart",
      "evStartUnpacking",
      "evTerminate",
      "evTimeout",
      "evUnknownJob",
      "evUnpacked",
      "evUnpackingFailed",
      "evWriteDataByID",
   };

   return eventNames[event];
}


} // namespace
