///////////////////////////////////////////////////////////////////////////////
//
// File: dia_DataDownloadFSM.h
//
// Generated by SMC 4.5.5 (C++ State Pattern Code Generator)
//
// Command Line Arguments:
//
//   --use_factory_method
//   -c dia_DataDownloadFSM.fsm
//
///////////////////////////////////////////////////////////////////////////////

#ifndef __INCLUDED_DIA_DATADOWNLOADFSM__
#define __INCLUDED_DIA_DATADOWNLOADFSM__

namespace dia_DataDownloadFSM
{

///////////////////////////////////////////////////////////////////////////////
//
// Forward Declarations
//
///////////////////////////////////////////////////////////////////////////////

class FsmBody;

///////////////////////////////////////////////////////////////////////////////
//
// Enums and typedefs
//
///////////////////////////////////////////////////////////////////////////////

//! enumeration of FSM events. First and last item added by SMC
enum FsmEvent
{
   evUnknown = 0,
   evDataTransferComplete,
   evDataTransferDone,
   evDataTransferExit,
   evDataTransferExitReady,
   evDataTransferRx,
   evDataTransferValidated,
   evIdle,
   evInvalidAddr,
   evInvalidFormat,
   evInvalidLength,
   evRequestDownload,
   evRequestDownloadReady,
   evRequestDownloadValid,
   evRequestUpload,
   evRequestUploadValid,
   evSessionChange,
   evTimeout,
   evCount
};

///////////////////////////////////////////////////////////////////////////////
//
// Functions
//
///////////////////////////////////////////////////////////////////////////////

const char* getEventName ( FsmEvent event );

///////////////////////////////////////////////////////////////////////////////
//
// Class: FsmBehaviour
//
// This is the base class for the FSM server (provides implementation for all
// actions and guards)
//
///////////////////////////////////////////////////////////////////////////////

class FsmBehaviour
{ 
public:
   virtual ~FsmBehaviour ( void ) {}

   // FSM actions
   virtual void calcCrcRam ( void* pArg ) = 0;
   virtual void checkForCompletion ( void* pArg ) = 0;
   virtual void downloadData ( void* pArg ) = 0;
   virtual void postprocessDownload ( void* pArg ) = 0;
   virtual void postprocessUpload ( void* pArg ) = 0;
   virtual void prepareDownload ( void* pArg ) = 0;
   virtual void prepareUpload ( void* pArg ) = 0;
   virtual void reset ( void* pArg ) = 0;
   virtual void retransmitTransferDataResponse ( void* pArg ) = 0;
   virtual void saveDataset ( void* pArg ) = 0;
   virtual void sendDownloadTransferDataResponse ( void* pArg ) = 0;
   virtual void sendErr_AlreadyRequested ( void* pArg ) = 0;
   virtual void sendErr_InvalidAddress ( void* pArg ) = 0;
   virtual void sendErr_InvalidData ( void* pArg ) = 0;
   virtual void sendErr_InvalidFormat ( void* pArg ) = 0;
   virtual void sendErr_InvalidLength ( void* pArg ) = 0;
   virtual void sendErr_InvalidSequence ( void* pArg ) = 0;
   virtual void sendErr_TransExitInvalidData ( void* pArg ) = 0;
   virtual void sendReqDownloadResponse ( void* pArg ) = 0;
   virtual void sendReqUploadResponse ( void* pArg ) = 0;
   virtual void sendTransExitResponse ( void* pArg ) = 0;
   virtual void sendUploadTransferDataResponse ( void* pArg ) = 0;
   virtual void setDownloadActivated ( void* pArg ) = 0;
   virtual void setUploadActivated ( void* pArg ) = 0;
   virtual void uploadData ( void* pArg ) = 0;
   virtual void validateDownloadRequest ( void* pArg ) = 0;
   virtual void validateTransferredData ( void* pArg ) = 0;
   virtual void validateUploadRequest ( void* pArg ) = 0;

   // FSM guards
   virtual bool areDownloadConditionsOk ( void* pArg ) = 0;
   virtual bool areUploadConditionsOk ( void* pArg ) = 0;
   virtual bool isCrcOk ( void* pArg ) = 0;
   virtual bool isDataValid ( void* pArg ) = 0;
   virtual bool isRetransmission ( void* pArg ) = 0;
};

///////////////////////////////////////////////////////////////////////////////
//
// Class: Fsm
//
// This is the finite state machine class 'dia_DataDownloadFSM'.
//
///////////////////////////////////////////////////////////////////////////////

class Fsm
{
    //! we grant the body class access to our protected section
    friend class FsmBody;

public:
    //! factory method used to create an FAM object in two stages
    static bool createFSM ( Fsm** ppFSM, FsmBehaviour* behaviour );
    //! class destructor
    virtual ~Fsm ( void );

    //! this method is used to stimulate the FSM with events
    virtual void acceptEvent ( FsmEvent event, void* pArg );

    //! return the name of the current state
    virtual const char* getStateName ( void ) const;

protected:
    //! protected default constructor to avoid usage
    Fsm ( void );
    //! class constructor
    Fsm ( FsmBehaviour* behaviour );
    //! copy constructor without implementation
    Fsm ( const Fsm& obj );
    //! assignment operator without implementation
    Fsm& operator = ( const Fsm& obj );

    //! setup and initialize the state machine
    virtual bool init ( void );

protected:
    //! pointer to the server that provides the implementation for the actions and guards
    FsmBehaviour* mpBehaviour;
    //! body of the FSM implementation
    FsmBody* mpBody;
};


} // namespace

#endif
