///////////////////////////////////////////////////////////////////////////////
//
// File: dia_DataDownloadFSM.cpp
//
// Generated by SMC 4.5.5 (C++ State Pattern Code Generator)
//
// Command Line Arguments:
//
//   --use_factory_method
//   -c dia_DataDownloadFSM.fsm
//
///////////////////////////////////////////////////////////////////////////////

#include <string.h>

#ifndef __INCLUDED_DIA_DATADOWNLOADFSM__
#include "dia_DataDownloadFSM.h"
#endif

namespace dia_DataDownloadFSM
{

const unsigned int MAX_TRIGGER_EVENTS = 20;

///////////////////////////////////////////////////////////////////////////////
//
// Forward Declarations
//
///////////////////////////////////////////////////////////////////////////////

class Fsm;
class FsmSuperState;

///////////////////////////////////////////////////////////////////////////////
//
// Abstract base class for all FSM states.
//
///////////////////////////////////////////////////////////////////////////////

class FsmState
{
public:
   //! name of the FSM's state
   virtual const char* getStateName ( void ) const = 0;

   //! resetting state internals
   virtual void reset ( void ) {}

   // event functions 
   virtual void evDataTransferComplete ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evDataTransferDone ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evDataTransferExit ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evDataTransferExitReady ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evDataTransferRx ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evDataTransferValidated ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evInvalidAddr ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evInvalidFormat ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evInvalidLength ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestDownload ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestDownloadReady ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestDownloadValid ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestUpload ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestUploadValid ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSessionChange ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! default implementation for the Entry action
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! default implementation for the Exit action
   virtual void exit  ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! method used to propagate the event to the superstate
   virtual const FsmState* propagate ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! return the parent state
   virtual FsmSuperState* getParent ( void );

   //! assign the body object
   void initState ( FsmSuperState* pParent );

protected:
   //! default constructor is protected to prevent usage of this constructor
   FsmState ( void );
   //! class destructor
   virtual ~FsmState ( void );

   //! pointer to the superstate
   FsmSuperState* mpParent;
};

///////////////////////////////////////////////////////////////////////////////
//
// Abstract base class for all FSM superstates.
//
///////////////////////////////////////////////////////////////////////////////

class FsmSuperState
   : public FsmState
{
public:
   //! set a savepoint for the history
   virtual void savepoint ( FsmBody& b );
   //! default action
   virtual void defaultAction ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! resetting state internals
   virtual void reset ( void ) { _history = 0; }

   //! method used to propagate the event to the superstate
   virtual const FsmState* propagate ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! assign the body object
   void initSuperState ( FsmSuperState* pParent, FsmState* defState, bool histEnable=false );

protected:
   //! default constructor is protected to prevent usage of this constructor
   FsmSuperState ( void );

   //! pointer to the default substate
   FsmState* _default;
   //! pointer to the history substate
   const FsmState* _history;
   //! flag that indicates if history is enabled or not
   bool _historyEnable;
};

///////////////////////////////////////////////////////////////////////////////
// 
// Class: DownloadActiveState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class DownloadActiveState
   : public FsmSuperState
{
public:
   //! default constructor
   DownloadActiveState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evDataTransferExitReady ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evInvalidAddr ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evInvalidFormat ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evInvalidLength ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestDownload ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestUpload ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSessionChange ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* DownloadActiveState::mStateName = "DownloadActive";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: DownloadDataTransferState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class DownloadDataTransferState
   : public FsmState
{
public:
   //! default constructor
   DownloadDataTransferState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evDataTransferComplete ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evDataTransferExit ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evDataTransferExitReady ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evDataTransferRx ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evDataTransferValidated ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evInvalidAddr ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evInvalidFormat ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evInvalidLength ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestDownload ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestUpload ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSessionChange ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* DownloadDataTransferState::mStateName = "DownloadDataTransfer";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: DownloadDoneState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class DownloadDoneState
   : public FsmState
{
public:
   //! default constructor
   DownloadDoneState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evDataTransferExit ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evDataTransferExitReady ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evDataTransferRx ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evInvalidAddr ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evInvalidFormat ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evInvalidLength ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestDownload ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestUpload ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSessionChange ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* DownloadDoneState::mStateName = "DownloadDone";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: DownloadingDataState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class DownloadingDataState
   : public FsmState
{
public:
   //! default constructor
   DownloadingDataState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evDataTransferDone ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evDataTransferExit ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evDataTransferExitReady ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evInvalidAddr ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evInvalidFormat ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evInvalidLength ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestDownload ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestUpload ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSessionChange ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* DownloadingDataState::mStateName = "DownloadingData";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: NotActiveState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class NotActiveState
   : public FsmState
{
public:
   //! default constructor
   NotActiveState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evDataTransferExit ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evDataTransferRx ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evInvalidAddr ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evInvalidFormat ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evInvalidLength ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestDownload ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestDownloadReady ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestDownloadValid ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestUpload ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestUploadValid ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* NotActiveState::mStateName = "NotActive";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: ToplevelDataUpDownloadState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class ToplevelDataUpDownloadState
   : public FsmSuperState
{
public:
   //! default constructor
   ToplevelDataUpDownloadState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evInvalidAddr ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evInvalidFormat ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evInvalidLength ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* ToplevelDataUpDownloadState::mStateName = "ToplevelDataUpDownload";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: UploadActiveState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class UploadActiveState
   : public FsmSuperState
{
public:
   //! default constructor
   UploadActiveState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evInvalidAddr ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evInvalidFormat ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evInvalidLength ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestDownload ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestUpload ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSessionChange ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* UploadActiveState::mStateName = "UploadActive";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: UploadDataTransferState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class UploadDataTransferState
   : public FsmState
{
public:
   //! default constructor
   UploadDataTransferState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evDataTransferComplete ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evDataTransferExit ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evDataTransferRx ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evInvalidAddr ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evInvalidFormat ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evInvalidLength ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestDownload ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestUpload ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSessionChange ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* UploadDataTransferState::mStateName = "UploadDataTransfer";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: UploadDoneState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class UploadDoneState
   : public FsmState
{
public:
   //! default constructor
   UploadDoneState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evDataTransferExit ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evDataTransferRx ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evInvalidAddr ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evInvalidFormat ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evInvalidLength ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestDownload ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestUpload ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSessionChange ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* UploadDoneState::mStateName = "UploadDone";

///////////////////////////////////////////////////////////////////////////////
//
// Class: FsmBody
//
// This is the finite state machine's body class 'FsmBody'.
//
///////////////////////////////////////////////////////////////////////////////

class FsmBody
{
    struct FsmDeferredEvent
    {
          FsmDeferredEvent() : mEvent(evUnknown), mArg(0) {}
          FsmEvent mEvent;
          void*    mArg;
    };

public:
    //! class constructor
    FsmBody ( void );

    //! connect the FSM body with its frontend
    void connect ( Fsm* frontend );

    //! initialize the FSM: set initial state and execute initial actions
    bool init ( void );

    //! this method is used to stimulate the FSM with events
    void acceptEvent ( FsmEvent event, void* pArg );

    //! return the name of the active state
    const char* getStateName ( void ) const;

    //! push trigger events to the event queue
    bool addEvent ( const FsmEvent& event, void* arg  );
    //! get event from the event queue
    bool getEvent ( FsmEvent& event, void** arg  );
    //! get event from the event queue
    bool isQueueEmpty ( void ) const;

    // set the FSM's internal state and propagate to default or history substate
    void setState ( FsmState& state, void* pArg );
    // set the FSM's internal state (no propagation
    void setState ( FsmState* pState );
    // return the active state object
    const FsmState* getState ( void ) const;

    //! static state objects
    DownloadActiveState oDownloadActiveState;
    DownloadDataTransferState oDownloadDataTransferState;
    DownloadDoneState oDownloadDoneState;
    DownloadingDataState oDownloadingDataState;
    NotActiveState oNotActiveState;
    ToplevelDataUpDownloadState oToplevelDataUpDownloadState;
    UploadActiveState oUploadActiveState;
    UploadDataTransferState oUploadDataTransferState;
    UploadDoneState oUploadDoneState;

    //! frontend for this body
    Fsm* mpFrontend;
    //! link to the active state object
    FsmState* mpState;

    //! busy indicator flag
    bool mBusyFlag;

    //! queue of trigger events
    FsmEvent mEventQueue[MAX_TRIGGER_EVENTS];
    //! queue of arguments for trigger events
    void*    mParamQueue[MAX_TRIGGER_EVENTS];
    //! index of the queue's front element
    unsigned int mQueueHead;
    //! index of the queue's back element
    unsigned int mQueueTail;
    //! number of queued events
    unsigned int mQueueSize;
};

///////////////////////////////////////////////////////////////////////////////
//
// Default implementation for all events.
//
///////////////////////////////////////////////////////////////////////////////

void
FsmState::evDataTransferComplete ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evDataTransferComplete *** 
}

void
FsmState::evDataTransferDone ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evDataTransferDone *** 
}

void
FsmState::evDataTransferExit ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evDataTransferExit *** 
}

void
FsmState::evDataTransferExitReady ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evDataTransferExitReady *** 
}

void
FsmState::evDataTransferRx ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evDataTransferRx *** 
}

void
FsmState::evDataTransferValidated ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evDataTransferValidated *** 
}

void
FsmState::evIdle ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evIdle *** 
}

void
FsmState::evInvalidAddr ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evInvalidAddr *** 
}

void
FsmState::evInvalidFormat ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evInvalidFormat *** 
}

void
FsmState::evInvalidLength ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evInvalidLength *** 
}

void
FsmState::evRequestDownload ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evRequestDownload *** 
}

void
FsmState::evRequestDownloadReady ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evRequestDownloadReady *** 
}

void
FsmState::evRequestDownloadValid ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evRequestDownloadValid *** 
}

void
FsmState::evRequestUpload ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evRequestUpload *** 
}

void
FsmState::evRequestUploadValid ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evRequestUploadValid *** 
}

void
FsmState::evSessionChange ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evSessionChange *** 
}

void
FsmState::evTimeout ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evTimeout *** 
}

///////////////////////////////////////////////////////////////////////////////
//
// Abstract base class for all FSM states components.
//
///////////////////////////////////////////////////////////////////////////////

FsmState::FsmState ( void )
   : mpParent(0)
{}

FsmState::~FsmState ( void )
{
   // make lint happy
   mpParent = 0;
}

void
FsmState::initState ( FsmSuperState* pParent )
{
   mpParent = pParent;
}

void
FsmState::entry ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   //... empty as default ...
}

void
FsmState::exit ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   //... empty as default ...
}

const FsmState*
FsmState::propagate ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   b.setState(this);
   entry(b,s,pArg);
   return this;
}

FsmSuperState*
FsmState::getParent ( void )
{
   return (mpParent) ? mpParent : 0;
}

///////////////////////////////////////////////////////////////////////////////
//
// Abstract base class for all FSM superstates.
//
///////////////////////////////////////////////////////////////////////////////

FsmSuperState::FsmSuperState ( void )
   : _default(0),
     _history(0),
     _historyEnable(false)
{}

void
FsmSuperState::initSuperState ( FsmSuperState* pParent, FsmState* defState, bool histEnable )
{
   mpParent = pParent;
   _default = defState;
   _history = 0;
   _historyEnable = histEnable;
}

const FsmState*
FsmSuperState::propagate ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   const FsmState* pState = 0;

   // we have crossed a state boundary
   b.setState(this);
   // execute the entry actions for this superstate
   entry(b,s,pArg);
   
   if ( _history && _historyEnable )
   {
      pState = const_cast<FsmState*>(_history)->propagate(b,s,pArg);
   }
   else
   {
      defaultAction(b,s,pArg);
      if ( _default ) {
         pState = _default->propagate(b,s,pArg);
      }
   }
   
   return pState;
}

void
FsmSuperState::savepoint ( FsmBody& b )
{
   if ( _historyEnable )
   {
      _history = b.getState();
   }
}

void
FsmSuperState::defaultAction ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /*pArg*/ )
{
   //... empty as default ...
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: DownloadActiveState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

DownloadActiveState::DownloadActiveState ( void )
{}

void
DownloadActiveState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.setDownloadActivated(pArg);
}

void
DownloadActiveState::evDataTransferExitReady ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.sendTransExitResponse(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
DownloadActiveState::evIdle ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oNotActiveState,pArg);
}

void
DownloadActiveState::evInvalidAddr ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.sendErr_InvalidAddress(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
DownloadActiveState::evInvalidFormat ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.sendErr_InvalidFormat(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
DownloadActiveState::evInvalidLength ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.sendErr_InvalidLength(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
DownloadActiveState::evRequestDownload ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.sendErr_AlreadyRequested(pArg);
   // this is an internal transition
}

void
DownloadActiveState::evRequestUpload ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.sendErr_InvalidSequence(pArg);
   // this is an internal transition
}

void
DownloadActiveState::evSessionChange ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.postprocessDownload(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
DownloadActiveState::evTimeout ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oNotActiveState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: DownloadDataTransferState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

DownloadDataTransferState::DownloadDataTransferState ( void )
{}

void
DownloadDataTransferState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.checkForCompletion(pArg);
}

void
DownloadDataTransferState::evDataTransferComplete ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.calcCrcRam(pArg);
   b.setState(b.oDownloadDoneState,pArg);
}

void
DownloadDataTransferState::evDataTransferExit ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.isCrcOk(pArg) )
   {
        // transition Actions
        s.saveDataset(pArg);
        s.postprocessDownload(pArg);
        // this is an internal transition
    }
    else
    {
   // transition Actions
   s.sendErr_TransExitInvalidData(pArg);
   b.setState(b.oNotActiveState,pArg);
    }
}

void
DownloadDataTransferState::evDataTransferExitReady ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.sendTransExitResponse(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
DownloadDataTransferState::evDataTransferRx ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   if ( s.isRetransmission(pArg) )
   {
        // transition Actions
        s.retransmitTransferDataResponse(pArg);
        // this is an internal transition
    }
    else
    {
   // transition Actions
   s.validateTransferredData(pArg);
   // this is an internal transition
    }
}

void
DownloadDataTransferState::evDataTransferValidated ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.isDataValid(pArg) )
   {
        b.setState(b.oDownloadingDataState,pArg);
    }
    else
    {
   // transition Actions
   s.sendErr_InvalidData(pArg);
   // this is an internal transition
    }
}

void
DownloadDataTransferState::evIdle ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oNotActiveState,pArg);
}

void
DownloadDataTransferState::evInvalidAddr ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.sendErr_InvalidAddress(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
DownloadDataTransferState::evInvalidFormat ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.sendErr_InvalidFormat(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
DownloadDataTransferState::evInvalidLength ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.sendErr_InvalidLength(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
DownloadDataTransferState::evRequestDownload ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.sendErr_AlreadyRequested(pArg);
   // this is an internal transition
}

void
DownloadDataTransferState::evRequestUpload ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.sendErr_InvalidSequence(pArg);
   // this is an internal transition
}

void
DownloadDataTransferState::evSessionChange ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.postprocessDownload(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
DownloadDataTransferState::evTimeout ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oNotActiveState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: DownloadDoneState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

DownloadDoneState::DownloadDoneState ( void )
{}

void
DownloadDoneState::evDataTransferExit ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.isCrcOk(pArg) )
   {
        // transition Actions
        s.saveDataset(pArg);
        s.postprocessDownload(pArg);
        // this is an internal transition
    }
    else
    {
   // transition Actions
   s.sendErr_TransExitInvalidData(pArg);
   b.setState(b.oNotActiveState,pArg);
    }
}

void
DownloadDoneState::evDataTransferExitReady ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.sendTransExitResponse(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
DownloadDoneState::evDataTransferRx ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   if ( s.isRetransmission(pArg) )
   {
        // transition Actions
        s.retransmitTransferDataResponse(pArg);
        // this is an internal transition
    }
    else
    {
   // transition Actions
   s.sendErr_InvalidSequence(pArg);
   // this is an internal transition
    }
}

void
DownloadDoneState::evIdle ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oNotActiveState,pArg);
}

void
DownloadDoneState::evInvalidAddr ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.sendErr_InvalidAddress(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
DownloadDoneState::evInvalidFormat ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.sendErr_InvalidFormat(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
DownloadDoneState::evInvalidLength ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.sendErr_InvalidLength(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
DownloadDoneState::evRequestDownload ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.sendErr_AlreadyRequested(pArg);
   // this is an internal transition
}

void
DownloadDoneState::evRequestUpload ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.sendErr_InvalidSequence(pArg);
   // this is an internal transition
}

void
DownloadDoneState::evSessionChange ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.postprocessDownload(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
DownloadDoneState::evTimeout ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oNotActiveState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: DownloadingDataState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

DownloadingDataState::DownloadingDataState ( void )
{}

void
DownloadingDataState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.downloadData(pArg);
}

void
DownloadingDataState::evDataTransferDone ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.sendDownloadTransferDataResponse(pArg);
   b.setState(b.oDownloadDataTransferState,pArg);
}

void
DownloadingDataState::evDataTransferExit ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.isCrcOk(pArg) )
   {
        // transition Actions
        s.saveDataset(pArg);
        s.postprocessDownload(pArg);
        // this is an internal transition
    }
    else
    {
   // transition Actions
   s.sendErr_TransExitInvalidData(pArg);
   b.setState(b.oNotActiveState,pArg);
    }
}

void
DownloadingDataState::evDataTransferExitReady ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.sendTransExitResponse(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
DownloadingDataState::evIdle ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oNotActiveState,pArg);
}

void
DownloadingDataState::evInvalidAddr ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.sendErr_InvalidAddress(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
DownloadingDataState::evInvalidFormat ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.sendErr_InvalidFormat(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
DownloadingDataState::evInvalidLength ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.sendErr_InvalidLength(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
DownloadingDataState::evRequestDownload ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.sendErr_AlreadyRequested(pArg);
   // this is an internal transition
}

void
DownloadingDataState::evRequestUpload ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.sendErr_InvalidSequence(pArg);
   // this is an internal transition
}

void
DownloadingDataState::evSessionChange ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.postprocessDownload(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
DownloadingDataState::evTimeout ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oNotActiveState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: NotActiveState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

NotActiveState::NotActiveState ( void )
{}

void
NotActiveState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.reset(pArg);
}

void
NotActiveState::evDataTransferExit ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.sendErr_InvalidSequence(pArg);
   // this is an internal transition
}

void
NotActiveState::evDataTransferRx ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.sendErr_InvalidSequence(pArg);
   // this is an internal transition
}

void
NotActiveState::evIdle ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oNotActiveState,pArg);
}

void
NotActiveState::evInvalidAddr ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.sendErr_InvalidAddress(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
NotActiveState::evInvalidFormat ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.sendErr_InvalidFormat(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
NotActiveState::evInvalidLength ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.sendErr_InvalidLength(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
NotActiveState::evRequestDownload ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.validateDownloadRequest(pArg);
   // this is an internal transition
}

void
NotActiveState::evRequestDownloadReady ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.sendReqDownloadResponse(pArg);
   b.setState(b.oDownloadActiveState,pArg);
}

void
NotActiveState::evRequestDownloadValid ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   if ( s.areDownloadConditionsOk(pArg) )
   {
        // transition Actions
        s.prepareDownload(pArg);
        // this is an internal transition
    }
    else
    {
   // transition Actions
   s.sendErr_InvalidSequence(pArg);
   // this is an internal transition
    }
}

void
NotActiveState::evRequestUpload ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.validateUploadRequest(pArg);
   // this is an internal transition
}

void
NotActiveState::evRequestUploadValid ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.areUploadConditionsOk(pArg) )
   {
        // transition Actions
        s.prepareUpload(pArg);
        s.sendReqUploadResponse(pArg);
        b.setState(b.oUploadActiveState,pArg);
    }
    else
    {
   // transition Actions
   s.sendErr_InvalidSequence(pArg);
   // this is an internal transition
    }
}

void
NotActiveState::evTimeout ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oNotActiveState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: ToplevelDataUpDownloadState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

ToplevelDataUpDownloadState::ToplevelDataUpDownloadState ( void )
{}

void
ToplevelDataUpDownloadState::evIdle ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oNotActiveState,pArg);
}

void
ToplevelDataUpDownloadState::evInvalidAddr ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.sendErr_InvalidAddress(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
ToplevelDataUpDownloadState::evInvalidFormat ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.sendErr_InvalidFormat(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
ToplevelDataUpDownloadState::evInvalidLength ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.sendErr_InvalidLength(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
ToplevelDataUpDownloadState::evTimeout ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oNotActiveState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: UploadActiveState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

UploadActiveState::UploadActiveState ( void )
{}

void
UploadActiveState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.setUploadActivated(pArg);
}

void
UploadActiveState::evIdle ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oNotActiveState,pArg);
}

void
UploadActiveState::evInvalidAddr ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.sendErr_InvalidAddress(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
UploadActiveState::evInvalidFormat ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.sendErr_InvalidFormat(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
UploadActiveState::evInvalidLength ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.sendErr_InvalidLength(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
UploadActiveState::evRequestDownload ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.sendErr_InvalidSequence(pArg);
   // this is an internal transition
}

void
UploadActiveState::evRequestUpload ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.sendErr_AlreadyRequested(pArg);
   // this is an internal transition
}

void
UploadActiveState::evSessionChange ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.postprocessUpload(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
UploadActiveState::evTimeout ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oNotActiveState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: UploadDataTransferState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

UploadDataTransferState::UploadDataTransferState ( void )
{}

void
UploadDataTransferState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.checkForCompletion(pArg);
}

void
UploadDataTransferState::evDataTransferComplete ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oUploadDoneState,pArg);
}

void
UploadDataTransferState::evDataTransferExit ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.postprocessUpload(pArg);
   s.sendTransExitResponse(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
UploadDataTransferState::evDataTransferRx ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.isRetransmission(pArg) )
   {
        // transition Actions
        s.retransmitTransferDataResponse(pArg);
        // this is an internal transition
    }
    else
    {
   // transition Actions
   s.uploadData(pArg);
   s.sendUploadTransferDataResponse(pArg);
   b.setState(b.oUploadDataTransferState,pArg);
    }
}

void
UploadDataTransferState::evIdle ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oNotActiveState,pArg);
}

void
UploadDataTransferState::evInvalidAddr ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.sendErr_InvalidAddress(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
UploadDataTransferState::evInvalidFormat ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.sendErr_InvalidFormat(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
UploadDataTransferState::evInvalidLength ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.sendErr_InvalidLength(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
UploadDataTransferState::evRequestDownload ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.sendErr_InvalidSequence(pArg);
   // this is an internal transition
}

void
UploadDataTransferState::evRequestUpload ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.sendErr_AlreadyRequested(pArg);
   // this is an internal transition
}

void
UploadDataTransferState::evSessionChange ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.postprocessUpload(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
UploadDataTransferState::evTimeout ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oNotActiveState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: UploadDoneState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

UploadDoneState::UploadDoneState ( void )
{}

void
UploadDoneState::evDataTransferExit ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.postprocessUpload(pArg);
   s.sendTransExitResponse(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
UploadDoneState::evDataTransferRx ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   if ( s.isRetransmission(pArg) )
   {
        // transition Actions
        s.retransmitTransferDataResponse(pArg);
        // this is an internal transition
    }
    else
    {
   // transition Actions
   s.sendErr_InvalidSequence(pArg);
   // this is an internal transition
    }
}

void
UploadDoneState::evIdle ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oNotActiveState,pArg);
}

void
UploadDoneState::evInvalidAddr ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.sendErr_InvalidAddress(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
UploadDoneState::evInvalidFormat ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.sendErr_InvalidFormat(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
UploadDoneState::evInvalidLength ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.sendErr_InvalidLength(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
UploadDoneState::evRequestDownload ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.sendErr_InvalidSequence(pArg);
   // this is an internal transition
}

void
UploadDoneState::evRequestUpload ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.sendErr_AlreadyRequested(pArg);
   // this is an internal transition
}

void
UploadDoneState::evSessionChange ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.postprocessUpload(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
UploadDoneState::evTimeout ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oNotActiveState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
//
// This is the finite state machine class implementation
//
///////////////////////////////////////////////////////////////////////////////

Fsm::Fsm ( void )
    : mpBehaviour(0),
      mpBody(0)
{
}

Fsm::Fsm ( FsmBehaviour* server )
    : mpBehaviour(server),
      mpBody(0)
{}

Fsm::~Fsm ( void )
{
    if ( mpBody )
    {
        delete mpBody;
        mpBody = 0;
    }
    mpBehaviour = 0;
}

bool
Fsm::createFSM ( Fsm** ppFSM, FsmBehaviour* behaviour )
{
   bool retCode = false;

   if ( ppFSM && behaviour )
   {
      (*ppFSM) = new Fsm(behaviour);
      if ( (*ppFSM) )
      {
         if ( !((*ppFSM)->init()) )
         {
            delete (*ppFSM);
            (*ppFSM) = 0;
         }
         else
         {
            retCode = true;
         }
      }
   }

   return retCode;
}

bool
Fsm::init ( void )
{
   bool retCode = false;
   
   mpBody = new FsmBody();
   
   if ( mpBody )
   {
      // connect the body with its frontend
      mpBody->connect(this);
      if ( mpBody->init() )
      {
          retCode = true;
      }
   }
   
   return retCode;
}

const char*
Fsm::getStateName (void) const
{
    return ( mpBody ) ? mpBody->getStateName() : 0;
}

void 
Fsm::acceptEvent ( FsmEvent event, void* pArg )
{
    if ( mpBody )
    {
        // forward the event to the FSM body (handle-body pattern)
        mpBody->acceptEvent(event,pArg);
    }
}
///////////////////////////////////////////////////////////////////////////////
//
// This is the finite state machine class implementation
//
///////////////////////////////////////////////////////////////////////////////

FsmBody::FsmBody ( void ) :
      mpFrontend(0),
      mpState(0),
      mBusyFlag(false),
      mQueueHead(0),
      mQueueTail(0),
      mQueueSize(0)
{
    (void) ::memset(mEventQueue,0,sizeof(FsmEvent)*MAX_TRIGGER_EVENTS);
    (void) ::memset(mParamQueue,0,sizeof(void*)*MAX_TRIGGER_EVENTS);
}

bool
FsmBody::init ( void )
{
    oDownloadActiveState.initSuperState(&oToplevelDataUpDownloadState, &oDownloadDataTransferState, false);
    oDownloadDataTransferState.initState(&oDownloadActiveState);
    oDownloadDoneState.initState(&oDownloadActiveState);
    oDownloadingDataState.initState(&oDownloadActiveState);
    oNotActiveState.initState(&oToplevelDataUpDownloadState);
    oToplevelDataUpDownloadState.initSuperState(0, &oNotActiveState, false);
    oUploadActiveState.initSuperState(&oToplevelDataUpDownloadState, &oUploadDataTransferState, false);
    oUploadDataTransferState.initState(&oUploadActiveState);
    oUploadDoneState.initState(&oUploadActiveState);

    setState(oToplevelDataUpDownloadState,0);
    
    return true;
}

void
FsmBody::connect ( Fsm* frontend )
{
    mpFrontend = frontend;
}

const char*
FsmBody::getStateName ( void ) const
{
    return ( mpState ) ? mpState->getStateName() : 0;
}

bool
FsmBody::addEvent ( const FsmEvent& event, void* param )
{
    if ( mQueueSize < MAX_TRIGGER_EVENTS )
    {
        mQueueSize++;
        mEventQueue[mQueueTail] = event;
        mParamQueue[mQueueTail] = param;
        mQueueTail++;
        if ( mQueueTail == MAX_TRIGGER_EVENTS )
        {
            mQueueTail = 0;
        }
        return true;
    }
    return false;
}

bool
FsmBody::getEvent ( FsmEvent& event, void** param )
{
    if ( !mQueueSize || !param )
    {
        return false;
    }
    mQueueSize--;
    event  = mEventQueue[mQueueHead];
    *param = mParamQueue[mQueueHead];
    mQueueHead++;
    if ( mQueueHead == MAX_TRIGGER_EVENTS )
    {
        mQueueHead = 0;
    }
    return true;
}

bool
FsmBody::isQueueEmpty ( void ) const
{
    return ( mQueueSize ) ? false : true;
}

void 
FsmBody::acceptEvent ( FsmEvent event, void* pArg )
{
    (void) addEvent(event,pArg);

    if ( mBusyFlag )
    {
        return;
    }

    mBusyFlag = true;
    while ( !isQueueEmpty() )
    {
        FsmEvent nextEvent = evUnknown;
        void*    nextArg   = 0;
        if ( !getEvent(nextEvent,&nextArg) )
        {
            break;
        }

        switch (nextEvent)
        {
        case evDataTransferComplete:
            if ( mpState ) mpState->evDataTransferComplete(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evDataTransferDone:
            if ( mpState ) mpState->evDataTransferDone(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evDataTransferExit:
            if ( mpState ) mpState->evDataTransferExit(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evDataTransferExitReady:
            if ( mpState ) mpState->evDataTransferExitReady(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evDataTransferRx:
            if ( mpState ) mpState->evDataTransferRx(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evDataTransferValidated:
            if ( mpState ) mpState->evDataTransferValidated(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evIdle:
            if ( mpState ) mpState->evIdle(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evInvalidAddr:
            if ( mpState ) mpState->evInvalidAddr(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evInvalidFormat:
            if ( mpState ) mpState->evInvalidFormat(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evInvalidLength:
            if ( mpState ) mpState->evInvalidLength(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evRequestDownload:
            if ( mpState ) mpState->evRequestDownload(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evRequestDownloadReady:
            if ( mpState ) mpState->evRequestDownloadReady(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evRequestDownloadValid:
            if ( mpState ) mpState->evRequestDownloadValid(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evRequestUpload:
            if ( mpState ) mpState->evRequestUpload(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evRequestUploadValid:
            if ( mpState ) mpState->evRequestUploadValid(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evSessionChange:
            if ( mpState ) mpState->evSessionChange(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evTimeout:
            if ( mpState ) mpState->evTimeout(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        default:
            //... unknown event ...
            break;
        } //lint !e788: not all items used within defaulted switch
    }
    mBusyFlag = false;
}

void 
FsmBody::setState ( FsmState& state, void* pArg )
{
    if ( mpFrontend )
    {
        mpState = const_cast<FsmState*>(state.propagate(*this,*(mpFrontend->mpBehaviour),pArg));
    }
}

void 
FsmBody::setState ( FsmState* pState )
{
    mpState = pState;
}

const FsmState*
FsmBody::getState ( void ) const
{
    return mpState;
}

///////////////////////////////////////////////////////////////////////////////
//
// Functions
//
///////////////////////////////////////////////////////////////////////////////

const char* getEventName ( FsmEvent event )
{
   static const char* eventNames[evCount] = {
      "evUnknown",
      "evDataTransferComplete",
      "evDataTransferDone",
      "evDataTransferExit",
      "evDataTransferExitReady",
      "evDataTransferRx",
      "evDataTransferValidated",
      "evIdle",
      "evInvalidAddr",
      "evInvalidFormat",
      "evInvalidLength",
      "evRequestDownload",
      "evRequestDownloadReady",
      "evRequestDownloadValid",
      "evRequestUpload",
      "evRequestUploadValid",
      "evSessionChange",
      "evTimeout",
   };

   return eventNames[event];
}


} // namespace
