///////////////////////////////////////////////////////////////////////////////
//
// File: dia_BluetoothModeFSM.h
//
// Generated by SMC 4.1.0 (C++ State Pattern Code Generator)
//
///////////////////////////////////////////////////////////////////////////////

#ifndef __INCLUDED_DIA_BLUETOOTHMODEFSM__
#define __INCLUDED_DIA_BLUETOOTHMODEFSM__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

namespace dia_BluetoothModeFSM
{

///////////////////////////////////////////////////////////////////////////////
//
// Forward Declarations
//
///////////////////////////////////////////////////////////////////////////////

class FsmBody;

///////////////////////////////////////////////////////////////////////////////
//
// Enums and typedefs
//
///////////////////////////////////////////////////////////////////////////////

//! enumeration of FSM events. First and last item added by SMC
enum FsmEvent
{
    evUnknown = 0,
    evError,
    evTimeout,
    evNormalMode,
    evStartSetMode,
    evTestModeLoopback,
    evTestModeLoopbackLocal,
    evTestModeI2S,
    evTestToneStopped,
    evLoopbackStopped,
    evProdModeActive,
    evDUTModeActive,
    evLoopbackStarted,
    evTestToneStarted,
    evModeRequestResult,
    evModeStatus,
    evTestToneRequestResult,
    evTestToneStatus,
    evLoopbackRequestResult,
    evCount
};

///////////////////////////////////////////////////////////////////////////////
//
// Class: FsmBehaviour
//
// This is the base class for the FSM server (provides implementation for all
// actions and guards)
//
///////////////////////////////////////////////////////////////////////////////

class FsmBehaviour
{
    friend class BTModeControlState;
    friend class BTModeToplevelState;
    friend class IdleState;
    friend class RequestI2SModeState;
    friend class RequestLocalLoopbackModeState;
    friend class RequestLoopbackModeState;
    friend class RequestNormalModeState;
    friend class SetDUTModeState;
    friend class SetNormalModeState;
    friend class SetProductionModeState;
    friend class StartI2STestToneState;
    friend class StartLoopbackState;
    friend class StopI2STestToneState;
    friend class StopLoopbackState;
    friend class FsmBody;

public:
    virtual ~FsmBehaviour ( void ) {}

protected:
    // FSM actions
    virtual void vSendNegativeResponse ( void* pArg ) = 0;
    virtual void vSetRequestedModeNormal ( void* pArg ) = 0;
    virtual void vSetRequestedModeProduction ( void* pArg ) = 0;
    virtual void vSetRequestedModeDUT ( void* pArg ) = 0;
    virtual void vSendPositiveResponse ( void* pArg ) = 0;
    virtual void vSendNormalModeRequest ( void* pArg ) = 0;
    virtual void vSendUpRegTestMode ( void* pArg ) = 0;
    virtual void vSendRelRegTestMode ( void* pArg ) = 0;
    virtual void vSendProductionModeRequest ( void* pArg ) = 0;
    virtual void vSendDUTModeRequest ( void* pArg ) = 0;
    virtual void vSendStartTestToneRequest ( void* pArg ) = 0;
    virtual void vSendUpRegTestTone ( void* pArg ) = 0;
    virtual void vSendRelRegTestTone ( void* pArg ) = 0;
    virtual void vSendStopTestToneRequest ( void* pArg ) = 0;
    virtual void vSendStartLoopbackRequest ( void* pArg ) = 0;
    virtual void vSendStopLoopbackRequest ( void* pArg ) = 0;

    // FSM guards
    virtual bool bIsI2STestToneActive ( void* pArg ) = 0;
    virtual bool bIsLoopbackActive ( void* pArg ) = 0;
    virtual bool bIsProductionModeRequested ( void* pArg ) = 0;
    virtual bool bIsDUTModeRequested ( void* pArg ) = 0;
    virtual bool bIsNormalModeRequested ( void* pArg ) = 0;
    virtual bool bIsProductionModeActivated ( void* pArg ) = 0;
    virtual bool bIsDUTModeActivated ( void* pArg ) = 0;
    virtual bool bIsNormalModeActivated ( void* pArg ) = 0;
    virtual bool bIsModeReqAccepted ( void* pArg ) = 0;
    virtual bool bIsRequestedModeReached ( void* pArg ) = 0;
    virtual bool bIsTestToneReqAccepted ( void* pArg ) = 0;
    virtual bool bIsTestToneReqExecuted ( void* pArg ) = 0;
    virtual bool bIsLoopbackReqExecuted ( void* pArg ) = 0;
};

///////////////////////////////////////////////////////////////////////////////
//
// Class: Fsm
//
// This is the finite state machine class 'dia_BluetoothModeFSM'.
//
///////////////////////////////////////////////////////////////////////////////

class Fsm
{
    //! we grant the body class access to our protected section
    friend class FsmBody;

public:
    //! class constructor
    Fsm ( FsmBehaviour* behaviour );
    //! class destructor
    virtual ~Fsm ( void );

    //! setup and initialize the state machine
    void init ( void );

    //! this method is used to stimulate the FSM with events
    void acceptEvent ( FsmEvent event, void* pArg );

    //! return the name of the current state
    const char* getStateName ( void ) const;

protected:
    //! protected default constructor to avoid usage
    Fsm ( void );
    //! copy constructor without implementation
    Fsm ( const Fsm& obj );
    //! assignment operator without implementation
    Fsm& operator = ( const Fsm& obj );

    //! pointer to the server that provides the implementation for the actions and guards
    FsmBehaviour* mpBehaviour;
    //! body of the FSM implementation
    FsmBody* mpBody;
};


} // namespace

#endif
