///////////////////////////////////////////////////////////////////////////////
//
// File: dia_BluetoothConnectionFSM.h
//
// Generated by SMC 4.1.0 (C++ State Pattern Code Generator)
//
///////////////////////////////////////////////////////////////////////////////

#ifndef __INCLUDED_DIA_BLUETOOTHCONNECTIONFSM__
#define __INCLUDED_DIA_BLUETOOTHCONNECTIONFSM__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

namespace dia_BluetoothConnectionFSM
{

///////////////////////////////////////////////////////////////////////////////
//
// Forward Declarations
//
///////////////////////////////////////////////////////////////////////////////

class FsmBody;

///////////////////////////////////////////////////////////////////////////////
//
// Enums and typedefs
//
///////////////////////////////////////////////////////////////////////////////

//! enumeration of FSM events. First and last item added by SMC
enum FsmEvent
{
    evUnknown = 0,
    evTimeout,
    evError,
    evModuleReset,
    evConnect,
    evMsgSent,
    evDisconnect,
    evConnectionResult,
    evDisconnectionResult,
    evCount
};

///////////////////////////////////////////////////////////////////////////////
//
// Class: FsmBehaviour
//
// This is the base class for the FSM server (provides implementation for all
// actions and guards)
//
///////////////////////////////////////////////////////////////////////////////

class FsmBehaviour
{
    friend class ConnectedState;
    friend class ConnectingState;
    friend class DisconnectedState;
    friend class DisconnectingState;
    friend class IdleState;
    friend class ToplevelState;
    friend class FsmBody;

public:
    virtual ~FsmBehaviour ( void ) {}

protected:
    // FSM actions
    virtual void vFsmSendNegativeResponse ( intptr_t pArg ) = 0;
    virtual void vFsmHandleError ( intptr_t pArg ) = 0;
    virtual void vFsmSetStateNotConnected ( intptr_t pArg ) = 0;
    virtual void vFsmSendConnectRequest ( intptr_t pArg ) = 0;
    virtual void vFsmSendPositiveResponse ( intptr_t pArg ) = 0;
    virtual void vFsmSetStateConnected ( intptr_t pArg ) = 0;
    virtual void vFsmSendDisconnectRequest ( intptr_t pArg ) = 0;

    // FSM guards
    virtual bool bFsmWasMsgSentOK ( intptr_t pArg ) = 0;
    virtual bool bFsmIsConnected ( intptr_t pArg ) = 0;
    virtual bool bFsmIsSameAddress ( intptr_t pArg ) = 0;
    virtual bool bFsmIsDisconnected ( intptr_t pArg ) = 0;
};

///////////////////////////////////////////////////////////////////////////////
//
// Class: Fsm
//
// This is the finite state machine class 'dia_BluetoothConnectionFSM'.
//
///////////////////////////////////////////////////////////////////////////////

class Fsm
{
    //! we grant the body class access to our protected section
    friend class FsmBody;

public:
    //! class constructor
    Fsm ( FsmBehaviour* behaviour );
    //! class destructor
    virtual ~Fsm ( void );

    //! setup and initialize the state machine
    void init ( void );

    //! this method is used to stimulate the FSM with events
    void acceptEvent ( FsmEvent event, intptr_t pArg );

    //! return the name of the current state
    const char* getStateName ( void ) const;

protected:
    //! protected default constructor to avoid usage
    Fsm ( void );
    //! copy constructor without implementation
    Fsm ( const Fsm& obj );
    //! assignment operator without implementation
    Fsm& operator = ( const Fsm& obj );

    //! pointer to the server that provides the implementation for the actions and guards
    FsmBehaviour* mpBehaviour;
    //! body of the FSM implementation
    FsmBody* mpBody;
};


} // namespace

#endif
