///////////////////////////////////////////////////////////////////////////////
//
// File: dia_AudioSourceSetFSM.h
//
// Generated by SMC 4.4.1 (C++ State Pattern Code Generator)
//
///////////////////////////////////////////////////////////////////////////////

#ifndef __INCLUDED_DIA_AUDIOSOURCESETFSM__
#define __INCLUDED_DIA_AUDIOSOURCESETFSM__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

namespace dia_AudioSourceSetFSM
{

///////////////////////////////////////////////////////////////////////////////
//
// Forward Declarations
//
///////////////////////////////////////////////////////////////////////////////

class FsmBody;

///////////////////////////////////////////////////////////////////////////////
//
// Enums and typedefs
//
///////////////////////////////////////////////////////////////////////////////

//! enumeration of FSM events. First and last item added by SMC
enum FsmEvent
{
   evUnknown = 0,
   evAudioDiagModeUpdate,
   evCheckedAudioDiagMode,
   evConnectionUpdate,
   evError,
   evGetActiveSource,
   evIdle,
   evReturnControl,
   evSetSource,
   evSinkUpdate,
   evSourceUpdate,
   evTimeout,
   evCount
};

///////////////////////////////////////////////////////////////////////////////
//
// Functions
//
///////////////////////////////////////////////////////////////////////////////

const char* getEventName ( FsmEvent event );

///////////////////////////////////////////////////////////////////////////////
//
// Class: FsmBehaviour
//
// This is the base class for the FSM server (provides implementation for all
// actions and guards)
//
///////////////////////////////////////////////////////////////////////////////

class FsmBehaviour
{ 
   friend class ActivateAudioDiagModeState;
   friend class EstablishConnectionState;
   friend class GettingActiveSourceState;
   friend class GettingConnectionsState;
   friend class GettingSinkListState;
   friend class GettingSourceListState;
   friend class IdleState;
   friend class SettingSourceState;
   friend class ToplevelState;
   friend class FsmBody;

public:
   virtual ~FsmBehaviour ( void ) {}

protected:
   // FSM actions
   virtual void vFsmCheckForAudioDiagMode ( void* pArg ) = 0;
   virtual void vFsmFinalize ( void* pArg ) = 0;
   virtual void vFsmInitialize ( void* pArg ) = 0;
   virtual void vFsmNoActiveSourceFound ( void* pArg ) = 0;
   virtual void vFsmRequestAudioDiagMode ( void* pArg ) = 0;
   virtual void vFsmRequestAudioNormalMode ( void* pArg ) = 0;
   virtual void vFsmRequestConnection ( void* pArg ) = 0;
   virtual void vFsmRequestListOfConnections ( void* pArg ) = 0;
   virtual void vFsmRequestListOfSinks ( void* pArg ) = 0;
   virtual void vFsmRequestListOfSources ( void* pArg ) = 0;
   virtual void vFsmReset ( void* pArg ) = 0;
   virtual void vFsmSendGetActiveSourceResponse ( void* pArg ) = 0;
   virtual void vFsmSendResponse ( void* pArg ) = 0;
   virtual void vFsmSetError_ConnectionFailed ( void* pArg ) = 0;
   virtual void vFsmSetError_SinkNotSupported ( void* pArg ) = 0;
   virtual void vFsmSetError_SourceNotSupported ( void* pArg ) = 0;

   // FSM guards
   virtual bool isActiveConnectionAvailable ( void* pArg ) = 0;
   virtual bool isAudioDiagModeActive ( void* pArg ) = 0;
   virtual bool isConnected ( void* pArg ) = 0;
   virtual bool isConnectionActive ( void* pArg ) = 0;
   virtual bool isConnectionFound ( void* pArg ) = 0;
   virtual bool isSinkSupported ( void* pArg ) = 0;
   virtual bool isSourceSupported ( void* pArg ) = 0;
};

///////////////////////////////////////////////////////////////////////////////
//
// Class: Fsm
//
// This is the finite state machine class 'dia_AudioSourceSetFSM'.
//
///////////////////////////////////////////////////////////////////////////////

class Fsm
{
    //! we grant the body class access to our protected section
    friend class FsmBody;

public:
    //! factory method used to create an FAM object in two stages
    static bool createFSM ( Fsm** ppFSM, FsmBehaviour* behaviour );
    //! class destructor
    virtual ~Fsm ( void );

    //! this method is used to stimulate the FSM with events
    virtual void acceptEvent ( FsmEvent event, void* pArg );

    //! return the name of the current state
    virtual const char* getStateName ( void ) const;

protected:
    //! protected default constructor to avoid usage
    Fsm ( void );
    //! class constructor
    Fsm ( FsmBehaviour* behaviour );
    //! copy constructor without implementation
    Fsm ( const Fsm& obj );
    //! assignment operator without implementation
    Fsm& operator = ( const Fsm& obj );

    //! setup and initialize the state machine
    virtual bool init ( void );

protected:
    //! pointer to the server that provides the implementation for the actions and guards
    FsmBehaviour* mpBehaviour;
    //! body of the FSM implementation
    FsmBody* mpBody;
};


} // namespace

#endif
