///////////////////////////////////////////////////////////////////////////////
//
// File: dia_AudioSourceSetFSM.cpp
//
// Generated by SMC 4.4.1 (C++ State Pattern Code Generator)
//
///////////////////////////////////////////////////////////////////////////////

#include <string.h>

#ifndef __INCLUDED_DIA_AUDIOSOURCESETFSM__
#include "dia_AudioSourceSetFSM.h"
#endif

namespace dia_AudioSourceSetFSM
{

const unsigned int MAX_TRIGGER_EVENTS = 20;

///////////////////////////////////////////////////////////////////////////////
//
// Forward Declarations
//
///////////////////////////////////////////////////////////////////////////////

class Fsm;
class FsmSuperState;

///////////////////////////////////////////////////////////////////////////////
//
// Abstract base class for all FSM states.
//
///////////////////////////////////////////////////////////////////////////////

class FsmState
{
public:
   //! name of the FSM's state
   virtual const char* getStateName ( void ) const = 0;

   //! resetting state internals
   virtual void reset ( void ) {}

   // event functions 
   virtual void evAudioDiagModeUpdate ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evCheckedAudioDiagMode ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evConnectionUpdate ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evGetActiveSource ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReturnControl ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSetSource ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSinkUpdate ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSourceUpdate ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! default implementation for the Entry action
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! default implementation for the Exit action
   virtual void exit  ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! method used to propagate the event to the superstate
   virtual const FsmState* propagate ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! return the parent state
   virtual FsmSuperState* getParent ( void );

   //! assign the body object
   void initState ( FsmSuperState* pParent );

protected:
   //! default constructor is protected to prevent usage of this constructor
   FsmState ( void );
   //! class destructor
   virtual ~FsmState ( void );

   //! pointer to the superstate
   FsmSuperState* mpParent;
};

///////////////////////////////////////////////////////////////////////////////
//
// Abstract base class for all FSM superstates.
//
///////////////////////////////////////////////////////////////////////////////

class FsmSuperState
   : public FsmState
{
public:
   //! set a savepoint for the history
   virtual void savepoint ( FsmBody& b );
   //! default action
   virtual void defaultAction ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! resetting state internals
   virtual void reset ( void ) { _history = 0; }

   //! method used to propagate the event to the superstate
   virtual const FsmState* propagate ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! assign the body object
   void initSuperState ( FsmSuperState* pParent, FsmState* defState, bool histEnable=false );

protected:
   //! default constructor is protected to prevent usage of this constructor
   FsmSuperState ( void );

   //! pointer to the default substate
   FsmState* _default;
   //! pointer to the history substate
   const FsmState* _history;
   //! flag that indicates if history is enabled or not
   bool _historyEnable;
};

///////////////////////////////////////////////////////////////////////////////
// 
// Class: ActivateAudioDiagModeState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class ActivateAudioDiagModeState
   : public FsmState
{
public:
   //! default constructor
   ActivateAudioDiagModeState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evAudioDiagModeUpdate ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evCheckedAudioDiagMode ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReturnControl ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* ActivateAudioDiagModeState::mStateName = "ActivateAudioDiagMode";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: EstablishConnectionState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class EstablishConnectionState
   : public FsmState
{
public:
   //! default constructor
   EstablishConnectionState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evConnectionUpdate ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReturnControl ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* EstablishConnectionState::mStateName = "EstablishConnection";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: GettingActiveSourceState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class GettingActiveSourceState
   : public FsmState
{
public:
   //! default constructor
   GettingActiveSourceState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evConnectionUpdate ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReturnControl ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSourceUpdate ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! exit actions
   virtual void exit ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* GettingActiveSourceState::mStateName = "GettingActiveSource";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: GettingConnectionsState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class GettingConnectionsState
   : public FsmState
{
public:
   //! default constructor
   GettingConnectionsState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evConnectionUpdate ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReturnControl ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* GettingConnectionsState::mStateName = "GettingConnections";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: GettingSinkListState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class GettingSinkListState
   : public FsmState
{
public:
   //! default constructor
   GettingSinkListState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReturnControl ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSinkUpdate ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* GettingSinkListState::mStateName = "GettingSinkList";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: GettingSourceListState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class GettingSourceListState
   : public FsmState
{
public:
   //! default constructor
   GettingSourceListState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReturnControl ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSourceUpdate ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* GettingSourceListState::mStateName = "GettingSourceList";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: IdleState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class IdleState
   : public FsmState
{
public:
   //! default constructor
   IdleState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evGetActiveSource ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReturnControl ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSetSource ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* IdleState::mStateName = "Idle";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: SettingSourceState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class SettingSourceState
   : public FsmSuperState
{
public:
   //! default constructor
   SettingSourceState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReturnControl ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! exit actions
   virtual void exit ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* SettingSourceState::mStateName = "SettingSource";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: ToplevelState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class ToplevelState
   : public FsmSuperState
{
public:
   //! default constructor
   ToplevelState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReturnControl ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* ToplevelState::mStateName = "Toplevel";

///////////////////////////////////////////////////////////////////////////////
//
// Class: FsmBody
//
// This is the finite state machine's body class 'FsmBody'.
//
///////////////////////////////////////////////////////////////////////////////

class FsmBody
{
    struct FsmDeferredEvent
    {
          FsmDeferredEvent() : mEvent(evUnknown), mArg(0) {}
          FsmEvent mEvent;
          void*    mArg;
    };

public:
    //! class constructor
    FsmBody ( void );

    //! connect the FSM body with its frontend
    void connect ( Fsm* frontend );

    //! initialize the FSM: set initial state and execute initial actions
    bool init ( void );

    //! this method is used to stimulate the FSM with events
    void acceptEvent ( FsmEvent event, void* pArg );

    //! return the name of the active state
    const char* getStateName ( void ) const;

    //! push trigger events to the event queue
    bool addEvent ( const FsmEvent& event, void* arg  );
    //! get event from the event queue
    bool getEvent ( FsmEvent& event, void** arg  );
    //! get event from the event queue
    bool isQueueEmpty ( void ) const;

    // set the FSM's internal state and propagate to default or history substate
    void setState ( FsmState& state, void* pArg );
    // set the FSM's internal state (no propagation
    void setState ( FsmState* pState );
    // return the active state object
    const FsmState* getState ( void ) const;

    //! static state objects
    ActivateAudioDiagModeState oActivateAudioDiagModeState;
    EstablishConnectionState oEstablishConnectionState;
    GettingActiveSourceState oGettingActiveSourceState;
    GettingConnectionsState oGettingConnectionsState;
    GettingSinkListState oGettingSinkListState;
    GettingSourceListState oGettingSourceListState;
    IdleState oIdleState;
    SettingSourceState oSettingSourceState;
    ToplevelState oToplevelState;

    //! frontend for this body
    Fsm* mpFrontend;
    //! link to the active state object
    FsmState* mpState;

    //! busy indicator flag
    bool mBusyFlag;

    //! queue of trigger events
    FsmEvent mEventQueue[MAX_TRIGGER_EVENTS];
    //! queue of arguments for trigger events
    void*    mParamQueue[MAX_TRIGGER_EVENTS];
    //! index of the queue's front element
    unsigned int mQueueHead;
    //! index of the queue's back element
    unsigned int mQueueTail;
    //! number of queued events
    unsigned int mQueueSize;
};

///////////////////////////////////////////////////////////////////////////////
//
// Default implementation for all events.
//
///////////////////////////////////////////////////////////////////////////////

void
FsmState::evAudioDiagModeUpdate ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evAudioDiagModeUpdate *** 
}

void
FsmState::evCheckedAudioDiagMode ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evCheckedAudioDiagMode *** 
}

void
FsmState::evConnectionUpdate ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evConnectionUpdate *** 
}

void
FsmState::evError ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evError *** 
}

void
FsmState::evGetActiveSource ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evGetActiveSource *** 
}

void
FsmState::evIdle ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evIdle *** 
}

void
FsmState::evReturnControl ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evReturnControl *** 
}

void
FsmState::evSetSource ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evSetSource *** 
}

void
FsmState::evSinkUpdate ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evSinkUpdate *** 
}

void
FsmState::evSourceUpdate ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evSourceUpdate *** 
}

void
FsmState::evTimeout ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evTimeout *** 
}

///////////////////////////////////////////////////////////////////////////////
//
// Abstract base class for all FSM states components.
//
///////////////////////////////////////////////////////////////////////////////

FsmState::FsmState ( void )
   : mpParent(0)
{}

FsmState::~FsmState ( void )
{
   // make lint happy
   mpParent = 0;
}

void
FsmState::initState ( FsmSuperState* pParent )
{
   mpParent = pParent;
}

void
FsmState::entry ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   //... empty as default ...
}

void
FsmState::exit ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   //... empty as default ...
}

const FsmState*
FsmState::propagate ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   b.setState(this);
   entry(b,s,pArg);
   return this;
}

FsmSuperState*
FsmState::getParent ( void )
{
   return (mpParent) ? mpParent : 0;
}

///////////////////////////////////////////////////////////////////////////////
//
// Abstract base class for all FSM superstates.
//
///////////////////////////////////////////////////////////////////////////////

FsmSuperState::FsmSuperState ( void )
   : _default(0),
     _history(0),
     _historyEnable(false)
{}

void
FsmSuperState::initSuperState ( FsmSuperState* pParent, FsmState* defState, bool histEnable )
{
   mpParent = pParent;
   _default = defState;
   _history = 0;
   _historyEnable = histEnable;
}

const FsmState*
FsmSuperState::propagate ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   const FsmState* pState = 0;

   // we have crossed a state boundary
   b.setState(this);
   // execute the entry actions for this superstate
   entry(b,s,pArg);
   
   if ( _history && _historyEnable )
   {
      pState = const_cast<FsmState*>(_history)->propagate(b,s,pArg);
   }
   else
   {
      defaultAction(b,s,pArg);
      if ( _default ) {
         pState = _default->propagate(b,s,pArg);
      }
   }
   
   return pState;
}

void
FsmSuperState::savepoint ( FsmBody& b )
{
   if ( _historyEnable )
   {
      _history = b.getState();
   }
}

void
FsmSuperState::defaultAction ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /*pArg*/ )
{
   //... empty as default ...
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: ActivateAudioDiagModeState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

ActivateAudioDiagModeState::ActivateAudioDiagModeState ( void )
{}

void
ActivateAudioDiagModeState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmCheckForAudioDiagMode(pArg);
}

void
ActivateAudioDiagModeState::evAudioDiagModeUpdate ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.isAudioDiagModeActive(pArg) )
   {
        b.setState(b.oSettingSourceState,pArg);
    }
}

void
ActivateAudioDiagModeState::evCheckedAudioDiagMode ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.isAudioDiagModeActive(pArg) )
   {
        b.setState(b.oSettingSourceState,pArg);
    }
    else
    {
   // transition Actions
   s.vFsmRequestAudioDiagMode(pArg);
   // this is an internal transition
    }
}

void
ActivateAudioDiagModeState::evError ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oIdleState,pArg);
}

void
ActivateAudioDiagModeState::evIdle ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oIdleState,pArg);
}

void
ActivateAudioDiagModeState::evReturnControl ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmRequestAudioNormalMode(pArg);
   b.setState(b.oIdleState,pArg);
}

void
ActivateAudioDiagModeState::evTimeout ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oIdleState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: EstablishConnectionState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

EstablishConnectionState::EstablishConnectionState ( void )
{}

void
EstablishConnectionState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmRequestConnection(pArg);
}

void
EstablishConnectionState::evConnectionUpdate ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.isConnectionFound(pArg) && s.isConnected(pArg) && s.isConnectionActive(pArg) )
   {
        b.oSettingSourceState.exit(b,s,pArg);
        // transition Actions
        s.vFsmSendResponse(pArg);
        b.setState(b.oIdleState,pArg);
    }
}

void
EstablishConnectionState::evError ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   b.oSettingSourceState.exit(b,s,pArg);
   // transition Actions
   s.vFsmSetError_ConnectionFailed(pArg);
   s.vFsmSendResponse(pArg);
   b.setState(b.oIdleState,pArg);
}

void
EstablishConnectionState::evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   b.oSettingSourceState.exit(b,s,pArg);
   // transition Actions
   s.vFsmSetError_ConnectionFailed(pArg);
   s.vFsmSendResponse(pArg);
   b.setState(b.oIdleState,pArg);
}

void
EstablishConnectionState::evReturnControl ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   b.oSettingSourceState.exit(b,s,pArg);
   // transition Actions
   s.vFsmSetError_ConnectionFailed(pArg);
   s.vFsmRequestAudioNormalMode(pArg);
   s.vFsmSendResponse(pArg);
   b.setState(b.oIdleState,pArg);
}

void
EstablishConnectionState::evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   b.oSettingSourceState.exit(b,s,pArg);
   // transition Actions
   s.vFsmSetError_ConnectionFailed(pArg);
   s.vFsmSendResponse(pArg);
   b.setState(b.oIdleState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: GettingActiveSourceState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

GettingActiveSourceState::GettingActiveSourceState ( void )
{}

void
GettingActiveSourceState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmInitialize(pArg);
   s.vFsmRequestListOfSources(pArg);
}

void
GettingActiveSourceState::exit ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmFinalize(pArg);
}

void
GettingActiveSourceState::evConnectionUpdate ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.isActiveConnectionAvailable(pArg) )
   {
        //... performing exit actions ...
        exit(b,s,pArg);
        // transition Actions
        s.vFsmSendGetActiveSourceResponse(pArg);
        b.setState(b.oIdleState,pArg);
    }
    else
    {
   //... performing exit actions ...
   exit(b,s,pArg);
   // transition Actions
   s.vFsmNoActiveSourceFound(pArg);
   s.vFsmSendGetActiveSourceResponse(pArg);
   b.setState(b.oIdleState,pArg);
    }
}

void
GettingActiveSourceState::evError ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   //... performing exit actions ...
   exit(b,s,pArg);
   b.setState(b.oIdleState,pArg);
}

void
GettingActiveSourceState::evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   //... performing exit actions ...
   exit(b,s,pArg);
   b.setState(b.oIdleState,pArg);
}

void
GettingActiveSourceState::evReturnControl ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   //... performing exit actions ...
   exit(b,s,pArg);
   // transition Actions
   s.vFsmRequestAudioNormalMode(pArg);
   b.setState(b.oIdleState,pArg);
}

void
GettingActiveSourceState::evSourceUpdate ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmRequestListOfConnections(pArg);
   // this is an internal transition
}

void
GettingActiveSourceState::evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   //... performing exit actions ...
   exit(b,s,pArg);
   b.setState(b.oIdleState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: GettingConnectionsState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

GettingConnectionsState::GettingConnectionsState ( void )
{}

void
GettingConnectionsState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmRequestListOfConnections(pArg);
}

void
GettingConnectionsState::evConnectionUpdate ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.isConnectionFound(pArg) && s.isConnectionActive(pArg) )
   {
        b.oSettingSourceState.exit(b,s,pArg);
        // transition Actions
        s.vFsmSendResponse(pArg);
        b.setState(b.oIdleState,pArg);
    }
    else
    {
   b.setState(b.oEstablishConnectionState,pArg);
    }
}

void
GettingConnectionsState::evError ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   b.oSettingSourceState.exit(b,s,pArg);
   b.setState(b.oIdleState,pArg);
}

void
GettingConnectionsState::evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   b.oSettingSourceState.exit(b,s,pArg);
   b.setState(b.oIdleState,pArg);
}

void
GettingConnectionsState::evReturnControl ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   b.oSettingSourceState.exit(b,s,pArg);
   // transition Actions
   s.vFsmRequestAudioNormalMode(pArg);
   b.setState(b.oIdleState,pArg);
}

void
GettingConnectionsState::evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   b.oSettingSourceState.exit(b,s,pArg);
   b.setState(b.oIdleState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: GettingSinkListState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

GettingSinkListState::GettingSinkListState ( void )
{}

void
GettingSinkListState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmRequestListOfSinks(pArg);
}

void
GettingSinkListState::evError ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   b.oSettingSourceState.exit(b,s,pArg);
   b.setState(b.oIdleState,pArg);
}

void
GettingSinkListState::evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   b.oSettingSourceState.exit(b,s,pArg);
   b.setState(b.oIdleState,pArg);
}

void
GettingSinkListState::evReturnControl ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   b.oSettingSourceState.exit(b,s,pArg);
   // transition Actions
   s.vFsmRequestAudioNormalMode(pArg);
   b.setState(b.oIdleState,pArg);
}

void
GettingSinkListState::evSinkUpdate ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.isSinkSupported(pArg) )
   {
        b.setState(b.oGettingConnectionsState,pArg);
    }
    else
    {
   b.oSettingSourceState.exit(b,s,pArg);
   // transition Actions
   s.vFsmSetError_SinkNotSupported(pArg);
   s.vFsmSendResponse(pArg);
   b.setState(b.oIdleState,pArg);
    }
}

void
GettingSinkListState::evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   b.oSettingSourceState.exit(b,s,pArg);
   b.setState(b.oIdleState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: GettingSourceListState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

GettingSourceListState::GettingSourceListState ( void )
{}

void
GettingSourceListState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmRequestListOfSources(pArg);
}

void
GettingSourceListState::evError ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   b.oSettingSourceState.exit(b,s,pArg);
   b.setState(b.oIdleState,pArg);
}

void
GettingSourceListState::evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   b.oSettingSourceState.exit(b,s,pArg);
   b.setState(b.oIdleState,pArg);
}

void
GettingSourceListState::evReturnControl ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   b.oSettingSourceState.exit(b,s,pArg);
   // transition Actions
   s.vFsmRequestAudioNormalMode(pArg);
   b.setState(b.oIdleState,pArg);
}

void
GettingSourceListState::evSourceUpdate ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.isSourceSupported(pArg) )
   {
        b.setState(b.oGettingSinkListState,pArg);
    }
    else
    {
   b.oSettingSourceState.exit(b,s,pArg);
   // transition Actions
   s.vFsmSetError_SourceNotSupported(pArg);
   s.vFsmSendResponse(pArg);
   b.setState(b.oIdleState,pArg);
    }
}

void
GettingSourceListState::evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   b.oSettingSourceState.exit(b,s,pArg);
   b.setState(b.oIdleState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: IdleState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

IdleState::IdleState ( void )
{}

void
IdleState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmReset(pArg);
}

void
IdleState::evError ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   // this is an internal transition
}

void
IdleState::evGetActiveSource ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oGettingActiveSourceState,pArg);
}

void
IdleState::evIdle ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   // this is an internal transition
}

void
IdleState::evReturnControl ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmRequestAudioNormalMode(pArg);
   // this is an internal transition
}

void
IdleState::evSetSource ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oActivateAudioDiagModeState,pArg);
}

void
IdleState::evTimeout ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   // this is an internal transition
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: SettingSourceState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

SettingSourceState::SettingSourceState ( void )
{}

void
SettingSourceState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmInitialize(pArg);
}

void
SettingSourceState::exit ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmFinalize(pArg);
}

void
SettingSourceState::evError ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   //... performing exit actions ...
   exit(b,s,pArg);
   b.setState(b.oIdleState,pArg);
}

void
SettingSourceState::evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   //... performing exit actions ...
   exit(b,s,pArg);
   b.setState(b.oIdleState,pArg);
}

void
SettingSourceState::evReturnControl ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   //... performing exit actions ...
   exit(b,s,pArg);
   // transition Actions
   s.vFsmRequestAudioNormalMode(pArg);
   b.setState(b.oIdleState,pArg);
}

void
SettingSourceState::evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   //... performing exit actions ...
   exit(b,s,pArg);
   b.setState(b.oIdleState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: ToplevelState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

ToplevelState::ToplevelState ( void )
{}

void
ToplevelState::evError ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oIdleState,pArg);
}

void
ToplevelState::evIdle ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oIdleState,pArg);
}

void
ToplevelState::evReturnControl ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmRequestAudioNormalMode(pArg);
   b.setState(b.oIdleState,pArg);
}

void
ToplevelState::evTimeout ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oIdleState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
//
// This is the finite state machine class implementation
//
///////////////////////////////////////////////////////////////////////////////

Fsm::Fsm ( void )
    : mpBehaviour(0),
      mpBody(0)
{
}

Fsm::Fsm ( FsmBehaviour* server )
    : mpBehaviour(server),
      mpBody(0)
{}

Fsm::~Fsm ( void )
{
    if ( mpBody )
    {
        delete mpBody;
        mpBody = 0;
    }
    mpBehaviour = 0;
}

bool
Fsm::createFSM ( Fsm** ppFSM, FsmBehaviour* behaviour )
{
   bool retCode = false;

   if ( ppFSM && behaviour )
   {
      (*ppFSM) = new Fsm(behaviour);
      if ( (*ppFSM) )
      {
         if ( !((*ppFSM)->init()) )
         {
            delete (*ppFSM);
            (*ppFSM) = 0;
         }
         else
         {
            retCode = true;
         }
      }
   }

   return retCode;
}

bool
Fsm::init ( void )
{
   bool retCode = false;
   
   mpBody = new FsmBody();
   
   if ( mpBody )
   {
      // connect the body with its frontend
      mpBody->connect(this);
      if ( mpBody->init() )
      {
          retCode = true;
      }
   }
   
   return retCode;
}

const char*
Fsm::getStateName (void) const
{
    return ( mpBody ) ? mpBody->getStateName() : 0;
}

void 
Fsm::acceptEvent ( FsmEvent event, void* pArg )
{
    if ( mpBody )
    {
        // forward the event to the FSM body (handle-body pattern)
        mpBody->acceptEvent(event,pArg);
    }
}
///////////////////////////////////////////////////////////////////////////////
//
// This is the finite state machine class implementation
//
///////////////////////////////////////////////////////////////////////////////

FsmBody::FsmBody ( void ) :
      mpFrontend(0),
      mpState(0),
      mBusyFlag(false),
      mQueueHead(0),
      mQueueTail(0),
      mQueueSize(0)
{
    (void) ::memset(mEventQueue,0,sizeof(FsmEvent)*MAX_TRIGGER_EVENTS);
    (void) ::memset(mParamQueue,0,sizeof(void*)*MAX_TRIGGER_EVENTS);
}

bool
FsmBody::init ( void )
{
    oActivateAudioDiagModeState.initState(&oToplevelState);
    oEstablishConnectionState.initState(&oSettingSourceState);
    oGettingActiveSourceState.initState(&oToplevelState);
    oGettingConnectionsState.initState(&oSettingSourceState);
    oGettingSinkListState.initState(&oSettingSourceState);
    oGettingSourceListState.initState(&oSettingSourceState);
    oIdleState.initState(&oToplevelState);
    oSettingSourceState.initSuperState(&oToplevelState, &oGettingSourceListState, false);
    oToplevelState.initSuperState(0, &oIdleState, false);

    setState(oToplevelState,0);
    
    return true;
}

void
FsmBody::connect ( Fsm* frontend )
{
    mpFrontend = frontend;
}

const char*
FsmBody::getStateName ( void ) const
{
    return ( mpState ) ? mpState->getStateName() : 0;
}

bool
FsmBody::addEvent ( const FsmEvent& event, void* param )
{
    if ( mQueueSize < MAX_TRIGGER_EVENTS )
    {
        mQueueSize++;
        mEventQueue[mQueueTail] = event;
        mParamQueue[mQueueTail] = param;
        mQueueTail++;
        if ( mQueueTail == MAX_TRIGGER_EVENTS )
        {
            mQueueTail = 0;
        }
        return true;
    }
    return false;
}

bool
FsmBody::getEvent ( FsmEvent& event, void** param )
{
    if ( !mQueueSize || !param )
    {
        return false;
    }
    mQueueSize--;
    event  = mEventQueue[mQueueHead];
    *param = mParamQueue[mQueueHead];
    mQueueHead++;
    if ( mQueueHead == MAX_TRIGGER_EVENTS )
    {
        mQueueHead = 0;
    }
    return true;
}

bool
FsmBody::isQueueEmpty ( void ) const
{
    return ( mQueueSize ) ? false : true;
}

void 
FsmBody::acceptEvent ( FsmEvent event, void* pArg )
{
    (void) addEvent(event,pArg);

    if ( mBusyFlag )
    {
        return;
    }

    mBusyFlag = true;
    while ( !isQueueEmpty() )
    {
        FsmEvent nextEvent = evUnknown;
        void*    nextArg   = 0;
        if ( !getEvent(nextEvent,&nextArg) )
        {
            break;
        }

        switch (nextEvent)
        {
        case evAudioDiagModeUpdate:
            if ( mpState ) mpState->evAudioDiagModeUpdate(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evCheckedAudioDiagMode:
            if ( mpState ) mpState->evCheckedAudioDiagMode(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evConnectionUpdate:
            if ( mpState ) mpState->evConnectionUpdate(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evError:
            if ( mpState ) mpState->evError(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evGetActiveSource:
            if ( mpState ) mpState->evGetActiveSource(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evIdle:
            if ( mpState ) mpState->evIdle(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evReturnControl:
            if ( mpState ) mpState->evReturnControl(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evSetSource:
            if ( mpState ) mpState->evSetSource(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evSinkUpdate:
            if ( mpState ) mpState->evSinkUpdate(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evSourceUpdate:
            if ( mpState ) mpState->evSourceUpdate(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evTimeout:
            if ( mpState ) mpState->evTimeout(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        default:
            //... unknown event ...
            break;
        } //lint !e788: not all items used within defaulted switch
    }
    mBusyFlag = false;
}

void 
FsmBody::setState ( FsmState& state, void* pArg )
{
    if ( mpFrontend )
    {
        mpState = const_cast<FsmState*>(state.propagate(*this,*(mpFrontend->mpBehaviour),pArg));
    }
}

void 
FsmBody::setState ( FsmState* pState )
{
    mpState = pState;
}

const FsmState*
FsmBody::getState ( void ) const
{
    return mpState;
}

///////////////////////////////////////////////////////////////////////////////
//
// Functions
//
///////////////////////////////////////////////////////////////////////////////

const char* getEventName ( FsmEvent event )
{
   static const char* eventNames[evCount] = {
      "evUnknown",
      "evAudioDiagModeUpdate",
      "evCheckedAudioDiagMode",
      "evConnectionUpdate",
      "evError",
      "evGetActiveSource",
      "evIdle",
      "evReturnControl",
      "evSetSource",
      "evSinkUpdate",
      "evSourceUpdate",
      "evTimeout",
   };

   return eventNames[event];
}


} // namespace
