/*!
 * \file       dia_TemperatureHistogram.h
 *
 * \brief      responsible for constructing histogram data for  
 *             temperature sensors and maintain them in persistent storage 
 *
 * \details    arguments of constructor define the type of sensor
 *
 * \component  Diagnosis
 *
 * \ingroup    diaCoreFrw
 *
 * \copyright  (c) 2019 Robert Bosch Car Multimedia
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */
#ifndef __INCLUDED_DIA_TEMPERATURE_HISTOGRAM__
#define __INCLUDED_DIA_TEMPERATURE_HISTOGRAM__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_TEMPERATURE_HISTOGRAM__
#include "common/interfaces/dia_ITemperatureHistogram.h"
#endif

namespace dia
{
   class TemperatureHistogram
   {
    private:
      static uint8_t getHistogramIndex(tS16 Value);

      static const uint32_t TEMPERATURE_HISTOGRAM_LENGTH = 22;
      static const uint32_t TEMPERATURE_HISTOGRAM_DEGREE_RANGE_RESOLUTION=10;
      static const int32_t TEMPERATURE_OFFSET_LOWER=-40;
      static const int32_t TEMPERATURE_OFFSET_HIGHER=TEMPERATURE_OFFSET_LOWER + TEMPERATURE_HISTOGRAM_DEGREE_RANGE_RESOLUTION *    (DIA_TEMPERATURE_HISTOGRAM_LENGTH - 2);// 160
      static const int16_t TEMPERATURE_OFFSET=10;
      /*
        simple case: DIA_TEMPERATURE_HISTOGRAM_LENGTH=2, TEMPERATURE_OFFSET_LOWER=0 =>  TEMPERATURE_OFFSET_HIGHER=0 
       */
      dia_eHeatCtrlTemperatureID mId;
      tS16 mTemperatureMin;
      tS16 mTemperatureMax;
      tU32 mtimeResolution;
      std::array<tU32,DIA_TEMPERATURE_HISTOGRAM_LENGTH> mData;

   public:
      TemperatureHistogram(dia_eHeatCtrlTemperatureID id=DIA_EN_HEATCTRL_TEMPERATURE_ID_UNKNOWN);
      virtual ~TemperatureHistogram();
      dia_eHeatCtrlTemperatureID getId() const {return mId;};
      void addMeasurement(tS16 temperature);
      void addTemperatureMin(tS16 temperatureMin);
      void addTemperatureMax(tS16 temperatureMax);
      std::array<uint32_t,DIA_TEMPERATURE_HISTOGRAM_LENGTH> const &getData() {
         return mData;
      }
      tS16 const getTemperatureMin(){return mTemperatureMin;}
      tS16 const getTemperatureMax(){return mTemperatureMax;}
   };
}
#endif
