/*!
 * \file       dia_FieldLoadDataPlugin.h
 *
 * \brief      skeleton for Field Load Data plugins
 *
 * \details    -
 *
 * \component  Diagnosis
 *
 * \ingroup    diaCoreFrw
 *
 * \copyright  (c) 2019 Robert Bosch Car Multimedia
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */
#ifndef __INCLUDED_DIA_FIELD_LOAD_DATA_PLUGIN__
#define __INCLUDED_DIA_FIELD_LOAD_DATA_PLUGIN__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

namespace dia{

class FieldLoadDataPlugin
{
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(FieldLoadDataPlugin);
public:
   FieldLoadDataPlugin();
   virtual ~FieldLoadDataPlugin();
   virtual void ProcessPluginStart(void) = 0;
   virtual void ProcessPluginUpdate(void) = 0;
   virtual void ProcessPluginStop(void) = 0;
};
}

#endif
