/*!
 * \file       dia_FieldLoadDataManager.h
 *
 * \brief      manager of the field load data plugins
 *
 * \details    -
 *
 * \component  Diagnosis
 *
 * \ingroup    diaCoreFrw
 *
 * \copyright  (c) 2019 Robert Bosch Car Multimedia
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */
#ifndef __INCLUDED_DIA_FIELD_LOAD_DATA_MANAGER__
#define __INCLUDED_DIA_FIELD_LOAD_DATA_MANAGER__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_SELF_TIMER__
#include "common/framework/application/dia_SelfTimer.h"
#endif

#ifndef __INCLUDED_DIA_FIELD_LOAD_DATA_PLUGIN__
#include "dia_FieldLoadDataPlugin.h"
#endif

namespace dia
{

class FieldLoadDataPlugin;

class FieldLoadDataManager
{
   DECL_SINGLETON_CONSTRUCTOR_AND_DESTRUCTOR(FieldLoadDataManager);
public:
   struct MsgTimeout {
   };
   FieldLoadDataManager();
   virtual ~FieldLoadDataManager();
   static const tU32 resolution = 60000;
private:

   bool mIsSetupDone;
   void init();
   RefCounter mRefCounter;
   SelfTimer<FieldLoadDataManager, MsgTimeout> mSelfTimer;

protected:
   std::list<std::shared_ptr<FieldLoadDataPlugin>> mPluginRep;
public:

   void start();
   void update();
   void stop();
   bool isSetupDone(){return mIsSetupDone;}

   void onTimeout(MsgTimeout *msg);

   //! add a FLD plugin
   tDiaResult addFieldLoadDataPlugin ( const std::shared_ptr<FieldLoadDataPlugin>& plugin );
};
}

#endif
