/**
 * \file      dia_factoryMethods.h
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    gib2hi
 * \date      13.05.2013
 *
 * \copyright Robert Bosch Car Multimedia 2013
 */


#ifndef __INCLUDED_DIA_FACTORY_METHODS__
#define __INCLUDED_DIA_FACTORY_METHODS__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

class dia_ConfigManager;
class dia_Factory;
class dia_Application;
class dia_AppController;
class dia_DataDownloadManager;
class dia_tclDiagSessionUds;
class dia_EngineManager;
class dia_SystemAdapterFacade;
class dia_TestController;
class dia_CommandController;
class dia_EventLogger;
class dia_ServiceTracker;
class dia_SecurityManager;
class dia_IOCtrlManager;
class dia_RoutineCtrlManager;
class dia_VideoSourceControl;
class dia_UpdateManager;
class dia_EventThread;
class dia_EcuResetManager;
class dia_SrvHandlerGenericECUResetsByResetType;
class dia_DataLogger;

//#############################################################################
//#
//# factory methods declarations
//#
//#############################################################################

dia_AppController* getInstanceOfAppController ( void );
dia_ConfigManager* getInstanceOfConfigManager ( void );
dia_Factory* getInstanceOfFactory ( void );
dia_Application* getInstanceOfApplication ( void );
dia_tclDiagSessionUds* getInstanceOfDiagSessionUDS (void );
dia_EngineManager* getInstanceOfEngineManager ( void );
dia_SystemAdapterFacade* createInstanceOfSystemAdapterFacade ( void );
dia_SystemAdapterFacade* getInstanceOfSystemAdapterFacade ( void );
dia_TestController* getInstanceOfTestController ( void );
dia_CommandController* getInstanceOfCommandController ( void );
dia_EventLogger* getInstanceOfEventLogger ( void );
dia_ServiceTracker* getInstanceOfServiceTracker ( void );
dia_SecurityManager* getInstanceOfSecurityManager ( void );
dia_IOCtrlManager* getInstanceOfIOCtrlManager ( void );
dia_RoutineCtrlManager* getInstanceOfRoutineControlManager ( void );
dia_DataDownloadManager* getInstanceOfDataDownloadManager ( void );
dia_UpdateManager* getInstanceOfUpdateManager ( void );
dia_VideoSourceControl* getInstanceOfVideoSourceControl ( void );
dia_EventThread* getInstanceOfdiaEventThread ( void );
dia_EcuResetManager* getInstanceOfEcuResetManager ( void );
dia_SrvHandlerGenericECUResetsByResetType* getInstanceOfSrvHandlerGenericECUResetsByResetType ( void );
dia_DataLogger* getInstanceOfDataLogger( void );

//-----------------------------------------------------------------------------

void releaseInstanceOfAppController ( void );
void releaseInstanceOfConfigManager ( void );
void releaseInstanceOfEngineManager ( void );
void releaseInstanceOfFactory ( void );
void releaseInstanceOfApplication ( void );
void releaseInstanceOfDataDownloadManager ( void );
void releaseInstanceOfEventLogger ( void);
void releaseInstanceOfRoutineControlManager ( void );
void releaseInstanceOfIOCtrlManager ( void );
void releaseInstanceOfSecurityManager ( void );
void releaseInstanceOfSystemAdapterFacade (void);
void releaseInstanceOfUpdateManager ( void );
void releaseInstanceOfVideoSourceControl ( void );
void releaseInstanceOfdiaEventThread ( void );
void releaseInstanceOfCommandController ( void );
void releaseInstanceOfServiceTracker ( void );
void releaseInstanceOfEcuResetManager ( void );
void releaseInstanceOfSrvHandlerGenericECUResetsByResetType ( void );
void releaseInstanceOfDataLogger( void );
#endif /* DIA_FACTORYMETHODS_H_ */
