#ifndef __INCLUDED_DIA_FACTORY_PLUGIN__
#include "common/framework/factory/dia_FactoryPlugin.h"
#endif

#ifndef __INCLUDED_DIA_HASH_CALCULATOR__
#include <common/framework/utils/dia_HashCalculator.h>
#endif

//-----------------------------------------------------------------------------

dia_FactoryPlugin::dia_FactoryPlugin ( tCString name, dia_eFactoryPluginType /*type*/ )
   : mName(name),
     mActiveLevel(DIA_EN_INITLEVEL_UNKNOWN),
     mSyncObj(std::string(std::string(name) + "_LK").c_str())
{
   mUID = dia_getHashCodeFromString(mName);
}

dia_FactoryPlugin::dia_FactoryPlugin ( tCString name )
   : mName(name),
     mActiveLevel(DIA_EN_INITLEVEL_UNKNOWN),
     mSyncObj(std::string(std::string(name) + "_LK").c_str())
{
   mUID = dia_getHashCodeFromString(mName);
}

//-----------------------------------------------------------------------------

dia_FactoryPlugin::~dia_FactoryPlugin ( void )
{
   mName = 0;
// mSubmodules.clear();
}

//-----------------------------------------------------------------------------

tCString
dia_FactoryPlugin::getName ( void ) const
{
   return mName;
}

//-----------------------------------------------------------------------------

dia_UID
dia_FactoryPlugin::getUID ( void ) const
{
   return mUID;
}
