#ifndef __INCLUDED_DIA_ERROR_INFO__
#define __INCLUDED_DIA_ERROR_INFO__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

enum dia_eExtResultInfoID
{
   DIA_EN_EXTENDED_RESULT_INFO_ID_UNKNOWN = 0,
   DIA_EN_EXTENDED_RESULT_INFO_ID_INTERFACE,
   DIA_EN_EXTENDED_RESULT_INFO_ID_COUNT
};

class dia_ErrorInfo
{
public:
   //! class constructor
   dia_ErrorInfo ( tDiaResult errCode = DIA_FAILED );
   //! class constructor
   dia_ErrorInfo ( dia_eExtResultInfoID extInfoID, tDiaResult errCode = DIA_FAILED );
   //! class destructor
   virtual ~dia_ErrorInfo ( void );

   //! method for setting the error code explicitly
   virtual void setErrorCode ( tDiaResult errCode );
   //! return the error code
   virtual tDiaResult getErrorCode ( void ) const;

   //! return the extended error information identifier
   virtual dia_eExtResultInfoID getExtendedInfoID ( void ) const;

protected:
   //! error/return code info
   tDiaResult mResult;
   //! identifier to specifiy the kind of extended error information
   dia_eExtResultInfoID mExtInfoID;
};

#endif
