/**
 * \file    dia_SessionADR.h
 *
 * \brief   Class dia_SessionADR is a subclass of dia_Session and is used for
 *          diagnosis of the ADR3 module. This session will forward incoming
 *          ADR3 diagnosis requests to the ADR3, but will reject all other UDS
 *          requests except of the SessionControl service.
 *
 * \author  gib2hi
 * \date    2012/09/05
 *
 * \copyright Robert Bosch Car Multimedia 2012
 */

#ifndef __INCLUDED_DIA_SESSION_ADR__
#define __INCLUDED_DIA_SESSION_ADR__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_SESSION__
#include "common/framework/engine/dia_Session.h"
#endif

#ifndef __INCLUDED_DIA_COMMON_PROTOCOLS_UDS__
#include "common/framework/protocols/uds/dia_common_uds.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_ADR_LISTENER__
#include "common/interfaces/dia_IADRListener.h"
#endif

#include "common/framework/fsm/generated/dia_ADRSessionFSM.h"


class dia_EngineServer;


/**
 * \class   dia_SessionADR
 *
 * \brief   This class implements diagnostic session used for ADR3 diagnosis
 *
 *          The class dia_SessionADR is a subclass of dia_Session and is used for
 *          diagnosis of the ADR3 module. This session will forward incoming
 *          ADR3 diagnosis requests to the ADR3, but will reject all other UDS
 *          requests except of the SessionControl service.
 *
 * \ingroup diaCoreEngine
 */

class dia_SessionADR
   : public virtual dia_Object,
     public dia_Session,
     public dia_ServiceHandlerUDS,
     public dia_IADRListener,
     protected dia_ADRSessionFSM::FsmBehaviour
{
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SessionADR);

public:
   //! class constructor
//   dia_SessionADR ( tU8 sessionID );
   //! class constructor
   dia_SessionADR ( tU8 sessionID, dia_EngineServer& engine );
   //! class destructor
   virtual ~dia_SessionADR ( void );

   void initialize ( void );

   //! method that can be overloaded by subclasses to perform specific task when the session is entered
   virtual tDiaResult onEnterSession ( void );
   //! method that can be overloaded by subclasses to perform specific task when the session is left
   virtual tDiaResult onLeaveSession ( void );
   //! method that can be overloaded by subclasses to perform specific task when the session is deactivated/reset
   virtual tDiaResult onResetSession ( void );

   //! handle an incoming UDS request
   virtual void vProcessRequest ( const std::vector<tArgsType>& vecArgs );
   //! provide lookup keys
   virtual tDiaResult makeLookupKeys ( std::vector<dia_LookupKey*>& keys );

   //! forward the given message to the ADR
   virtual void vOnADRContainerMessageResponse ( std::vector<tU8>& adrResponse );

protected:
   //! deprecated class constructor
   dia_SessionADR ( void );

   //! reset the ADR3
   void vResetADR3 ( void ) const;

   // FSM actions
   virtual void vFsmReset ( void* pArg );
   virtual void vFsmOnSessionDeactivated ( void* pArg );
   virtual void vFsmSendActivation ( void* pArg );
   virtual void vFsmEvalADRContainer ( void* pArg );
   virtual void vFsmOnSessionActivated ( void* pArg );
   virtual void vFsmForwardRequest ( void* pArg );
   virtual void vFsmForwardResponse ( void* pArg );
   virtual void vFsmSendDeactivation ( void* pArg );
   virtual void vFsmDeactivationFailed ( void* pArg );

   // FSM guards
   virtual bool bIsActivationComplete ( void* pArg );
   virtual bool bIsDeactivationComplete ( void* pArg );

protected:
   //! error information for an action is reported in the following variable
   tDiaResult mErrorCode;
//   //! session state
//   tBool mIsActive;
   //!
   std::vector<tU8> mResults;
   //! pointer to the FSM object
   dia_ADRSessionFSM::Fsm* mpFSM;
};

#endif /* __INCLUDED_DIA_SESSION_ADR__ */
