/*
 * dia_Session.cpp
 *
 *  Created on: 09.05.2012
 *      Author: gib2hi
 */


#include "dia_ServiceDispatcher.h"

#ifndef __INCLUDED_DIA_SESSION__
#include "common/framework/engine/dia_Session.h"
#endif

#ifndef __INCLUDED_DIA_ENGINE_SERVER__
#include "common/framework/engine/dia_EngineServer.h"
#endif

//-----------------------------------------------------------------------------

dia_Session::dia_Session ( tU8 sessionID, dia_EngineServer& engine )
   : mID(sessionID), mIsActive(FALSE), mEventMask(0), mpEngine(&engine)
{
   dia_tclFnctTrace oTrace("dia_Session::dia_Session ( tU8 sessionID, dia_EngineServer& engine )");
   mpDispatcher = OSAL_NEW dia_ServiceDispatcher();
}

//-----------------------------------------------------------------------------

dia_Session::dia_Session ( void )
   : mID(0x00), mIsActive(FALSE), mEventMask(0), mpEngine(0), mpDispatcher(0)
{
//   dia_tclFnctTrace oTrace("dia_Session::dia_Session()");
}

//-----------------------------------------------------------------------------

dia_Session::~dia_Session ( void )
{
   _BP_TRY_BEGIN
   {
      mpEngine = 0;
      if ( mpDispatcher )
      {
         OSAL_DELETE mpDispatcher;
         mpDispatcher = 0;
      }
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR("EXCEPTION CAUGHT: dia_Session::~dia_Session !!!");
      DIA_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}

//-----------------------------------------------------------------------------

tDiaResult
dia_Session::setEngine ( dia_EngineServer& engine )
{
#ifdef __DIA_UNIT_TESTING__
   DIA_TR_INF("dia_Session::setEngine pEngine=0x%08X", &engine);
#endif

   mpEngine = &engine;
   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

dia_ServiceDispatcher*
dia_Session::getDispatcher ( void )
{
   return mpDispatcher;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_Session::onEnterSession ( void )
{
   dia_tclFnctTrace oTrace("dia_Session::onEnterSession()");

   if ( !mpEngine ) return DIA_FAILED;

   mIsActive = true;

   dia_SessionController* pSessionMgr = mpEngine->getSessionController();
   if ( pSessionMgr )
   {
      pSessionMgr->vOnSessionUpdate(*this);
   }

   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_Session::onLeaveSession ( void )
{
   dia_tclFnctTrace oTrace("dia_Session::onLeaveSession()");

   if ( !mpEngine ) return DIA_FAILED;

   mIsActive = false;

   dia_SessionController* pSessionMgr =  mpEngine->getSessionController();
   if ( pSessionMgr )
   {
      pSessionMgr->vOnSessionUpdate(*this);
   }

   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_Session::onResetSession ( void )
{
   dia_tclFnctTrace oTrace("dia_Session::onResetSession()");

   mIsActive = false;

   return DIA_SUCCESS;
}
