/*!
 * \file       dia_ServiceHandler.cpp
 *
 * \brief      This file contains the definition of the base class for all kinds of
 *             service handlers
 *
 * \details    This file contains the definition of the base class for all kinds of
 *             service handlers
 *
 * \component  Diagnosis
 *
 * \ingroup    diaCoreEngine
 *
 * \copyright  (c) 2012-2016 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_SERVICE_HANDLER__
#include "common/framework/engine/dia_ServiceHandler.h"
#endif

#ifndef __INCLUDED_DIA_LOOKUPKEY__
#include "common/framework/engine/dia_LookupKey.h"
#endif

#ifndef __INCLUDED_DIA_ENGINE_SERVER__
#include "common/framework/engine/dia_EngineServer.h"
#endif

//-----------------------------------------------------------------------------

dia_ServiceHandler::dia_ServiceHandler ( void )
   : mName(0), mMaxTime(DIA_C_U32_MAX_PROCESSING_TIME_SERVICE),
     mpEngine(0)
{}

//-----------------------------------------------------------------------------

dia_ServiceHandler::dia_ServiceHandler ( tCString name, tU32 timeoutValue )
   : mName(name), mMaxTime(timeoutValue),
     mpEngine(0)
{}

//-----------------------------------------------------------------------------

dia_ServiceHandler::~dia_ServiceHandler ( void )
{
   _BP_TRY_BEGIN
   {
      mName = 0;
      mpEngine = 0;
      DIA_IMPL_VECTOR_REPOSITORY_TEAR_DOWN(dia_LookupKey,mLookupKeys)
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR("EXCEPTION CAUGHT: dia_ServiceHandler::~dia_ServiceHandler !!!");
      DIA_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}

//-----------------------------------------------------------------------------

tDiaResult
dia_ServiceHandler::setEngine ( dia_EngineServer& engine )
{
#ifdef __DIA_UNIT_TESTING__
   DIA_TR_INF("dia_ServiceHandler::setEngine pEngineServer=0x%08X", &engine);
#endif
   mpEngine = &engine;
   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

void
dia_ServiceHandler::vProcessRequest ( const std::vector<tArgsType>& vecArgs )
{
   dia_tclFnctTrace oTrace("dia_ServiceHandler::vProcessRequest(vecArgs[])");

   if ( !vecArgs.size() )
   {
      DIA_TR_INF("### NO PARAMETERS AVAILABLE: CALLING DEPRECATED vOnReqRx METHOD ###");
      vOnReqRx();
   }
}

//-----------------------------------------------------------------------------

tCString
dia_ServiceHandler::getName ( void ) const
{
   return mName;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_ServiceHandler::setName ( tCString name )
{
   mName = name;
   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tU32
dia_ServiceHandler::getTimeoutValue ( void ) const
{
   return mMaxTime;
}

//-----------------------------------------------------------------------------

void
dia_ServiceHandler::setTimeoutValue ( tU32 value )
{
   mMaxTime = value;
}

//-----------------------------------------------------------------------------


void
dia_ServiceHandler::vOnReqRx ( void )
{
   DIA_TR_INF("### DEPRECATED METHOD NOT IMPLEMENTED: dia_ServiceHandler::vOnReqRx() ###");
}

//-----------------------------------------------------------------------------

void
dia_ServiceHandler::vOnCompResPpg ( amt_tclServiceData* /*msg*/ )
{
   DIA_TR_INF("### DEPRECATED METHOD NOT IMPLEMENTED: dia_ServiceHandler::vOnCompResPpg() ###");
}

//-----------------------------------------------------------------------------

void
dia_ServiceHandler::vOnCompRes ( amt_tclServiceData* /*msg*/ )
{
   DIA_TR_INF("### DEPRECATED METHOD NOT IMPLEMENTED: dia_ServiceHandler::vOnCompRes() ###");
}

//-----------------------------------------------------------------------------

void
dia_ServiceHandler::vOnCallBack ( tU8 /*u8MsgBuffer*/[], const tU16 /*u16MsgLength*/ )
{
   DIA_TR_INF("### DEPRECATED METHOD NOT IMPLEMENTED: dia_ServiceHandler::vOnCallBack() ###");
}

//-----------------------------------------------------------------------------

tBool
dia_ServiceHandler::bOnNewReq ( tU8* /*pu8Buffer*/, tU16 /*u16MsgLen*/ )
{
   DIA_TR_INF("### DEPRECATED METHOD NOT IMPLEMENTED: dia_ServiceHandler::bOnNewReq() ###");
   return FALSE;
}

//-----------------------------------------------------------------------------

void
dia_ServiceHandler::vOnBeginPpg ( void )
{
   DIA_TR_INF("### DEPRECATED METHOD NOT IMPLEMENTED: dia_ServiceHandler::vOnBeginPpg() ###");
}

//-----------------------------------------------------------------------------

void
dia_ServiceHandler::vOnTimeoutPpg ( void )
{
   DIA_TR_INF("### DEPRECATED METHOD NOT IMPLEMENTED: dia_ServiceHandler::vOnTimeoutPpg() ###");
}

//-----------------------------------------------------------------------------

tCString
dia_ServiceHandler::cszClassName ( void ) const
{
   DIA_TR_INF("### DEPRECATED METHOD NOT IMPLEMENTED: dia_ServiceHandler::cszClassName() ###");
   return mName;
}

//-----------------------------------------------------------------------------

tU32
dia_ServiceHandler::u32MaxPgTime ( void ) const
{
   DIA_TR_INF("### DEPRECATED METHOD NOT IMPLEMENTED: dia_ServiceHandler::u32MaxPgTime() ###");
   return mMaxTime;
}

//-----------------------------------------------------------------------------

tU32
dia_ServiceHandler::u32MaxPpgTime ( void ) const
{
   DIA_TR_INF("### DEPRECATED METHOD NOT IMPLEMENTED: dia_ServiceHandler::u32MaxPpgTime() ###");
   return DIA_C_U32_MAX_PROCESSING_TIME_SERVICE;
}

