/*
 * dia_ServiceAccessInfo.h
 *
 *  Created on: 09.05.2012
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_SERVICE_ACCESS_INFO__
#define __INCLUDED_DIA_SERVICE_ACCESS_INFO__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

class dia_SecurityLevel;

class dia_ServiceAccessInfo
{
public:
   //! default constructor
   dia_ServiceAccessInfo ( void );
   //! constructor
   dia_ServiceAccessInfo ( tU8 sid, tU8 didLen, const std::vector<tU8>& sessions, const std::vector<dia_UID>& secLevels );
   //! constructor
   dia_ServiceAccessInfo ( tU8 sid, tU16 did, tU8 didLen, tU8 level, const std::vector<tU8>& sessions, const std::vector<dia_UID>& secLevels );
   //! class destructor
   virtual ~dia_ServiceAccessInfo ( void ) {}

   //! set the SID
   void setServiceID ( tU8 sid ) { mSID = sid; }
   //! retrieve service identifier
   tU8 getServiceID ( void ) const { return mSID; }

   //! set the subfunction ID
   void setSubFunctionID ( tU16 did ) { mDID = did; }
   //! retrieve service identifier
   tU16 getSubFunctionID ( void ) const { return mDID; }

   //! set the subfunction size
   void setSubIDSize ( tU8 didLen ) { mSizeofDID = didLen; }
   //! retrieve the size of the subfunction in Bytes
   tU8 getSubIDSize ( void ) const { return mSizeofDID; }

   //! assign the runlevel that specifies when the service can be processed
   void setRunLevel ( tU8 runLevel ) { mRunLevel = runLevel; }
   //! retrieve the run level
   tU8 getRunLevel ( void ) const { return mRunLevel; }
   //! check if the service is supported in the given run level
   bool checkRunLevel ( tU8 runLevel ) const { return ( runLevel >= mRunLevel ) ? true : false; }

   //! assign the support mode on service level
   void setSupportMode ( tU8 mode ) { mSupportMode = mode; }
   //! retrieve the run level
   tU8 getSupportMode ( void ) const { return mSupportMode; }

   //! assign the list of allowed sessions
   void setSessions ( const std::vector<tU8>& allowedSessions );
   //! add the given session id if it is valid
   void addSession ( tU8 session );
   //! assign the list of allowed sessions
   const std::vector<tU8>& getSessions ( void ) const { return mSessionRep; }

   //! assign the list of allowed security levels
   void setSecurityLevels ( const std::vector<dia_UID>& allowedSecurityLevels );
   //! add the given security level
   void addSecurityLevel ( dia_UID securityLevel );
   //! assign the list of allowed sessions
   const std::vector<dia_UID>& getSecurityLevels ( void ) const { return mSecLevelRep; }

   //! check if the service is supported in the given session
   bool checkSession ( tU8 session ) const;
   //! check if the service is supported for the given security level
   bool checkSecurityLevels ( const std::list<dia_SecurityLevel*>& activeSecurityLevels ) const;

protected:
   //! service identifier
   tU8  mSID;
   //! service data identifier (subfunction
   tU16 mDID;
   //! number of bytes used for the DID
   tU8  mSizeofDID;
   //! runlevel that has to be reached before the service can be executed
   tU8  mRunLevel;
   //! repository of supported sessions
   std::vector<tU8> mSessionRep;
   //! repository of supported security level
   std::vector<dia_UID> mSecLevelRep;
   //!
   tU8  mSupportMode;
};

#endif /* __INCLUDED_DIA_SERVICE_ACCESS_INFO__ */
