/*
 * dia_ServiceAccessInfo.cpp
 *
 *  Created on: 09.05.2012
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_DEFINES_UDS__
#include <common/framework/protocols/uds/dia_defsUds.h>
#endif

#ifndef __INCLUDED_DIA_SECURITY__
#include <common/framework/security/dia_security.h>
#endif

#ifndef __INCLUDED_DIA_SECURITY_LEVEL__
#include <common/framework/security/dia_SecurityLevel.h>
#endif

#include "dia_ServiceAccessInfo.h"

#define DIA_ACCESS_CONTROL_UNKNOWN_LEVEL    (( tU8)   0xFF)
#define DIA_ACCESS_CONTROL_UNKNOWN_SID      (( tU8)   0xFF)
#define DIA_ACCESS_CONTROL_UNKNOWN_DID      ((tU16) 0xFFFF)

//------------------------------------------------------------------------------

dia_ServiceAccessInfo::dia_ServiceAccessInfo ( void )
    : mSID(DIA_ACCESS_CONTROL_UNKNOWN_SID),
      mDID(DIA_ACCESS_CONTROL_UNKNOWN_DID),
      mSizeofDID(0),
      mRunLevel(DIA_ACCESS_CONTROL_UNKNOWN_LEVEL),
      mSupportMode(DIA_C_U8_UDS_SERVICE_SUPPORTED)
{}

//------------------------------------------------------------------------------

dia_ServiceAccessInfo::dia_ServiceAccessInfo ( tU8 sid, tU16 did, tU8 didLen, tU8 level, const std::vector<tU8>& sessions, const std::vector<dia_UID>& secLevels )
    : mSID(sid),
      mDID(did),
      mSizeofDID(didLen),
      mRunLevel(level),
      mSessionRep(sessions),
      mSecLevelRep(secLevels),
      mSupportMode(DIA_C_U8_UDS_SERVICE_SUPPORTED)
{}

//------------------------------------------------------------------------------

dia_ServiceAccessInfo::dia_ServiceAccessInfo ( tU8 sid, tU8 didLen, const std::vector<tU8>& sessions, const std::vector<dia_UID>& secLevels )
: mSID(sid),
  mDID(DIA_ACCESS_CONTROL_UNKNOWN_DID),
  mSizeofDID(didLen),
  mRunLevel(DIA_ACCESS_CONTROL_UNKNOWN_LEVEL),
  mSessionRep(sessions),
  mSecLevelRep(secLevels),
  mSupportMode(DIA_C_U8_UDS_SERVICE_SUPPORTED)
{}

//------------------------------------------------------------------------------

void
dia_ServiceAccessInfo::setSessions ( const std::vector<tU8>& allowedSessions )
{
    if ( allowedSessions.size() != 0 )
    {
        std::vector<tU8>::const_iterator it1 = allowedSessions.begin();
        for ( ; it1 != allowedSessions.end(); ++it1 )
        {
            tU8 session = (*it1);
            if ( session != DIA_C_U8_UDS_SESSION_INVALID )
            {
                std::vector<tU8>::iterator it2 = find(mSessionRep.begin(),mSessionRep.end(),session);
                if ( it2 == mSessionRep.end() )
                {
                    mSessionRep.push_back(session);
                }
            }
        }
    }
}

//------------------------------------------------------------------------------

void
dia_ServiceAccessInfo::addSession ( tU8 session )
{
   if ( session != 0x00 )
   {
      std::vector<tU8>::iterator iter = find(mSessionRep.begin(),mSessionRep.end(),session);
      if ( iter == mSessionRep.end() )
      {
         mSessionRep.push_back(session);
      }
   }
}

//------------------------------------------------------------------------------

bool
dia_ServiceAccessInfo::checkSession ( tU8 session ) const
{
   std::vector<tU8>::const_iterator it = find(mSessionRep.begin(),mSessionRep.end(),session);
    return ( it != mSessionRep.end() ) ? true : false;
}

//------------------------------------------------------------------------------

void
dia_ServiceAccessInfo::setSecurityLevels ( const std::vector<dia_UID>& allowedSecurityLevels )
{
    if ( allowedSecurityLevels.size() != 0 )
    {
       std::vector<dia_UID>::const_iterator it1 = allowedSecurityLevels.begin();
        for ( ; it1 != allowedSecurityLevels.end(); ++it1 )
        {
            dia_UID secLevel = (*it1);
            std::vector<dia_UID>::iterator it2 = std::find(mSecLevelRep.begin(),mSecLevelRep.end(),secLevel);
            if ( it2 == mSecLevelRep.end() )
            {
               mSecLevelRep.push_back(secLevel);
            }
        }
    }
}

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

void
dia_ServiceAccessInfo::addSecurityLevel ( dia_UID secLevel )
{
   std::vector<dia_UID>::iterator iter = std::find(mSecLevelRep.begin(),mSecLevelRep.end(),secLevel);
   if ( iter == mSecLevelRep.end() )
   {
      mSecLevelRep.push_back(secLevel);
   }
}

//------------------------------------------------------------------------------

bool
dia_ServiceAccessInfo::checkSecurityLevels ( const std::list<dia_SecurityLevel*>& activeSecurityLevels ) const
{
   dia_tclFnctTrace trc("dia_ServiceAccessInfo::checkSecurityLevels(activeSecurityLevels)");

   std::vector<dia_UID>::const_iterator configIter = std::find(mSecLevelRep.begin(),mSecLevelRep.end(),DIA_UID_SECURITY_LEVEL_NOT_ACTIVE);
   if ( configIter != mSecLevelRep.end() )
   {
      DIA_TR_INF("SECURITY ACCESS ALLOWED (DIA_UID_SECURITY_LEVEL_NOT_ACTIVE CONFIGURED) !!");
      return true;
   }

   // all configured security levels must be matched !!

   bool isActiveLevelFound = false;
   for ( configIter = mSecLevelRep.begin(); (isActiveLevelFound == false) && (configIter != mSecLevelRep.end()); ++configIter )
   {
      if ( !(*configIter) ) continue;
      if ( (*configIter) == DIA_UID_SECURITY_LEVEL_NOT_ACTIVE ) continue;
      std::list<dia_SecurityLevel*>::const_iterator activeLevelIter = activeSecurityLevels.begin();
      for ( ; activeLevelIter != activeSecurityLevels.end(); ++activeLevelIter )
      {
         if ( (*activeLevelIter) && ((*activeLevelIter)->getUID() == (*configIter)) )
         {
        	 isActiveLevelFound = true;
        	 break;
         }
      }
   }

//   bool isActiveLevelFound = false;
//
//   for ( configIter = mSecLevelRep.begin(); (isActiveLevelFound == false) && (configIter != mSecLevelRep.end()); ++configIter )
//   {
//      if ( (*configIter) == DIA_UID_SECURITY_LEVEL_NOT_ACTIVE ) continue;
//      // TBC: we assume OR combination of active levels here, thus only one of the active levels need to be configured
//      std::list<dia_SecurityLevel*>::const_iterator activeLevelIter = activeSecurityLevels.begin();
//      for ( ; activeLevelIter != activeSecurityLevels.end(); ++activeLevelIter )
//      {
//         if ( (*activeLevelIter) && ((*activeLevelIter)->getUID() == (*configIter)))
//         {
//            // the configured security level is active, so we can stop searching at this point
//            isActiveLevelFound = true;
//         }
//      }
//   }

   // bool isSecurityAccessAllowed = ( matchedLevels == ((tU16) mSecLevelRep.size()) ) ? true : false;
   DIA_TR_INF("SECURITY ACCESS %s !!", ((isActiveLevelFound) ? "ALLOWED": "DENIED"));
   return isActiveLevelFound;

//   if ( !isActiveLevelFound )
//   {
//      DIA_TR_INF("SECURITY ACCESS DENIED !!");
//      return false;
//   }
//
//   DIA_TR_INF("SECURITY ACCESS ALLOWED !!");
//   return true;
}

