/*
 * dia_EngineServerConfiguration.h
 *
 *  Created on: 16.10.2014
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_ENGINE_SERVER_CONFIGURATION__
#define __INCLUDED_DIA_ENGINE_SERVER_CONFIGURATION__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_ENGINE_CONFIGURATION__
#include <common/framework/engine/dia_EngineConfiguration.h>
#endif

#define DIA_C_U16_MAX_SESSION_PER_ENGINE           ((tU16) 25)
#define DIA_C_U16_MAX_SECURITY_LEVELS_PER_ENGINE   ((tU16)  5)

class dia_ServiceAccessInfo;
class dia_LookupKey;
class dia_EngineServer;
class dia_MessageBuffer;
class dia_Session;
class dia_SecurityLevel;

class dia_EngineServerConfiguration
   : public dia_EngineConfiguration
{
public:
   struct ServiceDataItem
   {
      //! service identifier
      tU8  mSID;
      //! diagnostic data identifier
      tU16 mDID;
      //! length of the DID
      tU16 mDIDLen;
      //! run level information
      tU8  mRunLevel;
      //! supported sessions
      tU8  mSupportedSessions[DIA_C_U16_MAX_SESSION_PER_ENGINE];
      //! supported security levels
      dia_UID  mSupportedSecurityLevels[DIA_C_U16_MAX_SECURITY_LEVELS_PER_ENGINE];
   };

   struct ServiceInfo
   {
      //! service identifier
      tU8  mSID;
      //! diagnostic data identifier
      tU8  mAccessInfo;
      //! length of the DID
      tU16 mDIDLen;
      //! supported sessions
      tU8  mSupportedSessions[DIA_C_U16_MAX_SESSION_PER_ENGINE];
      //! supported security levels
      dia_UID  mSupportedSecurityLevels[DIA_C_U16_MAX_SECURITY_LEVELS_PER_ENGINE];
   };

public:
   //! class destructor
   virtual ~dia_EngineServerConfiguration ( void ) {}

   virtual tDiaResult validateRequest ( const dia_MessageBuffer& request, const dia_Session* pSession, const std::list<dia_SecurityLevel*>& securityLevels ) const;
   virtual tDiaResult validateProtocol ( const dia_MessageBuffer& request) const;
   virtual tDiaResult validateLengthOrFormat ( tU8 sid, tU16 len ) const;

   const std::vector<tU8>& getSessions ( void ) const { return mSupportedSessions; }
   const std::map< tU32, std::map<tU32,::boost::shared_ptr<dia_ServiceAccessInfo> > >& getSubFunctionConfiguration ( void ) const { return static_cast<const std::map< tU32, std::map<tU32,::boost::shared_ptr<dia_ServiceAccessInfo> > >&>(mSubFuncRep); }

   tDiaResult querySessions ( const dia_LookupKey& key, std::vector<tU8>& supportedSessions ) const;

   tDiaResult querySubFuncIDs(const dia_Session* session, tU8 service, std::vector<tU8>& supportedIdents, tU16 bitMask=0xFFFF) const;

   //! load information about the supported diagnostic sessions
   tDiaResult updateSessions ( const std::vector<tU8>& supportedSessions );
   //! load information about the supported diagnostic services like SessionControl, ECUReset, ...
   tDiaResult updateServiceInfo ( const std::map<tU8,dia_ServiceAccessInfo*>&  srvInfo );
   //! load information about the supported subfunctions of supported diagnostic services
   tDiaResult updateServiceSubfunctionInfo ( const std::map< tU32, std::map<tU32,::boost::shared_ptr<dia_ServiceAccessInfo> > >& srvSubfuncInfo );

protected:
   //! deprecated class constructor (no implementation)
   dia_EngineServerConfiguration ( void );
   //! deprecated class constructor
   dia_EngineServerConfiguration ( tCString name, dia_enProtocol protocol=DIA_EN_PROTOCOL_UDS ) : dia_EngineConfiguration(name, protocol) {}

   //! load information about the supported diagnostic sessions
   tDiaResult loadSessions ( const std::vector<tU8>& supportedSessions );
   //! load information about the supported diagnostic services like SessionControl, ECUReset, ...
   tDiaResult loadServiceInfo ( const std::vector<ServiceInfo>&  srvInfo );
   //! load information about the supported subfunctions of supported diagnostic services
   tDiaResult loadServiceInfo ( const std::vector<ServiceDataItem>& srvDataInfo );

   virtual tDiaResult isAccessAllowed ( const dia_LookupKey& key ) const;
   virtual tDiaResult isServiceAllowed ( tU8 sid, tU16 did, tU8 session ) const;
   virtual tDiaResult isSecurityAccessAllowed ( const dia_LookupKey& key, tU8 sessionID, const std::list<dia_SecurityLevel*>& securityLevels ) const;

protected:
   //! supported sessions
   std::vector<tU8> mSupportedSessions;
   // map that provides access information on service level
   std::map<tU8,dia_ServiceAccessInfo*>  mServiceRep;
   // map that provides access information on subfunction level
   std::map< tU32, std::map<tU32,::boost::shared_ptr<dia_ServiceAccessInfo> > > mSubFuncRep;
};

#endif /* __INCLUDED_DIA_ENGINE_SERVER_CONFIGURATION__ */
