/**
 * \file    dia_EngineManager.h
 *
 * \brief   This file contains the definition of the dia_EngineManager class
 *          that is responsible for managing the number of existing engines
 *          in the diagnosis application
 *
 * \author  gib2hi
 * \date    2014/08/28
 */

#ifndef __INCLUDED_DIA_ENGINE_MANAGER__
#define __INCLUDED_DIA_ENGINE_MANAGER__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_ENGINE_DEFINES__
#include <common/framework/engine/dia_EngineDefs.h>
#endif

#ifndef __INCLUDED_DIA_ENGINE__
#include <common/framework/engine/dia_Engine.h>
#endif

#ifndef __INCLUDED_DIA_LOCK__
#include <common/framework/application/dia_Lock.h>
#endif

// forward declarations
class dia_Engine;
class dia_EngineServer;
class dia_EngineClient;

class dia_EngineManager
{
   DECL_SINGLETON_CONSTRUCTOR_AND_DESTRUCTOR(dia_EngineManager);

public:
   //! setup method for the application
   virtual tDiaResult setup ( void );
   //! shutdown method for the application
   virtual tDiaResult shutdown ( void );

   //! add a new test to the test controller object
   virtual tDiaResult addEngine ( dia_Engine& engine );
   //! query for the engine with the given ID
   virtual tDiaResult queryEngine ( tCString, dia_Engine** engine );
   //! query for the engine with the given ID
   virtual tDiaResult queryEngine ( dia_UID, dia_Engine** engine );
   //! query for the service provider engine with the given ID
   virtual tDiaResult queryEngineServer ( dia_UID, dia_EngineServer** engine );
   //! query for the service provider engine with the given ID
   virtual tDiaResult queryEngineClient( dia_UID id, dia_EngineClient** ppEngineController );

   const std::map<dia_UID,dia_Engine*>& getEngines ( void ) const  { return mEngineRep; }

protected:
   //! default class constructor
   dia_EngineManager ( void );
   //! class destructor
   virtual ~dia_EngineManager ( void );

protected:
   //! synchronization object used to synchronize concurrent access from multiple threads
   mutable dia_Lock mSyncObj;
   //! repository of engines managed by this controller
   std::map<dia_UID,dia_Engine*> mEngineRep;
};

#endif /* __INCLUDED_DIA_ENGINE_MANAGER__ */
