/*
 * dia_EngineFlashConfiguration.h
 *
 *  Created on: 07.11.2014
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_ENGINE_CONFIGURATION_FLASH_PDX__
#define __INCLUDED_DIA_ENGINE_CONFIGURATION_FLASH_PDX__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_ENGINE_CLIENT_CONFIGURATION__
#include <common/framework/engine/dia_EngineClientConfiguration.h>
#endif

namespace dia {

//-----------------------------------------------------------------------------

enum enFlashJobID
{
   DIA_EN_FLASH_JOB_ID_UNKNOWN = 0,
//   DIA_EN_UDS_CMD_TYPE_COMPOSITE,
   DIA_EN_FLASH_JOB_ID_RDBI,
   DIA_EN_FLASH_JOB_ID_WDBI,
   DIA_EN_FLASH_JOB_ID_EXPECTED_IDENT,
//   DIA_EN_UDS_CMD_TYPE_ROUTINE_CTRL_TYPE_1,
//   DIA_EN_UDS_CMD_TYPE_ROUTINE_CTRL_TYPE_2,
//   DIA_EN_UDS_CMD_TYPE_ROUTINE_CTRL_TYPE_2_RESULT,
//   DIA_EN_UDS_CMD_TYPE_IO_CTRL,
   DIA_EN_FLASH_JOB_ID_SESSION_CTRL,
//   DIA_EN_UDS_CMD_TYPE_SECURITY_ACCESS,
//   DIA_EN_UDS_CMD_TYPE_ECU_RESET,
   DIA_EN_FLASH_JOB_ID_DATA_DOWNLOAD,
   DIA_EN_UDS_CMD_TYPE_COUNT
};

//-----------------------------------------------------------------------------

struct FlashJob
{
   DECL_DEPRECATED_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(FlashJob);

public:
   FlashJob ( enFlashJobID id, tU8 sid, tU16 did, const std::vector<tU8>& data, void* cookie=0 );
   virtual ~FlashJob ( void );

   //! classifier for the type of service. might involve special handling within the processor
   enFlashJobID mID;
   //! name of the request
// tCString mName;
   //! service ID to be used for executing the request
   tU8  mSID;
   //! data ID to be used for executing the request
   tU16 mDID;
   //! length of data identifier, as we might have 1 or 2 byte identifiers or no identifier at all
// tU16 mDIDLen;
   //! data to be sent along with the request
   std::vector<tU8> mData;//   tU8* mpData;
//   //! length of data to be sent
//   tU16 mDataLen;
//   //! name of log file (zero terminated ASCII string
//   tCString mLogFileName;
//   //! time to wait before the engine shall continue with processing the next command
//   tU32 mTimeToWaitAfterExecution;
//   //! flag to indicate if the command has to be processed periodically
//   bool mIsPeriodic;
//   //! period in seconds
//   tU32 mPeriod;
//   //! flag to indicate if the process shall be triggered periodically in the background
//   bool mRunInBackground;
//   //!
//   bool mIsSubCommand;
//   //!
//   dia_CommandInfoUDS* mpSubCommand;
   void* mCookie;
};

//-----------------------------------------------------------------------------

class EngineFlashConfiguration
   : public dia_EngineClientConfiguration
{
public:
   //! class constructor
   EngineFlashConfiguration ( const std::string& name, dia_enProtocol protocol=DIA_EN_PROTOCOL_UDS );
   //! class constructor
   EngineFlashConfiguration ( tCString name, dia_enProtocol protocol=DIA_EN_PROTOCOL_UDS );
   //! class destructor
   virtual ~EngineFlashConfiguration ( void );

//   //! compile all configuration items in a way that the configuration can be used by the engine
//   virtual tDiaResult loadConfiguration ( void );
//
//   //!
//   virtual void setServer ( dia_UID uid ) { mUID = uid; }
//   //!
//   virtual dia_UID getServer ( void ) const { return mUID; }
//   //!
//   virtual tDiaResult addCommand ( dia_CommandInfoUDS& cmd );
//   //!
//   virtual tDiaResult addCommands ( std::vector<dia_CommandInfoUDS*> cmds );
//   //!
//   virtual const std::vector<dia_CommandInfoUDS*>& getCommands ( void ) const { return mCommands; }
//   //!
//   virtual tDiaResult addPostProcessingCommand ( dia_CommandInfoUDS& cmd );
//   //!
//   virtual tDiaResult addPostProcessingCommands ( std::vector<dia_CommandInfoUDS*> cmds );
//   //!
//   virtual const std::vector<dia_CommandInfoUDS*>& getPostProcessingCommands ( void ) const { return mPostProcessingCommands; }

   virtual bool getFlushControlMode ( void ) const { return mNeedToDisableFlushing; }
   virtual void setFlushControlMode ( bool mode ) { mNeedToDisableFlushing = mode; }

   virtual bool getCRCCalculationMode ( void ) const { return mNeedToCalculateBlockCRC; }
   virtual void setCRCCalculationMode ( bool mode ) { mNeedToCalculateBlockCRC = mode; }

   virtual tU8 getRequestedSession ( void ) const { return mRequestedSession; }
   virtual void setRequestedSession ( tU8 sessionID ) { mRequestedSession = sessionID; }


protected:
   //! deprecated class constructor (no implementation)
   EngineFlashConfiguration ( void );
//   //! validate a run in command
//   virtual tDiaResult validateCommand ( const dia_CommandInfoUDS& cmd ) const;

protected:
   //! unique ID of the service provider engine that shall execute the commands
   dia_UID mUID;
   bool mNeedToDisableFlushing;
   bool mNeedToCalculateBlockCRC;
   tU8  mRequestedSession;
//   //! vector of run in commands (1st command is stored at index 0, etc.)
//   std::vector<dia_CommandInfoUDS*> mCommands;
//   //! vector of run in commands (1st command is stored at index 0, etc.)
//   std::vector<dia_CommandInfoUDS*> mPostProcessingCommands;
};

}

#endif /* __INCLUDED_DIA_ENGINE_CONFIGURATION_FLASH_PDX__ */

