/*
 * dia_EngineFlashConfiguration.cpp
 *
 *  Created on: 07.11.2014
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_ENGINE__
#include <common/framework/engine/dia_Engine.h>
#endif

#ifndef __INCLUDED_DIA_ENGINE_CONFIGURATION_FLASH_PDX__
#include <common/framework/engine/dia_EngineFlashConfiguration.h>
#endif

#define DIA_C_U8_DEFAULT_SESSION_ID_PROGRAMMING             ((tU8)  0x60)

namespace dia {

//-----------------------------------------------------------------------------

FlashJob::FlashJob ( enFlashJobID id, tU8 sid, tU16 did, const std::vector<tU8>& data, void* cookie )
   : mID(id), mSID(sid), mDID(did), mData(data), mCookie(cookie)
{}

//-----------------------------------------------------------------------------

FlashJob::~FlashJob ( void )
{
   mCookie = 0;
}

//-----------------------------------------------------------------------------

EngineFlashConfiguration::EngineFlashConfiguration ( void )
   : dia_EngineClientConfiguration("UNKNOWN_PDX_FLASH_ENGINE_CONFIGURATION",DIA_EN_PROTOCOL_UDS),
     mUID(0),
     mNeedToDisableFlushing(false),
     mNeedToCalculateBlockCRC(false),
     mRequestedSession(DIA_C_U8_DEFAULT_SESSION_ID_PROGRAMMING)
{}

//-----------------------------------------------------------------------------

EngineFlashConfiguration::EngineFlashConfiguration ( const std::string& name, dia_enProtocol protocol )
   : dia_EngineClientConfiguration(name, protocol),
     mUID(0),
     mNeedToDisableFlushing(false),
     mNeedToCalculateBlockCRC(false),
     mRequestedSession(DIA_C_U8_DEFAULT_SESSION_ID_PROGRAMMING)
{}

//-----------------------------------------------------------------------------

EngineFlashConfiguration::EngineFlashConfiguration ( tCString name, dia_enProtocol protocol )
   : dia_EngineClientConfiguration(name, protocol),
     mUID(0),
     mNeedToDisableFlushing(false),
     mNeedToCalculateBlockCRC(false),
     mRequestedSession(DIA_C_U8_DEFAULT_SESSION_ID_PROGRAMMING)
{}

//-----------------------------------------------------------------------------

EngineFlashConfiguration::~EngineFlashConfiguration ( void )
{}

}
