/*
 * dia_EngineClientConfiguration.h
 *
 *  Created on: 16.10.2014
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_ENGINE_CLIENT_CONFIGURATION__
#define __INCLUDED_DIA_ENGINE_CLIENT_CONFIGURATION__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_ENGINE_CONFIGURATION__
#include <common/framework/engine/dia_EngineConfiguration.h>
#endif

class dia_EngineClientConfiguration
   : public dia_EngineConfiguration
{
public:
   //! class constructor that can be used to create a default client engine configuration object
   dia_EngineClientConfiguration ( const std::string& name, dia_enProtocol protocol=DIA_EN_PROTOCOL_UDS );
   //! class constructor that can be used to create a default client engine configuration object
   dia_EngineClientConfiguration ( tCString name, dia_enProtocol protocol=DIA_EN_PROTOCOL_UDS );
   //! class destructor
   virtual ~dia_EngineClientConfiguration ( void );

   //! load the configuration information (empty default implementation, need to be overloaded if required)
   virtual tDiaResult loadConfiguration ( void );
   //! return the comunication protocol used by this configuration
   virtual dia_enProtocol getProtocol ( void ) const;
   //! link an engine object to this engine configuration
   void setEngine ( dia_Engine* pEngine );

protected:
   //! deprecated class constructor (no implementation)
   dia_EngineClientConfiguration ( void ) {}
};

#endif /* __INCLUDED_DIA_ENGINE_CLIENT_CONFIGURATION__ */
