/*
 * dia_EngineClientConfiguration.cpp
 *
 *  Created on: 01.12.2014
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_ENGINE__
#include "common/framework/engine/dia_Engine.h"
#endif

#ifndef __INCLUDED_DIA_ENGINE_CLIENT_CONFIGURATION__
#include <common/framework/engine/dia_EngineClientConfiguration.h>
#endif

//-----------------------------------------------------------------------------

dia_EngineClientConfiguration::dia_EngineClientConfiguration ( const std::string& name, dia_enProtocol protocol )
   : dia_EngineConfiguration(name.c_str(), protocol)
{
   dia::ScopeTrace trc("dia_EngineClientConfiguration::dia_EngineClientConfiguration(const std::string&,dia_enProtocol)");
}

//-----------------------------------------------------------------------------

dia_EngineClientConfiguration::dia_EngineClientConfiguration ( tCString name, dia_enProtocol protocol )
   : dia_EngineConfiguration(name, protocol)
{
   dia::ScopeTrace trc("dia_EngineClientConfiguration::dia_EngineClientConfiguration(tCString,dia_enProtocol)");
}

//-----------------------------------------------------------------------------

dia_EngineClientConfiguration::~dia_EngineClientConfiguration ( void )
{}

//-----------------------------------------------------------------------------

tDiaResult
dia_EngineClientConfiguration::loadConfiguration ( void )
{
   dia::ScopeTrace trc("dia_EngineClientConfiguration::loadConfiguration()");
   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

dia_enProtocol
dia_EngineClientConfiguration::getProtocol ( void ) const
{
   return mProtocol;
}

//-----------------------------------------------------------------------------

void
dia_EngineClientConfiguration::setEngine ( dia_Engine* pEngine )
{
   DIA_TR_INF("dia_EngineClientConfiguration::setEngine pEngine=0x%p", pEngine);
   mpEngine = pEngine;
}
