/*
 * dia_EngineClient.cpp
 *
 *  Created on: 01.12.2014
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_ENGINE_CLIENT__
#include "common/framework/engine/dia_EngineClient.h"
#endif

#ifndef __DIA_UNIT_TESTING__

#ifndef __INCLUDED_DIA_ENGINE_BODY__
#include "common/framework/engine/dia_EngineBody.h"
#endif

#endif

#ifndef __INCLUDED_DIA_ENGINE_CLIENT_CONFIGURATION__
#include "common/framework/engine/dia_EngineClientConfiguration.h"
#endif

using namespace std;

//-----------------------------------------------------------------------------

dia_EngineClient::dia_EngineClient ( const std::string& name, dia_EngineClientConfiguration& config )
   : dia_Engine(name,config),
     mAutomaticStartMode(true)
{
   dia_tclFnctTrace trc("dia_EngineClient::dia_EngineClient");
}

//-----------------------------------------------------------------------------

dia_EngineClient::dia_EngineClient ( tCString name, dia_EngineClientConfiguration& config )
   : dia_Engine(name,config),
     mAutomaticStartMode(true)
{
   dia_tclFnctTrace trc("dia_EngineClient::dia_EngineClient");
}
//-----------------------------------------------------------------------------

dia_EngineClient::~dia_EngineClient ( void )
{
}

//-----------------------------------------------------------------------------

tDiaResult
dia_EngineClient::setup ( void )
{
   dia_tclFnctTrace trc("dia_EngineClient::setup");

   tDiaResult retCode = DIA_FAILED;

   // we setup the engine object only once
   if ( mIsSetupDone )
   {
      DIA_TR_INF("### ENGINE WAS ALREADY SET UP. RETURNING... ###");
      return DIA_SUCCESS;
   }

#ifndef __DIA_UNIT_TESTING__
   // configure the engine's body (the state machine)
   if ( !mpBody || (mpBody->setup() != DIA_SUCCESS) )
   {
      DIA_TR_INF("### ENGINE HAS NO BODY (ADDR=0x%p) OR SETTING UP THE BODY HAS FAILED. RETURNING... ###",this);
      return DIA_FAILED;
   }

   DIA_TR_INF("### READING ENGINE CONFIGURATION (ENGINE ADDR=0x%p)... ###",this);

   // body was properly set up so we set up the session management now

         mIsSetupDone = TRUE;
#endif
   return retCode;
}

//-----------------------------------------------------------------------------

const dia_EngineClientConfiguration&
dia_EngineClient::getClientConfiguration ( void ) const
{
   return static_cast<const dia_EngineClientConfiguration&>(mConfig);
}

//-----------------------------------------------------------------------------

tDiaResult
dia_EngineClient::startControl ( std::vector<tArgsType>& /*args*/ )
{
   return DIA_E_NOT_IMPLEMENTED;
}

tDiaResult
dia_EngineClient::startControl ( std::vector<tArgsType>& /*args*/, bool /*automaticStartMode*/ )
{
   return DIA_E_NOT_IMPLEMENTED;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_EngineClient::stopControl ( void )
{
   return DIA_E_NOT_IMPLEMENTED;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_EngineClient::execute ( void )
{
   return DIA_E_NOT_IMPLEMENTED;
}



