/*
 * dia_EngineBody.h
 *
 *  Created on: 12.05.2012
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_ENGINE_BODY__
#define __INCLUDED_DIA_ENGINE_BODY__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_INTERFACE_TIMER_LISTENER__
#include "common/interfaces/dia_ITimerListener.h"
#endif

class dia_Engine;

class dia_EngineBody
    : public dia_ITimerListener
{
   friend class dia_Engine;

   DECL_DEPRECATED_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_EngineBody);

public:
   //! setup the state machine
   virtual tDiaResult setup ( void );

   //! overloaded method from class dia_ITimerListener
   virtual void vOnTimerElapsed ( dia_TimerID id );

protected:
   //! constructor
   dia_EngineBody ( void );
   //! deprecated constructor kept for backward campatibility
   dia_EngineBody ( /*const*/ dia_Engine& engine );
   //! destructor
   virtual ~dia_EngineBody ( void );

   virtual void setEngine ( dia_Engine* pEngine )
   {
#ifdef __DIA_UNIT_TESTING__
      DIA_TR_INF("dia_EngineBody::setEngine pEngine=0x%08X", pEngine);
#endif
      mpEngine = pEngine;
   }

protected:
   //! reference to the associated engine
   dia_Engine* mpEngine;
   //! timer object used for timeout handling
   dia_Timer oTimer;
   //! active service handler used for processing the message
};

#endif /* __INCLUDED_DIA_ENGINE_BODY__ */
