/*
 * dia_Engine.h
 *
 *  Created on: 11.04.2012
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_ENGINE__
#define __INCLUDED_DIA_ENGINE__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_ENGINE_DEFINES__
#include <common/framework/engine/dia_EngineDefs.h>
#endif

#ifndef __DIA_UNIT_TESTING__

#ifndef __INCLUDED_DIA_APPLICATION__
#include "common/framework/application/dia_Application.h"
#endif

#endif

#ifndef __INCLUDED_DIA_SERVICE_DISPATCHER__
#include "common/framework/engine/dia_ServiceDispatcher.h"
#endif

class dia_EngineConfiguration;
class dia_EngineBody;
class dia_SessionController;
class dia_Session;
class dia_ServiceHandler;
class dia_MessageBuffer;

class dia_Engine
//   : public dia_MessageHandler
{
   friend class dia_EngineBody;

   DECL_DEPRECATED_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_Engine);

public:
   //! class constructor
   dia_Engine ( const std::string& name, dia_EngineBody& body, dia_EngineConfiguration& config );
   //! class constructor
   dia_Engine ( tCString name, dia_EngineBody& body, dia_EngineConfiguration& config );
   //! deprecated class constructor kept for backward compatibility
   dia_Engine ( tCString name, dia_EngineConfiguration& config );
   //! deprecated class constructor kept for backward compatibility
   dia_Engine ( const std::string& name, dia_EngineConfiguration& config );
   //! class destructor
   virtual ~dia_Engine ( void );

   //! return the name of the engine
   virtual tCString getName ( void ) const { return mName; }
   //! return the unique identifier of the engine. the UID is the hash code of the name
   virtual dia_UID  getUID  ( void ) const { return mUID; }

   //! we use a two level construction process
   virtual tDiaResult setup ( void );
   //! we use a two level destruction process
   virtual tDiaResult shutdown ( void ) const;

   //! return true if the engine acts as a service provider that processes diagnostic services
   virtual bool isServer ( void ) const { return false; }
   //! return true if the engine acts as a controller to other engines
   virtual bool isClient ( void ) const { return false; }

   virtual void setBody ( dia_EngineBody& body ) { mpBody = &body; }

   //const
   virtual const dia_EngineConfiguration& getConfiguration ( void ) const;

   virtual bool isSetupDone ( void ) const { return (mIsSetupDone == TRUE) ? true : false; }

protected:
   //! deprecated class constructor
   dia_Engine ( void );

protected:
   //! name of the engine
   tCString mName;
   //! unique identifier of the engine object (hash code of engine name)
   dia_UID  mUID;
   //! configuration object for this engine (project specific implementation)
   const dia_EngineConfiguration& mConfig; //lint !e1725 Info: class member is a reference, but usage of default copy constructor and assignment operator is prevented
   //! engine body (encapsulates the state machine responsible for processing engine requests)
   dia_EngineBody* mpBody;
   //! flag used to indicate if setup of the engine was done
   tBool mIsSetupDone;
};

#endif /* __INCLUDED_DIA_ENGINE__ */
