/*!
 * \file       dia_DynamicLoaderPluginSystemAdapterCCA.cpp
 *
 * \brief      Plugin for the DynamicLoader to handle CCA System Adapter items
 *
 * \component  Diagnostics
 *
 * \ingroup    diaCoreDynload
 *
 * \copyright  (c) 2019 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_ASF_COMPONENT__
#include "common/framework/platform/asf/dia_ASFComponent.h"
#endif

#ifndef __INCLUDED_DIA_DYNAMIC_LOADER_PLUGIN_SYSTEMADAPTER_CCA__
#include "common/framework/dynamicloader/dia_DynamicLoaderPluginSystemAdapterCCA.h"
#endif

#ifndef __INCLUDED_DIA_DYNAMIC_LOADER_ITEM_SYSTEMADAPTER_CCA__
#include "common/framework/dynamicloader/dia_DynamicLoaderItemSystemAdapterCCA.h"
#endif

namespace dia
{

//---------------------------------------------------------------------------------------------------------------------

DynamicLoaderPluginSystemAdapterCCA::DynamicLoaderPluginSystemAdapterCCA ( std::string name )
   : DynamicLoaderPlugin(name, DynamicLoaderItemSystemAdapterCCA::getItemName())
{
   dia_tclFnctTrace oTrace("DynamicLoaderPluginSystemAdapterCCA::DynamicLoaderPluginSystemAdapterCCA");
}

//---------------------------------------------------------------------------------------------------------------------

DynamicLoaderPluginSystemAdapterCCA::~DynamicLoaderPluginSystemAdapterCCA ( void )
{}

//---------------------------------------------------------------------------------------------------------------------

tDiaResult
DynamicLoaderPluginSystemAdapterCCA::loadItem ( const DynamicLoaderItem& item )
{
   dia_tclFnctTrace oTrace("DynamicLoaderPluginSystemAdapterCCA::loadItem");

   if ( std::string(item.getName()) != DynamicLoaderItemSystemAdapterCCA::getItemName() ) return DIA_E_DYNLOAD_INVALID_ITEM_TYPE;

#if 0
   // -fno-rtti :(
   const DynamicLoaderItemSystemAdapterCCA* pSystemAdapterItem = dynamic_cast<const DynamicLoaderItemSystemAdapterCCA*>(&item);
   if (!pSystemAdapterItem)
   {
      return DIA_E_DYNLOAD_INVALID_POINTER;
   }

   return pSystemAdapterItem->createSystemAdapterFeature();
#else
   const DynamicLoaderItemSystemAdapterCCA& systemAdapterItem = (const DynamicLoaderItemSystemAdapterCCA&) item;
   return systemAdapterItem.createSystemAdapterFeature();
#endif
}


}



