/*!
 * \file       dia_DynamicLoaderPluginSystemAdapterASF.cpp
 *
 * \brief      Plugin for the DynamicLoader to handle ASF System Adapter items
 *
 * \component  Diagnostics
 *
 * \ingroup    diaCoreDynload
 *
 * \copyright  (c) 2019 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_ASF_COMPONENT__
#include "common/framework/platform/asf/dia_ASFComponent.h"
#endif

#ifndef __INCLUDED_DIA_DYNAMIC_LOADER_PLUGIN_SYSTEMADAPTER_ASF__
#include "common/framework/dynamicloader/dia_DynamicLoaderPluginSystemAdapterASF.h"
#endif

#ifndef __INCLUDED_DIA_DYNAMIC_LOADER_ITEM_SYSTEMADAPTER_ASF__
#include "common/framework/dynamicloader/dia_DynamicLoaderItemSystemAdapterASF.h"
#endif

namespace dia
{

//---------------------------------------------------------------------------------------------------------------------

DynamicLoaderPluginSystemAdapterASF::DynamicLoaderPluginSystemAdapterASF ( std::shared_ptr< dia_SystemAdapterASF > pSystemAdapter )
   : DynamicLoaderPlugin("dia_DynamicLoaderPluginSystemAdapterASF", DynamicLoaderItemSystemAdapterASF::getItemName()),
     mpSystemAdapter(pSystemAdapter)
{
   dia_tclFnctTrace oTrace("DynamicLoaderPluginSystemAdapterASF::DynamicLoaderPluginSystemAdapterASF");
}

//---------------------------------------------------------------------------------------------------------------------

DynamicLoaderPluginSystemAdapterASF::~DynamicLoaderPluginSystemAdapterASF ( void )
{}

//---------------------------------------------------------------------------------------------------------------------

tDiaResult
DynamicLoaderPluginSystemAdapterASF::loadItem ( const DynamicLoaderItem& item )
{
   dia_tclFnctTrace oTrace("DynamicLoaderPluginSystemAdapterASF::loadItem");

   if ( std::string(item.getName()) != DynamicLoaderItemSystemAdapterASF::getItemName() ) return DIA_E_DYNLOAD_INVALID_ITEM_TYPE;

#if 0
   // -fno-rtti :(
   const DynamicLoaderItemSystemAdapterASF* pSystemAdapterItem = dynamic_cast<const DynamicLoaderItemSystemAdapterASF*>(&item);
   if (!pSystemAdapterItem)
   {
      return DIA_E_DYNLOAD_INVALID_POINTER;
   }

   if (!mpSystemAdapter)
   {
      return DIA_E_INVALID_POINTER;
   }

   return pSystemAdapterItem->createSystemAdapterFeature(mpSystemAdapter);
#else
   if (!mpSystemAdapter)
   {
      return DIA_E_INVALID_POINTER;
   }

   const DynamicLoaderItemSystemAdapterASF& systemAdapterItem = (const DynamicLoaderItemSystemAdapterASF&) item;
   return systemAdapterItem.createSystemAdapterFeature(mpSystemAdapter);
#endif
}


}



