/*
 * dia_DynamicLoaderPluginServices.cpp
 *
 *  Created on: 23.02.2016
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_DYNAMIC_LOADER_PLUGIN_SERVICES__
#include <common/framework/dynamicloader/dia_DynamicLoaderPluginServices.h>
#endif

#ifndef __INCLUDED_DIA_DYNAMIC_LOADER_ITEM_SERVICE__
#include <common/framework/dynamicloader/dia_DynamicLoaderItemService.h>
#endif

#ifndef __INCLUDED_DIA_ENGINE_MANAGER__
#include <common/framework/engine/dia_EngineManager.h>
#endif

#ifndef __INCLUDED_DIA_ENGINE_SERVER__
#include <common/framework/engine/dia_EngineServer.h>
#endif

#ifndef __INCLUDED_DIA_ENGINE_SERVER_CONFIGURATION__
#include <common/framework/engine/dia_EngineServerConfiguration.h>
#endif

// our global factory
std::map<tU32, factoryMethodServiceHandler*> factoryMethodsServices;

namespace dia
{

//---------------------------------------------------------------------------------------------------------------------

DynamicLoaderPluginServices::DynamicLoaderPluginServices ( const std::string& pluginName )
   : DynamicLoaderPlugin(pluginName,DynamicLoaderItemService::getItemName())
{
   dia_tclFnctTrace oTrace("dia::DynamicLoaderPluginServices::DynamicLoaderPluginServices(const std::string&)");
}

//---------------------------------------------------------------------------------------------------------------------

DynamicLoaderPluginServices::~DynamicLoaderPluginServices ( void )
{}

//---------------------------------------------------------------------------------------------------------------------

tDiaResult
DynamicLoaderPluginServices::loadItem ( const DynamicLoaderItem& item )
{
   dia_tclFnctTrace oTrace("dia::DynamicLoaderPluginServices::loadItem(const DynamicLoaderItem&)");

   if ( std::string(item.getName()) != DynamicLoaderItemService::getItemName() ) return DIA_E_DYNLOAD_INVALID_ITEM_TYPE;

   const DynamicLoaderItemService& serviceItem = (const DynamicLoaderItemService&) item;

   dia_EngineServer* pEngine = 0;
   if ( getInstanceOfEngineManager()->queryEngineServer(serviceItem.getEngineID(),&pEngine) != DIA_SUCCESS )
   {
      DIA_TR_ERR("##### UNABLE TO RETRIEVE POINTER TO DIAGNOSIS ENGINE #####");
      return DIA_FAILED;
   }

   //! return a reference to the service provider configuration
   dia_EngineServerConfiguration& engineConfig = const_cast<dia_EngineServerConfiguration&>(pEngine->getServerConfiguration());
   engineConfig.updateSessions(serviceItem.getSessions());
   engineConfig.updateServiceInfo(serviceItem.getServiceInfo());
   engineConfig.updateServiceSubfunctionInfo(serviceItem.getServiceSubfunctionInfo());

//   engineConfig.loadServiceInfo()         const std::map<tU8,dia_ServiceAccessInfo*>& getServiceInfo ( void ) const { return mServiceRep; }
//         const std::map<tU32,dia_ServiceAccessInfo*>& ServiceSubfunctionInfo ( void ) const { return mSubFuncRep; }

   const std::list<DynamicLoaderItemService::ServiceSpecification*>& serviceSpecs = serviceItem.getServiceSpecifications();
   std::list<DynamicLoaderItemService::ServiceSpecification*>::const_iterator cIter = serviceSpecs.begin();
   for ( ; cIter != serviceSpecs.end(); ++cIter )
   {
      tU32 key = (((tU32) (*cIter)->mSID) << 16) | ((tU32) (*cIter)->mDID);
      std::map<tU32, factoryMethodServiceHandler*>::iterator serviceIter = factoryMethodsServices.find(key);

      if ( serviceIter == factoryMethodsServices.end() ) return DIA_E_DYNLOAD_ITEM_NOT_FOUND;

//      dia_EngineServer* pEngine = 0;
//      if ( getInstanceOfEngineManager()->queryEngineServer(serviceItem.getEngineID(),&pEngine) != DIA_SUCCESS )
//      {
//         DIA_TR_ERR("##### UNABLE TO RETRIEVE POINTER TO DIAGNOSIS ENGINE #####");
//         return DIA_FAILED;
//      }
//
      dia_ServiceHandler* pSrvHandler = (*(serviceIter->second))((*cIter)->mName,(*cIter)->mSID,(*cIter)->mDID);
      if ( pSrvHandler )
      {
         (void) pEngine->bAddServiceHandler(pSrvHandler);
      }
      else
      {
         DIA_TR_ERR("##### FAILED TO INSTANTIATE SERVICE HANDLER \"%s\" (SID=0x%02x, DID=0x%04x) #####",(*cIter)->mName,(*cIter)->mSID,(*cIter)->mDID);
      }
   }

   return DIA_SUCCESS;
}

}
