/*!
 * \file       dia_DynamicLoaderModule.h
 *
 * \brief      {enter brief description here}
 *
 * \details    {enter detailed description here}
 *
 * \component  {enter component name}
 *
 * \ingroup    {enter group name}
 *
 * \copyright  (c) 2015 Robert Bosch Car Multimedia
 *
 */

#ifndef __INCLUDED_DIA_DYNAMIC_LOADER_MODULE__
#define __INCLUDED_DIA_DYNAMIC_LOADER_MODULE__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#include <dlfcn.h>

namespace dia
{

class DynamicLoaderModuleManifest;

class DynamicLoaderModule
   : public dia_ObjectWithUID
{
public:
   //! constructor that passes the manifest object
   DynamicLoaderModule ( const std::string& moduleName );
   //! constructor that passes the manifest object
   DynamicLoaderModule ( DynamicLoaderModuleManifest& manifest );
   //! destructor
   virtual ~DynamicLoaderModule ( void );

   virtual tDiaResult open ( const char* path = 0 );
   virtual tDiaResult close ( void );

   virtual void* loadSymbol ( const char* symbolName );

   template<typename _T> tDiaResult loadSymbol ( const char* symbolName, _T* pObject );
//   template<class _T> tDiaResult loadSymbol ( const char* symbolName, _T** pObject );

   //void *dlsym(void *handle, const char *symbol);

   const DynamicLoaderModuleManifest* getManifest ( void ) { return mpManifest; }

   bool isOpen() const { return mIsOpen; }

protected:
   //! constructor without implementation
   DynamicLoaderModule ( void );

protected:
   //! manifest information to be used for this module
   DynamicLoaderModuleManifest* mpManifest;
   //! handle for the dynamic library
   void* mpModuleHandle;
   //! flag used to indicate if the module is opened
   bool mIsOpen;
};

//---------------------------------------------------------------------------------------------------------------------

template<typename _T>
tDiaResult
DynamicLoaderModule::loadSymbol ( const char* symbolName, _T* pFunction /*Object*/ )
{
   dia_tclFnctTrace oTrace("DynamicLoaderModule::loadSymbol()");

   if ( !mpModuleHandle ) return DIA_E_DYNLOAD_INVALID_HANDLE;
   if ( !pFunction ) return DIA_E_DYNLOAD_INVALID_POINTER;

   DIA_TR_INF("##### DIA_DYNLOAD: LOADING SYMBOL ('%s') ...", symbolName);

   void* pSymbol = dlsym(mpModuleHandle,symbolName);
   if ( !pSymbol )
   {
      DIA_TR_ERR("##### DIA_DYNLOAD: LOADING FAILED !!");
      DIA_TR_ERR("'%s')", dlerror());
      return DIA_E_DYNLOAD_INVALID_SYMBOL;
   }

   *pFunction = (_T) /*static_cast<_T>*/ (pSymbol);

   return DIA_SUCCESS;
}

//      pFactory = (tDiaResult (*)(const dia_MessageBuffer&, dia_EngineServer&))(dlsym(pModuleHandle, "dia_CreateServiceHandlerProduction")); //lint !e611: Suspicious cast - This is intended & not an error
//      if (pFactory)
//      {
//         res = pFactory(request, *pEngine);

//#define DIA_E_DYNLOAD_MANIFEST_NOT_AVAILABLE                ((tU32) 0x00010B00)
//#define DIA_E_DYNLOAD_HANDLE_INVALID                        ((tU32) 0x00010B01)
//#define DIA_E_DYNLOAD_OPEN_FAILED                           ((tU32) 0x00010B02)
//#define DIA_E_DYNLOAD_CLOSE_FAILED                          ((tU32) 0x00010B03)

//void *dlsym(void *handle, const char *symbol);

//template<class _T> tDiaResult
//dia_SystemAdapterFacade::queryInterface ( _T** pInterface )
//{
//    tDiaResult retCode = DIA_FAILED;
//
//    if ( pInterface )
//    {
//        *pInterface = static_cast<_T*>(mInterfaceRep[_T::getUID()]);
//
//        if ( *pInterface )
//        {
//            retCode = DIA_SUCCESS;
//        }
//        else
//        {
//            retCode = DIA_E_INTERFACE_ID_MISMATCH;
//        }
//    }
//
//    return retCode;
//}

}

#endif /* __INCLUDED_DIA_DYNAMIC_LOADER_MODULE__ */
