/*!
 * \file       dia_DynamicLoaderItemSystemAdapterCCA.h
 *
 * \brief      Item for the DynamicLoader to create a CCA System Adapter
 *
 * \component  Diagnostics
 *
 * \ingroup    diaCoreDynload
 *
 * \copyright  (c) 2019 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_DYNAMIC_LOADER_ITEM_SYSTEMADAPTER_CCA__
#define __INCLUDED_DIA_DYNAMIC_LOADER_ITEM_SYSTEMADAPTER_CCA__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_DYNAMIC_LOADER_ITEM__
#include <common/framework/dynamicloader/dia_DynamicLoaderItem.h>
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_SERVICE_PLUGIN__
#include <common/framework/sysadapters/dia_SystemAdapterServicePlugin.h>
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_SERVICE_PLUGIN_DIAGLIB__
#include <common/framework/sysadapters/dia_SystemAdapterServicePluginDiaglib.h>
#endif


namespace dia
{

class DynamicLoaderItemSystemAdapterCCA
   : public DynamicLoaderItem
{
public:
   //! constructor
   DynamicLoaderItemSystemAdapterCCA ( dia_SystemAdapterServicePlugin* pServicePlugin, const std::function<tDiaResult( void )>& pSystemAdapterFeatureCreation );
   //! destructor
   virtual ~DynamicLoaderItemSystemAdapterCCA ( void );

   static const std::string& getItemName ( void ) { return mNameOfDynamicLoaderItemSystemAdapterCCA; }

   virtual tDiaResult createSystemAdapterFeature ( void ) const
   {
      return mpSystemAdapterFeatureCreation();
   }

protected:
   //! constructor without implementation
   DynamicLoaderItemSystemAdapterCCA ( void );
   //! generic way of creating a CCA SystemAdapterFeature
   template<class SystemAdapterFeature> SystemAdapterFeature* createSystemAdapterFeature(const std::string& featureName);
   //! generic way of creating a CCA Diaglib SystemAdapterFeature
   template<class SystemAdapterFeature> SystemAdapterFeature* createSystemAdapterFeatureDiaglib(const std::string& featureName);

protected:
   //! type name
   static std::string mNameOfDynamicLoaderItemSystemAdapterCCA;
   //! CCA SystemAdapter Service Plugin
   dia_SystemAdapterServicePlugin* mpSystemAdapterServicePlugin;
   //! SystemAdapterFeature creation
   std::function<tDiaResult( void )> mpSystemAdapterFeatureCreation;
};

//-----------------------------------------------------------------------------

template<class SystemAdapterFeature>
SystemAdapterFeature* DynamicLoaderItemSystemAdapterCCA::createSystemAdapterFeature(const std::string& featureName)
{
   SystemAdapterFeature* pSAFeature = nullptr;

   if (mpSystemAdapterServicePlugin)
   {
      pSAFeature = new SystemAdapterFeature(featureName.c_str(), *mpSystemAdapterServicePlugin);
      if ( pSAFeature )
      {
         mpSystemAdapterServicePlugin->addFeature(*pSAFeature);
      }
   }

   return pSAFeature;
}

//-----------------------------------------------------------------------------

template<class SystemAdapterFeature>
SystemAdapterFeature* DynamicLoaderItemSystemAdapterCCA::createSystemAdapterFeatureDiaglib(const std::string& featureName)
{
   SystemAdapterFeature* pSAFeature = nullptr;

   dia_SystemAdapterServicePluginDiaglib* pSystemAdapterServicePluginDiaglib =
         dynamic_cast<dia_SystemAdapterServicePluginDiaglib*>(mpSystemAdapterServicePlugin);

   if (pSystemAdapterServicePluginDiaglib)
   {
      pSAFeature = new SystemAdapterFeature(featureName.c_str(), *pSystemAdapterServicePluginDiaglib);
      if ( pSAFeature )
      {
         pSystemAdapterServicePluginDiaglib->addFeature(*pSAFeature);
      }
   }

   return pSAFeature;
}

}

#endif /* __INCLUDED_DIA_DYNAMIC_LOADER_ITEM_SYSTEMADAPTER_CCA__ */

