/*!
 * \file       dia_DynamicLoaderItemSystemAdapterASF.cpp
 *
 * \brief      Item for the DynamicLoader to create an ASF System Adapter
 *
 * \component  Diagnostics
 *
 * \ingroup    diaCoreDynload
 *
 * \copyright  (c) 2019 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_DYNAMIC_LOADER_ITEM_SYSTEMADAPTER_ASF__
#include "common/framework/dynamicloader/dia_DynamicLoaderItemSystemAdapterASF.h"
#endif

namespace dia
{

std::string
DynamicLoaderItemSystemAdapterASF::mNameOfDynamicLoaderItemSystemAdapterASF("__DYNLOADER_ITEM_SYSTEMADAPTER_ASF__");

//---------------------------------------------------------------------------------------------------------------------

DynamicLoaderItemSystemAdapterASF::DynamicLoaderItemSystemAdapterASF ( const std::function<tDiaResult( std::shared_ptr<dia_SystemAdapterASF> )>& pSystemAdapterFeatureCreation )
   : DynamicLoaderItem(mNameOfDynamicLoaderItemSystemAdapterASF),
     mpSystemAdapterFeatureCreation(pSystemAdapterFeatureCreation)
{
//   dia_tclFnctTrace oTrace("DynamicLoaderItemSystemAdapterASF::DynamicLoaderItemSystemAdapterASF()");
}

//---------------------------------------------------------------------------------------------------------------------

DynamicLoaderItemSystemAdapterASF::~DynamicLoaderItemSystemAdapterASF ( void )
{}


}


