/*
 * dia_DynamicLoaderItemService.h
 *
 *  Created on: 24.02.2016
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_DYNAMIC_LOADER_ITEM_SERVICE__
#define __INCLUDED_DIA_DYNAMIC_LOADER_ITEM_SERVICE__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_ENGINE_SERVER_CONFIGURATION__
#include "common/framework/engine/dia_EngineServerConfiguration.h"
#endif

#ifndef __INCLUDED_DIA_DYNAMIC_LOADER_ITEM__
#include <common/framework/dynamicloader/dia_DynamicLoaderItem.h>
#endif

namespace dia
{

class DynamicLoaderItemService
   : public DynamicLoaderItem //,
//     public dia_EngineServerConfiguration
{
public:
   struct ServiceDataItem
   {
      //! service identifier
      tU8  mSID;
      //! diagnostic data identifier
      tU16 mDID;
      //! length of the DID
      tU16 mDIDLen;
      //! run level information
      tU8  mRunLevel;
      //! supported sessions
      tU8  mSupportedSessions[DIA_C_U16_MAX_SESSION_PER_ENGINE];
      //! supported security levels
      dia_UID  mSupportedSecurityLevels[DIA_C_U16_MAX_SECURITY_LEVELS_PER_ENGINE];
   };

   struct ServiceInfo
   {
      //! service identifier
      tU8  mSID;
      //! diagnostic data identifier
      tU8  mAccessInfo;
      //! length of the DID
      tU16 mDIDLen;
      //! supported sessions
      tU8  mSupportedSessions[DIA_C_U16_MAX_SESSION_PER_ENGINE];
      //! supported security levels
      dia_UID  mSupportedSecurityLevels[DIA_C_U16_MAX_SECURITY_LEVELS_PER_ENGINE];
   };

   struct ServiceSpecification
   {
      ServiceSpecification ( tCString name, tU8 SID, tU16 DID ) : mName(name),mSID(SID),mDID(DID) {}
      //! name
      tCString mName;
      //! service identifier
      tU8  mSID;
      //! length of the DID
      tU16 mDID;
   };

public:
   //! constructor that passes the manifest object
   DynamicLoaderItemService ( /*tU8 serviceID, tU16 subfuncID, tU16 subfuncLen, std::vector<tU8>& sessions, std::vector<tU8>& levels,*/ dia_UID engineID );
   //! destructor
   virtual ~DynamicLoaderItemService ( void );

//   virtual tU8 getServiceID ( void ) const { return mServiceID; }
   virtual dia_UID getEngineID ( void ) const { return mEngineID; }

   static const std::string& getItemName ( void ) { return mNameOfDynamicLoaderServiceItem; }

   //! load information about supported services
   tDiaResult loadSessions ( const std::vector<tU8>& /*supportedSessions*/ ); // { return DIA_E_NOT_IMPLEMENTED; }
   //! load information about the supported diagnostic services like SessionControl, ECUReset, ...
   tDiaResult loadServiceInfo ( const std::vector<ServiceInfo>&  /*srvInfo*/ ); // { return DIA_E_NOT_IMPLEMENTED; }
   //! load information about the supported subfunctions of supported diagnostic services
   tDiaResult loadServiceInfo ( const std::vector<ServiceDataItem>& /*srvDataInfo*/ ); // { return DIA_E_NOT_IMPLEMENTED; }

   tDiaResult addServiceSpecification ( tCString name, tU8 SID, tU16 DID );

   const std::list<ServiceSpecification*>& getServiceSpecifications ( void ) const { return mServiceSpecs; }
   const std::vector<tU8>& getSessions ( void ) const { return mSupportedSessions; }
   const std::map<tU8,dia_ServiceAccessInfo*>& getServiceInfo ( void ) const { return mServiceRep; }
   const std::map<tU32, std::map<tU32,::boost::shared_ptr<dia_ServiceAccessInfo> > >& getServiceSubfunctionInfo ( void ) const { return mSubFuncRep; }

protected:
   //! constructor without implementation
   DynamicLoaderItemService ( void );

protected:
   //! type name
   static std::string mNameOfDynamicLoaderServiceItem;

   //   tU8 mServiceID;
//   //! diagnostic subfunction/DID
//   tU16 mSubfunctionID;
//   //! diagnostic subfunction length in bytes
//   tU16 mSubfunctionLength;
   //! engine identifier
   dia_UID mEngineID;

   //! supported sessions
   std::vector<tU8> mSupportedSessions;
   // map that provides access information on service level
   std::map<tU8,dia_ServiceAccessInfo*>  mServiceRep;
   // map that provides access information on subfunction level
   std::map<tU32, std::map<tU32,::boost::shared_ptr<dia_ServiceAccessInfo> > > mSubFuncRep;
   //! diagnostic service identifier
   std::list<ServiceSpecification*> mServiceSpecs;

};

}

#endif /* __INCLUDED_DIA_DYNAMIC_LOADER_ITEM_SERVICE__ */
