/*
 * dia_DynamicLoaderItemService.cpp
 *
 *  Created on: 24.02.2016
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_DYNAMIC_LOADER_ITEM_SERVICE__
#include <common/framework/dynamicloader/dia_DynamicLoaderItemService.h>
#endif

#ifndef __INCLUDED_DIA_SERVICE_ACCESS_INFO__
#include <common/framework/engine/dia_ServiceAccessInfo.h>
#endif

#ifndef __INCLUDED_DIA_SECURITY__
#include <common/framework/security/dia_security.h>
#endif

namespace dia
{

std::string
DynamicLoaderItemService::mNameOfDynamicLoaderServiceItem("__DYNLOADER_ITEM_SERVICES__");

//---------------------------------------------------------------------------------------------------------------------

DynamicLoaderItemService::DynamicLoaderItemService ( dia_UID engineID )
   : DynamicLoaderItem(mNameOfDynamicLoaderServiceItem /*"__DYNLOADER_ITEM_SESSION__"*/),
//   mSessionID(sessionID),
     mEngineID(engineID)
{
//   dia_tclFnctTrace oTrace("DynamicLoaderItemSession::DynamicLoaderItemSession(const std::string&)");
}

//---------------------------------------------------------------------------------------------------------------------

DynamicLoaderItemService::~DynamicLoaderItemService ( void )
{
   _BP_TRY_BEGIN
   {
      DIA_IMPL_LIST_REPOSITORY_TEAR_DOWN(ServiceSpecification,mServiceSpecs)
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR("EXCEPTION CAUGHT: DynamicLoaderItemService::~DynamicLoaderItemService !!!");
      DIA_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}

//-----------------------------------------------------------------------------

tDiaResult
DynamicLoaderItemService::loadSessions ( const std::vector<tU8>& supportedSessions )
{
   dia_tclFnctTrace trc("dia::DynamicLoaderItemService::loadSessions()");
   mSupportedSessions = supportedSessions;
   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult
DynamicLoaderItemService::loadServiceInfo ( const std::vector<ServiceInfo>& srvInfoRep )
{
   dia_tclFnctTrace trc("dia::DynamicLoaderItemService::loadServiceInfo()");

   // Add each row of allowed sessions to the AccessControl object
   for ( tU16 i=0; i < srvInfoRep.size(); i++ )
   {
      const ServiceInfo& item = srvInfoRep[i];

      if ( item.mAccessInfo != DIA_C_U8_UDS_SERVICE_NOT_SUPPORTED )
      {
         // Create a vector of the allowed sessions.
         std::vector<tU8> sessions;
         for ( tU16 j=0; j<DIA_C_U16_MAX_SESSION_PER_ENGINE; j++ ) {
            if ( item.mSupportedSessions[j] != 0x00 ) {
               sessions.push_back(item.mSupportedSessions[j]);
            }
         }

         // Create a vector of the allowed security levels
         std::vector<dia_UID> secLevels;
         for ( tU16 k=0; k<DIA_C_U16_MAX_SECURITY_LEVELS_PER_ENGINE; k++ ) {
            secLevels.push_back(item.mSupportedSecurityLevels[k]);
         }

         // create the data item
         dia_ServiceAccessInfo* pAccessInfoItem = OSAL_NEW dia_ServiceAccessInfo(item.mSID,(tU8) item.mDIDLen,sessions,secLevels);

         if ( pAccessInfoItem )
         {
            pAccessInfoItem->setSupportMode(item.mAccessInfo);
            // add the new info item to the lookup table
            mServiceRep[item.mSID] = pAccessInfoItem;
         }
         else
         {
            //tbd
         }
      }
   }

   return DIA_SUCCESS;
}

//------------------------------------------------------------------------------

tDiaResult
DynamicLoaderItemService::loadServiceInfo ( const std::vector<ServiceDataItem>& srvDataRep )
{
   dia_tclFnctTrace trc("dia::DynamicLoaderItemService::loadServiceInfo()");

   // Add each row of allowed sessions to the AccessControl object
   for ( tU16 i=0; i < srvDataRep.size(); i++ )
   {
      const ServiceDataItem& item = srvDataRep[i];

      // Create a vector of the allowed sessions.
      std::vector<tU8> sessions;
      for ( tU16 j=0; j<DIA_C_U16_MAX_SESSION_PER_ENGINE; j++ ) {
         if ( item.mSupportedSessions[j] != 0x00 ) {
            sessions.push_back(item.mSupportedSessions[j]);
         }
      }

      // Create a vector of the allowed security levels
      std::vector<dia_UID> secLevels;
      for ( tU16 k=0; k<DIA_C_U16_MAX_SECURITY_LEVELS_PER_ENGINE; k++ ) {
         if ( item.mSupportedSecurityLevels[k] != DIA_UID_SECURITY_LEVEL_UNKNOWN ) {
            secLevels.push_back(item.mSupportedSecurityLevels[k]);
         }
      }

      // create the data item
      ::boost::shared_ptr<dia_ServiceAccessInfo> pAccessDataItem(OSAL_NEW dia_ServiceAccessInfo(item.mSID,item.mDID,(tU8) item.mDIDLen,item.mRunLevel,sessions,secLevels));

      if ( pAccessDataItem )
      {
         tU32 key = (pAccessDataItem->getServiceID() << 16) | pAccessDataItem->getSubFunctionID();

         if ( mSubFuncRep.find(key) == mSubFuncRep.end() )
         {
            // iterate over all sessions configured for the given service access info item
            std::vector<tU8>::const_iterator sessionIter = sessions.begin();
            for ( ; sessionIter != sessions.end(); ++sessionIter )
            {
               (mSubFuncRep[key])[*sessionIter] = pAccessDataItem;
            }
         }
         else
         {
            // iterate over all sessions configured for the given service access info item
            std::vector<tU8>::const_iterator sessionIter = sessions.begin();
            for ( ; sessionIter != sessions.end(); ++sessionIter )
            {
               if ( mSubFuncRep[key].find(*sessionIter) != mSubFuncRep[key].end() )
               {
                  // an entry for the given session already exists and must be replaced
                  (mSubFuncRep[key]).erase(*sessionIter);
               }

               (mSubFuncRep[key])[*sessionIter] = pAccessDataItem;
            }
         }
//         tU32 key = (item.mSID << 16) | item.mDID;
//         // add the new info item to the lookup table
//         mSubFuncRep[key] = pAccessDataItem;
      }
      else
      {
         //tbd
      }
   }

   return DIA_SUCCESS;
}

tDiaResult
DynamicLoaderItemService::addServiceSpecification ( tCString name, tU8 SID, tU16 DID )
{
   dia_tclFnctTrace trc("dia::DynamicLoaderItemService::loadServiceInfo()");

   ServiceSpecification* pSpec = new ServiceSpecification(name,SID,DID);
   mServiceSpecs.push_back(pSpec);
   return DIA_SUCCESS;  //lint !e429: custodial pointer is stored in list and is freed in destructor
} //lint !e429: custodial pointer is stored in list and is freed in destructor

}
