

//#ifndef __INCLUDED_DIA_APPCONTROLLER__
//#include <common/framework/application/dia_AppController.h>
//#endif

//#ifndef __INCLUDED_DIA_THREAD_MONITOR__
//#include "common/framework/application/dia_ThreadMonitor.h"
//#endif

#ifndef __INCLUDED_DIA_DATALOGGERREQUEST__
#include <common/framework/datalogger/dia_DataLoggerRequest.h>
#endif


static tCString strEventName = "DATALOGGER_REQUEST_EV";
static tCString strThreadName = "DATALOGGER_REQUEST_THR";


#define DIA_DATALOGGER_REQUEST_EVENT_SHUTDOWN_THREAD  0x00000001
#define DIA_DATALOGGER_REQUEST_EVENT_TIMER            0x00000002

#define DIA_DATALOGGER_REQUEST_EVENT_MASK  (\
      DIA_DATALOGGER_REQUEST_EVENT_SHUTDOWN_THREAD |\
      DIA_DATALOGGER_REQUEST_EVENT_TIMER \
      )


dia_DataLoggerRequest::dia_DataLoggerRequest()
   : dia_ActiveObject(strThreadName),
     m_hEvent(OSAL_C_INVALID_HANDLE)
{
   dia_Timer::s32Create();

   tS32 s32Result = OSAL_s32EventCreate(strEventName, &m_hEvent);
   if(OSAL_ERROR == s32Result)
   {
       m_hEvent = OSAL_C_INVALID_HANDLE;
       DIA_TR_ERR("dia_DataLoggerRequest::dia_DataLoggerRequest - Event creation FAILED!");
       DIA_ASSERT_ALWAYS();
   }

   startThread();
}

dia_DataLoggerRequest::~dia_DataLoggerRequest()
{
   _BP_TRY_BEGIN
   {
      dia_Timer::s32Delete();
   }
   _BP_CATCH_ALL
   {

   }
   _BP_CATCH_END
}

void dia_DataLoggerRequest::vOnAlarm( void )
{
   if ( m_hEvent != OSAL_C_INVALID_HANDLE )
   {
      tS32 s32Result = OSAL_s32EventPost(m_hEvent, DIA_DATALOGGER_REQUEST_EVENT_TIMER, OSAL_EN_EVENTMASK_OR);
      NORMAL_M_ASSERT(OSAL_ERROR != s32Result);
   }
   else
   {
     DIA_ASSERT_ALWAYS();
   }
}

void dia_DataLoggerRequest::vThreadEntrypointObject ( void )
{
   OSAL_tEventMask hEvRequest = 0;
   tU32 u32Mask = DIA_DATALOGGER_REQUEST_EVENT_MASK;
   tBool bIsDone = FALSE;

   while ( !bIsDone )
   {
      NORMAL_M_ASSERT(OSAL_C_INVALID_HANDLE != m_hEvent);

      tS32 s32result = OSAL_s32EventWait (
            m_hEvent,
            u32Mask,
            OSAL_EN_EVENTMASK_OR,
            OSAL_C_TIMEOUT_FOREVER,
            &hEvRequest
      );

      if( OSAL_OK != s32result )
      {
         DIA_TR_INF("dia_DataLoggerRequest::vThreadEntrypointObject - EventWait returned 0x%x!", s32result);
         break;
      }

      if ( m_hEvent != OSAL_C_INVALID_HANDLE )
      {
         DIA_TR_INF("dia_DataLoggerRequest::vThreadEntrypointObject - Event Received: 0x%x", (tU32)hEvRequest);

         if ( OSAL_s32EventPost(m_hEvent, ~hEvRequest, OSAL_EN_EVENTMASK_AND) != OSAL_OK)
         {
            DIA_ASSERT_ALWAYS();
         }

         if (hEvRequest & DIA_DATALOGGER_REQUEST_EVENT_SHUTDOWN_THREAD)
         {
            bIsDone = TRUE;
         }

         if (hEvRequest & DIA_DATALOGGER_REQUEST_EVENT_TIMER)
         {
            this->storeData();
         }
      }
   }

   OSAL_vThreadExit();
}


