#ifndef __INCLUDED_DIA_DATALOGGERRECORD__
#define __INCLUDED_DIA_DATALOGGERRECORD__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_IDATALOGGERRECORD__
#include "common/interfaces/dia_IDataLoggerRecord.h"
#endif

#ifndef __INCLUDED_DIA_IDATALOGGERITEM__
#include "common/interfaces/dia_IDataLoggerItem.h"
#endif

namespace dia
{

template<typename T>
struct delete_ptr
{
   void operator()(T* p)
   {
      delete p;
   }
};

}

using namespace dia;

class dia_DataLoggerRecord : public dia_IDataLoggerRecord
{
private:
   timespec timestamp;
   std::vector<std::vector<tU8> > itemData;
   std::vector<boost::shared_ptr<dia_IDataLoggerItem> > logItems;
private:
   void copyAllItems(dia_DataLoggerRecord const& src);
   void removeAllItems();
public:
   dia_DataLoggerRecord();
   dia_DataLoggerRecord(dia_DataLoggerRecord const& src);
   virtual ~dia_DataLoggerRecord() ;
   dia_DataLoggerRecord& operator=(dia_DataLoggerRecord const& src);
   timespec getTimestamp() const {return this->timestamp;}
   virtual size_t addItem(boost::shared_ptr<dia_IDataLoggerItem> item);
   virtual std::vector<tU8> const& getItemData(size_t handle) const;
   virtual std::vector<boost::shared_ptr<dia_IDataLoggerItem> > const& items() const {return this->logItems;}
   virtual void update();
};

#endif
