#ifndef __INCLUDED_DIA_MAIN__
#include "common/depricated/dia_main.h"
#endif

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_EVENT_THREAD__
#include "common/framework/application/dia_EventThread.h"
#endif

#ifndef __INCLUDED_DIA_DATALOGGER__
#include "common/framework/datalogger/dia_DataLogger.h"
#endif

#ifndef __INCLUDED_DIA_LOCK_SCOPE__
#include "common/framework/application/dia_LockScope.h"
#endif

dia_DataLogger*
getInstanceOfDataLogger ( void )
{
   return dia_DataLogger::getInstance();
}

void
releaseInstanceOfDataLogger ( void )
{
   dia_DataLogger::deleteInstance();
}


DIA_IMPL_SINGLETON(dia_DataLogger)

dia_DataLogger::dia_DataLogger() :
   syncObj("dia_DataLogger_LK")
{
   dia_tclFnctTrace oTrace("dia_DataLogger::dia_DataLogger");
   this->logTimer.addTimerListener(this);
   this->logTimer.s32Create();
   this->logTimerID = this->logTimer.getID();

}

dia_DataLogger::~dia_DataLogger()
{
   _BP_TRY_BEGIN
   {
      this->logTimer.s32Delete();
      this->logTimer.removeTimerListener(this);
   }
   _BP_CATCH_ALL
   {

   }
   _BP_CATCH_END
}

void dia_DataLogger::startLogging()
{
   dia_tclFnctTrace oTrace("dia_DataLogger::startLogging");
   this->logTimer.s32SetTime(static_cast<tU32>(dia_DataLogger::resolution), static_cast<tU32>(dia_DataLogger::resolution));
}

void dia_DataLogger::stopLogging()
{
   this->logTimer.s32SetTime(0,0);
}

void dia_DataLogger::sample()
{
   dia_LockScope lock(this->syncObj);

   this->currentData.update();
   dia_DataLoggerRecord* pRec = 0;
   if(this->q.size() == maxSize)
   {
      pRec = this->q.front();
      this->q.pop_front();
      *pRec = this->currentData;
   }
   else
   {
      pRec = new dia_DataLoggerRecord(this->currentData);
   }
   this->q.push_back(pRec);
} //lint !e429: custodial pointer is freed when the list is full or by destroy function

size_t dia_DataLogger::addLoggedItem(boost::shared_ptr<dia_IDataLoggerItem> pItem)
{
   return currentData.addItem(pItem);
}

void dia_DataLogger::getCurrentRecord(dia_DataLoggerRecord& dlr) const
{
   dia_LockScope lock(this->syncObj);
   dlr = this->currentData;
}

void dia_DataLogger::getData(dia_DataLoggerRecord& dlr, tS32 offset) const
{
   dia_tclFnctTrace oTrace("dia_DataLogger::getData");
   dia_LockScope lock(this->syncObj);
   if(0 == this->q.size())
   {
      return;
   }
   if(offset < dia_DataLogger::historyPeriod)
   {
      return;
   }
   if(offset > dia_DataLogger::futurePeriod)
   {
      return;
   }
   // it can be that the max number of records is not yet reached
   tS32 recIndex = calcRecIndex((tS32)this->q.size(), offset);
   dlr = *this->q[recIndex];
}

tS32 dia_DataLogger::calcRecIndex(tS32 size, tS32 offset)
{
   tS32 recIndex = (offset - dia_DataLogger::historyPeriod) / dia_DataLogger::resolution;
   recIndex = std::max(0, size - (dia_DataLogger::maxSize - recIndex));
   return recIndex;
}

void dia_DataLogger::vOnTimerElapsed(dia_TimerID id)
{
   //dia_tclFnctTrace oTrace("dia_DataLogger::vOnTimerElapsed");
   tU32 timerID = (tU32) id;

   if ( timerID == this->logTimerID )
   {
      dia_EventThread* pEventThread = getInstanceOfdiaEventThread();
      if ( pEventThread ) 
      {
         pEventThread->bPostEvent(DIA_EVENT_LOG_DATA);
      }
   }
}

