/*!
 * \file       dia_UploadDownloadStrategyDatasets.h
 *
 * \brief      Abstract upload and download strategy used for service $34 (RequestDownload) and $35 (RequestUpload)
 *
 * \details    Abstract upload and download strategy used for service $34 (RequestDownload) and $35 (RequestUpload)
 *
 * \component  Diagnostics
 *
 * \ingroup    diaCoreUploadDownload
 *
 * \copyright  (c) 2012-2017 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_UPLOAD_DOWNLOAD_STRATEGY_DATASETS__
#define __INCLUDED_DIA_UPLOAD_DOWNLOAD_STRATEGY_DATASETS__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_UPLOAD_DOWNLOAD_STRATEGY__
#include <common/framework/datadownload/dia_UploadDownloadStrategy.h>
#endif

#ifndef __INCLUDED_DIA_DATADOWNLOADFSM__
#include <common/framework/fsm/generated/dia_DataDownloadFSM.h>
#endif

#ifndef __INCLUDED_DIA_DATASET__
#include <common/framework/datadownload/dia_Dataset.h>
#endif

// for backward compatibility
#define dia_DataDownloadStrategy dia::UploadDownloadStrategyDatasets

namespace dia {

class UploadDownloadStrategyDatasets
   : public UploadDownloadStrategy,
     protected dia_DataDownloadFSM::FsmBehaviour,
     protected dia_Dataset::ICallback
{
   DECL_DEPRECATED_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(UploadDownloadStrategyDatasets);
public:
   //! class constructor
   UploadDownloadStrategyDatasets ( const std::string& name, tU8 fmtID, tU8 addrFmt );
   //! class constructor
   UploadDownloadStrategyDatasets ( const char* name, tU8 fmtID, tU8 addrFmtID );
   //! class destructor
   virtual ~UploadDownloadStrategyDatasets ( void );

   virtual tU32 getID ( void );

   virtual tDiaResult requestDownload ( std::vector<tU8>& requestData ) = 0;
   virtual tDiaResult requestFileTransfer ( std::vector<tU8>& /*requestData*/ ) { return DIA_E_NOT_SUPPORTED; }
   virtual tDiaResult requestUpload ( std::vector<tU8>& requestData ) = 0;
   virtual tDiaResult transferData ( std::vector<tU8>& requestData, std::vector<tU8>& responseData ) = 0;
   virtual tDiaResult transferExit ( std::vector<tU8>& requestData ) = 0;

protected:
   //! deprecated default class constructor
   UploadDownloadStrategyDatasets ( void );

   tDiaResult triggerDownload ( void );
   tDiaResult triggerUpload ( void );
   void triggerReset ( void );

   // FSM actions
   virtual void sendErr_InvalidAddress ( void* pArg );
   virtual void sendErr_InvalidLength ( void* pArg );
   virtual void sendErr_InvalidFormat ( void* pArg );
   virtual void sendErr_AlreadyRequested ( void* pArg );
   virtual void sendErr_InvalidData ( void* pArg );
   virtual void sendErr_InvalidSequence ( void* pArg );
   virtual void sendErr_TransExitInvalidData ( void* /*pArg*/ );
   virtual void validateDownloadRequest ( void* pArg );
   virtual void validateUploadRequest ( void* pArg );
   virtual void prepareDownload ( void* pArg );
   virtual void prepareUpload ( void* pArg );
   virtual void postprocessDownload ( void* pArg );
   virtual void postprocessUpload ( void* pArg );
   virtual void sendReqDownloadResponse ( void* pArg );
   virtual void sendReqUploadResponse ( void* pArg );
   virtual void setDownloadActivated ( void* pArg );
   virtual void setUploadActivated ( void* pArg );
   virtual void saveDataset ( void* pArg );
   virtual void sendTransExitResponse ( void* pArg );
   virtual void checkForCompletion ( void* pArg );
   virtual void validateTransferredData ( void* pArg );
   virtual void calcCrcRam ( void* pArg );
   virtual void downloadData ( void* pArg );
   virtual void sendDownloadTransferDataResponse ( void* pArg );
   virtual void sendUploadTransferDataResponse ( void* pArg );
   virtual void retransmitTransferDataResponse ( void* pArg );
   virtual void reset ( void* pArg );
   virtual void uploadData ( void* pArg );

   // FSM guards
   virtual bool isCrcOk ( void* pArg );
   virtual bool isRetransmission ( void* pArg );
   virtual bool isDataValid ( void* pArg );
   virtual bool areDownloadConditionsOk ( void* pArg );
   virtual bool areUploadConditionsOk ( void* pArg );

   //! Callbacks of dia_Dataset
   virtual void onInitializeDataDownload( void ) override;
   virtual void onFinalizeDataDownload( void ) override;

protected:
   //! format identifier (encryption, compression, ...)
   tU8 mFormatIdentifier;
   //! address format identifier
   tU8 mAddressFormatIdentifier;

   //! pointer to the FSM object
   dia_DataDownloadFSM::Fsm* mpFSM;
   //! error code
   tDiaResult mErrorCode;
   //! flag to indicate if the CRC check was ok
   bool mIsCrcOk;
   //! flag to indicate if the received data is valid
   bool mIsDataValid;
   //! start address of the requested dataset
   tU32 mRequestedStartAddress;
   //! memory size of the requested data set
   tU32 mRequestedMemSize;
   //! pointer to the dataset object used for the current download request
   dia_Dataset* mRequestedDataset;
};

}

#endif /* __INCLUDED_DIA_UPLOAD_DOWNLOAD_STRATEGY_DATASETS__ */
