/*!
 * \file       dia_defsConfig.h
 *
 * \brief      This file is used to define common properties
 *
 * \details    This file is used to define common properties
 *
 * \component  Diagnosis
 *
 * \ingroup    diaCoreConfig
 *
 * \copyright  (c) 2012-2016 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_DEFS_CONFIG__
#define __INCLUDED_DIA_DEFS_CONFIG__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#define DIA_C_IID_CONFMGR_ADC                                  ((dia::IID) 0x1c16a25c)
#define DIA_C_IID_CONFMGR_UNKNOWN                              ((dia::IID) 0x00000000)
#define DIA_C_IID_CONFMGR_DATAPOOL                             ((dia::IID) 0xde6a6888)
#define DIA_C_IID_CONFMGR_FILE_SWITCH                          ((dia::IID) 0x3c3c7985)
#define DIA_C_IID_CONFMGR_GPIO                                 ((dia::IID) 0x9eee6c43)
#define DIA_C_IID_CONFMGR_KDS                                  ((dia::IID) 0x1c16ccf6)
#define DIA_C_IID_CONFMGR_KDS_VARLEN                           ((dia::IID) 0xc27a8a3d)
#define DIA_C_IID_CONFMGR_MASTER                               ((dia::IID) 0x212fa780)
#define DIA_C_IID_CONFMGR_RAM                                  ((dia::IID) 0x1c16ea54)
#define DIA_C_IID_CONFMGR_REGISTRY                             ((dia::IID) 0xe02c6e8d)
#define DIA_C_IID_CONFMGR_SCD                                  ((dia::IID) 0x1c16eece)
#define DIA_C_IID_CONFMGR_ENGINE_CLIENT                        ((dia::IID) 0x0965c328)    //    ./hasher -c "DIA_C_IID_CONFMGR_ENGINE_CLIENT"
#define DIA_C_IID_CONFIG_ITEM                                  ((dia::IID) 0x29f57c4b)

// predefined system setting type names
#define DIA_C_STR_PROPBAG_ADC                                  ((tCString) "dia_PropertyBagADC")
#define DIA_C_STR_PROPBAG_DATAPOOL                             ((tCString) "dia_PropertyBagDatapool")
#define DIA_C_STR_PROPBAG_FILE                                 ((tCString) "dia_PropertyBagFile")
#define DIA_C_STR_PROPBAG_FILESWITCH                           ((tCString) "dia_PropertyBagFileSwitches")
#define DIA_C_STR_PROPBAG_GPIO                                 ((tCString) "dia_PropertyBagGPIO")
#define DIA_C_STR_PROPBAG_KDS                                  ((tCString) "dia_PropertyBagKDS")
#define DIA_C_STR_PROPBAG_KDS_VARLEN                           ((tCString) "dia_PropertyBagKDSVarLen")
#define DIA_C_STR_PROPBAG_RAM                                  ((tCString) "dia_PropertyBagRAM")
#define DIA_C_STR_PROPBAG_REGISTRY                             ((tCString) "dia_PropertyBagRegistry")
#define DIA_C_STR_PROPBAG_SCD                                  ((tCString) "dia_PropertyBagSCD")
#define DIA_C_STR_PROPBAG_CONFIGITEM                           ((tCString) "dia_PropertyBagConfigItem")
#define DIA_C_STR_PROPBAG_ENGINE_CLIENT                        ((tCString) "dia_PropertyBagEngineClient")

// hash codes for the predefined system setting type names defined above; to calculate your hash use tool fc_diagnosis/tools/Hasher
#define DIA_C_UID_PROPBAG_UNKNOWN                              ((dia::UID) 0x00000000)
#define DIA_C_UID_PROPBAG_ADC                                  ((dia::UID) 0xc9829449)
#define DIA_C_UID_PROPBAG_DATAPOOL                             ((dia::UID) 0xe70d6b75)
#define DIA_C_UID_PROPBAG_FILE                                 ((dia::UID) 0xf9d87e61)
#define DIA_C_UID_PROPBAG_FILESWITCH                           ((dia::UID) 0x13a067eb)
#define DIA_C_UID_PROPBAG_GPIO                                 ((dia::UID) 0xf9d89bd0)
#define DIA_C_UID_PROPBAG_KDS                                  ((dia::UID) 0xc982bee3)
#define DIA_C_UID_PROPBAG_KDS_VARLEN                           ((dia::UID) 0x2db3e00b)
#define DIA_C_UID_PROPBAG_RAM                                  ((dia::UID) 0xc982dc41)
#define DIA_C_UID_PROPBAG_REGISTRY                             ((dia::UID) 0xe8cf717a)
#define DIA_C_UID_PROPBAG_SCD                                  ((dia::UID) 0xc982e0bb)
#define DIA_C_UID_PROPBAG_ENGINE_CLIENT                        ((dia::UID) 0x63612416)    // ./hasher -c "dia_PropertyBagEngineClient"

// deprecated list of property locations (please use the UIDs defined above)
#define DIA_PROP_SRC_UNKNOWN                                   (DIA_C_UID_PROPBAG_UNKNOWN)
#define DIA_PROP_SRC_ADC                                       (DIA_C_UID_PROPBAG_ADC)
#define DIA_PROP_SRC_DP                                        (DIA_C_UID_PROPBAG_DATAPOOL)
#define DIA_PROP_SRC_FILE                                      (DIA_C_UID_PROPBAG_FILE)
#define DIA_PROP_SRC_FILESW                                    (DIA_C_UID_PROPBAG_FILESWITCH)
#define DIA_PROP_SRC_GPIO                                      (DIA_C_UID_PROPBAG_GPIO)
#define DIA_PROP_SRC_KDS                                       (DIA_C_UID_PROPBAG_KDS)
#define DIA_PROP_SRC_KDS_VARLEN                                (DIA_C_UID_PROPBAG_KDS_VARLEN)
#define DIA_PROP_SRC_RAM                                       (DIA_C_UID_PROPBAG_RAM)
#define DIA_PROP_SRC_REGISTRY                                  (DIA_C_UID_PROPBAG_REGISTRY)
#define DIA_PROP_SRC_SCD                                       (DIA_C_UID_PROPBAG_SCD)
#define DIA_PROP_SRC_ENGINE_CLIENT                             (DIA_C_UID_PROPBAG_ENGINE_CLIENT)

#define DIA_PROP_LENGTH_MAX                                    ((tU16)       2500)
#define DIA_PROP_LENGTH_MAX_REG                                ((tU16)        256)
#define DIA_PROP_LENGTH_MAX_KDS                                ((tU16)        256)
#define DIA_PROP_LENGTH_MAX_DP                                 ((tU16)      20000)
#define DIA_PROP_LENGTH_MAX_KDS_INTERNAL                       ((tU16)        240)

#define DIA_C_U32_PROPMASK_TYPE                                ((tU32) 0x0F000000)
#define DIA_C_U32_PROPMASK_TYPE_U32                            ((tU32) 0x01000000)
#define DIA_C_U32_PROPMASK_TYPE_U16                            ((tU32) 0x02000000)
#define DIA_C_U32_PROPMASK_TYPE_U8                             ((tU32) 0x03000000)
#define DIA_C_U32_PROPMASK_TYPE_STR                            ((tU32) 0x04000000)

#define DIA_PROP_EXT_DATA_ELEM_MAX                             ((tU16) 20)


//#############################################################################
//#
//# A unique range for project specific property IDs is reserved
//#
//#############################################################################

// start addresses of known property ranges
#define DIA_PROP_RANGE_START_COMMON                            ((tU32) 0x00000000)

#define DIA_PROP_RANGE_START_PROJECT_01                        ((tU32) 0x00100000)
#define DIA_PROP_RANGE_START_PROJECT_02                        ((tU32) 0x00200000)
#define DIA_PROP_RANGE_START_PROJECT_03                        ((tU32) 0x00400000)
#define DIA_PROP_RANGE_START_PROJECT_04                        ((tU32) 0x00800000)
#define DIA_PROP_RANGE_START_PROJECT_05                        ((tU32) 0x01000000)
#define DIA_PROP_RANGE_START_PROJECT_06                        ((tU32) 0x01100000)
#define DIA_PROP_RANGE_START_PROJECT_07                        ((tU32) 0x01200000)
#define DIA_PROP_RANGE_START_PROJECT_08                        ((tU32) 0x01400000)
#define DIA_PROP_RANGE_START_PROJECT_09                        ((tU32) 0x01800000)
#define DIA_PROP_RANGE_START_PROJECT_10                        ((tU32) 0x02000000)
#define DIA_PROP_RANGE_START_PROJECT_11                        ((tU32) 0x02100000)
#define DIA_PROP_RANGE_START_PROJECT_12                        ((tU32) 0x02200000)
#define DIA_PROP_RANGE_START_PROJECT_13                        ((tU32) 0x02400000)
#define DIA_PROP_RANGE_START_PROJECT_14                        ((tU32) 0x02800000)
#define DIA_PROP_RANGE_START_PROJECT_15                        ((tU32) 0x04000000)
#define DIA_PROP_RANGE_START_PROJECT_16                        ((tU32) 0x04100000)

// the following macros might be used to assign property IDs to a certain range
#define DIA_PROP_COMMON(pid)                                   (((tU32) (pid)) | DIA_PROP_RANGE_START_COMMON)

//#############################################################################
//#
//# Common Property Key Definitions
//#
//#############################################################################

#define DIA_PROP_INVALID_IDENTIFIER                            0x0b2b283b  // "DIA_PROP_INVALID_IDENTIFIER"

#define DIA_PROP_VERSION_APPLE_COPRO                           0x079390cb  // "DIA_PROP_VERSION_APPLE_COPRO"
#define DIA_PROP_VERSION_DATACARRIER_WORM_ID                   0x69345229  // "DIA_PROP_VERSION_DATACARRIER_WORM_ID"
#define DIA_PROP_VERSION_IPOD                                  0xb0134603  // "DIA_PROP_VERSION_IPOD"
#define DIA_PROP_VERSION_HW_ADR                                0xb9ff6b0c  // "DIA_PROP_VERSION_HW_ADR"
#define DIA_PROP_VERSION_HW_BLUETOOTH                          0x40f2482b  // "DIA_PROP_VERSION_HW_BLUETOOTH"
#define DIA_PROP_VERSION_HW_DAB_MODULE                         0x2bbd1f61  // "DIA_PROP_VERSION_HW_DAB_MODULE"
#define DIA_PROP_VERSION_HW_FGS                                0xaae3e4b5  // "DIA_PROP_VERSION_HW_FGS"
#define DIA_PROP_VERSION_HW_XM                                 0xede785da  // "DIA_PROP_VERSION_HW_XM"
#define DIA_PROP_VERSION_SW_ADR_PATCH                          0x2d3b6ce6  // "DIA_PROP_VERSION_SW_ADR_PATCH"
#define DIA_PROP_VERSION_SW_ADR                                0xa55115f7  // "DIA_PROP_VERSION_SW_ADR"
#define DIA_PROP_VERSION_SW_BOOT_LOADER_FGS                    0x0c479909  // "DIA_PROP_VERSION_SW_BOOT_LOADER_FGS"
#define DIA_PROP_VERSION_SW_BOOTMGNR                           0x11a7c5e8  // "DIA_PROP_VERSION_SW_BOOTMGNR"
#define DIA_PROP_VERSION_SW_BOOTMGNR_ADIT                      0xf1a18b89  // "DIA_PROP_VERSION_SW_BOOTMGNR_ADIT"
#define DIA_PROP_VERSION_SW_BLUETOOTH                          0x2c43f316  // "DIA_PROP_VERSION_SW_BLUETOOTH"
#define DIA_PROP_VERSION_SW_BLUETOOTH_BOOTLOADER               0xf74ccce0  // "DIA_PROP_VERSION_SW_BLUETOOTH_BOOTLOADER"
#define DIA_PROP_VERSION_SW_DAB_MODULE                         0x170eca4c  // "DIA_PROP_VERSION_SW_DAB_MODULE"
#define DIA_PROP_VERSION_SW_FGS                                0x96358fa0  // "DIA_PROP_VERSION_SW_FGS"
#define DIA_PROP_VERSION_SW_FGS_BOOTLOADER                     0x623118ea  // "DIA_PROP_VERSION_SW_FGS_BOOTLOADER"
#define DIA_PROP_VERSION_SW_FGS_DATA                           0x74c28899  // "DIA_PROP_VERSION_SW_FGS_DATA"
#define DIA_PROP_VERSION_SW_FGS_TESTMANAGER                    0x82c14c9a  // "DIA_PROP_VERSION_SW_FGS_TESTMANAGER"
#define DIA_PROP_VERSION_SW_HMI                                0xb79b10de  // "DIA_PROP_VERSION_SW_HMI"
#define DIA_PROP_VERSION_SW_HMI_APP_ID                         0xe4f4226a  // "DIA_PROP_VERSION_SW_HMI_APP_ID"
#define DIA_PROP_VERSION_SW_MAIN                               0x837bb305  // "DIA_PROP_VERSION_SW_MAIN"
#define DIA_PROP_VERSION_SW_MAIN_SEQ_NUM                       0xb678fd7c  // "DIA_PROP_VERSION_SW_MAIN_SEQ_NUM"
#define DIA_PROP_VERSION_SW_NAVI                               0xa6af87ee  // "DIA_PROP_VERSION_SW_NAVI"
#define DIA_PROP_VERSION_SW_PLATFORM                           0xddf214e5  // "DIA_PROP_VERSION_SW_PLATFORM"
#define DIA_PROP_VERSION_SW_PLATFORM_DSP                       0x5e3ed1eb  // "DIA_PROP_VERSION_SW_PLATFORM_DSP"
#define DIA_PROP_VERSION_SW_RADIO_LIB                          0x1c640945  // "DIA_PROP_VERSION_SW_RADIO_LIB"
#define DIA_PROP_VERSION_SW_RADIO_UNIT                         0x4bc7532e  // "DIA_PROP_VERSION_SW_RADIO_UNIT"
#define DIA_PROP_VERSION_SW_SPEECHDATA                         0x6769de32  // "DIA_PROP_VERSION_SW_SPEECHDATA"
#define DIA_PROP_VERSION_SW_SPEECHDATA_DATE_BUILD              0x44520a9e  // "DIA_PROP_VERSION_SW_SPEECHDATA_DATE_BUILD"
#define DIA_PROP_VERSION_SW_SPEECHDATA_DATE_MSM                0x3dc1c15b  // "DIA_PROP_VERSION_SW_SPEECHDATA_DATE_MSM"
#define DIA_PROP_VERSION_SW_SPEECHDATA_DATE_MNM                0x975316b6  // "DIA_PROP_VERSION_SW_SPEECHDATA_DATE_MNM"
#define DIA_PROP_VERSION_SW_SYSTEM_ARION                       0x89bef5fd  // "DIA_PROP_VERSION_SW_SYSTEM_ARION"
#define DIA_PROP_VERSION_SW_TESTMGNR                           0x84a24134  // "DIA_PROP_VERSION_SW_TESTMGNR"
#define DIA_PROP_VERSION_SW_TESTMGNR_ADIT                      0x649c06d5  // "DIA_PROP_VERSION_SW_TESTMGNR_ADIT"

#define DIA_PROP_SERIAL_NUMBER                                 0x3a67667a  // "DIA_PROP_SERIAL_NUMBER"
#define DIA_PROP_SERIAL_NUMBER_PCB                             0xde2cafae  // "DIA_PROP_SERIAL_NUMBER_PCB"
#define DIA_PROP_SYSTEM_INFO                                   0x81f126a2  // "DIA_PROP_SYSTEM_INFO"
#define DIA_PROP_TYPE_NUMBER                                   0xe03b06fc  // "DIA_PROP_TYPE_NUMBER"
#define DIA_PROP_TYPE_NUMBER_PCB                               0x8a776d30  // "DIA_PROP_TYPE_NUMBER_PCB"
#define DIA_PROP_SW_INDEX                                      0x02db8a13  // "DIA_PROP_SW_INDEX"
#define DIA_PROP_PROD_DAY_INDEX                                0x4201bd9b  // "DIA_PROP_PROD_DAY_INDEX"
#define DIA_PROP_SYSTEM_SECURITY_LEVEL                         0xe9faeee5  // "DIA_PROP_SYSTEM_SECURITY_LEVEL"
#define DIA_PROP_SYSTEM_SECURITY_LEVEL_INVERT                  0x1439b39c  // "DIA_PROP_SYSTEM_SECURITY_LEVEL_INVERT"

#define DIA_PROP_DEFAULT_SESSION                               0x9636df5a  // "DIA_PROP_DEFAULT_SESSION"
#define DIA_PROP_SESSION_CTRL_SUPPORT_SPR                      0x404e1d3a  // "DIA_PROP_SESSION_CTRL_SUPPORT_SPR"
#define DIA_PROP_DEFAULT_SPEED_THRESHOLD                       0x1f876153  // "DIA_PROP_DEFAULT_SPEED_THRESHOLD"
#define DIA_PROP_UNDEFINED_SPEED_THRESHOLD                     0x095d7f20  // "DIA_PROP_UNDEFINED_SPEED_THRESHOLD"

#define DIA_PROP_DOWNLOAD_STATUS_BLUETOOTH                     0xd0a4a642  // "DIA_PROP_DOWNLOAD_STATUS_BLUETOOTH"
#define DIA_PROP_DOWNLOAD_STATUS_DAB                           0x905f92d3  // "DIA_PROP_DOWNLOAD_STATUS_DAB"

#define DIA_PROP_CM_CONFIG_EXT_DATA_CHECK_MODE                 0x4c4399c1  // "DIA_PROP_CM_CONFIG_EXT_DATA_CHECK_MODE"
#define DIA_PROP_CM_CONFIG_DISPLAY_TYPE                        0x0c7769ed  // "DIA_PROP_CM_CONFIG_DISPLAY_TYPE"
#define DIA_PROP_CM_CONFIG_OEM_TYPE                            0xa3bf1338  // "DIA_PROP_CM_CONFIG_OEM_TYPE"
#define DIA_PROP_CM_CONFIG_TUNER_MODE                          0xdb05ba28  // "DIA_PROP_CM_CONFIG_TUNER_MODE"
#define DIA_PROP_CM_CONFIG_TUNER_SUPPORT_XM                    0x547f09a4  // "DIA_PROP_CM_CONFIG_TUNER_SUPPORT_XM"
#define DIA_PROP_CM_CONFIG_TUNER_SUPPORT_DAB                   0xafa19fe6  // "DIA_PROP_CM_CONFIG_TUNER_SUPPORT_DAB"
#define DIA_PROP_CM_CONFIG_SIZE_RAM                            0x3f46e950  // "DIA_PROP_CM_CONFIG_SIZE_RAM"
#define DIA_PROP_CM_CONFIG_SIZE_ROM                            0xa5a9ec1e  // "DIA_PROP_CM_CONFIG_SIZE_ROM"
#define DIA_PROP_CM_CONFIG_INTERFACE_LOCK                      0x1ca1938f  // "DIA_PROP_CM_CONFIG_INTERFACE_LOCK"

// Bosch Car Multimedia - production diagnosis
#define DIA_PROP_CM_TEST_SERVICE_0047                          0x07f99f7b  // "DIA_PROP_CM_TEST_SERVICE_0047"
#define DIA_PROP_CM_CUSTOMER_ECU_PART_NR                       0x656ba2e4  // "DIA_PROP_CM_CUSTOMER_ECU_PART_NR"
#define DIA_PROP_CM_CUSTOMER_SERIAL_NR                         0x7709a431  // "DIA_PROP_CM_CUSTOMER_SERIAL_NR"
#define DIA_PROP_CM_CUSTOMER_SPARE_PART_NR                     0x91eb13e2  // "DIA_PROP_CM_CUSTOMER_SPARE_PART_NR"
#define DIA_PROP_CM_CUSTOMER_SW_VERSION                        0x821a7701  // "DIA_PROP_CM_CUSTOMER_SW_VERSION"
#define DIA_PROP_CM_ECU_HW_VERSION                             0x402d14a1  // "DIA_PROP_CM_ECU_HW_VERSION"
#define DIA_PROP_CM_ECU_SERIAL_NR                              0x601f081c  // "DIA_PROP_CM_ECU_SERIAL_NR"
#define DIA_PROP_CM_ECU_SPARE_PART_NR                          0xf91eee6d  // "DIA_PROP_CM_ECU_SPARE_PART_NR"
#define DIA_PROP_CM_ECU_SW_VERSION                             0x95b41cec  // "DIA_PROP_CM_ECU_SW_VERSION"
#define DIA_PROP_CM_VARIANT_ID                                 0xa11474e2  // "DIA_PROP_CM_VARIANT_ID"
#define DIA_PROP_VEHICLE_IDENTIFICATION_NUMBER                 0xa459de23  // "DIA_PROP_VEHICLE_IDENTIFICATION_NUMBER"

#define DIA_PROP_SYSTEM_SECURITY_LEVEL_UID                     0x4b1de446  // "DIA_PROP_SYSTEM_SECURITY_LEVEL_UID"
#define DIA_PROP_SYSTEM_SECURITY_LEVEL_UID_INVERT              0xb5e0e57d  // "DIA_PROP_SYSTEM_SECURITY_LEVEL_UID_INVERT"

#define DIA_PROP_CM_BT_NAME                                    0x6f47b397  // "DIA_PROP_CM_BT_NAME"
#define DIA_PROP_CM_WIFI_NAME_1                                0xbafe3fe0  // "DIA_PROP_CM_WIFI_NAME_1"
#define DIA_PROP_CM_WIFI_NAME_2                                0xcc3603e1  // "DIA_PROP_CM_WIFI_NAME_2"

#define DIA_PROP_CM_MAINBOARD_SERIAL_NR                        0x898f21ac  // "DIA_PROP_CM_MAINBOARD_SERIAL_NR"
#define DIA_PROP_CM_MAINBOARD_SPARE_PART_NR                    0xef38df3d  // "DIA_PROP_CM_MAINBOARD_SPARE_PART_NR"
#define DIA_PROP_CM_ECU_SW_BUILD_VERSION                       0xe37b605b  // "DIA_PROP_CM_ECU_SW_BUILD_VERSION"
#define DIA_PROP_CM_ODX_FILE_IDENTIFIER                        0x9ae03e4d  // "DIA_PROP_CM_ODX_FILE_IDENTIFIER"
#define DIA_PROP_CM_ODX_FILE_VERSION                           0xa0fb69f0  // "DIA_PROP_CM_ODX_FILE_VERSION"
#define DIA_PROP_CM_UNIQUE_FIELD_DATA_ID                       0xdef2e7dd  // {aa7329c3-6ca5-496c-b843-2c6b04c48a35}
#define DIA_PROP_CM_NAVIGATION_DEFAULT_POSITION                0x7fe38ce9  // "DIA_PROP_CM_NAVIGATION_DEFAULT_POSITION"
#define DIA_PROP_CM_NAVIGATION_SW_VERSION                      0x69bc247f  // "DIA_PROP_CM_NAVIGATION_SW_VERSION"
#define DIA_PROP_CM_SECLEV_BOSCH_INVALID_KEY_COUNTER           0x0c7daa5e  // "DIA_PROP_CM_SECLEV_BOSCH_INVALID_KEY_COUNTER"
#define DIA_PROP_CM_SECLEV_BOSCH_REMAINING_LOCK_TIME           0x5cab0f60  // "DIA_PROP_CM_SECLEV_BOSCH_REMAINING_LOCK_TIME"
#define DIA_PROP_CM_TEMPERATURE_DRIVE                          0xd4159048  // "DIA_PROP_CM_TEMPERATURE_DRIVE"
#define DIA_PROP_CM_TEMPERATURE_SYSTEM                         0xa7c7ef13  // "DIA_PROP_CM_TEMPERATURE_SYSTEM"
#define DIA_PROP_CM_TEMPERATURE_DISPLAY                        0xa853c3a4  // "DIA_PROP_CM_TEMPERATURE_DISPLAY"
#define DIA_PROP_CM_HW_CONFIG_STRING                           0x74f5116b  // "DIA_PROP_CM_HW_CONFIG_STRING"
#define DIA_PROP_CM_POI_ENCRYPTION_INFO                        0x6461563e  // "DIA_PROP_CM_POI_ENCRYPTION_INFO"
#define DIA_PROP_SPEED_LOCK                                    0x9ffd718b  // "DIA_PROP_SPEED_LOCK"
#define DIA_PROP_CM_IMMOBILIZER                                0x8663c444  // "DIA_PROP_CM_IMMOBILIZER"
#define DIA_PROP_CM_DIMMING_PARAMETER_SET                      0xe0c89811  // "DIA_PROP_CM_DIMMING_PARAMETER_SET"
#define DIA_PROP_CM_KEY_ILLUMINATION_ALIGNMENT_COEFF           0x11480efe  // "DIA_PROP_CM_KEY_ILLUMINATION_ALIGNMENT_COEFF"
#define DIA_PROP_CM_NAVI_DATA_SEC_KEY                          0x14a87bca  // "DIA_PROP_CM_NAVI_DATA_SEC_KEY"
#define DIA_PROP_CM_SYSTEM_IDENTIFICATION                      0x7190282f  // "DIA_PROP_CM_SYSTEM_IDENTIFICATION"
#define DIA_PROP_ENG_TEST_MODE                                 0xabe80b4f  // "DIA_PROP_ENG_TEST_MODE"
#define DIA_PROP_CM_SXM_SERIALNO_VER                           0xec6d0c81  // "DIA_PROP_CM_SXM_SERIALNO_VER"
#define DIA_PROP_CM_SXM_SW_VER                                 0xc483e78e  // "DIA_PROP_CM_SXM_SW_VER"
#define DIA_PROP_CM_SXM_SXM_HW_VER                             0x484f25fa  // "DIA_PROP_CM_SXM_SXM_HW_VER"
#define DIA_PROP_CM_CONF_INFO                                  0x1bd78e12  // "DIA_PROP_CM_CONF_INFO"
#define DIA_PROP_VERSION_CPLD_VERSION                          0x5324e5df  // "DIA_PROP_VERSION_CPLD_VERSION"
#define DIA_PROP_CRIN_IDENTIFICATION                           0x7cf11747  // "DIA_PROP_CRIN_IDENTIFICATION"
#define DIA_PROP_VERSION_SW_CUSTOMER                           0x9207b4b2  // "DIA_PROP_VERSION_SW_CUSTOMER"
#define DIA_PROP_CM_TEMPERATURE_GYRO                           0x91cc706f  // "DIA_PROP_CM_TEMPERATURE_GYRO"
#define DIA_PROP_ADC_U_REF_REAL                                0xf06e59ad  // "DIA_PROP_ADC_U_REF_REAL"
#define DIA_PROP_ADC_THRESHOLDS_EMMC                           0xf198499a  // "DIA_PROP_ADC_THRESHOLDS_EMMC"
#define DIA_PROP_CM_CONFIG_ID                                  0x3a891f23  // "DIA_PROP_CM_CONFIG_ID"
#define DIA_PROP_CM_SXM_SW_DOWNLOAD_STRING                     0xbba6100f  // "DIA_PROP_CM_SXM_SW_DOWNLOAD_STRING"
#define DIA_PROP_CM_SXM_SW_DOWNLOAD_VERSION                    0x84d2ba1e  // "DIA_PROP_CM_SXM_SW_DOWNLOAD_VERSION"
#define DIA_PROP_CM_SPM_HISTORY_ERROR_STATE_01                 0xc6e0f92b  // "DIA_PROP_CM_SPM_HISTORY_ERROR_STATE_01"
#define DIA_PROP_CM_SPM_HISTORY_ERROR_STATE_02                 0xb4f71b4c  // "DIA_PROP_CM_SPM_HISTORY_ERROR_STATE_02"
#define DIA_PROP_CM_SPM_HISTORY_ERROR_STATE_03                 0xa30d3d6d  // "DIA_PROP_CM_SPM_HISTORY_ERROR_STATE_03"
#define DIA_PROP_CM_SPM_HISTORY_ERROR_STATE_04                 0x91235f8e  // "DIA_PROP_CM_SPM_HISTORY_ERROR_STATE_04"
#define DIA_PROP_CM_SPM_HISTORY_ERROR_STATE_05                 0x7f3981af  // "DIA_PROP_CM_SPM_HISTORY_ERROR_STATE_05"
#define DIA_PROP_CM_TEMPERATURE_AMP                            0xeb238c8c  // "DIA_PROP_CM_TEMPERATURE_AMP"
#define DIA_PROP_CM_TEMPERATURE_EMMC                           0x7736f350  // "DIA_PROP_CM_TEMPERATURE_EMMC"
#define DIA_PROP_CM_TEMPERATURE_EXPBOARD                       0x6ccef063  // "DIA_PROP_CM_TEMPERATURE_EXPBOARD"
#define DIA_PROP_CM_TEMPERATURE_CDDRIVE                        0x86ac4bcf  // "DIA_PROP_CM_TEMPERATURE_CDDRIVE"
#define DIA_PROP_CM_TEMPERATURE_HEATSINK                       0xcf0ba525  // "DIA_PROP_CM_TEMPERATURE_HEATSINK"
#define DIA_PROP_CM_EVENT_LOGGER_MAX_ENTRIES                   0x81f52c40  // "DIA_PROP_CM_EVENT_LOGGER_MAX_ENTRIES"
#define DIA_PROP_CM_VERSION_SW_SCC                             0x2a92e748  // "DIA_PROP_CM_VERSION_SW_SCC"
#define DIA_PROP_CM_VERSION_BL_SCC                             0x9ebaad8c  // "DIA_PROP_CM_VERSION_BL_SCC"
#define DIA_PROP_CM_VERSION_BM_SCC                             0xd6eaf1ad  // "DIA_PROP_CM_VERSION_BM_SCC"
#define DIA_PROP_CM_VARIANT_CODING                             0x6f928e29  // "DIA_PROP_CM_VARIANT_CODING"
#define DIA_PROP_CM_EXTENDED_VARIANT_CODING                    0x664e056f  // b5c593fd-fad5-4a8c-a896-084ab495c44f
#define DIA_PROP_CM_SENSOR_CONFIG_GNSS                         0xde00ad0a  // "DIA_PROP_CM_SENSOR_CONFIG_GNSS"
#define DIA_PROP_CM_SENSOR_CONFIG_GYRO                         0xaab0c270  // "DIA_PROP_CM_SENSOR_CONFIG_GYRO"
#define DIA_PROP_CM_SENSOR_CONFIG_ACC                          0xa12a0b36  // "DIA_PROP_CM_SENSOR_CONFIG_ACC"

#define DIA_PROP_CM_GENERIC_TUNER_PARAM_SET                    0xd528f746  // "DIA_PROP_CM_GENERIC_TUNER_PARAM_SET"
#define DIA_PROP_CM_ANTENNA_PARAMETER_SET                      0x2c18dab1  // "DIA_PROP_CM_ANTENNA_PARAMETER_SET"
#define DIA_PROP_CM_ANTENNA_2_PARAMETER_SET                    0xf6f313d3  // "DIA_PROP_CM_ANTENNA_2_PARAMETER_SET"
#define DIA_PROP_CM_FM_AM_TUNER_PARAMETER_SET                  0x5a9ffe19  // "DIA_PROP_CM_FM_AM_TUNER_PARAMETER_SET"
#define DIA_PROP_CM_AUDIO_PARAMETER_SET                        0xbff0e7fe  // "DIA_PROP_CM_AUDIO_PARAMETER_SET"
#define DIA_PROP_CM_BLOCK_SIZE                                 0xf514f9c6  // "DIA_PROP_CM_BLOCK_SIZE"
#define DIA_PROP_SW_UPD_VARIANT_INFO                           0x38a77de3  // "DIA_PROP_SW_UPD_VARIANT_INFO"
#define DIA_PROP_CM_TEMPERATURE_AMPLIFIER                      0x0d9b3ce7  // "DIA_PROP_CM_TEMPERATURE_AMPLIFIER"
#define DIA_PROP_CM_TEMPERATURE_V850                           0xb28232a1  // "DIA_PROP_CM_TEMPERATURE_V850"
#define DIA_PROP_CM_TEMPERATURE_DVDDRIVER                      0xb6050178  // "DIA_PROP_CM_TEMPERATURE_DVDDRIVER"
#define DIA_PROP_CM_TEMPERATURE_GPS                            0x06e04078  // "DIA_PROP_CM_TEMPERATURE_GPS"
#define DIA_PROP_CM_TEMPERATURE_IMX                            0x0229669c  // "DIA_PROP_CM_TEMPERATURE_IMX"
#define DIA_PROP_CM_DATASET_BLOCK_SIZE                         0x27fb302b  // "DIA_PROP_CM_DATASET_BLOCK_SIZE"

#define DIA_PROP_AID_ADC_REF_PLUS_ACTUAL_VOLTAGE               0x36070310  // "DIA_PROP_AID_ADC_REF_PLUS_ACTUAL_VOLTAGE"
#define DIA_PROP_CM_DAB_TUNER_PARAMETER_SET                    0xe9d94400  // "DIA_PROP_CM_DAB_TUNER_PARAMETER_SET"
#define DIA_PROP_CM_HD_TUNER_PARAMETER_SET                     0xbce3b545  // "DIA_PROP_CM_HD_TUNER_PARAMETER_SET"

#define DIA_PROP_CM_RUN_IN_ACTIVATION                          0x6f9ae4dd  // "DIA_PROP_CM_RUN_IN_ACTIVATION"
#define DIA_PROP_CM_RUN_IN_START_DELAY                         0x9c8ec447  // "DIA_PROP_CM_RUN_IN_START_DELAY"

#define DIA_PROP_ENGINE_UDS_THREAD_PRIO                        0x0f3bfe23  // "DIA_PROP_ENGINE_UDS_THREAD_PRIO"
#define DIA_PROP_ENGINE_UDS_THREAD_STACK_SIZE                  0xde09fd19  // "DIA_PROP_ENGINE_UDS_THREAD_STACK_SIZE"
#define DIA_PROP_ENGINE_RUNIN_THREAD_PRIO                      0xae591b43  // "DIA_PROP_ENGINE_RUNIN_THREAD_PRIO"
#define DIA_PROP_ENGINE_RUNIN_THREAD_STACK_SIZE                0x188ee4b9  // "DIA_PROP_ENGINE_RUNIN_THREAD_STACK_SIZE"
#define DIA_PROP_ENGINE_INTTESTER_THREAD_PRIO                  0xd9c9c2f9  // "DIA_PROP_ENGINE_INTTESTER_THREAD_PRIO"
#define DIA_PROP_ENGINE_INTTESTER_THREAD_STACK_SIZE            0xc419416f  // "DIA_PROP_ENGINE_INTTESTER_THREAD_STACK_SIZE"
#define DIA_PROP_ENGINE_PDX_FLASH_THREAD_PRIO                  0xcf282030  // "DIA_PROP_ENGINE_PDX_FLASH_THREAD_PRIO"
#define DIA_PROP_ENGINE_PDX_FLASH_THREAD_STACK_SIZE            0xb9779ea6  // "DIA_PROP_ENGINE_PDX_FLASH_THREAD_STACK_SIZE"
#define DIA_PROP_ENGINE_PDX_FLASH_FINISH                       0x7159a460  // "DIA_PROP_ENGINE_PDX_FLASH_FINISH"
#define DIA_PROP_EVENT_WAIT_THREAD_PRIO                        0xbc230c18  // "DIA_PROP_EVENT_WAIT_THREAD_PRIO"
#define DIA_PROP_EVENT_WAIT_THREAD_STACK_SIZE                  0x8af10b0e  // "DIA_PROP_EVENT_WAIT_THREAD_STACK_SIZE"

#define DIA_PROP_CM_HD_PARAMETER_SET                           0xd8bf2a18  // "DIA_PROP_CM_HD_PARAMETER_SET"

#define DIA_PROP_CM_MIN_LEN_IOCONTROL_MESSAGE                  0x0c5cf01f  // "DIA_PROP_CM_MIN_LEN_IOCONTROL_MESSAGE"
#define DIA_PROP_CM_MIN_LEN_ROUTINECTRL_MESSAGE                0x6d1f28e1  // "DIA_PROP_CM_MIN_LEN_ROUTINECTRL_MESSAGE"

#define DIA_PROP_CM_INPUT_KEY_MAPPING_TABLE_ONE                0x05a2ccac  // "DIA_PROP_CM_INPUT_KEY_MAPPING_TABLE_ONE"
#define DIA_PROP_CM_INPUT_KEY_MAPPING_TABLE_TWO                0x9530d324  // "DIA_PROP_CM_INPUT_KEY_MAPPING_TABLE_TWO"
#define DIA_PROP_CM_INPUT_KEY_MAPPING_TABLE_THREE              0xb773cfa2  // "DIA_PROP_CM_INPUT_KEY_MAPPING_TABLE_THREE"
#define DIA_PROP_CM_INPUT_KEY_MAPPING_TABLE_FOUR               0x4c0adc86  // "DIA_PROP_CM_INPUT_KEY_MAPPING_TABLE_FOUR"

#define DIA_PROP_CUSTOMER_CONFIG_FINGERPRINT                   0xb1a623e0  // "DIA_PROP_CUSTOMER_CONFIG_FINGERPRINT"
#define DIA_PROP_THERMALMNGMT_TEMPERATURE_THRESHOLDS           0xd9a0a02e  // "DIA_PROP_THERMALMNGMT_TEMPERATURE_THRESHOLDS"
#define DIA_PROP_CUSTOMER_CONFIG_PART_NUMBER                   0xae897037  // "DIA_PROP_CUSTOMER_CONFIG_PART_NUMBER"
#define DIA_PROP_ECU_UID                                       0xbe897038  // "DIA_PROP_ECU_UID"

#define DIA_PROP_TEST_PROPERTY_RAM_250                         0xdef2e7a1
#define DIA_PROP_TEST_PROPERTY_RAM_4500                        0xdef2e7a2

#define DIA_PROP_AID_DATASET_ECNR_BT_PHONE_NB                  0x19d43ee9  // "DIA_PROP_AID_DATASET_ECNR_BT_PHONE_NB"
#define DIA_PROP_AID_DATASET_ECNR_BT_PHONE_WB                  0x4734e052  // "DIA_PROP_AID_DATASET_ECNR_BT_PHONE_WB"
#define DIA_PROP_AID_DATASET_ECNR_BT_VOICE_NB                  0x75881b25  // "DIA_PROP_AID_DATASET_ECNR_BT_VOICE_NB"
#define DIA_PROP_AID_DATASET_ECNR_BT_VOICE_WB                  0xa2e8bc8e  // "DIA_PROP_AID_DATASET_ECNR_BT_VOICE_WB"
#define DIA_PROP_AID_DATASET_ECNR_CP_PHONE_NB                  0xe5802ce6  // "DIA_PROP_AID_DATASET_ECNR_CP_PHONE_NB"
#define DIA_PROP_AID_DATASET_ECNR_CP_PHONE_WB                  0x12e0ce4f  // "DIA_PROP_AID_DATASET_ECNR_CP_PHONE_WB"
#define DIA_PROP_AID_DATASET_ECNR_CP_PHONE_SWB                 0x031f0082  // "DIA_PROP_AID_DATASET_ECNR_CP_PHONE_SWB"
#define DIA_PROP_AID_DATASET_ECNR_CP_VOICE_NB                  0x41340922  // "DIA_PROP_AID_DATASET_ECNR_CP_VOICE_NB"
#define DIA_PROP_AID_DATASET_ECNR_CP_VOICE_WB                  0x6e94aa8b  // "DIA_PROP_AID_DATASET_ECNR_CP_VOICE_WB"
#define DIA_PROP_AID_DATASET_ECNR_CP_VOICE_SWB                 0x5ed2dcbe  // "DIA_PROP_AID_DATASET_ECNR_CP_VOICE_SWB"
#define DIA_PROP_AID_DATASET_ECNR_CP_FACETIME_SWB              0xcbcbc146  // "DIA_PROP_AID_DATASET_ECNR_CP_FACETIME_SWB"
#define DIA_PROP_AID_DATASET_ECNR_BT_SIRI_NB                   0x0bd026c6  // "DIA_PROP_AID_DATASET_ECNR_BT_SIRI_NB"
#define DIA_PROP_AID_DATASET_ECNR_BT_SIRI_WB                   0xe544f54f  // "DIA_PROP_AID_DATASET_ECNR_BT_SIRI_WB"
#define DIA_PROP_AID_DATASET_ECNR_AA_VOICE_NB                  0xedd83b71  // "DIA_PROP_AID_DATASET_ECNR_AA_VOICE_NB"
#define DIA_PROP_AID_DATASET_ECNR_AA_VOICE_WB                  0x1b38dcda  // "DIA_PROP_AID_DATASET_ECNR_AA_VOICE_WB"
#define DIA_PROP_AID_DATASET_ECNR_AA_VOICE_SWB                 0x0b770f0d  // "DIA_PROP_AID_DATASET_ECNR_AA_VOICE_SWB"
#define DIA_PROP_AID_DATASET_ECNR_AA_PHONE_NB                  0x92245f35  // "DIA_PROP_AID_DATASET_ECNR_AA_PHONE_NB"
#define DIA_PROP_AID_DATASET_ECNR_AA_PHONE_WB                  0xbf85009e  // "DIA_PROP_AID_DATASET_ECNR_AA_PHONE_WB"
#define DIA_PROP_AID_DATASET_ECNR_AA_PHONE_SWB                 0xafc332d1  // "DIA_PROP_AID_DATASET_ECNR_AA_PHONE_SWB"
#define DIA_PROP_AID_DATASET_ECNR_INT_VOICE_NB                 0xa92a041a  // "DIA_PROP_AID_DATASET_ECNR_INT_VOICE_NB"
#define DIA_PROP_AID_DATASET_ECNR_INT_VOICE_WB                 0xe0d79c63  // "DIA_PROP_AID_DATASET_ECNR_INT_VOICE_WB"
#define DIA_PROP_AID_DATASET_ECNR_VPA_VOICE_WB                 0x8cc75564  // "DIA_PROP_AID_DATASET_ECNR_VPA_VOICE_WB"     // to be generated with fc_diagnosis/tools/Hasher/hasher.cpp

#define DIA_PROP_CM_VARIANT_CODING_SCC                         0x40d20ea1  // "DIA_PROP_CM_VARIANT_CODING_SCC"
#define DIA_PROP_CUSTOMER_DEFAULT_CONFIG_ID                    0x88dcf529  // "DIA_PROP_CUSTOMER_DEFAULT_CONFIG_ID"
#define DIA_PROP_CM_MIC_INVALID_CURRENT_VALUE                  0x9bbe195e  // "DIA_PROP_CM_MIC_INVALID_CURRENT_VALUE"
#define DIA_PROP_CM_VERSION_LABEL_SW_SCC                       0xdb198ea7  // "DIA_PROP_CM_VERSION_LABEL_SW_SCC"
#define DIA_PROP_CM_VERSION_LABEL_BL_SCC                       0x068af1eb  // "DIA_PROP_CM_VERSION_LABEL_BL_SCC"
#define DIA_PROP_CM_VERSION_LABEL_BM_SCC                       0x8926f14c  // "DIA_PROP_CM_VERSION_LABEL_BM_SCC"
#define DIA_PROP_AID_AUDIO_SOURCE_OFFSET                       0x1a39a047  // "DIA_PROP_AID_AUDIO_SOURCE_OFFSET"
#define DIA_PROP_CM_DEVICE_MANAGER                             0xb932246b  // "DIA_PROP_CM_DEVICE_MANAGER"
#define DIA_PROP_CM_MEDIA_PLAYER                               0x2c15a04d  // "DIA_PROP_CM_MEDIA_PLAYER"
#define DIA_PROP_CM_DISPLAY                                    0x13092237  // "DIA_PROP_CM_DISPLAY"
#define DIA_PROP_CM_SMARTPHONE_INTEGRATION_DISPLAY             0x4d63551a  // "DIA_PROP_CM_SMARTPHONE_INTEGRATION_DISPLAY"
#define DIA_PROP_CM_SMARTPHONE_INTEGRATION                     0x3bc40b45  // "DIA_PROP_CM_SMARTPHONE_INTEGRATION"

// ADC
#define DIA_PROP_CM_ADC_DEVICE_GYRO_R                          0xe0e11549  // "DIA_PROP_CM_ADC_DEVICE_GYRO_R"
#define DIA_PROP_CM_ADC_DEVICE_GYRO_S                          0xf45a2c8a  // "DIA_PROP_CM_ADC_DEVICE_GYRO_S"
#define DIA_PROP_CM_ADC_DEVICE_GYRO_T                          0x07d343cb  // "DIA_PROP_CM_ADC_DEVICE_GYRO_T"
#define DIA_PROP_CM_ADC_DEVICE_GPS_UANT                        0xb1586238  // "DIA_PROP_CM_ADC_DEVICE_GPS_UANT"
#define DIA_PROP_CM_ADC_DEVICE_GPS_UTMP                        0x43d11ce6  // "DIA_PROP_CM_ADC_DEVICE_GPS_UTMP"
#define DIA_PROP_CM_ADC_DEVICE_GPS_VOLTAGE_SENSE               0xa019d8af  // "DIA_PROP_CM_ADC_DEVICE_GPS_VOLTAGE_SENSE"
#define DIA_PROP_CM_ADC_DEVICE_UBAT_DROP_DET                   0x1e654bd3  // "DIA_PROP_CM_ADC_DEVICE_UBAT_DROP_DET"
#define DIA_PROP_CM_ADC_DEVICE_AMP_CLIP                        0x2932701c  // "DIA_PROP_CM_ADC_DEVICE_AMP_CLIP"
#define DIA_PROP_CM_ADC_DEVICE_DIAG_DAB_PHANTOM_ANT            0xa57dfb4a  // "DIA_PROP_CM_ADC_DEVICE_DIAG_DAB_PHANTOM_ANT"
#define DIA_PROP_CM_ADC_DEVICE_DIAG_PHANTOM1_ANT               0x2eed1c15  // "DIA_PROP_CM_ADC_DEVICE_DIAG_PHANTOM1_ANT"
#define DIA_PROP_CM_ADC_DEVICE_DIAG_PHANTOM2_ANT               0xfb144a76  // "DIA_PROP_CM_ADC_DEVICE_DIAG_PHANTOM2_ANT"
#define DIA_PROP_CM_ADC_DEVICE_CRADLE_KEY                      0x9a367e8a  // "DIA_PROP_CM_ADC_DEVICE_CRADLE_KEY"
#define DIA_PROP_CM_ADC_DEVICE_CRADLE_DIAG                     0xd46a9176  // "DIA_PROP_CM_ADC_DEVICE_CRADLE_DIAG"
#define DIA_PROP_CM_ADC_DEVICE_MIC_DIAG                        0xac071e04  // "DIA_PROP_CM_ADC_DEVICE_MIC_DIAG"
#define DIA_PROP_CM_ADC_DEVICE_MIC_DIAG_2                      0xab4088f5  // "DIA_PROP_CM_ADC_DEVICE_MIC_DIAG_2"
#define DIA_PROP_CM_ADC_DEVICE_TEMP_SENSE                      0xd58ca7ea  // "DIA_PROP_CM_ADC_DEVICE_TEMP_SENSE"
#define DIA_PROP_CM_ADC_DEVICE_DIAG_AUX_R                      0x22cd45aa  // "DIA_PROP_CM_ADC_DEVICE_DIAG_AUX_R"
#define DIA_PROP_CM_ADC_DEVICE_DIAG_AUX_L                      0x718b8d24  // "DIA_PROP_CM_ADC_DEVICE_DIAG_AUX_L"
#define DIA_PROP_CM_ADC_DEVICE_TEMP_SENSOR_1                   0x8e172916  // "DIA_PROP_CM_ADC_DEVICE_TEMP_SENSOR_1"
#define DIA_PROP_CM_ADC_DEVICE_TEMP_SENSOR_2                   0x5a3e5777  // "DIA_PROP_CM_ADC_DEVICE_TEMP_SENSOR_2"
#define DIA_PROP_CM_ADC_DEVICE_DIAG_PHANTOM_ANT                0x31cecbe4  // "DIA_PROP_CM_ADC_DEVICE_DIAG_PHANTOM_ANT"
#define DIA_PROP_CM_ADC_DEVICE_PWM_AMP_DIAG                    0x04dff95c  // "DIA_PROP_CM_ADC_DEVICE_PWM_AMP_DIAG"
#define DIA_PROP_CM_ADC_DEVICE_PWM_DISPLAY_DIAG                0x5e50cd74  // "DIA_PROP_CM_ADC_DEVICE_PWM_DISPLAY_DIAG"
#define DIA_PROP_CM_ADC_DEVICE_STEERING_WHEEL                  0x4e55188c  // "DIA_PROP_CM_ADC_DEVICE_STEERING_WHEEL"
#define DIA_PROP_CM_ADC_DEVICE_U33S_CPU_SWC                    0x9f165518  // "DIA_PROP_CM_ADC_DEVICE_U33S_CPU_SWC"
#define DIA_PROP_CM_ADC_DEVICE_FAN_DIAG                        0x19e018c0  // "DIA_PROP_CM_ADC_DEVICE_FAN_DIAG"
#define DIA_PROP_CM_ADC_DEVICE_TEMP_GPS                        0x26944196  // "DIA_PROP_CM_ADC_DEVICE_TEMP_GPS"
#define DIA_PROP_CM_ADC_DEVICE_HALFCLASS_1                     0xacc9d118  // "DIA_PROP_CM_ADC_DEVICE_HALFCLASS_1"
#define DIA_PROP_CM_ADC_DEVICE_HALFCLASS_2                     0x1f761bb9  // "DIA_PROP_CM_ADC_DEVICE_HALFCLASS_2"
#define DIA_PROP_CM_ADC_DEVICE_DIAG_PHANTOM_FM_ANT             0xfa14ae76  // "DIA_PROP_CM_ADC_DEVICE_DIAG_PHANTOM_FM_ANT"
#define DIA_PROP_CM_ADC_DEVICE_DISP_TEMP_SENSE                 0x7f54c3b9  // "DIA_PROP_CM_ADC_DEVICE_DISP_TEMP_SENSE"
#define DIA_PROP_CM_ADC_DEVICE_GER_VAR                         0x958008fd  // "DIA_PROP_CM_ADC_DEVICE_GER_VAR"
#define DIA_PROP_CM_ADC_DEVICE_GPS_PHANTOM_DIAG                0x3b8ec70b  // "DIA_PROP_CM_ADC_DEVICE_GPS_PHANTOM_DIAG"
#define DIA_PROP_CM_ADC_DEVICE_PHANTOM_2_DIAG                  0xca0d9353  // "DIA_PROP_CM_ADC_DEVICE_PHANTOM_2_DIAG"
#define DIA_PROP_CM_ADC_DEVICE_SWC_A                           0x4d9cb5e4  // "DIA_PROP_CM_ADC_DEVICE_SWC_A"
#define DIA_PROP_CM_ADC_DEVICE_SWC_B                           0xd038b545  // "DIA_PROP_CM_ADC_DEVICE_SWC_B"
#define DIA_PROP_CM_ADC_DEVICE_TOUCH_X_CO                      0xc0f76642  // "DIA_PROP_CM_ADC_DEVICE_TOUCH_X_CO"
#define DIA_PROP_CM_ADC_DEVICE_TOUCH_Y_CO                      0xf01a1963  // "DIA_PROP_CM_ADC_DEVICE_TOUCH_Y_CO"
#define DIA_PROP_CM_ADC_DEVICE_XM_DAB_ANT_I_SENSE              0x39186209  // "DIA_PROP_CM_ADC_DEVICE_XM_DAB_ANT_I_SENSE"
#define DIA_PROP_CM_ADC_DEVICE_CAMERA_VCC_DIAG                 0xc0d7ee6f  // "DIA_PROP_CM_ADC_DEVICE_CAMERA_VCC_DIAG"
#define DIA_PROP_CM_ADC_DEVICE_MIC_VCC_DIAG                    0x3150a29f  // "DIA_PROP_CM_ADC_DEVICE_MIC_VCC_DIAG"
#define DIA_PROP_CM_ADC_DEVICE_GYRO_VDD_REF                    0xa3d38a91  // "DIA_PROP_CM_ADC_DEVICE_GYRO_VDD_REF"
#define DIA_PROP_CM_ADC_DEVICE_INPUT_ECALL_MUTE                0x3b9cf881  // "DIA_PROP_CM_ADC_DEVICE_INPUT_ECALL_MUTE"
#define DIA_PROP_CM_ADC_DEVICE_UBAT_SENSE                      0xf9dc6300  // "DIA_PROP_CM_ADC_DEVICE_UBAT_SENSE"

#define DIA_PROP_PRODUCTION_TIME                               0xb96468e7  // "DIA_PROP_PRODUCTION_TIME"

// GPIO
#define DIA_PROP_GPIO_IGNITION                                 0x5cc8ed01  // "DIA_PROP_GPIO_IGNITION"
#define DIA_PROP_GPIO_ACC                                      0x995f47c7  // "DIA_PROP_GPIO_ACC"
#define DIA_PROP_GPIO_REVERSE_GEAR                             0x62be773a  // "DIA_PROP_GPIO_REVERSE_GEAR"
#define DIA_PROP_GPIO_MR_OUNTPUT                               0xf0f0f91d  // "DIA_PROP_GPIO_MR_OUNTPUT"
#define DIA_PROP_GPIO_ILLUM                                    0x3c1b1683  // "DIA_PROP_GPIO_ILLUM"
#define DIA_PROP_GPIO_CD_WACKUP                                0x3afc9e31  // "DIA_PROP_GPIO_CD_WACKUP"
#define DIA_PROP_GPIO_CD_CDROM_RESET                           0xb6b7a41d  // "DIA_PROP_GPIO_CD_CDROM_RESET"
#define DIA_PROP_GPIO_MIC_VCC                                  0x67c77614  // "DIA_PROP_GPIO_MIC_VCC"
#define DIA_PROP_GPIO_AUDIO_EXT_AMPLI                          0x8fffb454  // "DIA_PROP_GPIO_AUDIO_EXT_AMPLI"
#define DIA_PROP_GPIO_CAN_COMM_ENABLE                          0xae2fa503  // "DIA_PROP_GPIO_CAN_COMM_ENABLE"
#define DIA_PROP_GPIO_MOST_ECL                                 0x7e1e8376  // "DIA_PROP_GPIO_MOST_ECL"
#define DIA_PROP_GPIO_PARKING_BRAKE                            0xbcd0cb30  // "DIA_PROP_GPIO_PARKING_BRAKE"
#define DIA_PROP_GPIO_INPUT_ECALL_MUTE                         0x22b99eea  // "DIA_PROP_GPIO_INPUT_ECALL_MUTE"
#define DIA_PROP_GPIO_MICROPHONE_JACK_DETECT                   0xca8300a4  // "DIA_PROP_GPIO_MICROPHONE_JACK_DETECT"
#define DIA_PROP_GPIO_BT_MODULE_RESET                          0xdd8628fd  // "DIA_PROP_GPIO_BT_MODULE_RESET"
#define DIA_PROP_GPIO_WIFI_MODULE_RESET                        0x83dedd16  // "DIA_PROP_GPIO_WIFI_MODULE_RESET"

// INC
#define DIA_PROP_INC_THREAD_PRIO                               0xc81d70fc  // "DIA_PROP_INC_THREAD_PRIO"
#define DIA_PROP_INC_THREAD_STACKSIZE                          0x59e5e9f3  // "DIA_PROP_INC_THREAD_STACKSIZE"
#define DIA_PROP_INC_UDD_CHANNEL                               0x2eb000a0  // "DIA_PROP_INC_UDD_CHANNEL"

//TCP
#define DIA_PROP_TCP_THREAD_PRIO                               0xcc683449  // "DIA_PROP_TCP_THREAD_PRIO"
#define DIA_PROP_TCP_THREAD_STACKSIZE                          0x5e30ad40  // "DIA_PROP_TCP_THREAD_STACKSIZE"

//DTC
#define DIA_PROP_DTC_FORMAT_IDENTIFIER                         0xd57c7037  // "DIA_PROP_DTC_FORMAT_IDENTIFIER"

// properties defined for unit testing
#define DIA_PROP_UT_NOT_EXISTING                               0xa0f4f1f5  // "DIA_PROP_UT_NOT_EXISTING"
#define DIA_PROP_UT_RAM_U32                                    0x4b088013  // "DIA_PROP_UT_RAM_U32"
#define DIA_PROP_UT_RAM_U16                                    0xc72918d5  // "DIA_PROP_UT_RAM_U16"
#define DIA_PROP_UT_RAM_U8                                     0x18581e26  // "DIA_PROP_UT_RAM_U8"
#define DIA_PROP_UT_RAM_BOOLEAN                                0xa4041079  // "DIA_PROP_UT_RAM_BOOLEAN"
#define DIA_PROP_UT_RAM_STR                                    0x7a8f0f72  // "DIA_PROP_UT_RAM_STR"
#define DIA_PROP_UT_RAM_STR_10                                 0x6e7ae5b2  // "DIA_PROP_UT_RAM_STR_10"
#define DIA_PROP_UT_RAM_STR_100                                0x81f725c2  // "DIA_PROP_UT_RAM_STR_100"
#define DIA_PROP_UT_RAM_STR_4                                  0x0dcb9c8d  // "DIA_PROP_UT_RAM_STR_4"
#define DIA_PROP_UT_KDS_NO_SIZE                                0x4779e512  // "DIA_PROP_UT_KDS_NO_SIZE"
#define DIA_PROP_UT_KDS_SINGLE                                 0x049c61dd  // "DIA_PROP_UT_KDS_SINGLE"
#define DIA_PROP_UT_KDS_MULTIPLE                               0x36f87927  // "DIA_PROP_UT_KDS_MULTIPLE"
#define DIA_PROP_UT_KDS_MULTIPLE_SHORT                         0x04a87716  // "DIA_PROP_UT_KDS_MULTIPLE_SHORT"
#define DIA_PROP_UT_KDS_U32                                    0xde63ecb5  // "DIA_PROP_UT_KDS_U32"
#define DIA_PROP_UT_KDS_U32_NO_KDS_FLASH                       0x7319097f  // "DIA_PROP_UT_KDS_U32_NO_KDS_FLASH"
#define DIA_PROP_UT_KDS_U16                                    0x5a848577  // "DIA_PROP_UT_KDS_U16"
#define DIA_PROP_UT_KDS_U8                                     0xabb38ac8  // "DIA_PROP_UT_KDS_U8"
#define DIA_PROP_UT_DP_STR_1                                   0x3aa04cf1  // "DIA_PROP_UT_DP_STR_1"
#define DIA_PROP_UT_DP_STR_10                                  0x01cb2ee6  // "DIA_PROP_UT_DP_STR_10"
#define DIA_PROP_UT_DP_STR_100                                 0x84cf70f6  // "DIA_PROP_UT_DP_STR_100"
#define DIA_PROP_UT_DP_UNSUPPORTED_TYPE                        0x64585457  // "DIA_PROP_UT_DP_UNSUPPORTED_TYPE"
#define DIA_PROP_UT_SCD_U32                                    0x54a5c68d  // "DIA_PROP_UT_SCD_U32"
#define DIA_PROP_UT_SCD_UNSUPPORTED_TYPE                       0xdfede77d  // "DIA_PROP_UT_SCD_UNSUPPORTED_TYPE"
#define DIA_PROP_UT_KDS_U8_ZERO_PADDED                         0x43c4c9a8  // "DIA_PROP_UT_KDS_U8_ZERO_PADDED"
#define DIA_PROP_UT_KDS_U8_ZERO_PADDED_LARGE                   0x3d158d92  // "DIA_PROP_UT_KDS_U8_ZERO_PADDED_LARGE"
#define DIA_PROP_UT_KDS_U8_ZERO_TERMINATED                     0x9608f853  // "DIA_PROP_UT_KDS_U8_ZERO_TERMINATED"
#define DIA_PROP_UT_KDS_STR_ZERO_PADDED                        0x775f5ef4  // "DIA_PROP_UT_KDS_STR_ZERO_PADDED"
#define DIA_PROP_UT_KDS_U32_ZERO_PADDED                        0x47d8cf95  // "DIA_PROP_UT_KDS_U32_ZERO_PADDED"
#define DIA_PROP_UT_DP_VARIABLE_LENGTH                         0x6aeaafb4  // "DIA_PROP_UT_DP_VARIABLE_LENGTH"
#define DIA_PROP_UT_DP_NODEFAULTS                              0x1e018542  // "DIA_PROP_UT_DP_NODEFAULTS"
#define DIA_PROP_UT_DP_VARLEN_NODEF                            0x9b4ee600  // "DIA_PROP_UT_DP_VARLEN_NODEF"
#define DIA_PROP_UT_U32                                        0x432ad494  // "DIA_PROP_UT_U32"
#define DIA_PROP_UT_U16                                        0x9b8dfe56  // "DIA_PROP_UT_U16"
#define DIA_PROP_UT_U8                                         0x4c714427  // "DIA_PROP_UT_U8"
#define DIA_PROP_UT_BOOLEAN                                    0xd6a427fa  // "DIA_PROP_UT_BOOLEAN"
#define DIA_PROP_UT_BOOL                                       0x81246c26  // "DIA_PROP_UT_BOOL"
#define DIA_PROP_UT_DP_VARLEN_NODEF_NOFLUSH                    0xf804709e  // "DIA_PROP_UT_DP_VARLEN_NODEF_NOFLUSH"
#define DIA_PROP_UT_FILE_FEATURE_SWITCH                        0x9bb71336  // "DIA_PROP_UT_FILE_FEATURE_SWITCH"
#define DIA_PROP_UT_RAW_DATA                                   0xf87c9bbd  // "DIA_PROP_UT_RAW_DATA"
#define DIA_PROP_UT_KDS_STR_ZERO_TERMIN_FULL                   0x0e9e2e48  // "DIA_PROP_UT_KDS_STR_ZERO_TERMIN_FULL"
#define DIA_PROP_UT_KDS_STR_ZERO_TERMIN_SHORT                  0x0930aaff  // "DIA_PROP_UT_KDS_STR_ZERO_TERMIN_SHORT"

#define DIA_PROP_FEATURE_ALD_CM_DIAGNOSIS_ENABLED              0xfa52fe27  // "DIA_PROP_FEATURE_ALD_CM_DIAGNOSIS_ENABLED"
#define DIA_PROP_CM_ALD_SEED_INPUT_DATA                        0x8daf0e3a  // "DIA_PROP_CM_ALD_SEED_INPUT_DATA"
#define DIA_PROP_TOUCHCTRL_SELFTEST                            0x407b9d13  // "DIA_PROP_TOUCHCTRL_SELFTEST"

#define DIA_PROP_CM_EARLY_CONFIG_DISPLAY                       0xcc638588  // "DIA_PROP_CM_EARLY_CONFIG_DISPLAY"
#define DIA_PROP_CM_EARLY_CONFIG_TOUCH_DRIVER                  0x84fa3ba0  // "DIA_PROP_CM_EARLY_CONFIG_TOUCH_DRIVER"
#define DIA_PROP_CM_EARLY_CONFIG_TOUCH_DRIVER2                 0xb463e992  // "DIA_PROP_CM_EARLY_CONFIG_TOUCH_DRIVER2"
#define DIA_PROP_CM_NAVI_UNIT                                  0x326b80ae  // "DIA_PROP_CM_NAVI_UNIT"
#define DIA_PROP_MAP_VERSION                                   0xa69356b5  // "DIA_PROP_MAP_VERSION"
#define DIA_PROP_CM_EARLY_CONFIG_TWO_DISPLAY                   0x6a6cebc1  // "DIA_PROP_CM_EARLY_CONFIG_TWO_DISPLAY"
#define DIA_PROP_CM_DRM_TUNER_PARAMETER_SET                    0xdb6fb23c  // "DIA_PROP_CM_DRM_TUNER_PARAMETER_SET"

#define DIA_PROP_SWUPDATE_MOUNT_POINT                          0xfd4cc4fa  // "DIA_PROP_SWUPDATE_MOUNT_POINT"
#define DIA_PROP_SWUPDATE_PATH                                 0x521ebacb  // "DIA_PROP_SWUPDATE_PATH"
#define DIA_PROP_SWUPDATE_FILE                                 0x52195ffe  // "DIA_PROP_SWUPDATE_FILE"
#define DIA_PROP_CM_CONFIG_LAST_DIAG_ERROR                     0x857068c7  //"DIA_PROP_CM_CONFIG_LAST_DIAG_ERROR"

#define DIA_PROP_TEMPERATURE_HISTOGRAMS                        0x857068ff
#define DIA_PROP_NEXT_TEMPERATURE_HISTOGRAM                    0x857068fd

//--- property types ----------------------------------------------------------

enum dia_enPropType
{
    DIA_PROP_TYPE_UNKNOWN = 0,
    DIA_PROP_TYPE_BOOL,
    DIA_PROP_TYPE_U8,
    DIA_PROP_TYPE_U16,
    DIA_PROP_TYPE_U32,
    DIA_PROP_TYPE_STR,
    DIA_PROP_TYPE_RAW,
    DIA_PROP_TYPE_COUNT
};

//--- common registry path IDs for properties stored in the registry ----------

enum dia_enPropRegPath
{
    DIA_PROP_SRC_REG_PATH_UNKNOWN = DIA_PROP_RANGE_START_COMMON,
    DIA_PROP_SRC_REG_PATH_VERSIONS,
    DIA_PROP_SRC_REG_PATH_BOARD_CONFIG,
    DIA_PROP_SRC_REG_PATH_VERSIONS_BUILD,
    DIA_PROP_SRC_REG_PATH_VERSIONS_NAV,
    DIA_PROP_SRC_REG_PATH_VERSIONS_DNL,
    DIA_PROP_SRC_REG_PATH_DNL_STATUS,
    DIA_PROP_SRC_REG_PATH_VERSIONS_SXM,
    DIA_PROP_SRC_REG_PATH_SWUP,
    DIA_PROP_SRC_REG_PATH_COUNT
};
//--- common ADC Device Names for getting the Value  ----------
enum dia_enPropADCDevice
{
   DIA_PROP_SRC_ADC_DEVICE_UNKNOWN = DIA_PROP_RANGE_START_COMMON,
   DIA_PROP_SRC_ADC_DEVICE_GYRO_R,
   DIA_PROP_SRC_ADC_DEVICE_GYRO_S,
   DIA_PROP_SRC_ADC_DEVICE_GYRO_T,
   DIA_PROP_SRC_ADC_DEVICE_GPS_UANT,
   DIA_PROP_SRC_ADC_DEVICE_GPS_UTMP,
   DIA_PROP_SRC_ADC_DEVICE_GPS_VOLTAGE_SENSE,
   DIA_PROP_SRC_ADC_DEVICE_UBAT_DROP_DET,
   DIA_PROP_SRC_ADC_DEVICE_AMP_CLIP,
   DIA_PROP_SRC_ADC_DEVICE_DIAG_DAB_PHANTOM_ANT,
   DIA_PROP_SRC_ADC_DEVICE_DIAG_PHANTOM1_ANT,
   DIA_PROP_SRC_ADC_DEVICE_DIAG_PHANTOM2_ANT,
   DIA_PROP_SRC_ADC_DEVICE_CRADLE_KEY,
   DIA_PROP_SRC_ADC_DEVICE_CRADLE_DIAG,
   DIA_PROP_SRC_ADC_DEVICE_MIC_DIAG,
   DIA_PROP_SRC_ADC_DEVICE_MIC_DIAG_2,
   DIA_PROP_SRC_ADC_DEVICE_TEMP_SENSE,
   DIA_PROP_SRC_ADC_DEVICE_DIAG_AUX_R,
   DIA_PROP_SRC_ADC_DEVICE_DIAG_AUX_L,
   DIA_PROP_SRC_ADC_DEVICE_TEMP_SENSOR_1,
   DIA_PROP_SRC_ADC_DEVICE_TEMP_SENSOR_2,
   DIA_PROP_SRC_ADC_DEVICE_DIAG_PHANTOM_ANT,
   DIA_PROP_SRC_ADC_DEVICE_PWM_AMP_DIAG,
   DIA_PROP_SRC_ADC_DEVICE_PWM_DISPLAY_DIAG,
   DIA_PROP_SRC_ADC_DEVICE_STEERING_WHEEL,
   DIA_PROP_SRC_ADC_DEVICE_U33S_CPU_SWC,
   DIA_PROP_SRC_ADC_DEVICE_FAN_DIAG,
   DIA_PROP_SRC_ADC_DEVICE_TEMP_GPS,
   DIA_PROP_SRC_ADC_DEVICE_HALFCLASS_1,
   DIA_PROP_SRC_ADC_DEVICE_HALFCLASS_2,
   DIA_PROP_SRC_ADC_DEVICE_DIAG_PHANTOM_FM_ANT,
   DIA_PROP_SRC_ADC_DEVICE_DISP_TEMP_SENSE,
   DIA_PROP_SRC_ADC_DEVICE_GER_VAR,
   DIA_PROP_SRC_ADC_DEVICE_GPS_PHANTOM_DIAG,
   DIA_PROP_SRC_ADC_DEVICE_PHANTOM_2_DIAG,
   DIA_PROP_SRC_ADC_DEVICE_SWC_A,
   DIA_PROP_SRC_ADC_DEVICE_SWC_B,
   DIA_PROP_SRC_ADC_DEVICE_TOUCH_X_CO,
   DIA_PROP_SRC_ADC_DEVICE_TOUCH_Y_CO,
   DIA_PROP_SRC_ADC_DEVICE_XM_DAB_ANT_I_SENSE,
   DIA_PROP_SRC_ADC_DEVICE_CAMERA_VCC_DIAG,
   DIA_PROP_SRC_ADC_DEVICE_MIC_VCC_DIAG,
   DIA_PROP_SRC_ADC_DEVICE_GYRO_VDD_REF,
   DIA_PROP_SRC_ADC_DEVICE_INPUT_ECALL_MUTE,
   DIA_PROP_SRC_ADC_DEVICE_UBAT_SENSE,
   DIA_PROP_SRC_ADC_PATH_COUNT
};


enum dia_enPropGPIOKey
{
    DIA_PROP_SRC_GPIO_KEY_UNKNOWN = DIA_PROP_RANGE_START_COMMON,
    DIA_PROP_SRC_GPIO_KEY_IGNITION,
    DIA_PROP_SRC_GPIO_KEY_ILLUMINATION,
    DIA_PROP_SRC_GPIO_KEY_ACC,
    DIA_PROP_SRC_GPIO_KEY_REVERSE,
    DIA_PROP_SRC_GPIO_KEY_DAY_NIGHT_SWITCH,
    DIA_PROP_SRC_GPIO_KEY_CD_WACKUP,
    DIA_PROP_SRC_GPIO_MIC_VCC,
    DIA_PROP_SRC_GPIO_KEY_PARKING_BRAKE,
    DIA_PROP_SRC_GPIO_KEY_INPUT_ECALL_MUTE,
    DIA_PROP_SRC_GPIO_KEY_COUNT
};

enum dia_enPropEngineClientKey
{
   DIA_PROP_SRC_ENGINE_CLIENT_KEY_UNKNOWN = 0,
   DIA_PROP_SRC_ENGINE_CLIENT_KEY_SINGLE,       /* key shall be specified in property */
   DIA_PROP_SRC_ENGINE_CLIENT_KEY_MULTIPLE,     /* pointer to beginning of array and number of elements shall be specified */
   DIA_PROP_SRC_ENGINE_CLIENT_KEY_COUNT
};

extern const tChar* strDpNameEcnr;
extern const tChar* strDpElemNameEcnrBtPhoneNbData;
extern const tChar* strDpElemNameEcnrBtPhoneWbData;
extern const tChar* strDpElemNameEcnrBtVoiceNbData;
extern const tChar* strDpElemNameEcnrBtVoiceWbData;
extern const tChar* strDpElemNameEcnrBtSiriNbData;
extern const tChar* strDpElemNameEcnrBtSiriWbData;
extern const tChar* strDpElemNameEcnrCpVoiceNbData;
extern const tChar* strDpElemNameEcnrCpVoiceWbData;
extern const tChar* strDpElemNameEcnrCpVoiceSwbData;
extern const tChar* strDpElemNameEcnrCpPhoneNbData;
extern const tChar* strDpElemNameEcnrCpPhoneWbData;
extern const tChar* strDpElemNameEcnrCpPhoneSwbData;
extern const tChar* strDpElemNameEcnrCpFaceTimeSwbData;
extern const tChar* strDpElemNameEcnrAaVoiceNbData;
extern const tChar* strDpElemNameEcnrAaVoiceWbData;
extern const tChar* strDpElemNameEcnrAaVoiceSwbData;
extern const tChar* strDpElemNameEcnrAaPhoneNbData;
extern const tChar* strDpElemNameEcnrAaPhoneWbData;
extern const tChar* strDpElemNameEcnrAaPhoneSwbData;
extern const tChar* strDpElemNameEcnrIntVoiceNbData;
extern const tChar* strDpElemNameEcnrIntVoiceWbData;
extern const tChar* strDpElemNameEcnrVpaVoiceWbData;

extern const tChar* strDpNameAlignmentData;
extern const tChar* strDpNameADCRefPlusActualElemData;
extern const tChar* strDpNameCMVariantCoding;
extern const tChar* strDpNameCMVariantCodingValue;

extern const tChar* strScdKeyNameAppThread;
extern const tChar* strScdKeyValueThreadPrioEngineUDS;
extern const tChar* strScdKeyValueThreadStackSizeEngineUDS;

extern const tChar* strFilePathALDFeatureCMDiagnosisEnabled;

extern const tChar* strDpNameAudioSourceOffset;
extern const tChar* strDatasetNameAudioSrcOffset;

extern const tChar* strTouchCtrlSelfTestFilePath;

extern const tChar* strSwUpdateMountPoint;
extern const tChar* strSwUpdatePath;
extern const tChar* strSwUpdateFile;

extern const tChar* strOdxFileIdentifier;
extern const tChar* strOdxFileVersion;

extern const tChar* strDpNameTemperatureHistograms;
extern const tChar* strDpElementNameTemperatureHistograms;

#define DIA_C_U32_ENGINE_UDS_DEFAULT_THREAD_PRIO         ((tU32)  0x5f) //(OSAL_C_U32_THREAD_PRIORITY_NORMAL-1)
#define DIA_C_U32_ENGINE_UDS_DEFAULT_THREAD_STACK_SIZE   ((tU32) 30000)

#define DIA_C_U32_EVENT_WAIT_THREAD_DEFAULT_PRIO         ((tU32) 133  )
#define DIA_C_U32_EVENT_WAIT_THREAD_DEFAULT_STACKSIZE    ((tU32) 50000)
#define DIA_C_U32_TCP_THREAD_DEFAULT_PRIO                ((tU32) 35   )
#define DIA_C_U32_TCP_THREAD_DEFAULT_STACKSIZE           ((tU32) 5000 )
//--- common registry key IDs for properties stored in the registry -----------

//#############################################################################
//#
//# Detailed Property Definition
//#
//#############################################################################

struct dia_RegKeyInfo
{
   dia::UID mRegKeyID;
   const tChar* mRegKeyValue;
};

struct dia_RegPathInfo
{
   dia::UID mRegPathID;
   const tChar* mRegPathValue;
};
struct dia_RegADCPathInfo
{
    tU32 mRegADCID;
    const tChar* mRegADCPathValue;
};

//--- common registry keys ----------------------------------------------------
// 32-bit UID calculated using https://crccalc.com/ for CRC-32 (e.g. "DIA_PROP_SRC_REG_KEY_UNKNOWN" ==> 0xEEA5BDEE)

#define DIA_PROP_SRC_REG_KEY_UNKNOWN                           0xEEA5BDEE
#define DIA_PROP_SRC_REG_KEY_VERSION_IPOD                      0xD7F66FCD
#define DIA_PROP_SRC_REG_KEY_VERSION_HW_ADR                    0xDC5E30DB
#define DIA_PROP_SRC_REG_KEY_VERSION_HW_BLUETOOTH              0x64F37942
#define DIA_PROP_SRC_REG_KEY_VERSION_HW_DAB_MODULE             0x93F59E94
#define DIA_PROP_SRC_REG_KEY_VERSION_HW_FGS                    0x853B450B
#define DIA_PROP_SRC_REG_KEY_VERSION_HW_XM                     0x658B75E6
#define DIA_PROP_SRC_REG_KEY_VERSION_SW_ADR_PATCH              0x94541147
#define DIA_PROP_SRC_REG_KEY_VERSION_SW_ADR                    0xB54FC283
#define DIA_PROP_SRC_REG_KEY_VERSION_SW_BLUETOOTH              0x197930B0
#define DIA_PROP_SRC_REG_KEY_VERSION_SW_BLUETOOTH_BOOTLOADER   0xCA67A9C6
#define DIA_PROP_SRC_REG_KEY_VERSION_SW_BOOTMANAGER            0x70D12D1E
#define DIA_PROP_SRC_REG_KEY_VERSION_SW_DAB_MODULE             0xC03B87ED
#define DIA_PROP_SRC_REG_KEY_VERSION_SW_FGS                    0xEC2AB753
#define DIA_PROP_SRC_REG_KEY_VERSION_SW_FGS_BOOTLOADER         0x8C3D1985
#define DIA_PROP_SRC_REG_KEY_VERSION_SW_FGS_DATA               0xFE44D222
#define DIA_PROP_SRC_REG_KEY_VERSION_SW_FGS_TESTMANAGER        0xFE58E718
#define DIA_PROP_SRC_REG_KEY_VERSION_SW_HMI                    0xE1398BA9
#define DIA_PROP_SRC_REG_KEY_VERSION_SW_HMI_APP_ID             0x2CB7C9C4
#define DIA_PROP_SRC_REG_KEY_VERSION_SW_MAIN                   0xD249A88B
#define DIA_PROP_SRC_REG_KEY_VERSION_SW_MAIN_SEQ_NUM           0x2643E897
#define DIA_PROP_SRC_REG_KEY_VERSION_SW_NAVI                   0x93C29C58
#define DIA_PROP_SRC_REG_KEY_VERSION_SW_PLATFORM               0x802222D9
#define DIA_PROP_SRC_REG_KEY_VERSION_SW_PLATFORM_DSP           0x15DB1B0A
#define DIA_PROP_SRC_REG_KEY_VERSION_SW_RADIO_LIB              0xC201FA46
#define DIA_PROP_SRC_REG_KEY_VERSION_SW_RADIO_UNIT             0xEAD34864
#define DIA_PROP_SRC_REG_KEY_VERSION_SW_SPEECHDATA             0x61EA6B5B
#define DIA_PROP_SRC_REG_KEY_VERSION_SW_SPEECHDATA_DATE_BUILD  0xA9E9FC91
#define DIA_PROP_SRC_REG_KEY_VERSION_SW_SPEECHDATA_DATE_MSM    0x686CC136
#define DIA_PROP_SRC_REG_KEY_VERSION_SW_SPEECHDATA_DATE_MNM    0x9700AD2A
#define DIA_PROP_SRC_REG_KEY_VERSION_SW_SYSTEM_ARION           0x180B3303
#define DIA_PROP_SRC_REG_KEY_VERSION_SW_TESTMANAGER            0x6B44023A
#define DIA_PROP_SRC_REG_KEY_VERSION_DATA_CARRIER_WORM_ID      0x68B80FB5
#define DIA_PROP_SRC_REG_KEY_VERSION_APPLE_COPRO               0x9A31085E
#define DIA_PROP_SRC_REG_KEY_VERSION_CPLD_VERSION              0x9152A861
#define DIA_PROP_SRC_REG_KEY_DOWNLOAD_STATUS_BT                0x9BBAF8DE
#define DIA_PROP_SRC_REG_KEY_DOWNLOAD_STATUS_DAB               0x181810BC
#define DIA_PROP_SRC_REG_KEY_VERSION_SW_RBCM_ECU               0xD2332C84
#define DIA_PROP_SRC_REG_KEY_VERSION_SW_RBCM_ECU_BUILD         0x2D4FFE2D
#define DIA_PROP_SRC_REG_KEY_VERSION_SW_CUSTOMER               0x38497C1B
#define DIA_PROP_SRC_REG_KEY_SXM_SERIALNO_VER                  0x0EFBABF3
#define DIA_PROP_SRC_REG_KEY_SXM_SW_VER                        0x82035D05
#define DIA_PROP_SRC_REG_KEY_SXM_SXM_HW_VER                    0xA990C596
#define DIA_PROP_SRC_REG_KEY_SXM_DOWNL_STRING                  0x18EE746D
#define DIA_PROP_SRC_REG_KEY_SXM_DOWNL_VERSION                 0x18FDA564
#define DIA_PROP_SRC_REG_KEY_CM_CONFIG_ID                      0x7E82A851
#define DIA_PROP_SRC_REG_KEY_CUSTOMER_DEFAULT_CONFIG_ID        0x800C4D03
#define DIA_PROP_SRC_REG_KEY_CUSTOMER_CONFIG_FINGERPRINT       0x8E9022FC
#define DIA_PROP_SRC_REG_KEY_CUSTOMER_CONFIG_PART_NUMBER       0x1226B1EB
#define DIA_PROP_SRC_REG_KEY_ECU_UID                           0x27B5DB80
#define DIA_PROP_SRC_REG_KEY_VERSION_SW_SCC                    0x8F1C03A8
#define DIA_PROP_SRC_REG_KEY_VERSION_BL_SCC                    0x50A67405
#define DIA_PROP_SRC_REG_KEY_VERSION_BM_SCC                    0x6DC65DB5
#define DIA_PROP_SRC_REG_KEY_VERSION_LABEL_SW_SCC              0x76ACBFA9
#define DIA_PROP_SRC_REG_KEY_VERSION_LABEL_BL_SCC              0xA916C804
#define DIA_PROP_SRC_REG_KEY_VERSION_LABEL_BM_SCC              0x9476E1B4
#define DIA_PROP_SRC_REG_KEY_PDX_FOLDER                        0x491EA828

const dia_RegKeyInfo
aCommonRegKeyData[] =
{
    { DIA_PROP_SRC_REG_KEY_UNKNOWN,                         "Unknown"                       },
    { DIA_PROP_SRC_REG_KEY_VERSION_IPOD,                    "IPOD_SW_VERSION"               },
    { DIA_PROP_SRC_REG_KEY_VERSION_HW_ADR,                  "ADR_HW_Version"                },
    { DIA_PROP_SRC_REG_KEY_VERSION_HW_BLUETOOTH,            "Bluetooth_HW_Version"          },
    { DIA_PROP_SRC_REG_KEY_VERSION_HW_DAB_MODULE,           "DABMODULE_HW_VERSION"          },
    { DIA_PROP_SRC_REG_KEY_VERSION_HW_FGS,                  "FGSVersion_HW"                 },
    { DIA_PROP_SRC_REG_KEY_VERSION_HW_XM,                   "XM_TUNER_HW_VER"               },
    { DIA_PROP_SRC_REG_KEY_VERSION_SW_ADR_PATCH,            "ADR_PATCH_Version"             },
    { DIA_PROP_SRC_REG_KEY_VERSION_SW_ADR,                  "ADR_SW_Version"                },
    { DIA_PROP_SRC_REG_KEY_VERSION_SW_BLUETOOTH,            "Bluetooth_SW_Version"          },
    { DIA_PROP_SRC_REG_KEY_VERSION_SW_BLUETOOTH_BOOTLOADER, "Bluetooth_HW_LoaderVersion"    },
    { DIA_PROP_SRC_REG_KEY_VERSION_SW_BOOTMANAGER,          "BOOTMANAGER_VERSION_SW"        },
    { DIA_PROP_SRC_REG_KEY_VERSION_SW_DAB_MODULE,           "DABMODULE_SW_VERSION"          },
    { DIA_PROP_SRC_REG_KEY_VERSION_SW_FGS,                  "FGSVersion_SW"                 },
    { DIA_PROP_SRC_REG_KEY_VERSION_SW_FGS_BOOTLOADER,       "FGSVersion_Downloader"         },
    { DIA_PROP_SRC_REG_KEY_VERSION_SW_FGS_DATA,             "XML_VERSION_FGS"               },
    { DIA_PROP_SRC_REG_KEY_VERSION_SW_FGS_TESTMANAGER,      "FGSVersion_Testmanager"        },
    { DIA_PROP_SRC_REG_KEY_VERSION_SW_HMI,                  "XML_VERSION_ARION"             },
    { DIA_PROP_SRC_REG_KEY_VERSION_SW_HMI_APP_ID,           "SW_APP_ID"                     },
    { DIA_PROP_SRC_REG_KEY_VERSION_SW_MAIN,                 "MAIN_VERSION_SW"               },
    { DIA_PROP_SRC_REG_KEY_VERSION_SW_MAIN_SEQ_NUM,         "ECU_SW_NUMBER_SEQUENCE_NUMBER" },
    { DIA_PROP_SRC_REG_KEY_VERSION_SW_NAVI,                 "REGISTRY_VERSION"              },
    { DIA_PROP_SRC_REG_KEY_VERSION_SW_PLATFORM,             "PLATFORM_SW_VERSION"           },
    { DIA_PROP_SRC_REG_KEY_VERSION_SW_PLATFORM_DSP,         "DSP_VERSION"                   },
    { DIA_PROP_SRC_REG_KEY_VERSION_SW_RADIO_LIB,            "Radio_Lib_Version"             },
    { DIA_PROP_SRC_REG_KEY_VERSION_SW_RADIO_UNIT,           "RU_SW_VERSION"                 },
    { DIA_PROP_SRC_REG_KEY_VERSION_SW_SPEECHDATA,           "SDS_VERSION"                   },
    { DIA_PROP_SRC_REG_KEY_VERSION_SW_SPEECHDATA_DATE_BUILD,"SDS_BUILD_DATE"                },
    { DIA_PROP_SRC_REG_KEY_VERSION_SW_SPEECHDATA_DATE_MSM,  "SDS_CREATE_DATE_MSM"           },
    { DIA_PROP_SRC_REG_KEY_VERSION_SW_SPEECHDATA_DATE_MNM,  "SDS_CREATE_DATE_MNM"           },
    { DIA_PROP_SRC_REG_KEY_VERSION_SW_SYSTEM_ARION,         "BASE_SW_VERSION"               },
    { DIA_PROP_SRC_REG_KEY_VERSION_SW_TESTMANAGER,          "TESTMANAGER_VERSION_SW"        },
    { DIA_PROP_SRC_REG_KEY_VERSION_DATA_CARRIER_WORM_ID,    "NAVI_MEDIA_DESCRIPTION0"       },
    { DIA_PROP_SRC_REG_KEY_VERSION_APPLE_COPRO,             "APPLECP_VERSION"               },
    { DIA_PROP_SRC_REG_KEY_VERSION_CPLD_VERSION,            "CPLD_VERSION"                  },
    { DIA_PROP_SRC_REG_KEY_DOWNLOAD_STATUS_BT,              "STATE_BT"                      },
    { DIA_PROP_SRC_REG_KEY_DOWNLOAD_STATUS_DAB,             "STATE_DAB"                     },
    { DIA_PROP_SRC_REG_KEY_VERSION_SW_RBCM_ECU,             "BUILDVERSION_CUSTVERSTRING"    },
    { DIA_PROP_SRC_REG_KEY_VERSION_SW_RBCM_ECU_BUILD,       "BUILDVERSION_LABEL"            },
    { DIA_PROP_SRC_REG_KEY_VERSION_SW_CUSTOMER,             "CUSTOMERVERSION"               },
    { DIA_PROP_SRC_REG_KEY_SXM_SERIALNO_VER,                "SXM_SERIALNO_VER"              },
    { DIA_PROP_SRC_REG_KEY_SXM_SW_VER,                      "SXM_SW_VER"                    },
    { DIA_PROP_SRC_REG_KEY_SXM_SXM_HW_VER,                  "SXM_HW_VER"                    },
    { DIA_PROP_SRC_REG_KEY_SXM_DOWNL_STRING,                "SXM_DOWNL_STRING"              },
    { DIA_PROP_SRC_REG_KEY_SXM_DOWNL_VERSION,               "SXM_DOWNL_VERSION"             },
    { DIA_PROP_SRC_REG_KEY_CM_CONFIG_ID,                    "BOSCH_CONFIGURATION_ID"        },
    { DIA_PROP_SRC_REG_KEY_CUSTOMER_DEFAULT_CONFIG_ID,      "CUSTOMER_DEFAULT_CONFIG_ID"    },
    { DIA_PROP_SRC_REG_KEY_CUSTOMER_CONFIG_FINGERPRINT,     "CUSTOMER_CONFIG_FINGERPRINT"   },
    { DIA_PROP_SRC_REG_KEY_CUSTOMER_CONFIG_PART_NUMBER,     "CUSTOMER_CONFIG_PART_NUMBER"   },
    { DIA_PROP_SRC_REG_KEY_ECU_UID,                         "ECU_UID"                       },
    { DIA_PROP_SRC_REG_KEY_VERSION_SW_SCC,                  "SCC_APP_VERSION"               },
    { DIA_PROP_SRC_REG_KEY_VERSION_BL_SCC,                  "SCC_BL_VERSION"                },
    { DIA_PROP_SRC_REG_KEY_VERSION_BM_SCC,                  "SCC_BM_VERSION"                },
    { DIA_PROP_SRC_REG_KEY_VERSION_LABEL_SW_SCC,            "SCC_APP_LABEL"                 },
    { DIA_PROP_SRC_REG_KEY_VERSION_LABEL_BL_SCC,            "SCC_BL_LABEL"                  },
    { DIA_PROP_SRC_REG_KEY_VERSION_LABEL_BM_SCC,            "SCC_BM_LABEL"                  }
};

//--- common registry pathes --------------------------------------------------

const dia_RegPathInfo
aCommonRegPathData[] =
{
    { DIA_PROP_SRC_REG_PATH_UNKNOWN,         "" }, // not used
    { DIA_PROP_SRC_REG_PATH_VERSIONS,        "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/VERSIONS" },
    { DIA_PROP_SRC_REG_PATH_BOARD_CONFIG,    "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/VERSIONS/BOARDCFG" },
    { DIA_PROP_SRC_REG_PATH_VERSIONS_NAV,    "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/PROCESS/NAVAPP" },
    { DIA_PROP_SRC_REG_PATH_VERSIONS_DNL,    "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/VERSIONS/DOWNLOAD" },
    { DIA_PROP_SRC_REG_PATH_DNL_STATUS,      "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/PROCESS/BASE/DOWNLOAD" },
    { DIA_PROP_SRC_REG_PATH_VERSIONS_BUILD,  "HKEY_LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/VERSIONS" },
    { DIA_PROP_SRC_REG_PATH_VERSIONS_SXM,    "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/PROCESS/PROCSXM/FC_SXM" }
};

//--- common ADC pathes --------------------------------------------------

const dia_RegADCPathInfo
aCommonRegADCPathData[] =
{
   { DIA_PROP_SRC_ADC_DEVICE_UNKNOWN,                 ""                                             }, // not used
   { DIA_PROP_SRC_ADC_DEVICE_GYRO_R,                  OSAL_C_STRING_DEVICE_ADC_GYRO_R                }, //1100
   { DIA_PROP_SRC_ADC_DEVICE_GYRO_S,                  OSAL_C_STRING_DEVICE_ADC_GYRO_S                }, //1101...
   { DIA_PROP_SRC_ADC_DEVICE_GYRO_T,                  OSAL_C_STRING_DEVICE_ADC_GYRO_T                },
   { DIA_PROP_SRC_ADC_DEVICE_GPS_UANT,                OSAL_C_STRING_DEVICE_ADC_GPS_UANT              },
   { DIA_PROP_SRC_ADC_DEVICE_GPS_UTMP,                OSAL_C_STRING_DEVICE_ADC_GPS_UTMP              },
   { DIA_PROP_SRC_ADC_DEVICE_GPS_VOLTAGE_SENSE,       OSAL_C_STRING_DEVICE_ADC_GPS_VOLTAGE_SENSE     },
   { DIA_PROP_SRC_ADC_DEVICE_UBAT_DROP_DET,           OSAL_C_STRING_DEVICE_ADC_10                    },               //OSAL_C_STRING_DEVICE_ADC_UBAT_DROP_DET         },
   { DIA_PROP_SRC_ADC_DEVICE_AMP_CLIP,                OSAL_C_STRING_DEVICE_ADC_AMP_CLIP              },
   { DIA_PROP_SRC_ADC_DEVICE_DIAG_DAB_PHANTOM_ANT,    OSAL_C_STRING_DEVICE_ADC_DIAG_DAB_PHANTOM_ANT  },
   { DIA_PROP_SRC_ADC_DEVICE_DIAG_PHANTOM1_ANT,       OSAL_C_STRING_DEVICE_ADC_DIAG_PHANTOM1_ANT     },
   { DIA_PROP_SRC_ADC_DEVICE_DIAG_PHANTOM2_ANT,       OSAL_C_STRING_DEVICE_ADC_DIAG_PHANTOM2_ANT     },
   { DIA_PROP_SRC_ADC_DEVICE_CRADLE_KEY,              OSAL_C_STRING_DEVICE_ADC_CRADLE_KEY            },
   { DIA_PROP_SRC_ADC_DEVICE_CRADLE_DIAG,             OSAL_C_STRING_DEVICE_ADC_CRADLE_DIAG           },
   { DIA_PROP_SRC_ADC_DEVICE_MIC_DIAG,                OSAL_C_STRING_DEVICE_ADC_MIC_DIAG              },
   { DIA_PROP_SRC_ADC_DEVICE_MIC_DIAG_2,              OSAL_C_STRING_DEVICE_ADC_MIC_DIAG_2            },
   { DIA_PROP_SRC_ADC_DEVICE_TEMP_SENSE,              OSAL_C_STRING_DEVICE_ADC_TEMP_SENSE            },
   { DIA_PROP_SRC_ADC_DEVICE_DIAG_AUX_R,              OSAL_C_STRING_DEVICE_ADC_DIAG_AUX_R            },
   { DIA_PROP_SRC_ADC_DEVICE_DIAG_AUX_L,              OSAL_C_STRING_DEVICE_ADC_DIAG_AUX_L            },
   { DIA_PROP_SRC_ADC_DEVICE_TEMP_SENSOR_1,           OSAL_C_STRING_DEVICE_ADC_TEMP_SENSOR_1         },
   { DIA_PROP_SRC_ADC_DEVICE_TEMP_SENSOR_2,           OSAL_C_STRING_DEVICE_ADC_TEMP_SENSOR_2         },
   { DIA_PROP_SRC_ADC_DEVICE_DIAG_PHANTOM_ANT,        OSAL_C_STRING_DEVICE_ADC_DIAG_PHANTOM_ANT      },
   { DIA_PROP_SRC_ADC_DEVICE_PWM_AMP_DIAG,            OSAL_C_STRING_DEVICE_ADC_PWM_AMP_DIAG          },
   { DIA_PROP_SRC_ADC_DEVICE_PWM_DISPLAY_DIAG,        OSAL_C_STRING_DEVICE_ADC_PWM_DISPLAY_DIAG      },
   { DIA_PROP_SRC_ADC_DEVICE_STEERING_WHEEL,          OSAL_C_STRING_DEVICE_ADC_STEERING_WHEEL        },
   { DIA_PROP_SRC_ADC_DEVICE_U33S_CPU_SWC,            OSAL_C_STRING_DEVICE_ADC_U33S_CPU_SWC          },
   { DIA_PROP_SRC_ADC_DEVICE_FAN_DIAG,                OSAL_C_STRING_DEVICE_ADC_FAN_DIAG              },
   { DIA_PROP_SRC_ADC_DEVICE_TEMP_GPS,                OSAL_C_STRING_DEVICE_ADC_TEMP_GPS              },
   { DIA_PROP_SRC_ADC_DEVICE_HALFCLASS_1,             OSAL_C_STRING_DEVICE_ADC_HALFCLASS_1           },
   { DIA_PROP_SRC_ADC_DEVICE_HALFCLASS_2,             OSAL_C_STRING_DEVICE_ADC_HALFCLASS_2           },
   { DIA_PROP_SRC_ADC_DEVICE_DIAG_PHANTOM_FM_ANT,     OSAL_C_STRING_DEVICE_ADC_DIAG_PHANTOM_FM_ANT   },
   { DIA_PROP_SRC_ADC_DEVICE_DISP_TEMP_SENSE,         OSAL_C_STRING_DEVICE_ADC_DISP_TEMP_SENSE       },
   { DIA_PROP_SRC_ADC_DEVICE_GER_VAR,                 OSAL_C_STRING_DEVICE_ADC_7                     },//               OSAL_C_STRING_DEVICE_ADC_GER_VAR               },
   { DIA_PROP_SRC_ADC_DEVICE_GPS_PHANTOM_DIAG,        OSAL_C_STRING_DEVICE_ADC_GPS_PHANTOM_DIAG      },
   { DIA_PROP_SRC_ADC_DEVICE_PHANTOM_2_DIAG,          OSAL_C_STRING_DEVICE_ADC_PHANTOM_2_DIAG        },
   { DIA_PROP_SRC_ADC_DEVICE_SWC_A,                   OSAL_C_STRING_DEVICE_ADC_SWC_A                 },
   { DIA_PROP_SRC_ADC_DEVICE_SWC_B,                   OSAL_C_STRING_DEVICE_ADC_SWC_B                 },
   { DIA_PROP_SRC_ADC_DEVICE_TOUCH_X_CO,              OSAL_C_STRING_DEVICE_ADC_TOUCH_X_CO            },
   { DIA_PROP_SRC_ADC_DEVICE_TOUCH_Y_CO,              OSAL_C_STRING_DEVICE_ADC_TOUCH_Y_CO            },
   { DIA_PROP_SRC_ADC_DEVICE_XM_DAB_ANT_I_SENSE,      OSAL_C_STRING_DEVICE_ADC_XM_DAB_ANT_I_SENSE    },
   { DIA_PROP_SRC_ADC_DEVICE_CAMERA_VCC_DIAG,         OSAL_C_STRING_DEVICE_ADC_CAMERA_VCC_DIAG       },
   { DIA_PROP_SRC_ADC_DEVICE_MIC_VCC_DIAG,            OSAL_C_STRING_DEVICE_ADC_MIC_VCC_DIAG          },
   { DIA_PROP_SRC_ADC_DEVICE_GYRO_VDD_REF,            OSAL_C_STRING_DEVICE_ADC_GYRO_VDD_REF          },   //1040
   { DIA_PROP_SRC_ADC_DEVICE_INPUT_ECALL_MUTE,        OSAL_C_STRING_DEVICE_ADC_JACK_DETECT           },
   { DIA_PROP_SRC_ADC_DEVICE_UBAT_SENSE,              OSAL_C_STRING_DEVICE_ADC_UBAT_SENSE            }
};

const dia_RegKeyInfo
aNissanGPIOData[] =
{
    { DIA_PROP_SRC_REG_KEY_UNKNOWN,                   "Unknown"                   },
    { DIA_PROP_SRC_GPIO_KEY_IGNITION,                 "GPIO_IGNITION"             },
    { DIA_PROP_SRC_GPIO_KEY_ILLUMINATION,             "GPIO_ILLUMINATION"         },
    { DIA_PROP_SRC_GPIO_KEY_ACC,                      "GPIO_ACC"                  },
    { DIA_PROP_SRC_GPIO_KEY_REVERSE,                  "GPIO_REVERSE"              },
    { DIA_PROP_SRC_GPIO_KEY_DAY_NIGHT_SWITCH,         "GPIO_DAY_NIGHT_SWITCH"     },
    { DIA_PROP_SRC_GPIO_KEY_CD_WACKUP,                "GPIO_CD_WAKEUP"            },
    { DIA_PROP_SRC_GPIO_MIC_VCC,                      "GPIO_MIC_VCC_ON"           },
    { DIA_PROP_SRC_GPIO_KEY_PARKING_BRAKE,            "GPIO_PARKING_BRAKE"        },
    { DIA_PROP_SRC_GPIO_KEY_INPUT_ECALL_MUTE,         "GPIO_INPUT_ECALL_MUTE"     }
};
//------------------------------------------------------------------------------

struct dia_FingerprintInfo
{
   tU32 mProperty;
   tU8  mCrcLen;
};

struct dia_PropertyInfo
{
    tU32             mPropKey;
    dia_enPropType   mPropType;
    tU16             mStatusMask;
    size_t             mPropSize;
    dia_UID          mPropLoc;
    intptr_t         mPropExtData[DIA_PROP_EXT_DATA_ELEM_MAX];
};

enum dia_PropertyInfo_statusMask_enum {
    SM_NO_STATUS_MASK     = 0x0000,
    SM_ZERO_PADDED        = 0x0001, // fill remaining bytes in data buffer with zeros
    SM_ZERO_TERMINATED    = 0x0002, // value has zero termination at the end of the data
    SM_DISABLE_FLUSH      = 0x0004, // skip flush operation at writing
    SM_VAR_LEN            = 0x0008, // size value defines the maximum value, in concrete use case less bytes might be stored, but not more
    SM_NO_DEFAULT         = 0x0010, // no default data is available
    SM_LEADING_ZERO       = 0x0020, // fill leading bytes in the data buffer with ASCII '0'
    SM_READ_ONLY          = 0x0040  // property could be read only (e.g. in case of communication with another ECU WDBI with multiple DIDs is not possible, used by dia_PropertyBagEngineClient)
};

#define DIA_C_U16_PROP_SM_NONE               ((tU16) 0x0000)
#define DIA_C_U16_PROP_SM_ZERO_PADDED        ((tU16) 0x0001)
#define DIA_C_U16_PROP_SM_ZERO_TERMINATED    ((tU16) 0x0002)
#define DIA_C_U16_PROP_SM_FLUSH_DISABLED     ((tU16) 0x0004)
#define DIA_C_U16_PROP_SM_VARIABLE_LENGTH    ((tU16) 0x0008)
#define DIA_C_U16_PROP_SM_NO_DEFAULTS        ((tU16) 0x0010)

extern const dia_PropertyInfo aCommonPropData[];
namespace dia
{
   size_t getCommonPropDataSize();
}
#endif
