/*
 * dia_defsConfig.cpp
 *
 *  Created on: 12.06.2014
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_DEFS_CONFIG__
#include "common/framework/config/dia_defsConfig.h"
#endif

const tChar* strDpNameEcnr                                        = "DPAID_DatasetEcnr";
const tChar* strDpElemNameEcnrBtPhoneNbData                       = "DataEcnrBtPhoneNB";
const tChar* strDpElemNameEcnrBtPhoneWbData                       = "DataEcnrBtPhoneWB";
const tChar* strDpElemNameEcnrBtVoiceNbData                       = "DataEcnrBtVoiceNB";
const tChar* strDpElemNameEcnrBtVoiceWbData                       = "DataEcnrBtVoiceWB";
const tChar* strDpElemNameEcnrBtSiriNbData                        = "DataEcnrBtSiriNB";
const tChar* strDpElemNameEcnrBtSiriWbData                        = "DataEcnrBtSiriWB";
const tChar* strDpElemNameEcnrCpVoiceNbData                       = "DataEcnrCpVoiceNB";
const tChar* strDpElemNameEcnrCpVoiceWbData                       = "DataEcnrCpVoiceWB";
const tChar* strDpElemNameEcnrCpVoiceSwbData                      = "DataEcnrCpVoiceSWB";
const tChar* strDpElemNameEcnrCpPhoneNbData                       = "DataEcnrCpPhoneNB";
const tChar* strDpElemNameEcnrCpPhoneWbData                       = "DataEcnrCpPhoneWB";
const tChar* strDpElemNameEcnrCpPhoneSwbData                      = "DataEcnrCpPhoneSWB";
const tChar* strDpElemNameEcnrCpFaceTimeSwbData                   = "DataEcnrCpFacetimeSWB";
const tChar* strDpElemNameEcnrAaVoiceNbData                       = "DataEcnrAaVoiceNB";
const tChar* strDpElemNameEcnrAaVoiceWbData                       = "DataEcnrAaVoiceWB";
const tChar* strDpElemNameEcnrAaVoiceSwbData                      = "DataEcnrAaVoiceSWB";
const tChar* strDpElemNameEcnrAaPhoneNbData                       = "DataEcnrAaPhoneNB";
const tChar* strDpElemNameEcnrAaPhoneWbData                       = "DataEcnrAaPhoneWB";
const tChar* strDpElemNameEcnrAaPhoneSwbData                      = "DataEcnrAaPhoneSWB";
const tChar* strDpElemNameEcnrIntVoiceNbData                      = "DataEcnrIntVoiceNB";
const tChar* strDpElemNameEcnrIntVoiceWbData                      = "DataEcnrIntVoiceWB";
const tChar* strDpElemNameEcnrVpaVoiceWbData                      = "DataEcnrVpaVoiceWB";

const tChar* strDpNameAlignmentData                               = "DPCMD_AlignmentData";
const tChar* strDpNameADCRefPlusActualElemData                    = "ADCRefPlusActualVoltageValues";
const tChar* strDpNameCMVariantCoding                             = "DPCMD_CMVariantCoding";
const tChar* strDpNameCMVariantCodingValue                        = "CMVariantCodingValue";

const tChar* strScdKeyNameAppThread                               = "APP_THREAD";
const tChar* strScdKeyValueThreadPrioEngineUDS                    = "DIA_UDS_PRIO";
const tChar* strScdKeyValueThreadStackSizeEngineUDS               = "DIA_UDS_STCK";

const tChar* strFilePathALDFeatureCMDiagnosisEnabled              = "/var/opt/bosch/persistent/diagnosis/.security/ald_feature_cm_diagnosis_enabled";

const tChar* strDpNameAudioSourceOffset                           = "aidDpDatasetAudioSourceOffsetIn";    // Name as in "aidDpDatasetAudioSourceOffsetIn.xml"
const tChar* strDatasetNameAudioSrcOffset                         = "DataAudioSourceOffset";              // Name as in "aidDpDatasetAudioSourceOffsetIn.xml"

const tChar* strTouchCtrlSelfTestFilePath                         = "/sys/devices/soc0/soc.0/2100000.aips-bus/21a0000.i2c/i2c-0/0-004a/t25"; // path can be different for other projects

const tChar* strSwUpdateMountPoint                                = "/var/opt/bosch/persistent";
const tChar* strSwUpdatePath                                      = "fcswupdate";
const tChar* strSwUpdateFile                                      = "bosch.xml";
const tChar* lastdiagerror                                        = "No_error_information_set";

const tChar* strOdxFileIdentifier                                 = "CM_BV";
const tChar* strOdxFileVersion                                    = "00030003"; // MajorVersion 3 MinorVersion 3

const tChar* testContentRamProperty_250                           = "testContentRamProperty_250_00000000000000000111111111111111111111111112222222222222222222222222222222333333333333333333333333333888888888888888888888888888888444444444444444444444444444777777777777777777777777777777775555555555555555555555555";
const tChar* testContentRamProperty_4500                          = "testContentRamProperty_4500_00000000000000000111111111111111111111111112222222222222222222222222222222333333333333333333333333333888888888888888888888888888888444444444444444444444444444777777777777777777777777777777775555555555555555555555555";

const tChar* strDpNameTemperatureHistograms                       = "DPCMD_TemperatureHistograms";
const tChar* strDpElementNameTemperatureHistograms                = "TemperatureHistograms";


//#############################################################################
//#
//# Detailed descriptions of common properties
//#
//#############################################################################

const dia_PropertyInfo aCommonPropData[] =
{
//    key                                           type               statMask           size     location               extended data
    { DIA_PROP_VERSION_APPLE_COPRO,                 DIA_PROP_TYPE_U32, SM_NO_STATUS_MASK,    4,    DIA_PROP_SRC_REGISTRY, {(intptr_t)DIA_PROP_SRC_REG_KEY_VERSION_APPLE_COPRO,              DIA_PROP_SRC_REG_PATH_VERSIONS, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_VERSION_DATACARRIER_WORM_ID,         DIA_PROP_TYPE_STR, SM_ZERO_TERMINATED, 240,    DIA_PROP_SRC_REGISTRY, {(intptr_t)DIA_PROP_SRC_REG_KEY_VERSION_DATA_CARRIER_WORM_ID,     DIA_PROP_SRC_REG_PATH_VERSIONS, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_VERSION_IPOD,                        DIA_PROP_TYPE_U32, SM_NO_STATUS_MASK,    4,    DIA_PROP_SRC_REGISTRY, {(intptr_t)DIA_PROP_SRC_REG_KEY_VERSION_IPOD,                     DIA_PROP_SRC_REG_PATH_VERSIONS, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_VERSION_HW_ADR,                      DIA_PROP_TYPE_STR, SM_ZERO_TERMINATED, 240,    DIA_PROP_SRC_REGISTRY, {(intptr_t)DIA_PROP_SRC_REG_KEY_VERSION_HW_ADR,                   DIA_PROP_SRC_REG_PATH_VERSIONS, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_VERSION_HW_BLUETOOTH,                DIA_PROP_TYPE_STR, SM_ZERO_TERMINATED, 240,    DIA_PROP_SRC_REGISTRY, {(intptr_t)DIA_PROP_SRC_REG_KEY_VERSION_HW_BLUETOOTH,             DIA_PROP_SRC_REG_PATH_VERSIONS, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_VERSION_HW_DAB_MODULE,               DIA_PROP_TYPE_STR, SM_NO_STATUS_MASK,   32,    DIA_PROP_SRC_REGISTRY, {(intptr_t)DIA_PROP_SRC_REG_KEY_VERSION_HW_DAB_MODULE,            DIA_PROP_SRC_REG_PATH_VERSIONS, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_VERSION_HW_FGS,                      DIA_PROP_TYPE_STR, SM_NO_STATUS_MASK,   32,    DIA_PROP_SRC_REGISTRY, {(intptr_t)DIA_PROP_SRC_REG_KEY_VERSION_HW_FGS,                   DIA_PROP_SRC_REG_PATH_VERSIONS, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_VERSION_HW_XM,                       DIA_PROP_TYPE_U32, SM_NO_STATUS_MASK,    4,    DIA_PROP_SRC_REGISTRY, {(intptr_t)DIA_PROP_SRC_REG_KEY_VERSION_HW_XM,                    DIA_PROP_SRC_REG_PATH_VERSIONS, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_VERSION_SW_ADR_PATCH,                DIA_PROP_TYPE_STR, SM_NO_STATUS_MASK,   32,    DIA_PROP_SRC_REGISTRY, {(intptr_t)DIA_PROP_SRC_REG_KEY_VERSION_SW_ADR_PATCH,             DIA_PROP_SRC_REG_PATH_VERSIONS, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_VERSION_SW_ADR,                      DIA_PROP_TYPE_STR, SM_ZERO_TERMINATED, 240,    DIA_PROP_SRC_REGISTRY, {(intptr_t)DIA_PROP_SRC_REG_KEY_VERSION_SW_ADR,                   DIA_PROP_SRC_REG_PATH_VERSIONS, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_VERSION_SW_BLUETOOTH,                DIA_PROP_TYPE_STR, SM_ZERO_TERMINATED, 240,    DIA_PROP_SRC_REGISTRY, {(intptr_t)DIA_PROP_SRC_REG_KEY_VERSION_SW_BLUETOOTH,             DIA_PROP_SRC_REG_PATH_VERSIONS, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_VERSION_SW_BLUETOOTH_BOOTLOADER,     DIA_PROP_TYPE_STR, SM_NO_STATUS_MASK,   32,    DIA_PROP_SRC_REGISTRY, {(intptr_t)DIA_PROP_SRC_REG_KEY_VERSION_SW_BLUETOOTH_BOOTLOADER,  DIA_PROP_SRC_REG_PATH_VERSIONS, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_VERSION_SW_BOOTMGNR,                 DIA_PROP_TYPE_STR, SM_NO_STATUS_MASK,   32,    DIA_PROP_SRC_REGISTRY, {(intptr_t)DIA_PROP_SRC_REG_KEY_VERSION_SW_BOOTMANAGER,           DIA_PROP_SRC_REG_PATH_VERSIONS, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_VERSION_SW_CUSTOMER,                 DIA_PROP_TYPE_U8,  SM_NO_STATUS_MASK,    4,    DIA_PROP_SRC_REGISTRY, {(intptr_t)DIA_PROP_SRC_REG_KEY_VERSION_SW_CUSTOMER,              DIA_PROP_SRC_REG_PATH_VERSIONS, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_VERSION_SW_DAB_MODULE,               DIA_PROP_TYPE_STR, SM_NO_STATUS_MASK,   32,    DIA_PROP_SRC_REGISTRY, {(intptr_t)DIA_PROP_SRC_REG_KEY_VERSION_SW_DAB_MODULE,            DIA_PROP_SRC_REG_PATH_VERSIONS, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_VERSION_SW_FGS,                      DIA_PROP_TYPE_STR, SM_NO_STATUS_MASK,   32,    DIA_PROP_SRC_REGISTRY, {(intptr_t)DIA_PROP_SRC_REG_KEY_VERSION_SW_FGS,                   DIA_PROP_SRC_REG_PATH_VERSIONS, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_VERSION_SW_FGS_BOOTLOADER,           DIA_PROP_TYPE_STR, SM_NO_STATUS_MASK,   32,    DIA_PROP_SRC_REGISTRY, {(intptr_t)DIA_PROP_SRC_REG_KEY_VERSION_SW_FGS_BOOTLOADER,        DIA_PROP_SRC_REG_PATH_VERSIONS, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_VERSION_SW_FGS_DATA,                 DIA_PROP_TYPE_STR, SM_NO_STATUS_MASK,   64,    DIA_PROP_SRC_REGISTRY, {(intptr_t)DIA_PROP_SRC_REG_KEY_VERSION_SW_FGS_DATA,              DIA_PROP_SRC_REG_PATH_VERSIONS, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_VERSION_SW_FGS_TESTMANAGER,          DIA_PROP_TYPE_STR, SM_NO_STATUS_MASK,   32,    DIA_PROP_SRC_REGISTRY, {(intptr_t)DIA_PROP_SRC_REG_KEY_VERSION_SW_FGS_TESTMANAGER,       DIA_PROP_SRC_REG_PATH_VERSIONS, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_VERSION_SW_HMI,                      DIA_PROP_TYPE_STR, SM_NO_STATUS_MASK,   64,    DIA_PROP_SRC_REGISTRY, {(intptr_t)DIA_PROP_SRC_REG_KEY_VERSION_SW_HMI,                   DIA_PROP_SRC_REG_PATH_VERSIONS, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_VERSION_SW_HMI_APP_ID,               DIA_PROP_TYPE_STR, SM_NO_STATUS_MASK,   64,    DIA_PROP_SRC_REGISTRY, {(intptr_t)DIA_PROP_SRC_REG_KEY_VERSION_SW_HMI_APP_ID,            DIA_PROP_SRC_REG_PATH_VERSIONS, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_VERSION_SW_MAIN,                     DIA_PROP_TYPE_STR, SM_NO_STATUS_MASK,   12,    DIA_PROP_SRC_REGISTRY, {(intptr_t)DIA_PROP_SRC_REG_KEY_VERSION_SW_MAIN,                  DIA_PROP_SRC_REG_PATH_VERSIONS, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_VERSION_SW_MAIN_SEQ_NUM,             DIA_PROP_TYPE_STR, SM_NO_STATUS_MASK,    2,    DIA_PROP_SRC_REGISTRY, {(intptr_t)DIA_PROP_SRC_REG_KEY_VERSION_SW_MAIN_SEQ_NUM,          DIA_PROP_SRC_REG_PATH_VERSIONS, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_VERSION_SW_PLATFORM,                 DIA_PROP_TYPE_STR, SM_NO_STATUS_MASK,   64,    DIA_PROP_SRC_REGISTRY, {(intptr_t)DIA_PROP_SRC_REG_KEY_VERSION_SW_PLATFORM,              DIA_PROP_SRC_REG_PATH_VERSIONS, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_VERSION_SW_PLATFORM_DSP,             DIA_PROP_TYPE_STR, SM_NO_STATUS_MASK,   32,    DIA_PROP_SRC_REGISTRY, {(intptr_t)DIA_PROP_SRC_REG_KEY_VERSION_SW_PLATFORM_DSP,          DIA_PROP_SRC_REG_PATH_VERSIONS, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_VERSION_SW_RADIO_LIB,                DIA_PROP_TYPE_STR, SM_NO_STATUS_MASK,   32,    DIA_PROP_SRC_REGISTRY, {(intptr_t)DIA_PROP_SRC_REG_KEY_VERSION_SW_RADIO_LIB,             DIA_PROP_SRC_REG_PATH_VERSIONS, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_VERSION_SW_RADIO_UNIT,               DIA_PROP_TYPE_STR, SM_NO_STATUS_MASK,   32,    DIA_PROP_SRC_REGISTRY, {(intptr_t)DIA_PROP_SRC_REG_KEY_VERSION_SW_RADIO_UNIT,            DIA_PROP_SRC_REG_PATH_VERSIONS, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_VERSION_SW_SPEECHDATA,               DIA_PROP_TYPE_STR, SM_NO_STATUS_MASK,   32,    DIA_PROP_SRC_REGISTRY, {(intptr_t)DIA_PROP_SRC_REG_KEY_VERSION_SW_SPEECHDATA,            DIA_PROP_SRC_REG_PATH_VERSIONS, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_VERSION_SW_SPEECHDATA_DATE_BUILD,    DIA_PROP_TYPE_STR, SM_NO_STATUS_MASK,   32,    DIA_PROP_SRC_REGISTRY, {(intptr_t)DIA_PROP_SRC_REG_KEY_VERSION_SW_SPEECHDATA_DATE_BUILD, DIA_PROP_SRC_REG_PATH_VERSIONS, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_VERSION_SW_SPEECHDATA_DATE_MSM,      DIA_PROP_TYPE_STR, SM_NO_STATUS_MASK,   32,    DIA_PROP_SRC_REGISTRY, {(intptr_t)DIA_PROP_SRC_REG_KEY_VERSION_SW_SPEECHDATA_DATE_MSM,   DIA_PROP_SRC_REG_PATH_VERSIONS, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_VERSION_SW_SPEECHDATA_DATE_MNM,      DIA_PROP_TYPE_STR, SM_NO_STATUS_MASK,   32,    DIA_PROP_SRC_REGISTRY, {(intptr_t)DIA_PROP_SRC_REG_KEY_VERSION_SW_SPEECHDATA_DATE_MNM,   DIA_PROP_SRC_REG_PATH_VERSIONS, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_VERSION_SW_SYSTEM_ARION,             DIA_PROP_TYPE_STR, SM_NO_STATUS_MASK,   64,    DIA_PROP_SRC_REGISTRY, {(intptr_t)DIA_PROP_SRC_REG_KEY_VERSION_SW_SYSTEM_ARION,          DIA_PROP_SRC_REG_PATH_VERSIONS, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_VERSION_SW_TESTMGNR,                 DIA_PROP_TYPE_STR, SM_NO_STATUS_MASK,   32,    DIA_PROP_SRC_REGISTRY, {(intptr_t)DIA_PROP_SRC_REG_KEY_VERSION_SW_TESTMANAGER,           DIA_PROP_SRC_REG_PATH_VERSIONS, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_VERSION_CPLD_VERSION,                DIA_PROP_TYPE_STR, SM_ZERO_TERMINATED, 240,    DIA_PROP_SRC_REGISTRY, {(intptr_t)DIA_PROP_SRC_REG_KEY_VERSION_CPLD_VERSION,             DIA_PROP_SRC_REG_PATH_VERSIONS, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_CUSTOMER_CONFIG_FINGERPRINT,         DIA_PROP_TYPE_STR, SM_NO_STATUS_MASK,   47,    DIA_PROP_SRC_REGISTRY, {(intptr_t)DIA_PROP_SRC_REG_KEY_CUSTOMER_CONFIG_FINGERPRINT,      DIA_PROP_SRC_REG_PATH_VERSIONS, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_CUSTOMER_CONFIG_PART_NUMBER,         DIA_PROP_TYPE_STR, SM_NO_STATUS_MASK,   11,    DIA_PROP_SRC_REGISTRY, {(intptr_t)DIA_PROP_SRC_REG_KEY_CUSTOMER_CONFIG_PART_NUMBER,      DIA_PROP_SRC_REG_PATH_VERSIONS, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_ECU_UID,                             DIA_PROP_TYPE_RAW, SM_NO_STATUS_MASK,   20,    DIA_PROP_SRC_REGISTRY, {(intptr_t)DIA_PROP_SRC_REG_KEY_ECU_UID,                          DIA_PROP_SRC_REG_PATH_VERSIONS, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    // properties for testing
    { DIA_PROP_TEST_PROPERTY_RAM_250,               DIA_PROP_TYPE_STR, SM_NO_STATUS_MASK,  250,    DIA_PROP_SRC_RAM,      {(intptr_t)testContentRamProperty_250} },
    { DIA_PROP_TEST_PROPERTY_RAM_4500,              DIA_PROP_TYPE_STR, SM_NO_STATUS_MASK, 4500,    DIA_PROP_SRC_RAM,      {(intptr_t)testContentRamProperty_4500} },

    { DIA_PROP_DOWNLOAD_STATUS_BLUETOOTH,           DIA_PROP_TYPE_U32, SM_NO_STATUS_MASK,    4,    DIA_PROP_SRC_REGISTRY, {(intptr_t)DIA_PROP_SRC_REG_KEY_DOWNLOAD_STATUS_BT,               DIA_PROP_SRC_REG_PATH_DNL_STATUS, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_DOWNLOAD_STATUS_DAB,                 DIA_PROP_TYPE_U32, SM_NO_STATUS_MASK,    4,    DIA_PROP_SRC_REGISTRY, {(intptr_t)DIA_PROP_SRC_REG_KEY_DOWNLOAD_STATUS_DAB,              DIA_PROP_SRC_REG_PATH_DNL_STATUS, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },

    { DIA_PROP_DEFAULT_SESSION,                     DIA_PROP_TYPE_U8,  SM_NO_STATUS_MASK,    1,    DIA_PROP_SRC_RAM,      {0x00,   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_SESSION_CTRL_SUPPORT_SPR,            DIA_PROP_TYPE_U8,  SM_NO_STATUS_MASK,    1,    DIA_PROP_SRC_RAM,      {0x01,   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_DEFAULT_SPEED_THRESHOLD,             DIA_PROP_TYPE_U8,  SM_NO_STATUS_MASK,    1,    DIA_PROP_SRC_RAM,      {0x06,   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_UNDEFINED_SPEED_THRESHOLD,           DIA_PROP_TYPE_U8,  SM_NO_STATUS_MASK,    1,    DIA_PROP_SRC_RAM,      {0xFF,   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },

    { DIA_PROP_CM_CONFIG_ID,                        DIA_PROP_TYPE_STR, SM_NO_STATUS_MASK,   47,    DIA_PROP_SRC_REGISTRY, {(intptr_t)DIA_PROP_SRC_REG_KEY_CM_CONFIG_ID,                     DIA_PROP_SRC_REG_PATH_VERSIONS, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_CUSTOMER_DEFAULT_CONFIG_ID,          DIA_PROP_TYPE_STR, SM_NO_STATUS_MASK,   47,    DIA_PROP_SRC_REGISTRY, {(intptr_t)DIA_PROP_SRC_REG_KEY_CUSTOMER_DEFAULT_CONFIG_ID,       DIA_PROP_SRC_REG_PATH_VERSIONS, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_CM_MIN_LEN_IOCONTROL_MESSAGE,        DIA_PROP_TYPE_U8,  SM_NO_STATUS_MASK,    1,    DIA_PROP_SRC_RAM,      {0x04,   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },  //minimal length of IO Control message    (e.g. 2F AA BB 01)
    { DIA_PROP_CM_MIN_LEN_ROUTINECTRL_MESSAGE,      DIA_PROP_TYPE_U8,  SM_NO_STATUS_MASK,    1,    DIA_PROP_SRC_RAM,      {0x04,   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },  //minimal length of Routine Ctrl message  (e.g. 31 AA BB 01)

    { DIA_PROP_PROD_DAY_INDEX,                      DIA_PROP_TYPE_STR, SM_NO_STATUS_MASK,    4,    DIA_PROP_SRC_KDS,      {0x01B3, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, // KDS Production Day Index
    { DIA_PROP_SW_INDEX,                            DIA_PROP_TYPE_STR, SM_NO_STATUS_MASK,   12,    DIA_PROP_SRC_KDS,      {0x0DD9, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, // KDS Software Index
    { DIA_PROP_SPEED_LOCK,                          DIA_PROP_TYPE_U8,  SM_NO_STATUS_MASK,    2,    DIA_PROP_SRC_KDS,      {0x0DE6, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, // KDS Speed Lock
    { DIA_PROP_ENG_TEST_MODE,                       DIA_PROP_TYPE_U8,  SM_NO_STATUS_MASK,    1,    DIA_PROP_SRC_KDS,      {0x0DE4, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, // KDS Speed Lock

                                                                                                                                                                      /*Resolution*/ /*Bitmask */
    { DIA_PROP_CM_ADC_DEVICE_AMP_CLIP,              DIA_PROP_TYPE_U16, SM_NO_STATUS_MASK,    4,    DIA_PROP_SRC_ADC,      {DIA_PROP_SRC_ADC_DEVICE_AMP_CLIP            , 0x0A        , 0x00000FFF,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, // ADC test
    { DIA_PROP_CM_ADC_DEVICE_CRADLE_KEY,            DIA_PROP_TYPE_U16, SM_NO_STATUS_MASK,    4,    DIA_PROP_SRC_ADC,      {DIA_PROP_SRC_ADC_DEVICE_CRADLE_KEY          , 0x0A        , 0x00000FFF,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, // ADC test
    { DIA_PROP_CM_ADC_DEVICE_CRADLE_DIAG,           DIA_PROP_TYPE_U16, SM_NO_STATUS_MASK,    4,    DIA_PROP_SRC_ADC,      {DIA_PROP_SRC_ADC_DEVICE_CRADLE_DIAG         , 0x0A        , 0x00000FFF,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, // ADC test
    { DIA_PROP_CM_ADC_DEVICE_DIAG_DAB_PHANTOM_ANT,  DIA_PROP_TYPE_U16, SM_NO_STATUS_MASK,    4,    DIA_PROP_SRC_ADC,      {DIA_PROP_SRC_ADC_DEVICE_DIAG_DAB_PHANTOM_ANT, 0x0A        , 0x00000FFF,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, // ADC test
    { DIA_PROP_CM_ADC_DEVICE_DIAG_PHANTOM1_ANT,     DIA_PROP_TYPE_U16, SM_NO_STATUS_MASK,    4,    DIA_PROP_SRC_ADC,      {DIA_PROP_SRC_ADC_DEVICE_DIAG_PHANTOM1_ANT   , 0x0A        , 0x00000FFF,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, // ADC test
    { DIA_PROP_CM_ADC_DEVICE_DIAG_PHANTOM2_ANT,     DIA_PROP_TYPE_U16, SM_NO_STATUS_MASK,    4,    DIA_PROP_SRC_ADC,      {DIA_PROP_SRC_ADC_DEVICE_DIAG_PHANTOM2_ANT   , 0x0A        , 0x00000FFF,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, // ADC test
    { DIA_PROP_CM_ADC_DEVICE_GYRO_R,                DIA_PROP_TYPE_U16, SM_NO_STATUS_MASK,    4,    DIA_PROP_SRC_ADC,      {DIA_PROP_SRC_ADC_DEVICE_GYRO_R              , 0x0A        , 0x00000FFF,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, // ADC test
    { DIA_PROP_CM_ADC_DEVICE_GYRO_S,                DIA_PROP_TYPE_U16, SM_NO_STATUS_MASK,    4,    DIA_PROP_SRC_ADC,      {DIA_PROP_SRC_ADC_DEVICE_GYRO_S              , 0x0A        , 0x00000FFF,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, // ADC test
    { DIA_PROP_CM_ADC_DEVICE_GYRO_T,                DIA_PROP_TYPE_U16, SM_NO_STATUS_MASK,    4,    DIA_PROP_SRC_ADC,      {DIA_PROP_SRC_ADC_DEVICE_GYRO_T              , 0x0A        , 0x00000FFF,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, // ADC test
    { DIA_PROP_CM_ADC_DEVICE_GPS_UANT,              DIA_PROP_TYPE_U16, SM_NO_STATUS_MASK,    4,    DIA_PROP_SRC_ADC,      {DIA_PROP_SRC_ADC_DEVICE_GPS_UANT            , 0x0A        , 0x00000FFF,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, // ADC test
    { DIA_PROP_CM_ADC_DEVICE_GPS_UTMP,              DIA_PROP_TYPE_U16, SM_NO_STATUS_MASK,    4,    DIA_PROP_SRC_ADC,      {DIA_PROP_SRC_ADC_DEVICE_GPS_UTMP            , 0x0A        , 0x00000FFF,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, // ADC test
    { DIA_PROP_CM_ADC_DEVICE_GPS_VOLTAGE_SENSE,     DIA_PROP_TYPE_U16, SM_NO_STATUS_MASK,    4,    DIA_PROP_SRC_ADC,      {DIA_PROP_SRC_ADC_DEVICE_GPS_VOLTAGE_SENSE   , 0x0A        , 0x00000FFF,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, // ADC test
    { DIA_PROP_CM_ADC_DEVICE_UBAT_DROP_DET,         DIA_PROP_TYPE_U16, SM_NO_STATUS_MASK,    4,    DIA_PROP_SRC_ADC,      {DIA_PROP_SRC_ADC_DEVICE_UBAT_DROP_DET       , 0x0A        , 0x00000FFF,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, // ADC test
    { DIA_PROP_CM_ADC_DEVICE_MIC_DIAG,              DIA_PROP_TYPE_U16, SM_NO_STATUS_MASK,    4,    DIA_PROP_SRC_ADC,      {DIA_PROP_SRC_ADC_DEVICE_MIC_DIAG            , 0x0A        , 0x00000FFF,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, // ADC test
    { DIA_PROP_CM_ADC_DEVICE_MIC_DIAG_2,            DIA_PROP_TYPE_U16, SM_NO_STATUS_MASK,    4,    DIA_PROP_SRC_ADC,      {DIA_PROP_SRC_ADC_DEVICE_MIC_DIAG_2          , 0x0A        , 0x00000FFF,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, // ADC test
    { DIA_PROP_CM_ADC_DEVICE_TEMP_SENSE,            DIA_PROP_TYPE_U16, SM_NO_STATUS_MASK,    4,    DIA_PROP_SRC_ADC,      {DIA_PROP_SRC_ADC_DEVICE_TEMP_SENSE          , 0x0A        , 0x00000FFF,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, // ADC test
    { DIA_PROP_CM_ADC_DEVICE_DIAG_AUX_R,            DIA_PROP_TYPE_U16, SM_NO_STATUS_MASK,    4,    DIA_PROP_SRC_ADC,      {DIA_PROP_SRC_ADC_DEVICE_DIAG_AUX_R          , 0x0A        , 0x00000FFF,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, // ADC test
    { DIA_PROP_CM_ADC_DEVICE_DIAG_AUX_L,            DIA_PROP_TYPE_U16, SM_NO_STATUS_MASK,    4,    DIA_PROP_SRC_ADC,      {DIA_PROP_SRC_ADC_DEVICE_DIAG_AUX_L          , 0x0A        , 0x00000FFF,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, // ADC test
    { DIA_PROP_CM_ADC_DEVICE_TEMP_SENSOR_1,         DIA_PROP_TYPE_U16, SM_NO_STATUS_MASK,    4,    DIA_PROP_SRC_ADC,      {DIA_PROP_SRC_ADC_DEVICE_TEMP_SENSOR_1       , 0x0A        , 0x00000FFF,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, // ADC test
    { DIA_PROP_CM_ADC_DEVICE_TEMP_SENSOR_2,         DIA_PROP_TYPE_U16, SM_NO_STATUS_MASK,    4,    DIA_PROP_SRC_ADC,      {DIA_PROP_SRC_ADC_DEVICE_TEMP_SENSOR_2       , 0x0A        , 0x00000FFF,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, // ADC test
    { DIA_PROP_CM_ADC_DEVICE_DIAG_PHANTOM_ANT,      DIA_PROP_TYPE_U16, SM_NO_STATUS_MASK,    4,    DIA_PROP_SRC_ADC,      {DIA_PROP_SRC_ADC_DEVICE_DIAG_PHANTOM_ANT    , 0x0A        , 0x00000FFF,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, // ADC test
    { DIA_PROP_CM_ADC_DEVICE_PWM_AMP_DIAG,          DIA_PROP_TYPE_U16, SM_NO_STATUS_MASK,    4,    DIA_PROP_SRC_ADC,      {DIA_PROP_SRC_ADC_DEVICE_PWM_AMP_DIAG        , 0x0A        , 0x00000FFF,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, // ADC test
    { DIA_PROP_CM_ADC_DEVICE_PWM_DISPLAY_DIAG,      DIA_PROP_TYPE_U16, SM_NO_STATUS_MASK,    4,    DIA_PROP_SRC_ADC,      {DIA_PROP_SRC_ADC_DEVICE_PWM_DISPLAY_DIAG    , 0x0A        , 0x00000FFF,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, // ADC test
    { DIA_PROP_CM_ADC_DEVICE_STEERING_WHEEL,        DIA_PROP_TYPE_U16, SM_NO_STATUS_MASK,    4,    DIA_PROP_SRC_ADC,      {DIA_PROP_SRC_ADC_DEVICE_STEERING_WHEEL      , 0x0A        , 0x00000FFF,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, // ADC test
    { DIA_PROP_CM_ADC_DEVICE_U33S_CPU_SWC,          DIA_PROP_TYPE_U16, SM_NO_STATUS_MASK,    4,    DIA_PROP_SRC_ADC,      {DIA_PROP_SRC_ADC_DEVICE_U33S_CPU_SWC        , 0x0A        , 0x00000FFF,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, // ADC test
    { DIA_PROP_CM_ADC_DEVICE_FAN_DIAG,              DIA_PROP_TYPE_U16, SM_NO_STATUS_MASK,    4,    DIA_PROP_SRC_ADC,      {DIA_PROP_SRC_ADC_DEVICE_FAN_DIAG            , 0x0A        , 0x00000FFF,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, // ADC test
    { DIA_PROP_CM_ADC_DEVICE_TEMP_GPS,              DIA_PROP_TYPE_U16, SM_NO_STATUS_MASK,    4,    DIA_PROP_SRC_ADC,      {DIA_PROP_SRC_ADC_DEVICE_TEMP_GPS            , 0x0A        , 0x00000FFF,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, // ADC test
    { DIA_PROP_CM_ADC_DEVICE_HALFCLASS_1,           DIA_PROP_TYPE_U16, SM_NO_STATUS_MASK,    4,    DIA_PROP_SRC_ADC,      {DIA_PROP_SRC_ADC_DEVICE_HALFCLASS_1         , 0x0A        , 0x00000FFF,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, // ADC test
    { DIA_PROP_CM_ADC_DEVICE_HALFCLASS_2,           DIA_PROP_TYPE_U16, SM_NO_STATUS_MASK,    4,    DIA_PROP_SRC_ADC,      {DIA_PROP_SRC_ADC_DEVICE_HALFCLASS_2         , 0x0A        , 0x00000FFF,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, // ADC test
    { DIA_PROP_CM_ADC_DEVICE_DIAG_PHANTOM_FM_ANT,   DIA_PROP_TYPE_U16, SM_NO_STATUS_MASK,    4,    DIA_PROP_SRC_ADC,      {DIA_PROP_SRC_ADC_DEVICE_DIAG_PHANTOM_FM_ANT , 0x0A        , 0x00000FFF,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, // ADC test
    { DIA_PROP_CM_ADC_DEVICE_DISP_TEMP_SENSE,       DIA_PROP_TYPE_U16, SM_NO_STATUS_MASK,    4,    DIA_PROP_SRC_ADC,      {DIA_PROP_SRC_ADC_DEVICE_DISP_TEMP_SENSE     , 0x0A        , 0x00000FFF,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, // ADC test
    { DIA_PROP_CM_ADC_DEVICE_GER_VAR,               DIA_PROP_TYPE_U16, SM_NO_STATUS_MASK,    4,    DIA_PROP_SRC_ADC,      {DIA_PROP_SRC_ADC_DEVICE_GER_VAR             , 0x0A        , 0x00000FFF,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, // ADC test
    { DIA_PROP_CM_ADC_DEVICE_GPS_PHANTOM_DIAG,      DIA_PROP_TYPE_U16, SM_NO_STATUS_MASK,    4,    DIA_PROP_SRC_ADC,      {DIA_PROP_SRC_ADC_DEVICE_GPS_PHANTOM_DIAG    , 0x0A        , 0x00000FFF,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, // ADC test
    { DIA_PROP_CM_ADC_DEVICE_PHANTOM_2_DIAG,        DIA_PROP_TYPE_U16, SM_NO_STATUS_MASK,    4,    DIA_PROP_SRC_ADC,      {DIA_PROP_SRC_ADC_DEVICE_PHANTOM_2_DIAG      , 0x0A        , 0x00000FFF,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, // ADC test
    { DIA_PROP_CM_ADC_DEVICE_SWC_A,                 DIA_PROP_TYPE_U16, SM_NO_STATUS_MASK,    4,    DIA_PROP_SRC_ADC,      {DIA_PROP_SRC_ADC_DEVICE_SWC_A               , 0x0A        , 0x00000FFF,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, // ADC test
    { DIA_PROP_CM_ADC_DEVICE_SWC_B,                 DIA_PROP_TYPE_U16, SM_NO_STATUS_MASK,    4,    DIA_PROP_SRC_ADC,      {DIA_PROP_SRC_ADC_DEVICE_SWC_B               , 0x0A        , 0x00000FFF,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, // ADC test
    { DIA_PROP_CM_ADC_DEVICE_TOUCH_X_CO,            DIA_PROP_TYPE_U16, SM_NO_STATUS_MASK,    4,    DIA_PROP_SRC_ADC,      {DIA_PROP_SRC_ADC_DEVICE_TOUCH_X_CO          , 0x0A        , 0x00000FFF,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, // ADC test
    { DIA_PROP_CM_ADC_DEVICE_TOUCH_Y_CO,            DIA_PROP_TYPE_U16, SM_NO_STATUS_MASK,    4,    DIA_PROP_SRC_ADC,      {DIA_PROP_SRC_ADC_DEVICE_TOUCH_Y_CO          , 0x0A        , 0x00000FFF,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, // ADC test
    { DIA_PROP_CM_ADC_DEVICE_XM_DAB_ANT_I_SENSE,    DIA_PROP_TYPE_U16, SM_NO_STATUS_MASK,    4,    DIA_PROP_SRC_ADC,      {DIA_PROP_SRC_ADC_DEVICE_XM_DAB_ANT_I_SENSE  , 0x0A        , 0x00000FFF,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, // ADC test
    { DIA_PROP_CM_ADC_DEVICE_CAMERA_VCC_DIAG,       DIA_PROP_TYPE_U16, SM_NO_STATUS_MASK,    4,    DIA_PROP_SRC_ADC,      {DIA_PROP_SRC_ADC_DEVICE_CAMERA_VCC_DIAG     , 0x0A        , 0x00000FFF,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, // ADC test
    { DIA_PROP_CM_ADC_DEVICE_MIC_VCC_DIAG,          DIA_PROP_TYPE_U16, SM_NO_STATUS_MASK,    4,    DIA_PROP_SRC_ADC,      {DIA_PROP_SRC_ADC_DEVICE_MIC_VCC_DIAG        , 0x0A        , 0x00000FFF,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, // ADC test
    { DIA_PROP_CM_ADC_DEVICE_GYRO_VDD_REF,          DIA_PROP_TYPE_U16, SM_NO_STATUS_MASK,    4,    DIA_PROP_SRC_ADC,      {DIA_PROP_SRC_ADC_DEVICE_GYRO_VDD_REF        , 0x0A        , 0x00000FFF,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, // ADC test
    { DIA_PROP_CM_ADC_DEVICE_INPUT_ECALL_MUTE,      DIA_PROP_TYPE_U16, SM_NO_STATUS_MASK,    4,    DIA_PROP_SRC_ADC,      {DIA_PROP_SRC_ADC_DEVICE_INPUT_ECALL_MUTE    , 0x0A        , 0x00000FFF,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, // ADC ECALL MUTE
    { DIA_PROP_CM_ADC_DEVICE_UBAT_SENSE,            DIA_PROP_TYPE_U16, SM_NO_STATUS_MASK,    4,    DIA_PROP_SRC_ADC,      {DIA_PROP_SRC_ADC_DEVICE_UBAT_SENSE          , 0x0A        , 0x00000FFF,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, // ADC UBAT SENSE

    // Bosch Car Multimedia configuration string and associated properties
    { DIA_PROP_CM_VARIANT_CODING,                   DIA_PROP_TYPE_STR, SM_NO_STATUS_MASK,   32,    DIA_PROP_SRC_KDS,      {0x0DF4, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, // CMVariantCoding (DID $8100)
    { DIA_PROP_CM_VARIANT_CODING_SCC,               DIA_PROP_TYPE_STR, SM_NO_STATUS_MASK,   32,    DIA_PROP_SRC_DP,       {(intptr_t)strDpNameCMVariantCoding,  0x0114, 0xfffD, (intptr_t) strDpNameCMVariantCodingValue,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_CM_EXTENDED_VARIANT_CODING,          DIA_PROP_TYPE_STR, SM_NO_STATUS_MASK,  230,    DIA_PROP_SRC_KDS,      {0xA013, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, // CMExtendedVariantCoding (DID $810C)
    { DIA_PROP_CM_CONFIG_EXT_DATA_CHECK_MODE,       DIA_PROP_TYPE_U8,  SM_NO_STATUS_MASK,    1,    DIA_PROP_SRC_RAM,      {0x00  , 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_CM_CONFIG_DISPLAY_TYPE,              DIA_PROP_TYPE_U8,  SM_NO_STATUS_MASK,    1,    DIA_PROP_SRC_RAM,      {0x00  , 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, // undefined
    { DIA_PROP_CM_CONFIG_OEM_TYPE,                  DIA_PROP_TYPE_U8,  SM_NO_STATUS_MASK,    1,    DIA_PROP_SRC_RAM,      {0x00  , 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, // VW
    { DIA_PROP_CM_CONFIG_TUNER_MODE,                DIA_PROP_TYPE_U8,  SM_NO_STATUS_MASK,    1,    DIA_PROP_SRC_RAM,      {0x00  , 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, // single tuner
    { DIA_PROP_CM_CONFIG_TUNER_SUPPORT_XM,          DIA_PROP_TYPE_U8,  SM_NO_STATUS_MASK,    1,    DIA_PROP_SRC_RAM,      {0x00  , 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, // not available
    { DIA_PROP_CM_CONFIG_TUNER_SUPPORT_DAB,         DIA_PROP_TYPE_U8,  SM_NO_STATUS_MASK,    1,    DIA_PROP_SRC_RAM,      {0x00  , 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, // not available
    { DIA_PROP_CM_CONFIG_SIZE_RAM,                  DIA_PROP_TYPE_U8,  SM_NO_STATUS_MASK,    1,    DIA_PROP_SRC_RAM,      {0x00  , 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, // unknown
    { DIA_PROP_CM_CONFIG_SIZE_ROM,                  DIA_PROP_TYPE_U8,  SM_NO_STATUS_MASK,    1,    DIA_PROP_SRC_RAM,      {0x00  , 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, // unknown
    { DIA_PROP_CM_CONFIG_INTERFACE_LOCK,            DIA_PROP_TYPE_U8,  SM_NO_STATUS_MASK,    1,    DIA_PROP_SRC_RAM,      {0x00  , 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, // unknown

    // Bosch Car Multimedia - production diagnosis
    { DIA_PROP_CM_TEST_SERVICE_0047,                DIA_PROP_TYPE_STR, SM_ZERO_PADDED,       7,    DIA_PROP_SRC_KDS,      {0x0D00, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },  // KDS Testfunktion
    { DIA_PROP_CM_ECU_SERIAL_NR,                    DIA_PROP_TYPE_STR, SM_NO_STATUS_MASK,    7,    DIA_PROP_SRC_KDS,      {0x0106, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },  // KDS Serial Number
//  { DIA_PROP_CM_ECU_SPARE_PART_NR,                DIA_PROP_TYPE_STR, SM_NO_STATUS_MASK,   10,    DIA_PROP_SRC_KDS,      {0x0105, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },  // KDS SparePartNumber
    { DIA_PROP_CM_ECU_SPARE_PART_NR,                DIA_PROP_TYPE_STR, SM_NO_STATUS_MASK,   32,   DIA_PROP_SRC_KDS_VARLEN,{0x0105, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },  // KDS SparePartNumber
    { DIA_PROP_CM_VARIANT_ID,                       DIA_PROP_TYPE_STR, SM_NO_STATUS_MASK,  230,   DIA_PROP_SRC_KDS_VARLEN,{0xA011, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },  // KDS SparePartNumber
    { DIA_PROP_CM_ECU_HW_VERSION,                   DIA_PROP_TYPE_STR, SM_NO_STATUS_MASK,    3,    DIA_PROP_SRC_KDS,      {0x010E, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },  // ECU Hardware Version      (with dummy KDS key)
    { DIA_PROP_CM_NAVI_UNIT,                        DIA_PROP_TYPE_STR, SM_NO_STATUS_MASK,    8,    DIA_PROP_SRC_KDS,      {0x2010, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },  // Navi Unit in KDS
    { DIA_PROP_CM_CUSTOMER_ECU_PART_NR,             DIA_PROP_TYPE_STR, SM_NO_STATUS_MASK,   10,    DIA_PROP_SRC_KDS,      {0xA124, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },  // CustomerECUPartNumber
    { DIA_PROP_CM_CUSTOMER_SERIAL_NR,               DIA_PROP_TYPE_STR, SM_ZERO_TERMINATED, 240,    DIA_PROP_SRC_KDS,      {0x0D02, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },  // customerSerialNumber      (with dummy KDS key)
    { DIA_PROP_CM_CUSTOMER_SPARE_PART_NR,           DIA_PROP_TYPE_STR, SM_ZERO_TERMINATED, 240,    DIA_PROP_SRC_KDS,      {0x0D03, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },  // customerSparePartNumber   (with dummy KDS key)
    { DIA_PROP_CM_NAVIGATION_DEFAULT_POSITION,      DIA_PROP_TYPE_STR, SM_NO_STATUS_MASK,    9,    DIA_PROP_SRC_KDS,      {0x0D05, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },  // navigationDefaultPosition
    { DIA_PROP_CM_NAVIGATION_SW_VERSION,            DIA_PROP_TYPE_STR, SM_ZERO_TERMINATED, 240,    DIA_PROP_SRC_REGISTRY, {(intptr_t)DIA_PROP_SRC_REG_KEY_VERSION_SW_NAVI, DIA_PROP_SRC_REG_PATH_VERSIONS_NAV, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },  // navigationSWVersion
    { DIA_PROP_CM_ECU_SW_VERSION,                   DIA_PROP_TYPE_STR, SM_ZERO_TERMINATED, 240,    DIA_PROP_SRC_REGISTRY, {(intptr_t)DIA_PROP_SRC_REG_KEY_VERSION_SW_RBCM_ECU,       DIA_PROP_SRC_REG_PATH_VERSIONS, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },  // ECUSWVersion
    { DIA_PROP_CM_MAINBOARD_SERIAL_NR,              DIA_PROP_TYPE_STR, SM_NO_STATUS_MASK,    7,    DIA_PROP_SRC_KDS,      {0x0D06, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },  // mainboardSerialNumber
    { DIA_PROP_CM_MAINBOARD_SPARE_PART_NR,          DIA_PROP_TYPE_STR, SM_NO_STATUS_MASK,   12,  DIA_PROP_SRC_KDS_VARLEN, {0x0D07, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },  // mainboardSparePartNumber
    { DIA_PROP_CM_ECU_SW_BUILD_VERSION,             DIA_PROP_TYPE_STR, SM_ZERO_TERMINATED, 240,    DIA_PROP_SRC_REGISTRY, {DIA_PROP_SRC_REG_KEY_VERSION_SW_RBCM_ECU_BUILD, DIA_PROP_SRC_REG_PATH_VERSIONS, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },  // ECUSWBuildVersionLabel
    { DIA_PROP_CM_ODX_FILE_IDENTIFIER,              DIA_PROP_TYPE_STR, SM_ZERO_TERMINATED, 240,    DIA_PROP_SRC_RAM,      {(intptr_t)strOdxFileIdentifier, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },  // ODXFileIdentifier    (default: NULL-Pointer; overloaded by project-part)
    { DIA_PROP_CM_ODX_FILE_VERSION,                 DIA_PROP_TYPE_STR, SM_NO_STATUS_MASK,    8,    DIA_PROP_SRC_RAM,      {(intptr_t)strOdxFileVersion, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },  // ODXFileVersion   (default: NULL-Pointer; overloaded by project-part)
    { DIA_PROP_CM_POI_ENCRYPTION_INFO,              DIA_PROP_TYPE_STR, SM_NO_STATUS_MASK,   16,    DIA_PROP_SRC_KDS,      {0x1216, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },  // POI encryption information
    { DIA_PROP_CM_ALD_SEED_INPUT_DATA,              DIA_PROP_TYPE_STR, SM_NO_STATUS_MASK,    7,    DIA_PROP_SRC_KDS,      {0x0D06, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },  // mainboardSerialNumber
    { DIA_PROP_VEHICLE_IDENTIFICATION_NUMBER,       DIA_PROP_TYPE_STR, SM_NO_STATUS_MASK,   17,    DIA_PROP_SRC_KDS,      {0xA012, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },  // Vehicle Identification Number

    { DIA_PROP_SYSTEM_SECURITY_LEVEL,               DIA_PROP_TYPE_U8,  SM_NO_STATUS_MASK,    1,    DIA_PROP_SRC_KDS,      {0x0DF5, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, // KDS System Security Level
    { DIA_PROP_SYSTEM_SECURITY_LEVEL_INVERT,        DIA_PROP_TYPE_U8,  SM_NO_STATUS_MASK,    1,    DIA_PROP_SRC_KDS,      {0x0DFB, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, // KDS System Security Level (inverted)
    { DIA_PROP_SYSTEM_SECURITY_LEVEL_UID,           DIA_PROP_TYPE_U32, SM_NO_STATUS_MASK,    4,    DIA_PROP_SRC_KDS,      {0xA020, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, // KDS System Security Level Gen3
    { DIA_PROP_SYSTEM_SECURITY_LEVEL_UID_INVERT,    DIA_PROP_TYPE_U32, SM_NO_STATUS_MASK,    4,    DIA_PROP_SRC_KDS,      {0xA021, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, // KDS System Security Level Gen3 (inverted)
    { DIA_PROP_CM_SECLEV_BOSCH_INVALID_KEY_COUNTER, DIA_PROP_TYPE_U32, SM_NO_STATUS_MASK,    4,    DIA_PROP_SRC_RAM,      {0x0000, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_CM_SECLEV_BOSCH_REMAINING_LOCK_TIME, DIA_PROP_TYPE_U32, SM_NO_STATUS_MASK,    4,    DIA_PROP_SRC_RAM,      {0x0000, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_CM_IMMOBILIZER,                      DIA_PROP_TYPE_U8,  SM_NO_STATUS_MASK,   16,    DIA_PROP_SRC_KDS,      {0x1215, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, // KDS System Security Level

    { DIA_PROP_CM_DIMMING_PARAMETER_SET,            DIA_PROP_TYPE_U8,  SM_NO_STATUS_MASK,  230,    DIA_PROP_SRC_KDS,      {0x0D08, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },  // DimmingParameterSet
    { DIA_PROP_CM_KEY_ILLUMINATION_ALIGNMENT_COEFF ,DIA_PROP_TYPE_U8,  SM_NO_STATUS_MASK,   10,    DIA_PROP_SRC_KDS,      {0x0D09, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },  // keyIlluminationAlignmentCoefficients

    { DIA_PROP_CM_ANTENNA_PARAMETER_SET,            DIA_PROP_TYPE_U8,  SM_NO_STATUS_MASK,  131,    DIA_PROP_SRC_KDS,      {0x0430, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },  // AntennaParamSet
    { DIA_PROP_CM_ANTENNA_2_PARAMETER_SET,          DIA_PROP_TYPE_U8,  SM_NO_STATUS_MASK,  297,    DIA_PROP_SRC_KDS,      {0x0431, 230, 0x0432, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },  // Antenna2ParamSet
    { DIA_PROP_CM_GENERIC_TUNER_PARAM_SET,          DIA_PROP_TYPE_U8,  SM_NO_STATUS_MASK,  417,    DIA_PROP_SRC_KDS,      {0x0420, 230, 0x0421, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },  // GenTunerParamSet
    { DIA_PROP_CM_FM_AM_TUNER_PARAMETER_SET,        DIA_PROP_TYPE_U8,  SM_NO_STATUS_MASK,  288,    DIA_PROP_SRC_KDS,      {0x0410, 230, 0x0411, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },  // FmAmTunerParamSet
    { DIA_PROP_CM_DAB_TUNER_PARAMETER_SET,          DIA_PROP_TYPE_U8,  SM_NO_STATUS_MASK,  230,    DIA_PROP_SRC_KDS,      {0x0440, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },  // DAB ParamSet
    { DIA_PROP_CM_HD_TUNER_PARAMETER_SET,           DIA_PROP_TYPE_U8,  SM_NO_STATUS_MASK,   64,    DIA_PROP_SRC_KDS,      {0x0450, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },  // DAB ParamSet

    { DIA_PROP_CM_NAVI_DATA_SEC_KEY,                DIA_PROP_TYPE_U8,  SM_NO_STATUS_MASK,   40,    DIA_PROP_SRC_KDS,      {0x1214, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },   // Navi data security key (ECC)
    { DIA_PROP_CM_SYSTEM_IDENTIFICATION,            DIA_PROP_TYPE_STR, SM_NO_STATUS_MASK,   24,    DIA_PROP_SRC_KDS,      {0x0DFC, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_CM_CONF_INFO,                        DIA_PROP_TYPE_STR, SM_NO_STATUS_MASK,   20,    DIA_PROP_SRC_KDS,      {0x0D30, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_CRIN_IDENTIFICATION,                 DIA_PROP_TYPE_STR, SM_NO_STATUS_MASK,   14,    DIA_PROP_SRC_KDS,      {0x0DFF, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_ADC_U_REF_REAL,                      DIA_PROP_TYPE_STR, SM_NO_STATUS_MASK,    2,    DIA_PROP_SRC_KDS,      {0x0DA0, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_ADC_THRESHOLDS_EMMC,                 DIA_PROP_TYPE_STR, SM_NO_STATUS_MASK,    4,    DIA_PROP_SRC_KDS,      {0x0DA1, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },

    { DIA_PROP_THERMALMNGMT_TEMPERATURE_THRESHOLDS, DIA_PROP_TYPE_STR, SM_NO_STATUS_MASK,  126,    DIA_PROP_SRC_KDS,      {0x1310, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },  //Thermalmanagement_Temperature threshold

    { DIA_PROP_CM_SXM_SERIALNO_VER,                 DIA_PROP_TYPE_STR, SM_ZERO_TERMINATED, 240,    DIA_PROP_SRC_REGISTRY, {(intptr_t)DIA_PROP_SRC_REG_KEY_SXM_SERIALNO_VER,          DIA_PROP_SRC_REG_PATH_VERSIONS_SXM, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },  // XMRadioID              NCG3D-9809 bma9kor
    { DIA_PROP_CM_SXM_SW_VER,                       DIA_PROP_TYPE_STR, SM_ZERO_TERMINATED, 240,    DIA_PROP_SRC_REGISTRY, {(intptr_t)DIA_PROP_SRC_REG_KEY_SXM_SW_VER,                DIA_PROP_SRC_REG_PATH_VERSIONS_SXM, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },  // XMSubModuleSWVersion   NCG3D-9809 bma9kor
    { DIA_PROP_CM_SXM_SXM_HW_VER,                   DIA_PROP_TYPE_STR, SM_ZERO_TERMINATED, 240,    DIA_PROP_SRC_REGISTRY, {(intptr_t)DIA_PROP_SRC_REG_KEY_SXM_SXM_HW_VER,            DIA_PROP_SRC_REG_PATH_VERSIONS_SXM, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },   // XMSubModuleHWVersion  NCG3D-9809 bma9kor

    { DIA_PROP_CM_SXM_SW_DOWNLOAD_STRING,           DIA_PROP_TYPE_STR, SM_ZERO_TERMINATED, 240,    DIA_PROP_SRC_REGISTRY, {(intptr_t)DIA_PROP_SRC_REG_KEY_SXM_DOWNL_STRING,          DIA_PROP_SRC_REG_PATH_VERSIONS, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },   // XMSubModuleSWUpdate
    { DIA_PROP_CM_SXM_SW_DOWNLOAD_VERSION,          DIA_PROP_TYPE_STR, SM_ZERO_TERMINATED, 240,    DIA_PROP_SRC_REGISTRY, {(intptr_t)DIA_PROP_SRC_REG_KEY_SXM_DOWNL_VERSION,         DIA_PROP_SRC_REG_PATH_VERSIONS, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },   // XMSubModuleSWUpdate

    { DIA_PROP_CM_VERSION_SW_SCC,                   DIA_PROP_TYPE_STR, SM_ZERO_TERMINATED, 240,    DIA_PROP_SRC_REGISTRY, {(intptr_t)DIA_PROP_SRC_REG_KEY_VERSION_SW_SCC,            DIA_PROP_SRC_REG_PATH_VERSIONS, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, //nbs3kor scc sw version
    { DIA_PROP_CM_VERSION_BL_SCC,                   DIA_PROP_TYPE_STR, SM_ZERO_TERMINATED, 240,    DIA_PROP_SRC_REGISTRY, {(intptr_t)DIA_PROP_SRC_REG_KEY_VERSION_BL_SCC,            DIA_PROP_SRC_REG_PATH_VERSIONS, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },  //rva5cob scc bl version
    { DIA_PROP_CM_VERSION_BM_SCC,                   DIA_PROP_TYPE_STR, SM_ZERO_TERMINATED, 240,    DIA_PROP_SRC_REGISTRY, {(intptr_t)DIA_PROP_SRC_REG_KEY_VERSION_BM_SCC,            DIA_PROP_SRC_REG_PATH_VERSIONS, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },  //rva5cob scc bm version
    { DIA_PROP_CM_VERSION_LABEL_SW_SCC,             DIA_PROP_TYPE_STR, SM_ZERO_TERMINATED, 240,    DIA_PROP_SRC_REGISTRY, {(intptr_t)DIA_PROP_SRC_REG_KEY_VERSION_LABEL_SW_SCC,      DIA_PROP_SRC_REG_PATH_VERSIONS, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },  // scc sw version label
    { DIA_PROP_CM_VERSION_LABEL_BL_SCC,             DIA_PROP_TYPE_STR, SM_ZERO_TERMINATED, 240,    DIA_PROP_SRC_REGISTRY, {(intptr_t)DIA_PROP_SRC_REG_KEY_VERSION_LABEL_BL_SCC,      DIA_PROP_SRC_REG_PATH_VERSIONS, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },  // scc bl version label
    { DIA_PROP_CM_VERSION_LABEL_BM_SCC,             DIA_PROP_TYPE_STR, SM_ZERO_TERMINATED, 240,    DIA_PROP_SRC_REGISTRY, {(intptr_t)DIA_PROP_SRC_REG_KEY_VERSION_LABEL_BM_SCC,      DIA_PROP_SRC_REG_PATH_VERSIONS, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },  // scc bm version label

    { DIA_PROP_CM_SENSOR_CONFIG_GNSS,               DIA_PROP_TYPE_U8,  SM_NO_STATUS_MASK,   12,    DIA_PROP_SRC_KDS,      {0x0530, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, //SensorConfigurationGNSS (DID $8104)
    { DIA_PROP_CM_SENSOR_CONFIG_GYRO,               DIA_PROP_TYPE_U8,  SM_NO_STATUS_MASK,  203,    DIA_PROP_SRC_KDS,      {0x0700, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, //SensorConfigurationGyro (DID $8105)
    { DIA_PROP_CM_SENSOR_CONFIG_ACC,                DIA_PROP_TYPE_STR, SM_NO_STATUS_MASK,  203,    DIA_PROP_SRC_KDS,      {0x0780, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, //SensorConfigurationACC (DID $8106)

    { DIA_PROP_CM_EVENT_LOGGER_MAX_ENTRIES,         DIA_PROP_TYPE_U32, SM_NO_STATUS_MASK,    4,    DIA_PROP_SRC_RAM,      {0x00  , 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },  //maximal number of entries in cyclic buffer of logger
    { DIA_PROP_CM_MIC_INVALID_CURRENT_VALUE,        DIA_PROP_TYPE_U16, SM_NO_STATUS_MASK,    2,    DIA_PROP_SRC_RAM,      {0x0000, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },  //invalid value for microphone current

    // GPIO Signals
    { DIA_PROP_GPIO_IGNITION,                       DIA_PROP_TYPE_BOOL, SM_NO_STATUS_MASK,   1,    DIA_PROP_SRC_GPIO,     {DIA_PROP_SRC_GPIO_KEY_UNKNOWN,                  OSAL_EN_IGNITION_DETECT,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },//DIA_PROP_SRC_GPIO_KEY_IGNITION
    { DIA_PROP_GPIO_ACC,                            DIA_PROP_TYPE_BOOL, SM_NO_STATUS_MASK,   1,    DIA_PROP_SRC_GPIO,     {DIA_PROP_SRC_GPIO_KEY_UNKNOWN,                  OSAL_EN_ACC_DETECT,               0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_GPIO_REVERSE_GEAR,                   DIA_PROP_TYPE_BOOL, SM_NO_STATUS_MASK,   1,    DIA_PROP_SRC_GPIO,     {DIA_PROP_SRC_GPIO_KEY_UNKNOWN,                  OSAL_EN_REVERSE_DETECT,                            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_GPIO_PARKING_BRAKE,                  DIA_PROP_TYPE_BOOL, SM_NO_STATUS_MASK,   1,    DIA_PROP_SRC_GPIO,     {DIA_PROP_SRC_GPIO_KEY_UNKNOWN,                  OSAL_EN_PKB_DETECT,                            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_GPIO_MR_OUNTPUT,                     DIA_PROP_TYPE_BOOL, SM_NO_STATUS_MASK,   1,    DIA_PROP_SRC_GPIO,     {DIA_PROP_SRC_GPIO_KEY_DAY_NIGHT_SWITCH,         DIA_PROP_SRC_REG_PATH_BOARD_CONFIG,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_GPIO_ILLUM,                          DIA_PROP_TYPE_BOOL, SM_NO_STATUS_MASK,   1,    DIA_PROP_SRC_GPIO,     {DIA_PROP_SRC_GPIO_KEY_UNKNOWN,                  OSAL_EN_ILLUMINATION_DETECT,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_GPIO_CD_WACKUP,                      DIA_PROP_TYPE_BOOL, SM_NO_STATUS_MASK,   1,    DIA_PROP_SRC_GPIO,     {DIA_PROP_SRC_GPIO_KEY_CD_WACKUP,                DIA_PROP_SRC_REG_PATH_BOARD_CONFIG,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_GPIO_CD_CDROM_RESET,                 DIA_PROP_TYPE_BOOL, SM_NO_STATUS_MASK,   1,    DIA_PROP_SRC_GPIO,     {DIA_PROP_SRC_GPIO_KEY_UNKNOWN,                  0x0431,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_GPIO_MIC_VCC,                        DIA_PROP_TYPE_BOOL, SM_NO_STATUS_MASK,   1,    DIA_PROP_SRC_GPIO,     {DIA_PROP_SRC_GPIO_MIC_VCC,                      DIA_PROP_SRC_REG_PATH_BOARD_CONFIG,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_GPIO_AUDIO_EXT_AMPLI,                DIA_PROP_TYPE_BOOL, SM_NO_STATUS_MASK,   1,    DIA_PROP_SRC_GPIO,     {DIA_PROP_SRC_GPIO_KEY_UNKNOWN,                  0x042D,                            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_GPIO_MICROPHONE_JACK_DETECT,         DIA_PROP_TYPE_BOOL, SM_NO_STATUS_MASK,   1,    DIA_PROP_SRC_GPIO,     {DIA_PROP_SRC_GPIO_KEY_UNKNOWN,                  OSAL_EN_MIC_DETECT,                            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
#ifdef __ENABLE_BTMODULE_OSAL_DEFINE__
    { DIA_PROP_GPIO_BT_MODULE_RESET,                DIA_PROP_TYPE_BOOL, SM_NO_STATUS_MASK,   1,    DIA_PROP_SRC_GPIO,     {DIA_PROP_SRC_GPIO_KEY_UNKNOWN,                  OSAL_EN_CPU_RST_BT,                            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
#endif
#ifdef __ENABLE_WIFIMODULE_OSAL_DEFINE__
    { DIA_PROP_GPIO_WIFI_MODULE_RESET,              DIA_PROP_TYPE_BOOL, SM_NO_STATUS_MASK,   1,    DIA_PROP_SRC_GPIO,     {DIA_PROP_SRC_GPIO_KEY_UNKNOWN,                  OSAL_EN_CPU_RST_WL,                            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
#endif
    { DIA_PROP_CM_AUDIO_PARAMETER_SET             , DIA_PROP_TYPE_U8,  SM_NO_STATUS_MASK,  230,    DIA_PROP_SRC_KDS,      {0x0D5F, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },    // Audio Parameter Set
    { DIA_PROP_CM_BLOCK_SIZE,                       DIA_PROP_TYPE_U8,  SM_NO_STATUS_MASK,    2,    DIA_PROP_SRC_KDS,      {0x0D13, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },

    { DIA_PROP_CM_DATASET_BLOCK_SIZE,               DIA_PROP_TYPE_U32, SM_NO_STATUS_MASK,    4,    DIA_PROP_SRC_RAM,      {DIA_C_U16_DATA_DOWNLOAD_BLOCK_MAX_BYTES, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },  // block size to be used for dataset up- and download

    // datapool properties                                                                                                                            dpname            dpid    subid   dpElemName
    { DIA_PROP_AID_DATASET_ECNR_BT_PHONE_NB,        DIA_PROP_TYPE_STR, (SM_VAR_LEN|SM_NO_DEFAULT),       20480,    DIA_PROP_SRC_DP,       {(intptr_t) strDpNameEcnr,    0x0114, 0xfffA, (intptr_t) strDpElemNameEcnrBtPhoneNbData,      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_AID_DATASET_ECNR_BT_PHONE_WB,        DIA_PROP_TYPE_STR, (SM_VAR_LEN|SM_NO_DEFAULT),       20480,    DIA_PROP_SRC_DP,       {(intptr_t) strDpNameEcnr,    0x0114, 0xfffA, (intptr_t) strDpElemNameEcnrBtPhoneWbData,      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_AID_DATASET_ECNR_BT_VOICE_NB,        DIA_PROP_TYPE_STR, (SM_VAR_LEN|SM_NO_DEFAULT),       20480,    DIA_PROP_SRC_DP,       {(intptr_t) strDpNameEcnr,    0x0114, 0xfffA, (intptr_t) strDpElemNameEcnrBtVoiceNbData,      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_AID_DATASET_ECNR_BT_VOICE_WB,        DIA_PROP_TYPE_STR, (SM_VAR_LEN|SM_NO_DEFAULT),       20480,    DIA_PROP_SRC_DP,       {(intptr_t) strDpNameEcnr,    0x0114, 0xfffA, (intptr_t) strDpElemNameEcnrBtVoiceWbData,      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_AID_DATASET_ECNR_BT_SIRI_NB,         DIA_PROP_TYPE_STR, (SM_VAR_LEN|SM_NO_DEFAULT),       20480,    DIA_PROP_SRC_DP,       {(intptr_t) strDpNameEcnr,    0x0114, 0xfffA, (intptr_t) strDpElemNameEcnrBtSiriNbData,       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_AID_DATASET_ECNR_BT_SIRI_WB,         DIA_PROP_TYPE_STR, (SM_VAR_LEN|SM_NO_DEFAULT),       20480,    DIA_PROP_SRC_DP,       {(intptr_t) strDpNameEcnr,    0x0114, 0xfffA, (intptr_t) strDpElemNameEcnrBtSiriWbData,       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_AID_DATASET_ECNR_CP_VOICE_NB,        DIA_PROP_TYPE_STR, (SM_VAR_LEN|SM_NO_DEFAULT),       20480,    DIA_PROP_SRC_DP,       {(intptr_t) strDpNameEcnr,    0x0114, 0xfffA, (intptr_t) strDpElemNameEcnrCpVoiceNbData,      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_AID_DATASET_ECNR_CP_VOICE_WB,        DIA_PROP_TYPE_STR, (SM_VAR_LEN|SM_NO_DEFAULT),       20480,    DIA_PROP_SRC_DP,       {(intptr_t) strDpNameEcnr,    0x0114, 0xfffA, (intptr_t) strDpElemNameEcnrCpVoiceWbData,      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_AID_DATASET_ECNR_CP_VOICE_SWB,       DIA_PROP_TYPE_STR, (SM_VAR_LEN|SM_NO_DEFAULT),       20480,    DIA_PROP_SRC_DP,       {(intptr_t) strDpNameEcnr,    0x0114, 0xfffA, (intptr_t) strDpElemNameEcnrCpVoiceSwbData,     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_AID_DATASET_ECNR_CP_PHONE_NB,        DIA_PROP_TYPE_STR, (SM_VAR_LEN|SM_NO_DEFAULT),       20480,    DIA_PROP_SRC_DP,       {(intptr_t) strDpNameEcnr,    0x0114, 0xfffA, (intptr_t) strDpElemNameEcnrCpPhoneNbData,      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_AID_DATASET_ECNR_CP_PHONE_WB,        DIA_PROP_TYPE_STR, (SM_VAR_LEN|SM_NO_DEFAULT),       20480,    DIA_PROP_SRC_DP,       {(intptr_t) strDpNameEcnr,    0x0114, 0xfffA, (intptr_t) strDpElemNameEcnrCpPhoneWbData,      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_AID_DATASET_ECNR_CP_PHONE_SWB,       DIA_PROP_TYPE_STR, (SM_VAR_LEN|SM_NO_DEFAULT),       20480,    DIA_PROP_SRC_DP,       {(intptr_t) strDpNameEcnr,    0x0114, 0xfffA, (intptr_t) strDpElemNameEcnrCpPhoneSwbData,     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_AID_DATASET_ECNR_CP_FACETIME_SWB,    DIA_PROP_TYPE_STR, (SM_VAR_LEN|SM_NO_DEFAULT),       20480,    DIA_PROP_SRC_DP,       {(intptr_t) strDpNameEcnr,    0x0114, 0xfffA, (intptr_t) strDpElemNameEcnrCpFaceTimeSwbData,  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_AID_DATASET_ECNR_AA_VOICE_NB,        DIA_PROP_TYPE_STR, (SM_VAR_LEN|SM_NO_DEFAULT),       20480,    DIA_PROP_SRC_DP,       {(intptr_t) strDpNameEcnr,    0x0114, 0xfffA, (intptr_t) strDpElemNameEcnrAaVoiceNbData,      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_AID_DATASET_ECNR_AA_VOICE_WB,        DIA_PROP_TYPE_STR, (SM_VAR_LEN|SM_NO_DEFAULT),       20480,    DIA_PROP_SRC_DP,       {(intptr_t) strDpNameEcnr,    0x0114, 0xfffA, (intptr_t) strDpElemNameEcnrAaVoiceWbData,      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_AID_DATASET_ECNR_AA_VOICE_SWB,       DIA_PROP_TYPE_STR, (SM_VAR_LEN|SM_NO_DEFAULT),       20480,    DIA_PROP_SRC_DP,       {(intptr_t) strDpNameEcnr,    0x0114, 0xfffA, (intptr_t) strDpElemNameEcnrAaVoiceSwbData,     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_AID_DATASET_ECNR_AA_PHONE_NB,        DIA_PROP_TYPE_STR, (SM_VAR_LEN|SM_NO_DEFAULT),       20480,    DIA_PROP_SRC_DP,       {(intptr_t) strDpNameEcnr,    0x0114, 0xfffA, (intptr_t) strDpElemNameEcnrAaPhoneNbData,      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_AID_DATASET_ECNR_AA_PHONE_WB,        DIA_PROP_TYPE_STR, (SM_VAR_LEN|SM_NO_DEFAULT),       20480,    DIA_PROP_SRC_DP,       {(intptr_t) strDpNameEcnr,    0x0114, 0xfffA, (intptr_t) strDpElemNameEcnrAaPhoneWbData,      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_AID_DATASET_ECNR_AA_PHONE_SWB,       DIA_PROP_TYPE_STR, (SM_VAR_LEN|SM_NO_DEFAULT),       20480,    DIA_PROP_SRC_DP,       {(intptr_t) strDpNameEcnr,    0x0114, 0xfffA, (intptr_t) strDpElemNameEcnrAaPhoneSwbData,     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_AID_DATASET_ECNR_INT_VOICE_NB,       DIA_PROP_TYPE_STR, (SM_VAR_LEN|SM_NO_DEFAULT),       20480,    DIA_PROP_SRC_DP,       {(intptr_t) strDpNameEcnr,    0x0114, 0xfffA, (intptr_t) strDpElemNameEcnrIntVoiceNbData,     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_AID_DATASET_ECNR_INT_VOICE_WB,       DIA_PROP_TYPE_STR, (SM_VAR_LEN|SM_NO_DEFAULT),       20480,    DIA_PROP_SRC_DP,       {(intptr_t) strDpNameEcnr,    0x0114, 0xfffA, (intptr_t) strDpElemNameEcnrIntVoiceWbData,     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_AID_DATASET_ECNR_VPA_VOICE_WB,       DIA_PROP_TYPE_STR, (SM_VAR_LEN|SM_NO_DEFAULT),       20480,    DIA_PROP_SRC_DP,       {(intptr_t) strDpNameEcnr,    0x0114, 0xfffA, (intptr_t) strDpElemNameEcnrVpaVoiceWbData,     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },

    { DIA_PROP_AID_ADC_REF_PLUS_ACTUAL_VOLTAGE,     DIA_PROP_TYPE_STR,  SM_NO_STATUS_MASK,                   4,    DIA_PROP_SRC_DP,       {(intptr_t) strDpNameAlignmentData,     0x0114, 0xfffB, (intptr_t) strDpNameADCRefPlusActualElemData,   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_AID_AUDIO_SOURCE_OFFSET,             DIA_PROP_TYPE_STR,  SM_VAR_LEN,                       2046,    DIA_PROP_SRC_DP,       {(intptr_t) strDpNameAudioSourceOffset, 0x0114, 0xff15, (intptr_t) strDatasetNameAudioSrcOffset,        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },

    { DIA_PROP_SW_UPD_VARIANT_INFO,                 DIA_PROP_TYPE_STR,  SM_NO_STATUS_MASK,   16,   DIA_PROP_SRC_KDS,      {0xA070, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },

    { DIA_PROP_ENGINE_INTTESTER_THREAD_PRIO,        DIA_PROP_TYPE_U32,  SM_NO_STATUS_MASK,    4,   DIA_PROP_SRC_SCD,      {0x0114, (intptr_t) strScdKeyNameAppThread,(intptr_t) strScdKeyValueThreadPrioEngineUDS,     DIA_C_U32_ENGINE_UDS_DEFAULT_THREAD_PRIO,      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_ENGINE_INTTESTER_THREAD_STACK_SIZE,  DIA_PROP_TYPE_U32,  SM_NO_STATUS_MASK,    4,   DIA_PROP_SRC_SCD,      {0x0114, (intptr_t) strScdKeyNameAppThread,(intptr_t) strScdKeyValueThreadStackSizeEngineUDS,DIA_C_U32_ENGINE_UDS_DEFAULT_THREAD_STACK_SIZE,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_ENGINE_UDS_THREAD_PRIO,              DIA_PROP_TYPE_U32,  SM_NO_STATUS_MASK,    4,   DIA_PROP_SRC_SCD,      {0x0114, (intptr_t) strScdKeyNameAppThread,(intptr_t) strScdKeyValueThreadPrioEngineUDS,     DIA_C_U32_ENGINE_UDS_DEFAULT_THREAD_PRIO,      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_ENGINE_UDS_THREAD_STACK_SIZE,        DIA_PROP_TYPE_U32,  SM_NO_STATUS_MASK,    4,   DIA_PROP_SRC_SCD,      {0x0114, (intptr_t) strScdKeyNameAppThread,(intptr_t) strScdKeyValueThreadStackSizeEngineUDS,DIA_C_U32_ENGINE_UDS_DEFAULT_THREAD_STACK_SIZE,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_ENGINE_RUNIN_THREAD_PRIO,            DIA_PROP_TYPE_U32,  SM_NO_STATUS_MASK,    4,   DIA_PROP_SRC_SCD,      {0x0114, (intptr_t) strScdKeyNameAppThread,(intptr_t) strScdKeyValueThreadPrioEngineUDS,     DIA_C_U32_ENGINE_UDS_DEFAULT_THREAD_PRIO,      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_ENGINE_RUNIN_THREAD_STACK_SIZE,      DIA_PROP_TYPE_U32,  SM_NO_STATUS_MASK,    4,   DIA_PROP_SRC_SCD,      {0x0114, (intptr_t) strScdKeyNameAppThread,(intptr_t) strScdKeyValueThreadStackSizeEngineUDS,DIA_C_U32_ENGINE_UDS_DEFAULT_THREAD_STACK_SIZE,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_ENGINE_PDX_FLASH_THREAD_PRIO,        DIA_PROP_TYPE_U32,  SM_NO_STATUS_MASK,    4,   DIA_PROP_SRC_SCD,      {0x0114, (intptr_t) strScdKeyNameAppThread,(intptr_t) strScdKeyValueThreadPrioEngineUDS,     DIA_C_U32_ENGINE_UDS_DEFAULT_THREAD_PRIO,      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_ENGINE_PDX_FLASH_THREAD_STACK_SIZE,  DIA_PROP_TYPE_U32,  SM_NO_STATUS_MASK,    4,   DIA_PROP_SRC_SCD,      {0x0114, (intptr_t) strScdKeyNameAppThread,(intptr_t) strScdKeyValueThreadStackSizeEngineUDS,DIA_C_U32_ENGINE_UDS_DEFAULT_THREAD_STACK_SIZE,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_ENGINE_PDX_FLASH_FINISH,             DIA_PROP_TYPE_U8,  SM_NO_STATUS_MASK,    1,    DIA_PROP_SRC_RAM,      {0x00,   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },

    { DIA_PROP_EVENT_WAIT_THREAD_PRIO,              DIA_PROP_TYPE_U32,  SM_NO_STATUS_MASK,    4,   DIA_PROP_SRC_RAM,      {DIA_C_U32_EVENT_WAIT_THREAD_DEFAULT_PRIO,      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_EVENT_WAIT_THREAD_STACK_SIZE,        DIA_PROP_TYPE_U32,  SM_NO_STATUS_MASK,    4,   DIA_PROP_SRC_RAM,      {DIA_C_U32_EVENT_WAIT_THREAD_DEFAULT_STACKSIZE, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },

    // INC properties
    { DIA_PROP_INC_THREAD_PRIO,                     DIA_PROP_TYPE_U32,  SM_NO_STATUS_MASK,    4,   DIA_PROP_SRC_RAM,      {0x0023, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_INC_THREAD_STACKSIZE,                DIA_PROP_TYPE_U32,  SM_NO_STATUS_MASK,    4,   DIA_PROP_SRC_RAM,      {0x1388, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_INC_UDD_CHANNEL,                     DIA_PROP_TYPE_U8,   SM_NO_STATUS_MASK,    1,   DIA_PROP_SRC_RAM,      {0x00,   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },

    { DIA_PROP_CM_BT_NAME,                          DIA_PROP_TYPE_STR,  SM_NO_STATUS_MASK,   32,   DIA_PROP_SRC_KDS,      {0xA030, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, // BTName
    { DIA_PROP_CM_EARLY_CONFIG_DISPLAY,             DIA_PROP_TYPE_U8,   SM_NO_STATUS_MASK,   40,   DIA_PROP_SRC_KDS,      {0xA090, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, // EarlyConfig_Display
    { DIA_PROP_CM_EARLY_CONFIG_TWO_DISPLAY,         DIA_PROP_TYPE_U8,   SM_NO_STATUS_MASK,   64,   DIA_PROP_SRC_KDS,      {0xA092, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, // EarlyConfig_Two_Display
    { DIA_PROP_CM_EARLY_CONFIG_TOUCH_DRIVER,        DIA_PROP_TYPE_U8,   SM_NO_STATUS_MASK,  128,   DIA_PROP_SRC_KDS,      {0xA091, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, // EarlyConfig_TouchDriver
    { DIA_PROP_CM_EARLY_CONFIG_TOUCH_DRIVER2,       DIA_PROP_TYPE_U8,   SM_NO_STATUS_MASK,  128,   DIA_PROP_SRC_KDS,      {0xA093, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, // EarlyConfig_TouchDriver2
    { DIA_PROP_CM_HD_PARAMETER_SET,                 DIA_PROP_TYPE_STR,  SM_NO_STATUS_MASK,   64,   DIA_PROP_SRC_KDS,      {0x0450, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, // HDParameterSet (DID $8116)
    { DIA_PROP_CM_INPUT_KEY_MAPPING_TABLE_ONE,      DIA_PROP_TYPE_U8,   SM_NO_STATUS_MASK,  230,   DIA_PROP_SRC_KDS,      {0xA080, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, // InputKeyMappingTable_1 (DID $8101)
    { DIA_PROP_CM_INPUT_KEY_MAPPING_TABLE_TWO,      DIA_PROP_TYPE_U8,   SM_NO_STATUS_MASK,  230,   DIA_PROP_SRC_KDS,      {0xA081, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, // InputKeyMappingTable_2 (DID $8102)
    { DIA_PROP_CM_INPUT_KEY_MAPPING_TABLE_THREE,    DIA_PROP_TYPE_U8,   SM_NO_STATUS_MASK,  230,   DIA_PROP_SRC_KDS,      {0xA082, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, // InputKeyMappingTable_3 (DID $8103)
    { DIA_PROP_CM_INPUT_KEY_MAPPING_TABLE_FOUR,     DIA_PROP_TYPE_U8,   SM_NO_STATUS_MASK,  230,   DIA_PROP_SRC_KDS,      {0xA083, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, // InputKeyMappingTable_4 (DID $8104)
    { DIA_PROP_CM_RUN_IN_ACTIVATION,                DIA_PROP_TYPE_BOOL, SM_NO_STATUS_MASK,    1,   DIA_PROP_SRC_KDS,      {0xA071, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_CM_RUN_IN_START_DELAY,               DIA_PROP_TYPE_U32,  SM_NO_STATUS_MASK,    4,   DIA_PROP_SRC_KDS,      {0xA072, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_CM_WIFI_NAME_1,                      DIA_PROP_TYPE_STR,  SM_NO_STATUS_MASK,   32,   DIA_PROP_SRC_KDS,      {0xA032, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, // WiFiName_1
    { DIA_PROP_CM_WIFI_NAME_2,                      DIA_PROP_TYPE_STR,  SM_NO_STATUS_MASK,   32,   DIA_PROP_SRC_KDS,      {0xA033, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, // WiFiName_2
    { DIA_PROP_CM_DRM_TUNER_PARAMETER_SET,          DIA_PROP_TYPE_U8,   SM_NO_STATUS_MASK,   48,   DIA_PROP_SRC_KDS,      {0x0460, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, // DRM_TunerParameterSet
    { DIA_PROP_CM_DEVICE_MANAGER,                   DIA_PROP_TYPE_U8,   SM_NO_STATUS_MASK,   92,   DIA_PROP_SRC_KDS,      {0xA0B0, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, //
    { DIA_PROP_CM_MEDIA_PLAYER,                     DIA_PROP_TYPE_STR,  SM_NO_STATUS_MASK,   32,   DIA_PROP_SRC_KDS,      {0xA0C1, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, //
    { DIA_PROP_CM_DISPLAY,                          DIA_PROP_TYPE_U32,  SM_NO_STATUS_MASK,  160,   DIA_PROP_SRC_KDS,      {0xA0C2, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, // Config Records for SmartPhoneIntegration (DID $811A)
    { DIA_PROP_CM_SMARTPHONE_INTEGRATION_DISPLAY,   DIA_PROP_TYPE_U32,  SM_NO_STATUS_MASK,  160,   DIA_PROP_SRC_KDS,      {0xA0C3, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, // Config Records for SmartPhoneIntegration (DID $811B)
    { DIA_PROP_CM_SMARTPHONE_INTEGRATION,           DIA_PROP_TYPE_STR,  SM_NO_STATUS_MASK,  224,   DIA_PROP_SRC_KDS,      {0xA0C4, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, // Config Records for SmartPhoneIntegration (DID $811C)

    { DIA_PROP_FEATURE_ALD_CM_DIAGNOSIS_ENABLED,    DIA_PROP_TYPE_BOOL, SM_NO_STATUS_MASK,    1,   DIA_PROP_SRC_FILESW,   {0x00000001, (intptr_t) strFilePathALDFeatureCMDiagnosisEnabled,          0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },

    { DIA_PROP_TCP_THREAD_PRIO,                     DIA_PROP_TYPE_U32,  SM_NO_STATUS_MASK,    4,   DIA_PROP_SRC_RAM,      {DIA_C_U32_TCP_THREAD_DEFAULT_PRIO,      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_TCP_THREAD_STACKSIZE,                DIA_PROP_TYPE_U32,  SM_NO_STATUS_MASK,    4,   DIA_PROP_SRC_RAM,      {DIA_C_U32_TCP_THREAD_DEFAULT_STACKSIZE, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_PRODUCTION_TIME,                     DIA_PROP_TYPE_STR,  SM_NO_STATUS_MASK,    6,   DIA_PROP_SRC_KDS,      {0xA010, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, // Device Production time (with fix value)

    { DIA_PROP_DTC_FORMAT_IDENTIFIER,               DIA_PROP_TYPE_U8,   SM_NO_STATUS_MASK,    1,   DIA_PROP_SRC_RAM,      {0x01,   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, //DTCFormatIdentifier: 0x01 = 14229-1DTCF
    { DIA_PROP_TOUCHCTRL_SELFTEST,                  DIA_PROP_TYPE_STR,  SM_ZERO_TERMINATED, 128,   DIA_PROP_SRC_RAM,      {(intptr_t)strTouchCtrlSelfTestFilePath, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_SWUPDATE_MOUNT_POINT,                DIA_PROP_TYPE_STR,  SM_ZERO_TERMINATED, 128,   DIA_PROP_SRC_RAM,      {(intptr_t)strSwUpdateMountPoint, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_SWUPDATE_PATH,                       DIA_PROP_TYPE_STR,  SM_ZERO_TERMINATED, 128,   DIA_PROP_SRC_RAM,      {(intptr_t)strSwUpdatePath, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_SWUPDATE_FILE,                       DIA_PROP_TYPE_STR,  SM_ZERO_TERMINATED, 128,   DIA_PROP_SRC_RAM,      {(intptr_t)strSwUpdateFile, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
    { DIA_PROP_CM_CONFIG_LAST_DIAG_ERROR,           DIA_PROP_TYPE_STR,  SM_ZERO_TERMINATED,  250,  DIA_PROP_SRC_RAM,      {(intptr_t)lastdiagerror,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, // Last Diagnosis Error
    { DIA_PROP_CM_UNIQUE_FIELD_DATA_ID,             DIA_PROP_TYPE_U8,   SM_NO_STATUS_MASK,   20,   DIA_PROP_SRC_KDS,      {0x0107,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, // ECU Unique FieldData ID

    { DIA_PROP_TEMPERATURE_HISTOGRAMS,              DIA_PROP_TYPE_STR,  (SM_VAR_LEN|SM_NO_DEFAULT),   20480,   DIA_PROP_SRC_DP,       {(intptr_t)strDpNameTemperatureHistograms,  0x0114, 0x0001, (intptr_t) strDpElementNameTemperatureHistograms,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
  //  { DIA_PROP_NEXT_TEMPERATURE_HISTOGRAM,          DIA_PROP_TYPE_STR,  (SM_VAR_LEN),       250,   DIA_PROP_SRC_RAM,       {(intptr_t)0} },



};

namespace dia
{

size_t getCommonPropDataSize()
{
   return sizeof(aCommonPropData)/sizeof(dia_PropertyInfo);
}

}
