/*
 * dia_PropertyBagSCD.cpp
 *
 *  Created on: 25.11.2014
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_PROPERTY_BAG_SCD__
#include "dia_PropertyBagSCD.h"
#endif

#ifndef __INCLUDED_DIA_SCD__
#include "common/framework/platform/aid/dia_scd.h"
#endif

//----------------------------------------------------------------------------------------

dia_PropertyBagSCD::dia_PropertyBagSCD ( void )
    : dia_PropertyBag(DIA_C_STR_PROPBAG_SCD)
{
    dia_tclFnctTrace trc("dia_PropertyBagSCD::dia_PropertyBagSCD");
}

//----------------------------------------------------------------------------------------

dia_PropertyBagSCD::~dia_PropertyBagSCD ( void )
{
//    dia_tclFnctTrace trc("dia_PropertyBagSCD::~dia_PropertyBagSCD");
}

//----------------------------------------------------------------------------------------

tDiaResult
dia_PropertyBagSCD::getPropertyU32 (tU32 propID, tU32& propValue )
{
   dia_tclFnctTrace trc("dia_PropertyBagSCD::getPropertyU32(tU32, tU32&");

   dia_PropertyInfo propData;
   if ( queryProperty(propID, propData) != DIA_SUCCESS )
   {
      DIA_TR_INF("dia_PropertyBagDatapool::getProperty(tU32,tU8[],tU16) ERROR: DIA_E_INVALID_KEY");
      return DIA_E_INVALID_KEY;
   }

   tU16     appID         =     (tU16) propData.mPropExtData[0];
   tCString scdKeyName    = (tCString) propData.mPropExtData[1];
   tCString strValueName  = (tCString) propData.mPropExtData[2];
   tU32     defaultValue  =     (tU32) propData.mPropExtData[3];

   if ( propData.mPropType == DIA_PROP_TYPE_U32 )
   {
      // Read the thread Priority from the Registry
      if ( scd_bGetAppConfigurationValue(appID,scdKeyName,strValueName,&propValue) == FALSE )
      {
         propValue = defaultValue;
         DIA_TR_ERR( "--- !! ERROR !! READING FROM SCD REGISTRY FAILED. USING DEFAULT VALUE");
      }
   }
   else
   {
      DIA_TR_INF("dia_PropertyBagSCD::getProperty(tU32,tU32&) ERROR: UNSUPPORTED TYPE (%d)",propData.mPropType);
      return DIA_E_NOT_SUPPORTED;
   }

   return DIA_SUCCESS;
}

